/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.idrange;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.git.GitRepositoryManager;
import org.protege.editor.owl.model.idrange.IdPolicyEntityCreationPreferencesUpdater;
import org.protege.editor.owl.model.idrange.IdRangesPolicy;
import org.protege.editor.owl.model.idrange.IdRangesPolicyParseException;
import org.protege.editor.owl.model.idrange.IdRangesPolicyParser;
import org.protege.editor.owl.model.idrange.NoRangeForUserNameHandlerUi;
import org.protege.editor.owl.model.user.DefaultUserNameProvider;
import org.protege.editor.owl.model.user.UserNamePreferencesManager;
import org.protege.editor.owl.model.user.UserNameProvider;
import org.protege.editor.owl.model.user.UserPreferences;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.StreamDocumentSource;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveOntologyIdRangesPolicyManager {
    private static final Logger logger = LoggerFactory.getLogger(ActiveOntologyIdRangesPolicyManager.class);
    private static final String ID_RANGES_FILE_SUFFIX = "-idranges.owl";
    @Nonnull
    private final OWLModelManager modelManager;
    private ImmutableList<IdRangesPolicy> idRangesPolicies = ImmutableList.of();

    public ActiveOntologyIdRangesPolicyManager(@Nonnull OWLModelManager modelManager) {
        this.modelManager = (OWLModelManager)Preconditions.checkNotNull((Object)modelManager);
    }

    public ImmutableList<IdRangesPolicy> getIdRangesPolicies() {
        return this.idRangesPolicies;
    }

    public void reload() {
        this.idRangesPolicies = ImmutableList.of();
        OWLOntology activeOntology = this.modelManager.getActiveOntology();
        URI activeOntologyLocation = this.modelManager.getOntologyPhysicalURI(activeOntology);
        if (!ActiveOntologyIdRangesPolicyManager.isFileUri(activeOntologyLocation)) {
            return;
        }
        Path activeOntologyPath = Paths.get(activeOntologyLocation);
        if (!Files.exists(activeOntologyPath, new LinkOption[0])) {
            return;
        }
        Path activeOntologyDirectory = activeOntologyPath.getParent();
        try {
            List policies = Files.list(activeOntologyDirectory).filter(this::isIdRangesFile).peek(path -> logger.info("[IdRanges] Loading id ranges policy from {}", path)).map(this::toOntology).map(this::toIdRangesPolicy).filter(Objects::nonNull).collect(Collectors.toList());
            this.idRangesPolicies = ImmutableList.copyOf(policies);
            this.updateNewEntitiesPreferences();
        }
        catch (IOException e) {
            logger.warn("An error ocurred whilst listing the active ontology directory contents: {}", (Object)e.getMessage());
        }
    }

    public void updateNewEntitiesPreferences() {
        logger.info("[IdRanges] Updating entity creation preferences");
        this.idRangesPolicies.stream().findFirst().ifPresent(policy -> {
            IdPolicyEntityCreationPreferencesUpdater updater = new IdPolicyEntityCreationPreferencesUpdater((IdRangesPolicy)policy, new NoRangeForUserNameHandlerUi(), this.getUserNameProvider());
            updater.updatePreferences();
        });
    }

    private UserNameProvider getUserNameProvider() {
        return new DefaultUserNameProvider(GitRepositoryManager.get(this.modelManager), new UserNamePreferencesManager(UserPreferences.get()), System.getProperties());
    }

    private boolean isIdRangesFile(Path path) {
        return path.toFile().getName().endsWith(ID_RANGES_FILE_SUFFIX);
    }

    private static boolean isFileUri(URI activeOntologyLocation) {
        return "file".equalsIgnoreCase(activeOntologyLocation.getScheme());
    }

    @Nullable
    private OWLOntology toOntology(@Nonnull Path path) {
        OWLOntology oWLOntology;
        BufferedInputStream is = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
        try {
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            oWLOntology = manager.loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)new StreamDocumentSource((InputStream)is));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.warn("[IdRanges] An error occurred whilst loading the Id ranges policy ontology at {}.  Details: {}", (Object)path, (Object)e.getMessage());
                return null;
            }
        }
        ((InputStream)is).close();
        return oWLOntology;
    }

    @Nullable
    private IdRangesPolicy toIdRangesPolicy(@Nullable OWLOntology ontology) {
        if (ontology == null) {
            return null;
        }
        try {
            return IdRangesPolicyParser.get(ontology).parse();
        }
        catch (IdRangesPolicyParseException e) {
            logger.warn("Count not parse Id ranges policy ontology: {}", (Object)e.getMessage());
            return null;
        }
    }
}

