/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.oboformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.obolibrary.obo2owl.OWLAPIObo2Owl;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.parser.OBOFormatParser;
import org.obolibrary.oboformat.parser.OBOFormatParserException;
import org.semanticweb.owlapi.formats.OBODocumentFormat;
import org.semanticweb.owlapi.formats.OBODocumentFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;

public class OBOFormatOWLAPIParser
extends AbstractOWLParser
implements Serializable {
    private static final long serialVersionUID = 40000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public OWLDocumentFormat parse(@Nonnull OWLOntologyDocumentSource documentSource, @Nonnull OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws IOException {
        OBOFormatParser p = new OBOFormatParser();
        OBODoc obodoc = null;
        try {
            Reader reader = null;
            InputStream is = null;
            try {
                if (documentSource.isReaderAvailable()) {
                    reader = documentSource.getReader();
                    obodoc = p.parse(new BufferedReader(reader));
                } else if (documentSource.isInputStreamAvailable()) {
                    is = documentSource.getInputStream();
                    obodoc = p.parse(new BufferedReader(new InputStreamReader(is)));
                } else {
                    if (documentSource.getDocumentIRI().getNamespace().startsWith("jar:")) {
                        if (documentSource.getDocumentIRI().getNamespace().startsWith("jar:!")) {
                            String name = documentSource.getDocumentIRI().toString().substring(5);
                            if (!name.startsWith("/")) {
                                name = "/" + name;
                            }
                            is = this.getClass().getResourceAsStream(name);
                        } else {
                            try {
                                is = ((JarURLConnection)new URL(documentSource.getDocumentIRI().toString()).openConnection()).getInputStream();
                            }
                            catch (IOException e) {
                                throw new OWLParserException(e);
                            }
                        }
                    } else {
                        Optional<String> headers = documentSource.getAcceptHeaders();
                        is = headers.isPresent() ? this.getInputStream(documentSource.getDocumentIRI(), configuration, headers.get()) : this.getInputStream(documentSource.getDocumentIRI(), configuration, "application/rdf+xml, application/xml; q=0.7, text/xml; q=0.6, text/plain; q=0.1, */*; q=0.09");
                    }
                    obodoc = p.parse(new BufferedReader(new InputStreamReader(is)));
                }
                OWLAPIObo2Owl bridge = new OWLAPIObo2Owl(ontology.getOWLOntologyManager());
                bridge.convert(obodoc, ontology);
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (OBOFormatParserException e) {
            throw new OWLParserException(e);
        }
        return new OBODocumentFormat();
    }

    @Override
    @Nonnull
    public String getName() {
        return "OWLoboformatParser";
    }

    @Override
    @Nonnull
    public OWLDocumentFormatFactory getSupportedFormat() {
        return new OBODocumentFormatFactory();
    }
}

