/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.brlapi;

import org.a11y.brlapi.KeywordMap;
import org.a11y.brlapi.Strings;
import org.a11y.brlapi.SyntaxException;

public abstract class Parse {
    private static final KeywordMap<Boolean> booleanKeywords = new KeywordMap();
    public static final byte DEFAULT_RANGE_MINIMUM = 0;
    public static final int MINIMUM_CURSOR_POSITION = 1;
    public static final String NO_CURSOR = "no";
    public static final String LEAVE_CURSOR = "leave";
    public static final int MINIMUM_DISPLAY_NUMBER = 1;
    public static final String DEFAULT_DISPLAY = "default";

    private Parse() {
    }

    public static Boolean asBoolean(String string, String string2) throws SyntaxException {
        Boolean bl = booleanKeywords.get(string2);
        if (bl != null) {
            return bl;
        }
        throw new SyntaxException("%s is not a boolean: %s", string, string2);
    }

    public static void checkMinimum(String string, long l, long l2) throws SyntaxException {
        if (l < l2) {
            throw new SyntaxException("%s is less than %d: %d", string, l2, l);
        }
    }

    public static void checkMaximum(String string, long l, long l2) throws SyntaxException {
        if (l > l2) {
            throw new SyntaxException("%s is greater than %d: %d", string, l2, l);
        }
    }

    public static void checkRange(String string, long l, long l2, long l3) throws SyntaxException {
        Parse.checkMinimum(string, l, l2);
        Parse.checkMaximum(string, l, l3);
    }

    private static Number asNumber(String string, String string2, long l, long l2) throws SyntaxException {
        try {
            long l3 = Long.valueOf(string2);
            Parse.checkRange(string, l3, l, l2);
            return l3;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SyntaxException("%s is not an integer: %s", string, string2);
        }
    }

    public static long asLong(String string, String string2, long l, long l2) throws SyntaxException {
        return Parse.asNumber(string, string2, l, l2).longValue();
    }

    public static long asLong(String string, String string2, long l) throws SyntaxException {
        return Parse.asLong(string, string2, l, Long.MAX_VALUE);
    }

    public static long asLong(String string, String string2) throws SyntaxException {
        return Parse.asLong(string, string2, 0L);
    }

    public static int asInt(String string, String string2, int n, int n2) throws SyntaxException {
        return Parse.asNumber(string, string2, n, n2).intValue();
    }

    public static int asInt(String string, String string2, int n) throws SyntaxException {
        return Parse.asInt(string, string2, n, Integer.MAX_VALUE);
    }

    public static int asInt(String string, String string2) throws SyntaxException {
        return Parse.asInt(string, string2, 0);
    }

    public static short asShort(String string, String string2, short s, short s2) throws SyntaxException {
        return Parse.asNumber(string, string2, s, s2).shortValue();
    }

    public static short asShort(String string, String string2, short s) throws SyntaxException {
        return Parse.asShort(string, string2, s, (short)Short.MAX_VALUE);
    }

    public static short asShort(String string, String string2) throws SyntaxException {
        return Parse.asShort(string, string2, (short)0);
    }

    public static byte asByte(String string, String string2, byte by, byte by2) throws SyntaxException {
        return Parse.asNumber(string, string2, by, by2).byteValue();
    }

    public static byte asByte(String string, String string2, byte by) throws SyntaxException {
        return Parse.asByte(string, string2, by, (byte)127);
    }

    public static byte asByte(String string, String string2) throws SyntaxException {
        return Parse.asByte(string, string2, (byte)0);
    }

    public static byte asDots(String string, String string2) throws SyntaxException {
        if (string2.equals("0")) {
            return 0;
        }
        byte by = 0;
        String string3 = "12345678";
        for (char c : string2.toCharArray()) {
            int n = string3.indexOf(c);
            if (n < 0) {
                throw new SyntaxException("%s contains an invalid dot number: %s (%c)", string, string2, Character.valueOf(c));
            }
            int n2 = 1 << n;
            if ((by & n2) != 0) {
                throw new SyntaxException("%s contains a duplicate dot number: %s (%c)", string, string2, Character.valueOf(c));
            }
            by = (byte)(by | n2);
        }
        return by;
    }

    public static int asCursorPosition(String string) throws SyntaxException {
        if (Strings.isAbbreviation(NO_CURSOR, string)) {
            return 0;
        }
        if (Strings.isAbbreviation(LEAVE_CURSOR, string)) {
            return -1;
        }
        return Parse.asInt("cursor position", string, 1);
    }

    public static int asDisplayNumber(String string) throws SyntaxException {
        if (Strings.isAbbreviation(DEFAULT_DISPLAY, string)) {
            return -1;
        }
        return Parse.asInt("display number", string, 1);
    }

    static {
        Boolean bl = false;
        Boolean bl2 = true;
        booleanKeywords.put("false", bl);
        booleanKeywords.put("true", bl2);
        booleanKeywords.put("off", bl);
        booleanKeywords.put("on", bl2);
        booleanKeywords.put(NO_CURSOR, bl);
        booleanKeywords.put("yes", bl2);
        booleanKeywords.put("0", bl);
        booleanKeywords.put("1", bl2);
    }
}

