#ifndef AVIREADHANDLER_H
#define AVIREADHANDLER_H

#include "Cache.h"
#include "ReadHandlers.h"

AVM_BEGIN_NAMESPACE;

class AviReadStream;

class AviStreamPacket : public StreamPacket
{
public:
    int64_t offset;
    uint_t id;

    AviStreamPacket(uint_t off = 0, uint_t i = 0, size_t bsize = 0)
	: StreamPacket(bsize), offset(off), id(i) {}
};


class AviReadHandler : public IMediaReadHandler
{
    friend class AviReadStream;
    static const size_t MAX_CHUNK_SIZE = 10000000;
public:
    AviReadHandler(int flags = 0);
    virtual ~AviReadHandler();
    virtual size_t GetHeader(void* pheader, size_t size);
    virtual IMediaReadStream* GetStream(uint_t stream_id,
					IStream::StreamType type);
    virtual size_t GetStreamCount(IStream::StreamType type);
    virtual bool GetURLs(avm::vector<avm::string>& urls) { return false; }
    virtual void Interrupt() {}
    /* avi files are opened synchronously */
    virtual bool IsOpened() { return true; }
    virtual bool IsValid() { return true; }
    virtual bool IsRedirector() { return false; }

    int init(const char* pszFile);

    static void PrintAVIMainHeader(const AVIMainHeader* hdr);
    static void PrintAVIStreamHeader(const AVIStreamHeader* hdr);
    static char* GetAviFlags(char* buffer, int flags);

protected:
    void readAVIMainHeader(size_t);
    void readAVIStreamHeader(size_t);
    void readInfoChunk(size_t);
    int readIndexChunk(size_t, off_t movie_chunk_offset);

    //AviStreamPacket* readPacket(bool fill = true);
    int reconstructIndexChunk(off_t);

    AVIMainHeader m_MainHeader;
    avm::vector<AviReadStream*> m_Streams;
    InputStream m_Input;
    int m_iFlags;
};

AVM_END_NAMESPACE;

#endif // AVIREADHANDLER_H
