//
// Copyright (c) 2015-2022 MinIO, Inc.
//
// This file is part of MinIO Object Storage stack
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
//

// Code generated by "stringer -type=TraceType -trimprefix=Trace trace.go"; DO NOT EDIT.

package madmin

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[TraceOS-1]
	_ = x[TraceStorage-2]
	_ = x[TraceS3-4]
	_ = x[TraceInternal-8]
	_ = x[TraceScanner-16]
	_ = x[TraceDecommission-32]
	_ = x[TraceHealing-64]
	_ = x[TraceBatchReplication-128]
	_ = x[TraceRebalance-256]
	_ = x[TraceReplicationResync-512]
	_ = x[TraceBootstrap-1024]
	_ = x[TraceAll-2047]
}

const _TraceType_name = "OSStorageS3InternalScannerDecommissionHealingBatchReplicationRebalanceReplicationResyncBootstrapAll"

var _TraceType_map = map[TraceType]string{
	1:    _TraceType_name[0:2],
	2:    _TraceType_name[2:9],
	4:    _TraceType_name[9:11],
	8:    _TraceType_name[11:19],
	16:   _TraceType_name[19:26],
	32:   _TraceType_name[26:38],
	64:   _TraceType_name[38:45],
	128:  _TraceType_name[45:61],
	256:  _TraceType_name[61:70],
	512:  _TraceType_name[70:87],
	1024: _TraceType_name[87:96],
	2047: _TraceType_name[96:99],
}

func (i TraceType) String() string {
	if str, ok := _TraceType_map[i]; ok {
		return str
	}
	return "TraceType(" + strconv.FormatInt(int64(i), 10) + ")"
}
