#include <string_view>

// json_attention_golden_data calculated with pytorch
static const std::string_view json_attention_fwd_golden_data =
    R"json({
    "tensor": [
        [   3.770536184310913,
            4.329129219055176,
            4.109292030334473,
            3.92095947265625
        ],
        [   3.7122879028320312,
            4.259908199310303,
            4.0466790199279785,
            3.8648295402526855
        ],
        [   3.721836805343628,
            4.262655258178711,
            4.054609775543213,
            3.8784942626953125
        ],
        [   3.7891483306884766,
            4.350048065185547,
            4.128964424133301,
            3.9394826889038086
        ],
        [   3.7144012451171875,
            4.253789901733398,
            4.046574115753174,
            3.871335506439209
        ],

        [   3.0347471237182617,
            3.4869349002838135,
            3.316852569580078,
            3.171729326248169
        ],
        [   2.9643800258636475,
            3.380119800567627,
            3.234912872314453,
            3.1168062686920166
        ],
        [   3.193814277648926,
            3.6726696491241455,
            3.4919581413269043,
            3.336332321166992
        ],
        [   3.173119068145752,
            3.636214017868042,
            3.4669370651245117,
            3.3240883350372314
        ],
        [   3.2662007808685303,
            3.7338991165161133,
            3.567594051361084,
            3.4292633533477783
        ]
    ]
})json";

static const std::string_view json_attention_word_position =
    R"json({
    "tensor": [
        [   0.8401877284049988,
            0.3943829238414764,
            0.7830992341041565,
            0.7984400391578674
        ],
        [   0.9116473793983459,
            0.1975513696670532,
            0.3352227509021759,
            0.7682296037673950
        ],
        [   0.2777747213840485,
            0.5539699792861938,
            0.4773970544338226,
            0.6288709044456482
        ],
        [   0.3647844791412354,
            0.5134009122848511,
            0.9522297382354736,
            0.9161950945854187
        ],
        [   0.6357117295265198,
            0.7172969579696655,
            0.1416025608778000,
            0.6069688796997070
        ],

        [   0.0163005720824003,
            0.2428867667913437,
            0.1372315734624863,
            0.8041767477989197
        ],
        [   0.1566790938377380,
            0.4009443819522858,
            0.1297904402017593,
            0.1088088005781174
        ],
        [   0.9989244937896729,
            0.2182569056749344,
            0.5129324197769165,
            0.8391122221946716
        ],
        [   0.6126398444175720,
            0.2960316240787506,
            0.6375522613525391,
            0.5242871642112732
        ],
        [   0.4935829937458038,
            0.9727750420570374,
            0.2925167977809906,
            0.7713577151298523
        ]
    ]
})json";

static const std::string_view json_attention_q_weights =
    R"json({
    "tensor": [
        [   0.5267449617385864,
            0.7699138522148132,
            0.4002286195755005,
            0.8915294408798218
        ],
        [   0.2833147346973419,
            0.3524583578109741,
            0.8077245354652405,
            0.9190264940261841
        ],

        [   0.0697552785277367,
            0.9493270516395569,
            0.5259953737258911,
            0.0860558450222015
        ],
        [   0.1922138482332230,
            0.6632269024848938,
            0.8902326226234436,
            0.3488929271697998
        ]
    ]
})json";

static const std::string_view json_attention_k_weights =
    R"json({
    "tensor": [
        [   0.0641713216900826,
            0.0200230497866869,
            0.4577017426490784,
            0.0630958378314972
        ],
        [   0.2382799535989761,
            0.9706341028213501,
            0.9022080898284912,
            0.8509197831153870
        ],

        [   0.2666657567024231,
            0.5397603511810303,
            0.3752069771289825,
            0.7602487206459045
        ],
        [   0.5125353932380676,
            0.6677237749099731,
            0.5316064357757568,
            0.0392803438007832
        ]
    ]
})json";

static const std::string_view json_attention_v_weights =
    R"json({
    "tensor": [
        [   0.4376375973224640,
            0.9318350553512573,
            0.9308097958564758,
            0.7209523320198059
        ],
        [   0.2842934131622314,
            0.7385343313217163,
            0.6399788260459900,
            0.3540486693382263
        ],

        [   0.6878613829612732,
            0.1659741699695587,
            0.4401045143604279,
            0.8800752162933350
        ],
        [   0.8292011022567749,
            0.3303371369838715,
            0.2289681732654572,
            0.8933724164962769
        ]
    ]
})json";

static const std::string_view json_attention_fwd_final_linear_transform_weights =
    R"json({
    "tensor": [
        [   0.3503601849079132,
            0.6866698861122131,
            0.9564682245254517,
            0.5886401534080505
        ],
        [   0.6573040485382080,
            0.8586763143539429,
            0.4395599067211151,
            0.9239698052406311
        ],
        [   0.3984366655349731,
            0.8147668838500977,
            0.6842185258865356,
            0.9109720587730408
        ],
        [   0.4824906587600708,
            0.2158249616622925,
            0.9502523541450500,
            0.9201282262802124
        ]
    ]
})json";

static const std::string_view json_dO_val =
    R"json({
    "tensor": [
        [0.4326967000961304, 0.5034142732620239],
        [0.3742998838424683, 0.8130495548248291],
        [0.2719697952270508, 0.0869214236736298],
        [0.0300454571843147, 0.5597561597824097],
        [0.6639074087142944, 0.1598965376615524],
        [0.9877028465270996, 0.4654746651649475],
        [0.1985244303941727, 0.7646803855895996],
        [0.3851194083690643, 0.9054278135299683],
        [0.7841265201568604, 0.2662073373794556],
        [0.0736359953880310, 0.0607693009078503],
        [0.0075395158492029, 0.6795202493667603],
        [0.1296833753585815, 0.2451221495866776],
        [0.0392608530819416, 0.3937692046165466],
        [0.5831758975982666, 0.8619759082794189],
        [0.3022827506065369, 0.1364451646804810],
        [0.3314520418643951, 0.5866937041282654],
        [0.6233373880386353, 0.5215975046157837],
        [0.7075114250183105, 0.8668782114982605],
        [0.0853137969970703, 0.0257864110171795],
        [0.6712992787361145, 0.3348474800586700]
    ]
})json";

static const std::string_view json_str_dV = R"json({
    "tensor": 
    [
        [
          0.46276405453681946,
          0.5632290840148926,
          0.6301558017730713,
          0.6143999695777893
        ],
        [
             0.21040800213813782,
             0.23169182240962982,
             0.38223886489868164,
             0.40467533469200134
        ],
        [
             0.2607715427875519,
             0.2960909307003021,
             0.3691549599170685,
             0.393097460269928
        ],
        [
             0.6277356743812561,
             0.7965565919876099,
             0.6256253123283386,
             0.6110870242118835
        ],
        [
             0.21125063300132751,
             0.2354714274406433,
             0.4219350814819336,
             0.4393003582954407
        ],

        [
          0.132674440741539,
          0.3022109270095825,
          0.320855051279068,
          0.32227981090545654
        ],
        [
             0.09208431094884872,
             0.21530890464782715,
             0.29005980491638184,
             0.2968984544277191
        ],
        [
             0.27132707834243774,
             0.5833349227905273,
             0.6035137176513672,
             0.5730515718460083
        ],
        [
             0.2368224859237671,
             0.5134046673774719,
             0.50053870677948,
             0.48598945140838623
        ],
        [
             0.32903170585632324,
             0.7025806307792664,
             0.7039426565170288,
             0.6575907468795776
        ]
    ]
})json";

static const std::string_view json_str_dQ = R"json({
    "tensor": 
    [
        [
          0.028277257457375526,
          0.07200080156326294,
          0.041350290179252625,
          0.03680729493498802
        ],
        [
             0.03550948202610016,
             0.09047053754329681,
             0.022952184081077576,
             0.021599717438220978
        ],
        [
             0.013200974091887474,
             0.0331602618098259,
             0.03173384815454483,
             0.029656197875738144
        ],
        [
             0.014150556176900864,
             0.03654339164495468,
             0.030366968363523483,
             0.026921339333057404
        ],
        [
             0.03096843883395195,
             0.07780992984771729,
             0.003662070259451866,
             0.0032906262204051018
        ],


        [
          0.01230604387819767,
          0.08554355800151825,
          0.12323366105556488,
          0.1049455925822258
        ],
        [
             0.010758176445960999,
             0.061150021851062775,
             0.15029355883598328,
             0.12868845462799072
        ],
        [
             0.005017941817641258,
             0.046435996890068054,
             0.18252424895763397,
             0.15568195283412933
        ],
        [
             0.025845274329185486,
             0.19355353713035583,
             0.012176983058452606,
             0.01042320765554905
        ],
        [
             0.007626548409461975,
             0.059891343116760254,
             0.09300088882446289,
             0.08080047369003296
        ]
    ]
})json";

static const std::string_view json_str_dK = R"json({
    "tensor": 
    [

        [
          0.12819401919841766,
          0.11493054777383804,
          0.18875014781951904,
          0.27348482608795166
        ],
        [
             -0.18670454621315002,
             -0.16970974206924438,
             0.035735923796892166,
             0.051827192306518555
        ],
        [
             -0.170164093375206,
             -0.15484140813350677,
             -0.17655421793460846,
             -0.2559382915496826
        ],
        [
             0.36930567026138306,
             0.33704400062561035,
             0.06264787912368774,
             0.0910910815000534
        ],
        [
             -0.14063072204589844,
             -0.12742310762405396,
             -0.11057973653078079,
             -0.1604647934436798
        ],

        
        [
          -0.18692390620708466,
          -0.1738758087158203,
          -0.11495179682970047,
          -0.15318563580513
        ],
        [
             -0.1666441559791565,
             -0.15434391796588898,
             -0.22044941782951355,
             -0.29630666971206665
        ],
        [
             0.06872744113206863,
             0.06314821541309357,
             0.2631801664829254,
             0.3502889573574066
        ],
        [
             -0.023755840957164764,
             -0.022147303447127342,
             -0.015536848455667496,
             -0.020632755011320114
        ],
        [
             0.30859625339508057,
             0.2872186303138733,
             0.08775784820318222,
             0.11983604729175568
        ]
    ]
})json";
