/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.List;
import java.util.Stack;
import org.chefproject.core.AnnouncementChannel;
import org.chefproject.core.AnnouncementChannelEdit;
import org.chefproject.core.AnnouncementMessage;
import org.chefproject.core.AnnouncementMessageEdit;
import org.chefproject.core.AnnouncementMessageHeader;
import org.chefproject.core.AnnouncementMessageHeaderEdit;
import org.chefproject.core.Edit;
import org.chefproject.core.Filter;
import org.chefproject.core.Message;
import org.chefproject.core.MessageChannel;
import org.chefproject.core.MessageHeader;
import org.chefproject.core.MessageHeaderEdit;
import org.chefproject.core.Resource;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.SecurityService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.component.BaseMessageService;
import org.chefproject.service.generic.GenericAnnouncementService;
import org.chefproject.util.Different;
import org.chefproject.util.ReferenceVector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BaseAnnouncementService
extends BaseMessageService
implements GenericAnnouncementService {
    public Resource newContainer(String ref) {
        return new BaseAnnouncementChannelEdit(ref);
    }

    public Resource newContainer(Element element) {
        return new BaseAnnouncementChannelEdit(element);
    }

    public Resource newContainer(Resource other) {
        return new BaseAnnouncementChannelEdit((MessageChannel)other);
    }

    public Resource newResource(Resource container, String id, Object[] others) {
        return new BaseAnnouncementMessageEdit((MessageChannel)container, id);
    }

    public Resource newResource(Resource container, Element element) {
        return new BaseAnnouncementMessageEdit((MessageChannel)container, element);
    }

    public Resource newResource(Resource container, Resource other) {
        return new BaseAnnouncementMessageEdit((MessageChannel)container, (Message)other);
    }

    public Edit newContainerEdit(String ref) {
        BaseAnnouncementChannelEdit rv = new BaseAnnouncementChannelEdit(ref);
        rv.activate();
        return rv;
    }

    public Edit newContainerEdit(Element element) {
        BaseAnnouncementChannelEdit rv = new BaseAnnouncementChannelEdit(element);
        rv.activate();
        return rv;
    }

    public Edit newContainerEdit(Resource other) {
        BaseAnnouncementChannelEdit rv = new BaseAnnouncementChannelEdit((MessageChannel)other);
        rv.activate();
        return rv;
    }

    public Edit newResourceEdit(Resource container, String id, Object[] others) {
        BaseAnnouncementMessageEdit rv = new BaseAnnouncementMessageEdit((MessageChannel)container, id);
        rv.activate();
        return rv;
    }

    public Edit newResourceEdit(Resource container, Element element) {
        BaseAnnouncementMessageEdit rv = new BaseAnnouncementMessageEdit((MessageChannel)container, element);
        rv.activate();
        return rv;
    }

    public Edit newResourceEdit(Resource container, Resource other) {
        BaseAnnouncementMessageEdit rv = new BaseAnnouncementMessageEdit((MessageChannel)container, (Message)other);
        rv.activate();
        return rv;
    }

    public Object[] storageFields(Resource r) {
        Object[] rv = new Object[]{((Message)r).getHeader().getDate()};
        return rv;
    }

    protected MessageHeaderEdit newMessageHeader(String id) {
        return new BaseAnnouncementMessageHeaderEdit(id);
    }

    protected MessageHeaderEdit newMessageHeader(Element el) {
        return new BaseAnnouncementMessageHeaderEdit(el);
    }

    protected MessageHeaderEdit newMessageHeader(MessageHeader other) {
        return new BaseAnnouncementMessageHeaderEdit(other);
    }

    protected String eventId(String secure) {
        return "annc." + secure;
    }

    protected String getReferenceRoot() {
        return "/announcement";
    }

    public AnnouncementChannel getAnnouncementChannel(String ref) throws IdUnusedException, PermissionException {
        return (AnnouncementChannel)this.getChannel(ref);
    }

    public AnnouncementChannelEdit addAnnouncementChannel(String ref) throws IdUsedException, IdInvalidException, PermissionException {
        return (AnnouncementChannelEdit)this.addChannel(ref);
    }

    protected class PrivacyFilter
    implements Filter {
        protected Filter m_filter = null;

        public PrivacyFilter(Filter filter) {
            this.m_filter = filter;
        }

        public boolean accept(Object o) {
            AnnouncementMessage msg;
            if (o instanceof AnnouncementMessage && (msg = (AnnouncementMessage)o).getAnnouncementHeader().getDraft() && !SecurityService.isSuperUser() && !msg.getHeader().getFrom().equals(UsageSessionService.getSessionUser()) && !BaseAnnouncementService.this.unlockCheck("read.drafts", msg.getReference())) {
                return false;
            }
            if (this.m_filter != null) {
                return this.m_filter.accept(o);
            }
            return true;
        }
    }

    public class BaseAnnouncementMessageHeaderEdit
    extends BaseMessageService.BaseMessageHeaderEdit
    implements AnnouncementMessageHeaderEdit {
        protected String m_subject = null;
        protected boolean m_draft = true;

        public BaseAnnouncementMessageHeaderEdit(String id) {
            super((BaseMessageService)BaseAnnouncementService.this, id);
        }

        public BaseAnnouncementMessageHeaderEdit(Element el) {
            super((BaseMessageService)BaseAnnouncementService.this, el);
            this.m_subject = el.getAttribute("subject");
            this.m_draft = new Boolean(el.getAttribute("draft"));
        }

        public BaseAnnouncementMessageHeaderEdit(MessageHeader other) {
            super((BaseMessageService)BaseAnnouncementService.this, other);
            this.m_draft = ((AnnouncementMessageHeader)other).getDraft();
            this.m_subject = ((AnnouncementMessageHeader)other).getSubject();
        }

        public String getSubject() {
            return this.m_subject == null ? "" : this.m_subject;
        }

        public void setSubject(String subject) {
            if (Different.different(subject, this.m_subject)) {
                this.m_subject = subject;
            }
        }

        public boolean getDraft() {
            return this.m_draft;
        }

        public void setDraft(boolean draft) {
            if (draft != this.m_draft) {
                this.m_draft = draft;
            }
        }

        public Element toXml(Document doc, Stack stack) {
            Element header = super.toXml(doc, stack);
            header.setAttribute("subject", this.getSubject());
            header.setAttribute("draft", new Boolean(this.getDraft()).toString());
            return header;
        }
    }

    public class BaseAnnouncementMessageEdit
    extends BaseMessageService.BaseMessageEdit
    implements AnnouncementMessageEdit {
        public BaseAnnouncementMessageEdit(MessageChannel channel, String id) {
            super((BaseMessageService)BaseAnnouncementService.this, channel, id);
        }

        public BaseAnnouncementMessageEdit(MessageChannel channel, Message other) {
            super((BaseMessageService)BaseAnnouncementService.this, channel, other);
        }

        public BaseAnnouncementMessageEdit(MessageChannel channel, Element el) {
            super((BaseMessageService)BaseAnnouncementService.this, channel, el);
        }

        public AnnouncementMessageHeader getAnnouncementHeader() {
            return (AnnouncementMessageHeader)this.getHeader();
        }

        public AnnouncementMessageHeaderEdit getAnnouncementHeaderEdit() {
            return (AnnouncementMessageHeaderEdit)this.getHeader();
        }
    }

    public class BaseAnnouncementChannelEdit
    extends BaseMessageService.BaseMessageChannelEdit
    implements AnnouncementChannelEdit {
        public BaseAnnouncementChannelEdit(String ref) {
            super((BaseMessageService)BaseAnnouncementService.this, ref);
        }

        public BaseAnnouncementChannelEdit(MessageChannel other) {
            super((BaseMessageService)BaseAnnouncementService.this, other);
        }

        public BaseAnnouncementChannelEdit(Element el) {
            super((BaseMessageService)BaseAnnouncementService.this, el);
        }

        public AnnouncementMessage getAnnouncementMessage(String messageId) throws IdUnusedException, PermissionException {
            AnnouncementMessage msg = (AnnouncementMessage)this.getMessage(messageId);
            if (msg.getAnnouncementHeader().getDraft() && !SecurityService.isSuperUser() && !msg.getHeader().getFrom().equals(UsageSessionService.getSessionUser()) && !BaseAnnouncementService.this.unlockCheck("read.drafts", msg.getReference())) {
                throw new PermissionException(UsageSessionService.getSessionUser().getId(), "read", msg.getReference());
            }
            return msg;
        }

        public List getMessages(Filter filter, boolean ascending) throws PermissionException {
            filter = new PrivacyFilter(filter);
            return super.getMessages(filter, ascending);
        }

        public AnnouncementMessageEdit editAnnouncementMessage(String messageId) throws IdUnusedException, PermissionException, InUseException {
            return (AnnouncementMessageEdit)this.editMessage(messageId);
        }

        public AnnouncementMessageEdit addAnnouncementMessage() throws PermissionException {
            return (AnnouncementMessageEdit)this.addMessage();
        }

        public AnnouncementMessage addAnnouncementMessage(String subject, boolean draft, ReferenceVector attachments, String body) throws PermissionException {
            AnnouncementMessageEdit edit = (AnnouncementMessageEdit)this.addMessage();
            AnnouncementMessageHeaderEdit header = edit.getAnnouncementHeaderEdit();
            edit.setBody(body);
            header.replaceAttachments(attachments);
            header.setSubject(subject);
            header.setDraft(draft);
            this.commitMessage(edit);
            return edit;
        }
    }
}

