% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_sigs_to_ref.R
\name{convert_sigs_to_ref}
\alias{convert_sigs_to_ref}
\title{Convert tissue specific signature exposures to reference}
\usage{
convert_sigs_to_ref(fit_res)
}
\arguments{
\item{fit_res}{Named list with signature contributions and reconstructed
mutation matrix}
}
\value{
The input fit_res, but with converted signature contributions.
}
\description{
This function converts tissue specific signature contributions into
reference signature contributions. This works on SNV signatures from SIGNAL.
It uses a conversion matrix to do the conversion.
The output can include possible artifact signatures.
}
\examples{

## See the 'mut_matrix()' example for how we obtained the mutation matrix:
mut_mat <- readRDS(system.file("states/mut_mat_data.rds",
  package = "MutationalPatterns"
))

## Get tissue specific signatures
signatures <- get_known_signatures(source = "SIGNAL", sig_type = "tissue", tissue_type = "Skin")

## Fit tissue specific signatures
fit_res <- fit_to_signatures(mut_mat, signatures)

## Convert the tissue specific signatures exposures to reference
fit_res <- convert_sigs_to_ref(fit_res)
}
