% This LilyPond file was generated by Rosegarden 23.06
\include "nederlands.ly"
\version "2.12.0"
\header {
    arranger = "D. Michael McIntyre"
    composer = "J. S. Bach (1685-1750)"
    copyright =  \markup { "Arrangement Copyright "\char ##x00A9" 2006 D. Michael McIntyre" }
    opus = "BWV 1060"
    subtitle = "duet arrangement for two trumpets in Bb"
    title = "Excerpt from Concerto in D minor BWV 1060"
    tagline = "Created using Rosegarden 23.06 and LilyPond"
}
#(set-global-staff-size 18)
#(set-default-paper-size "a4")
global = { 
    \time 4/4
    \skip 1*33 
}
globalTempo = {
    \override Score.MetronomeMark #'transparent = ##t
    \tempo 4 = 85  \skip 8... \skip 4 \skip 2 \skip 1*30 \skip 64 \skip 64 \skip 2 \skip 4 \skip 8 \skip 16 \skip 32 \skip 64 \skip 64 
    \tempo 4 = 80  \skip 1 
    \tempo 4 = 85  
}
\score {
    << % common
        % Force offset of colliding notes in chords:
        \override Score.NoteColumn #'force-hshift = #1.0
        % Allow fingerings inside the staff (configured from export options):
        \override Score.Fingering #'staff-padding = #'()

        \context Staff = "track 1, Trumpet I" << 
            \set Staff.instrumentName = \markup { \center-column { "Trumpet I " \line { "in B" \smaller \flat } } }
            \set Staff.midiInstrument = "Trumpet"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 0.0" {
                % Segment: Trumpet in Bb (I low)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1
                \once \override Staff.TimeSignature #'style = #'default 
                \time 4/4
                
                \clef "treble"
                \key e \minor
                b' 8 ^\markup { \bold \large "Allegro" } ^( [ e'' ) g'' ^( fis'' ) ] b' [ e'' 16 ^( fis'' ) ] g'' ^( [ fis'' ) g'' ^( fis'' ) ]  |
                \stemDown e' 8 [ fis' 16 g' ] a' [ b' c'' 8 ] c'' ^( [ fis' ) ] c'' ^( [ fis' ) ] \stemNeutral  |
                \breathe a' 8 ^( [ d'' ) fis'' ^( e'' ) ] a' [ d'' 16 ^( e'' ) ] fis'' ^( [ e'' ) fis'' ^( e'' ) ]  |
                \stemDown d' 8 [ e' 16 fis' ] g' [ a' b' 8 ] b' ^( [ e' ) ] b' ^( [ e' ) ] \stemNeutral  |
%% 5
                \breathe e'' 16 ^( [ d'' c'' b' ) ] a' 8 [ a' ] a' 4 r16 \stemDown e' [ a' b' ] \stemNeutral  |
                \stemDown c'' 16 ^( [ b' a' g' ) ] f' 8 [ f' ] f' 4 r16 c' [ f' g' ] \stemNeutral  |
                \stemDown a' 16 [ b' c'' b' ] a' [ g' fis'? e' ] dis' 8 [ b' e' a' ] \stemNeutral  |
                g'' 8. [ fis'' 16 ] fis'' 8. -\trill [ e'' 16 ] e'' 4 r16 c'' [ b' a' ]  |
                g' 8 -\staccato [ a' -\staccato ] g' -\staccato [ fis' -\staccato ] g' -\staccato [ c'' -\staccato ] b' -\staccato [ a' -\staccato ]  |
%% 10
                b' 8 -\staccato [ a' -\staccato ] g' -\staccato [ fis' -\staccato ] g' 16 [ fis' e' fis' ] g' [ a' b' cis'' ]  |
                \breathe dis'' 8 -\staccato [ e'' -\staccato ] fis'' -\staccato [ e'' -\staccato ] dis'' 16 [ b' a' fis' ] g' [ b' e'' g'' ]  |
                c'' 16 [ a' fis' dis' ] e' [ g' bes' cis'' ] e'' [ cis'' dis'' fis'' ] b' [ a' g' fis' ]  |
                \breathe b' 8 ^( [ e'' ) g'' ^( fis'' ) ] b' [ e'' 16 ^( fis'' ) ] g'' ^( [ fis'' ) g'' ^( fis'' ) ]  |
                e' 8 [ fis' 16 g' ] a' [ b' c'' 8 ] c'' _( [ fis' ) ] \breathe d' 16 [ e' fis' g' ]  |
%% 15
                a' 8 -\staccato [ g' -\staccato ] c'' -\staccato [ b' -\staccato ] a' -\staccato [ g' -\staccato ] fis' -\staccato [ e' -\staccato ]  |
                a' 8 ^( [ d'' ) fis'' ^( e'' ) ] a' [ d'' 16 ^( e'' ) ] fis'' ^( [ e'' ) fis'' ^( e'' ) ]  |
                d' 8 [ e' 16 fis' ] g' [ a' b' 8 ] b' _( [ e' ) ] e' 16 [ dis' e' fis' ]  |
                g' 8 -\staccato [ a' -\staccato ] g' -\staccato [ c'' -\staccato ] b' -\staccato [ a' -\staccato ] g' -\staccato [ fis' -\staccato ]  |
                e'' 16 ^( [ d'' c'' b' ) ] a' 8 [ a' ] a' 4 r  |
%% 20
                d'' 16 ^( [ c'' b' a' ) ] g' 8 [ g' ] g' 4 r  |
                R1  |
                r2 r16 a' ^( [ c'' b' ] \stemDown a' [ g' fis' e' ) ] \stemNeutral  |
                d' 8 _( [ g' ) b' _( a' ) ] d' [ g' 16 _( a' ) ] b' _( [ a' ) b' _( a' ) ]  |
                g' 8 [ a' 16 b' ] c'' [ d'' e'' 8 ] e'' ^( [ fis' ) ] r4  |
%% 25
                fis' 8 [ g' 16 a' ] b' [ c'' d'' 8 ] d'' _( [ e' ) ] r4  |
                \stemDown e' 8 [ fis' 16 g' ] a' [ b' c'' 8 ] c'' ^( [ d' ) ] r4 \stemNeutral  |
                r4 g'' 8 [ d'' ] r4 g'' 8 [ d'' ]  |
                r4 g'' 8 [ d'' ] r4 g'' 16 ^( [ fis'' e'' d'' ) ]  |
                c'' 8 [ c'' ] c'' 4 r8 c'' 16 [ b' ] a' _( [ g' fis' e' ) ]  |
%% 30
                d' 8 [ d' ] d' 4 r2  |
                R1  |
                g'' 16 _\markup { \bold \italic "ritard." } [ fis'' e'' d'' ] cis'' 8 \stemDown bes 4 \breathe a 16 [ g ] fis 8. [ g 16 ] \stemNeutral  |
                \stemDown g 1 \stemNeutral  |
                \bar "|."
            } % Voice

            % End of segment Trumpet in Bb (I low)

            % End voice 0

            \context Voice = "voice 0.1" {
                % Segment: Trumpet in Bb (I high)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1
                \once \override Staff.TimeSignature #'style = #'default 
                \time 4/4
                
                \clef "treble"
                \key e \minor
                s1\tiny   |
                \stemUp e'' 8 [ fis'' 16 g'' ] a'' [ b'' c''' 8 ] c''' ^( [ fis'' ) ] c''' ^( [ fis'' ) ] \stemNeutral  |
                s1  |
                \stemUp d'' 8 [ e'' 16 fis'' ] g'' [ a'' b'' 8 ] b'' ^( [ e'' ) ] b'' ^( [ e'' ) ] \stemNeutral  |
%% 5
                s2 s4 r16 \stemUp e'' [ a'' b'' ] \stemNeutral  |
                \stemUp c''' 16 ^( [ b'' a'' g'' ) ] f'' 8 [ f'' ] f'' 4 r16 c'' [ f'' g'' ] \stemNeutral  |
                \stemUp a'' 16 [ b'' c''' b'' ] a'' [ g'' fis''? e'' ] dis'' 8 [ b'' e'' a'' ] \stemNeutral  |
                s1  |
                s1  |
%% 10
                s1  |
                s1  |
                s1  |
                s1  |
                s1  |
%% 15
                s1  |
                s1  |
                s1  |
                s1  |
                s1  |
%% 20
                s1  |
                s1  |
                s1  |
                s1  |
                s1  |
%% 25
                s1  |
                \stemUp e'' 8 [ fis'' 16 g'' ] a'' [ b'' c''' 8 ] c''' ^( [ d'' ) ] r4 \stemNeutral  |
                s1  |
                s1  |
                s1  |
%% 30
                s1  |
                s1  |
                s4 s8 \stemUp bes'' 4 a'' 16 [ g'' ] fis'' 8. -\trill [ g'' 16 ] \stemNeutral  |
                \stemUp g'' 1 \normalsize \stemNeutral  |
                \bar "|."
            } % Voice

            % End of segment Trumpet in Bb (I high)

            % End voice 1
        >> % Staff ends

        \context Staff = "track 2, Trumpet II" << 
            \set Staff.instrumentName = \markup { \center-column { "Trumpet II " \line { "in B" \smaller \flat } } }
            \set Staff.midiInstrument = "Oboe"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 1.0" {
                % Segment: Trumpet in Bb (II)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1
                \once \override Staff.TimeSignature #'style = #'default 
                \time 4/4
                
                \clef "treble"
                \key e \minor
                b 8 _( [ e' ) g' _( fis' ) ] b [ e' 16 _( fis' ) ] g' _( [ fis' ) g' _( fis' ) ]  |
                e' 8 [ fis' 16 g' ] a' [ b' c'' 8 ] c'' _( [ fis' ) ] c'' _( [ fis' ) ]  |
                \breathe a 8 _( [ d' ) fis' _( e' ) ] a [ d' 16 _( e' ) ] fis' _( [ e' ) fis' _( e' ) ]  |
                d' 8 [ e' 16 fis' ] g' [ a' b' 8 ] b' _( [ e' ) ] b' _( [ e' ) ]  |
%% 5
                r4 e'' 16 ^( [ d'' c'' b' ) ] a' 8 r r4  |
                r4 c'' 16 _( [ b' a' g' ) ] f' 8 r r f' 16 [ g' ]  |
                a' 16 [ b' c'' b' ] a' [ g' fis'? e' ] dis' 8 [ b' e' a' ]  |
                \breathe g' 8. -\tenuto [ fis' 16 ] fis' 8. _\markup { \finger "0 1" } -\trill [ e' 16 ] e' [ b cis' dis' ] e' [ fis' g' a' ]  |
                b' 8 ^( [ c'' ) b' ^( a' ) ] b' _( [ a' ) g' _( fis' ) ]  |
%% 10
                g' 8 [ c'' b' a' ] b' 16 [ a' g' fis' ] e' 8 r  |
                fis' 8 _( [ g' ) a' _( g' ) ] fis' _( [ c'' ) b' _( g' ) ]  |
                dis' 8 _( [ a' ) g' _( e' ) ] g' _( [ fis' ) ] r4  |
                b 8 _( [ e' ) g' _( fis' ) ] b [ e' 16 _( fis' ) ] g' _( [ fis' ) g' _( fis' ) ]  |
                e' 8 [ fis' 16 g' ] a' [ b' ] c'' 8 c'' 2 _\markup { \finger "0 1" } -\startTrillSpan s4*0 \stopTrillSpan _~  |
%% 15
                c'' 8 -\tenuto _~ [ \breathe b' _( a' g' ) ] fis' _( [ e' ) d' _( cis' ) ]  |
                a 8 _( [ d' ) fis' _( e' ) ] a [ d' 16 _( e' ) ] fis' _( [ e' ) fis' _( e' ) ]  |
                d' 8 [ e' 16 fis' ] g' [ a' ] b' 8 b' 2 \startTrillSpan _~ 
                % warning: overlong bar truncated here |
                b' 8 -\tenuto _~ \breathe c'' \stopTrillSpan [ b' a' ] g' [ fis' e' dis' ]  |
                e' 4 -\tenuto r8 fis' 16 [ g' ] a' [ g' fis' e' ] d' [ c' b a ]  |
%% 20
                g 8 d'' 4 \breathe e'' 16 [ fis'' ] g'' [ fis'' e'' d'' ] c'' [ b' a' g' ]  |
                fis' 16 [ g' a' b' ] c' [ b c' e' ] d' [ e' fis' g' ] a' [ g' a' c'' ]  |
                \breathe b' 16 [ d'' e'' d'' ] c'' [ b' a' g' ] d'' 2 _\markup { \finger "0 1" }  \startTrillSpan _~ 
                % warning: overlong bar truncated here |
                d'' 1 _~  |
                d'' 4 -\tenuto \stopTrillSpan r8 g' [ c'' 16 b' a' b' ] c'' [ d'' ] e'' 8  |
%% 25
                \stemUp e'' 8 _( [ fis' ) ] r \stemNeutral fis' b' 16 [ a' g' a' ] b' [ c'' d'' 8 ]  |
                d'' 8 _( [ e' ) ] r e' a' 16 [ g' fis' g' ] a' [ b' c'' 8 ]  |
                d' 8 [ g' 16 a' ] b' [ a' b' a' ] g' [ e' g' a' ] b' [ a' b' a' ]  |
                g' 16 [ d' g' a' ] b' [ a' b' a' ] g' _( [ fis' e' d' ) ] c' 8 [ c' ]  |
                c' 4 \breathe c' 16 [ g c' e' ] a' [ g' fis' e' ] d' [ c' b c' ]  |
%% 30
                c' 4 \breathe c' 16 [ d' fis' a' ] \stemUp b' _( [ a' ) c'' _( b' ) ] \stemNeutral e'' [ d'' c'' b' ]  |
                a' 16 [ g' fis' e' ] d' [ c' b a ] b 8 [ g' a fis' ]  |
                g' 16 _\markup { \bold \italic "ritard." } [ fis' e' d' ] cis' 8 bes' 4 \breathe a' 16 [ g' ] fis' 8. -\trill_\markup { \finger "0 2" }  [ g' 16 ]  |
                g' 1  |
                \bar "|."
            } % Voice

            % End of segment Trumpet in Bb (II)

            % End voice 0
        >> % Staff ends

    >> % notes

    \layout {
        indent = 3.0\cm
        short-indent = 1.5\cm
        \context { \Staff \RemoveEmptyStaves }
        \context { \GrandStaff \accepts "Lyrics" }
    }
%     uncomment to enable generating midi file from the lilypond source
%         \midi {
%         } 
} % score
