# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


class Show(AAZCommand):
    """Get the details of an application gateway.

    :example: Get the details of an application gateway.
        az network application-gateway show -g MyResourceGroup -n MyAppGateway
    """

    _aaz_info = {
        "version": "2018-11-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/applicationgateways/{}", "2018-11-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="Name of the application gateway.",
            required=True,
            id_part="name",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.ApplicationGatewaysGet(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class ApplicationGatewaysGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "applicationGatewayName", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2018-11-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.etag = AAZStrType()
            _schema_on_200.id = AAZStrType()
            _schema_on_200.identity = AAZObjectType()
            _schema_on_200.location = AAZStrType()
            _schema_on_200.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200.tags = AAZDictType()
            _schema_on_200.type = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.zones = AAZListType()

            identity = cls._schema_on_200.identity
            identity.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )
            identity.tenant_id = AAZStrType(
                serialized_name="tenantId",
                flags={"read_only": True},
            )
            identity.type = AAZStrType()
            identity.user_assigned_identities = AAZDictType(
                serialized_name="userAssignedIdentities",
            )

            user_assigned_identities = cls._schema_on_200.identity.user_assigned_identities
            user_assigned_identities.Element = AAZObjectType()

            _element = cls._schema_on_200.identity.user_assigned_identities.Element
            _element.client_id = AAZStrType(
                serialized_name="clientId",
                flags={"read_only": True},
            )
            _element.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.properties
            properties.authentication_certificates = AAZListType(
                serialized_name="authenticationCertificates",
            )
            properties.autoscale_configuration = AAZObjectType(
                serialized_name="autoscaleConfiguration",
            )
            properties.backend_address_pools = AAZListType(
                serialized_name="backendAddressPools",
            )
            properties.backend_http_settings_collection = AAZListType(
                serialized_name="backendHttpSettingsCollection",
            )
            properties.custom_error_configurations = AAZListType(
                serialized_name="customErrorConfigurations",
            )
            properties.enable_fips = AAZBoolType(
                serialized_name="enableFips",
            )
            properties.enable_http2 = AAZBoolType(
                serialized_name="enableHttp2",
            )
            properties.frontend_ip_configurations = AAZListType(
                serialized_name="frontendIPConfigurations",
            )
            properties.frontend_ports = AAZListType(
                serialized_name="frontendPorts",
            )
            properties.gateway_ip_configurations = AAZListType(
                serialized_name="gatewayIPConfigurations",
            )
            properties.http_listeners = AAZListType(
                serialized_name="httpListeners",
            )
            properties.operational_state = AAZStrType(
                serialized_name="operationalState",
                flags={"read_only": True},
            )
            properties.probes = AAZListType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
            )
            properties.redirect_configurations = AAZListType(
                serialized_name="redirectConfigurations",
            )
            properties.request_routing_rules = AAZListType(
                serialized_name="requestRoutingRules",
            )
            properties.resource_guid = AAZStrType(
                serialized_name="resourceGuid",
            )
            properties.rewrite_rule_sets = AAZListType(
                serialized_name="rewriteRuleSets",
            )
            properties.sku = AAZObjectType()
            properties.ssl_certificates = AAZListType(
                serialized_name="sslCertificates",
            )
            properties.ssl_policy = AAZObjectType(
                serialized_name="sslPolicy",
            )
            properties.trusted_root_certificates = AAZListType(
                serialized_name="trustedRootCertificates",
            )
            properties.url_path_maps = AAZListType(
                serialized_name="urlPathMaps",
            )
            properties.web_application_firewall_configuration = AAZObjectType(
                serialized_name="webApplicationFirewallConfiguration",
            )

            authentication_certificates = cls._schema_on_200.properties.authentication_certificates
            authentication_certificates.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.authentication_certificates.Element
            _element.etag = AAZStrType()
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType()

            properties = cls._schema_on_200.properties.authentication_certificates.Element.properties
            properties.data = AAZStrType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
            )

            autoscale_configuration = cls._schema_on_200.properties.autoscale_configuration
            autoscale_configuration.max_capacity = AAZIntType(
                serialized_name="maxCapacity",
            )
            autoscale_configuration.min_capacity = AAZIntType(
                serialized_name="minCapacity",
                flags={"required": True},
            )

            backend_address_pools = cls._schema_on_200.properties.backend_address_pools
            backend_address_pools.Element = AAZObjectType()
            _ShowHelper._build_schema_application_gateway_backend_address_pool_read(backend_address_pools.Element)

            backend_http_settings_collection = cls._schema_on_200.properties.backend_http_settings_collection
            backend_http_settings_collection.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.backend_http_settings_collection.Element
            _element.etag = AAZStrType()
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType()

            properties = cls._schema_on_200.properties.backend_http_settings_collection.Element.properties
            properties.affinity_cookie_name = AAZStrType(
                serialized_name="affinityCookieName",
            )
            properties.authentication_certificates = AAZListType(
                serialized_name="authenticationCertificates",
            )
            properties.connection_draining = AAZObjectType(
                serialized_name="connectionDraining",
            )
            properties.cookie_based_affinity = AAZStrType(
                serialized_name="cookieBasedAffinity",
            )
            properties.host_name = AAZStrType(
                serialized_name="hostName",
            )
            properties.path = AAZStrType()
            properties.pick_host_name_from_backend_address = AAZBoolType(
                serialized_name="pickHostNameFromBackendAddress",
            )
            properties.port = AAZIntType()
            properties.probe = AAZObjectType()
            _ShowHelper._build_schema_sub_resource_read(properties.probe)
            properties.probe_enabled = AAZBoolType(
                serialized_name="probeEnabled",
            )
            properties.protocol = AAZStrType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
            )
            properties.request_timeout = AAZIntType(
                serialized_name="requestTimeout",
            )
            properties.trusted_root_certificates = AAZListType(
                serialized_name="trustedRootCertificates",
            )

            authentication_certificates = cls._schema_on_200.properties.backend_http_settings_collection.Element.properties.authentication_certificates
            authentication_certificates.Element = AAZObjectType()
            _ShowHelper._build_schema_sub_resource_read(authentication_certificates.Element)

            connection_draining = cls._schema_on_200.properties.backend_http_settings_collection.Element.properties.connection_draining
            connection_draining.drain_timeout_in_sec = AAZIntType(
                serialized_name="drainTimeoutInSec",
                flags={"required": True},
            )
            connection_draining.enabled = AAZBoolType(
                flags={"required": True},
            )

            trusted_root_certificates = cls._schema_on_200.properties.backend_http_settings_collection.Element.properties.trusted_root_certificates
            trusted_root_certificates.Element = AAZObjectType()
            _ShowHelper._build_schema_sub_resource_read(trusted_root_certificates.Element)

            custom_error_configurations = cls._schema_on_200.properties.custom_error_configurations
            custom_error_configurations.Element = AAZObjectType()
            _ShowHelper._build_schema_application_gateway_custom_error_read(custom_error_configurations.Element)

            frontend_ip_configurations = cls._schema_on_200.properties.frontend_ip_configurations
            frontend_ip_configurations.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.frontend_ip_configurations.Element
            _element.etag = AAZStrType()
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType()

            properties = cls._schema_on_200.properties.frontend_ip_configurations.Element.properties
            properties.private_ip_address = AAZStrType(
                serialized_name="privateIPAddress",
            )
            properties.private_ip_allocation_method = AAZStrType(
                serialized_name="privateIPAllocationMethod",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
            )
            properties.public_ip_address = AAZObjectType(
                serialized_name="publicIPAddress",
            )
            _ShowHelper._build_schema_sub_resource_read(properties.public_ip_address)
            properties.subnet = AAZObjectType()
            _ShowHelper._build_schema_sub_resource_read(properties.subnet)

            frontend_ports = cls._schema_on_200.properties.frontend_ports
            frontend_ports.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.frontend_ports.Element
            _element.etag = AAZStrType()
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType()

            properties = cls._schema_on_200.properties.frontend_ports.Element.properties
            properties.port = AAZIntType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
            )

            gateway_ip_configurations = cls._schema_on_200.properties.gateway_ip_configurations
            gateway_ip_configurations.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.gateway_ip_configurations.Element
            _element.etag = AAZStrType()
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType()

            properties = cls._schema_on_200.properties.gateway_ip_configurations.Element.properties
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
            )
            properties.subnet = AAZObjectType()
            _ShowHelper._build_schema_sub_resource_read(properties.subnet)

            http_listeners = cls._schema_on_200.properties.http_listeners
            http_listeners.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.http_listeners.Element
            _element.etag = AAZStrType()
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType()

            properties = cls._schema_on_200.properties.http_listeners.Element.properties
            properties.custom_error_configurations = AAZListType(
                serialized_name="customErrorConfigurations",
            )
            properties.frontend_ip_configuration = AAZObjectType(
                serialized_name="frontendIPConfiguration",
            )
            _ShowHelper._build_schema_sub_resource_read(properties.frontend_ip_configuration)
            properties.frontend_port = AAZObjectType(
                serialized_name="frontendPort",
            )
            _ShowHelper._build_schema_sub_resource_read(properties.frontend_port)
            properties.host_name = AAZStrType(
                serialized_name="hostName",
            )
            properties.protocol = AAZStrType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
            )
            properties.require_server_name_indication = AAZBoolType(
                serialized_name="requireServerNameIndication",
            )
            properties.ssl_certificate = AAZObjectType(
                serialized_name="sslCertificate",
            )
            _ShowHelper._build_schema_sub_resource_read(properties.ssl_certificate)

            custom_error_configurations = cls._schema_on_200.properties.http_listeners.Element.properties.custom_error_configurations
            custom_error_configurations.Element = AAZObjectType()
            _ShowHelper._build_schema_application_gateway_custom_error_read(custom_error_configurations.Element)

            probes = cls._schema_on_200.properties.probes
            probes.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.probes.Element
            _element.etag = AAZStrType()
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType()

            properties = cls._schema_on_200.properties.probes.Element.properties
            properties.host = AAZStrType()
            properties.interval = AAZIntType()
            properties.match = AAZObjectType()
            properties.min_servers = AAZIntType(
                serialized_name="minServers",
            )
            properties.path = AAZStrType()
            properties.pick_host_name_from_backend_http_settings = AAZBoolType(
                serialized_name="pickHostNameFromBackendHttpSettings",
            )
            properties.protocol = AAZStrType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
            )
            properties.timeout = AAZIntType()
            properties.unhealthy_threshold = AAZIntType(
                serialized_name="unhealthyThreshold",
            )

            match = cls._schema_on_200.properties.probes.Element.properties.match
            match.body = AAZStrType()
            match.status_codes = AAZListType(
                serialized_name="statusCodes",
            )

            status_codes = cls._schema_on_200.properties.probes.Element.properties.match.status_codes
            status_codes.Element = AAZStrType()

            redirect_configurations = cls._schema_on_200.properties.redirect_configurations
            redirect_configurations.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.redirect_configurations.Element
            _element.etag = AAZStrType()
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType()

            properties = cls._schema_on_200.properties.redirect_configurations.Element.properties
            properties.include_path = AAZBoolType(
                serialized_name="includePath",
            )
            properties.include_query_string = AAZBoolType(
                serialized_name="includeQueryString",
            )
            properties.path_rules = AAZListType(
                serialized_name="pathRules",
            )
            properties.redirect_type = AAZStrType(
                serialized_name="redirectType",
            )
            properties.request_routing_rules = AAZListType(
                serialized_name="requestRoutingRules",
            )
            properties.target_listener = AAZObjectType(
                serialized_name="targetListener",
            )
            _ShowHelper._build_schema_sub_resource_read(properties.target_listener)
            properties.target_url = AAZStrType(
                serialized_name="targetUrl",
            )
            properties.url_path_maps = AAZListType(
                serialized_name="urlPathMaps",
            )

            path_rules = cls._schema_on_200.properties.redirect_configurations.Element.properties.path_rules
            path_rules.Element = AAZObjectType()
            _ShowHelper._build_schema_sub_resource_read(path_rules.Element)

            request_routing_rules = cls._schema_on_200.properties.redirect_configurations.Element.properties.request_routing_rules
            request_routing_rules.Element = AAZObjectType()
            _ShowHelper._build_schema_sub_resource_read(request_routing_rules.Element)

            url_path_maps = cls._schema_on_200.properties.redirect_configurations.Element.properties.url_path_maps
            url_path_maps.Element = AAZObjectType()
            _ShowHelper._build_schema_sub_resource_read(url_path_maps.Element)

            request_routing_rules = cls._schema_on_200.properties.request_routing_rules
            request_routing_rules.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.request_routing_rules.Element
            _element.etag = AAZStrType()
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType()

            properties = cls._schema_on_200.properties.request_routing_rules.Element.properties
            properties.backend_address_pool = AAZObjectType(
                serialized_name="backendAddressPool",
            )
            _ShowHelper._build_schema_sub_resource_read(properties.backend_address_pool)
            properties.backend_http_settings = AAZObjectType(
                serialized_name="backendHttpSettings",
            )
            _ShowHelper._build_schema_sub_resource_read(properties.backend_http_settings)
            properties.http_listener = AAZObjectType(
                serialized_name="httpListener",
            )
            _ShowHelper._build_schema_sub_resource_read(properties.http_listener)
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
            )
            properties.redirect_configuration = AAZObjectType(
                serialized_name="redirectConfiguration",
            )
            _ShowHelper._build_schema_sub_resource_read(properties.redirect_configuration)
            properties.rewrite_rule_set = AAZObjectType(
                serialized_name="rewriteRuleSet",
            )
            _ShowHelper._build_schema_sub_resource_read(properties.rewrite_rule_set)
            properties.rule_type = AAZStrType(
                serialized_name="ruleType",
            )
            properties.url_path_map = AAZObjectType(
                serialized_name="urlPathMap",
            )
            _ShowHelper._build_schema_sub_resource_read(properties.url_path_map)

            rewrite_rule_sets = cls._schema_on_200.properties.rewrite_rule_sets
            rewrite_rule_sets.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.rewrite_rule_sets.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )

            properties = cls._schema_on_200.properties.rewrite_rule_sets.Element.properties
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.rewrite_rules = AAZListType(
                serialized_name="rewriteRules",
            )

            rewrite_rules = cls._schema_on_200.properties.rewrite_rule_sets.Element.properties.rewrite_rules
            rewrite_rules.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.rewrite_rule_sets.Element.properties.rewrite_rules.Element
            _element.action_set = AAZObjectType(
                serialized_name="actionSet",
            )
            _element.name = AAZStrType()

            action_set = cls._schema_on_200.properties.rewrite_rule_sets.Element.properties.rewrite_rules.Element.action_set
            action_set.request_header_configurations = AAZListType(
                serialized_name="requestHeaderConfigurations",
            )
            action_set.response_header_configurations = AAZListType(
                serialized_name="responseHeaderConfigurations",
            )

            request_header_configurations = cls._schema_on_200.properties.rewrite_rule_sets.Element.properties.rewrite_rules.Element.action_set.request_header_configurations
            request_header_configurations.Element = AAZObjectType()
            _ShowHelper._build_schema_application_gateway_header_configuration_read(request_header_configurations.Element)

            response_header_configurations = cls._schema_on_200.properties.rewrite_rule_sets.Element.properties.rewrite_rules.Element.action_set.response_header_configurations
            response_header_configurations.Element = AAZObjectType()
            _ShowHelper._build_schema_application_gateway_header_configuration_read(response_header_configurations.Element)

            sku = cls._schema_on_200.properties.sku
            sku.capacity = AAZIntType()
            sku.name = AAZStrType()
            sku.tier = AAZStrType()

            ssl_certificates = cls._schema_on_200.properties.ssl_certificates
            ssl_certificates.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.ssl_certificates.Element
            _element.etag = AAZStrType()
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType()

            properties = cls._schema_on_200.properties.ssl_certificates.Element.properties
            properties.data = AAZStrType()
            properties.key_vault_secret_id = AAZStrType(
                serialized_name="keyVaultSecretId",
            )
            properties.password = AAZStrType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
            )
            properties.public_cert_data = AAZStrType(
                serialized_name="publicCertData",
            )

            ssl_policy = cls._schema_on_200.properties.ssl_policy
            ssl_policy.cipher_suites = AAZListType(
                serialized_name="cipherSuites",
            )
            ssl_policy.disabled_ssl_protocols = AAZListType(
                serialized_name="disabledSslProtocols",
            )
            ssl_policy.min_protocol_version = AAZStrType(
                serialized_name="minProtocolVersion",
            )
            ssl_policy.policy_name = AAZStrType(
                serialized_name="policyName",
            )
            ssl_policy.policy_type = AAZStrType(
                serialized_name="policyType",
            )

            cipher_suites = cls._schema_on_200.properties.ssl_policy.cipher_suites
            cipher_suites.Element = AAZStrType()

            disabled_ssl_protocols = cls._schema_on_200.properties.ssl_policy.disabled_ssl_protocols
            disabled_ssl_protocols.Element = AAZStrType()

            trusted_root_certificates = cls._schema_on_200.properties.trusted_root_certificates
            trusted_root_certificates.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.trusted_root_certificates.Element
            _element.etag = AAZStrType()
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType()

            properties = cls._schema_on_200.properties.trusted_root_certificates.Element.properties
            properties.data = AAZStrType()
            properties.key_vault_secret_id = AAZStrType(
                serialized_name="keyVaultSecretId",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
            )

            url_path_maps = cls._schema_on_200.properties.url_path_maps
            url_path_maps.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.url_path_maps.Element
            _element.etag = AAZStrType()
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType()

            properties = cls._schema_on_200.properties.url_path_maps.Element.properties
            properties.default_backend_address_pool = AAZObjectType(
                serialized_name="defaultBackendAddressPool",
            )
            _ShowHelper._build_schema_sub_resource_read(properties.default_backend_address_pool)
            properties.default_backend_http_settings = AAZObjectType(
                serialized_name="defaultBackendHttpSettings",
            )
            _ShowHelper._build_schema_sub_resource_read(properties.default_backend_http_settings)
            properties.default_redirect_configuration = AAZObjectType(
                serialized_name="defaultRedirectConfiguration",
            )
            _ShowHelper._build_schema_sub_resource_read(properties.default_redirect_configuration)
            properties.default_rewrite_rule_set = AAZObjectType(
                serialized_name="defaultRewriteRuleSet",
            )
            _ShowHelper._build_schema_sub_resource_read(properties.default_rewrite_rule_set)
            properties.path_rules = AAZListType(
                serialized_name="pathRules",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
            )

            path_rules = cls._schema_on_200.properties.url_path_maps.Element.properties.path_rules
            path_rules.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.url_path_maps.Element.properties.path_rules.Element
            _element.etag = AAZStrType()
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType()

            properties = cls._schema_on_200.properties.url_path_maps.Element.properties.path_rules.Element.properties
            properties.backend_address_pool = AAZObjectType(
                serialized_name="backendAddressPool",
            )
            _ShowHelper._build_schema_sub_resource_read(properties.backend_address_pool)
            properties.backend_http_settings = AAZObjectType(
                serialized_name="backendHttpSettings",
            )
            _ShowHelper._build_schema_sub_resource_read(properties.backend_http_settings)
            properties.paths = AAZListType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
            )
            properties.redirect_configuration = AAZObjectType(
                serialized_name="redirectConfiguration",
            )
            _ShowHelper._build_schema_sub_resource_read(properties.redirect_configuration)
            properties.rewrite_rule_set = AAZObjectType(
                serialized_name="rewriteRuleSet",
            )
            _ShowHelper._build_schema_sub_resource_read(properties.rewrite_rule_set)

            paths = cls._schema_on_200.properties.url_path_maps.Element.properties.path_rules.Element.properties.paths
            paths.Element = AAZStrType()

            web_application_firewall_configuration = cls._schema_on_200.properties.web_application_firewall_configuration
            web_application_firewall_configuration.disabled_rule_groups = AAZListType(
                serialized_name="disabledRuleGroups",
            )
            web_application_firewall_configuration.enabled = AAZBoolType(
                flags={"required": True},
            )
            web_application_firewall_configuration.exclusions = AAZListType()
            web_application_firewall_configuration.file_upload_limit_in_mb = AAZIntType(
                serialized_name="fileUploadLimitInMb",
            )
            web_application_firewall_configuration.firewall_mode = AAZStrType(
                serialized_name="firewallMode",
                flags={"required": True},
            )
            web_application_firewall_configuration.max_request_body_size = AAZIntType(
                serialized_name="maxRequestBodySize",
            )
            web_application_firewall_configuration.max_request_body_size_in_kb = AAZIntType(
                serialized_name="maxRequestBodySizeInKb",
            )
            web_application_firewall_configuration.request_body_check = AAZBoolType(
                serialized_name="requestBodyCheck",
            )
            web_application_firewall_configuration.rule_set_type = AAZStrType(
                serialized_name="ruleSetType",
                flags={"required": True},
            )
            web_application_firewall_configuration.rule_set_version = AAZStrType(
                serialized_name="ruleSetVersion",
                flags={"required": True},
            )

            disabled_rule_groups = cls._schema_on_200.properties.web_application_firewall_configuration.disabled_rule_groups
            disabled_rule_groups.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.web_application_firewall_configuration.disabled_rule_groups.Element
            _element.rule_group_name = AAZStrType(
                serialized_name="ruleGroupName",
                flags={"required": True},
            )
            _element.rules = AAZListType()

            rules = cls._schema_on_200.properties.web_application_firewall_configuration.disabled_rule_groups.Element.rules
            rules.Element = AAZIntType()

            exclusions = cls._schema_on_200.properties.web_application_firewall_configuration.exclusions
            exclusions.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.web_application_firewall_configuration.exclusions.Element
            _element.match_variable = AAZStrType(
                serialized_name="matchVariable",
                flags={"required": True},
            )
            _element.selector = AAZStrType(
                flags={"required": True},
            )
            _element.selector_match_operator = AAZStrType(
                serialized_name="selectorMatchOperator",
                flags={"required": True},
            )

            tags = cls._schema_on_200.tags
            tags.Element = AAZStrType()

            zones = cls._schema_on_200.zones
            zones.Element = AAZStrType()

            return cls._schema_on_200


class _ShowHelper:
    """Helper class for Show"""

    _schema_application_gateway_backend_address_pool_read = None

    @classmethod
    def _build_schema_application_gateway_backend_address_pool_read(cls, _schema):
        if cls._schema_application_gateway_backend_address_pool_read is not None:
            _schema.etag = cls._schema_application_gateway_backend_address_pool_read.etag
            _schema.id = cls._schema_application_gateway_backend_address_pool_read.id
            _schema.name = cls._schema_application_gateway_backend_address_pool_read.name
            _schema.properties = cls._schema_application_gateway_backend_address_pool_read.properties
            _schema.type = cls._schema_application_gateway_backend_address_pool_read.type
            return

        cls._schema_application_gateway_backend_address_pool_read = _schema_application_gateway_backend_address_pool_read = AAZObjectType()

        application_gateway_backend_address_pool_read = _schema_application_gateway_backend_address_pool_read
        application_gateway_backend_address_pool_read.etag = AAZStrType()
        application_gateway_backend_address_pool_read.id = AAZStrType()
        application_gateway_backend_address_pool_read.name = AAZStrType()
        application_gateway_backend_address_pool_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        application_gateway_backend_address_pool_read.type = AAZStrType()

        properties = _schema_application_gateway_backend_address_pool_read.properties
        properties.backend_addresses = AAZListType(
            serialized_name="backendAddresses",
        )
        properties.backend_ip_configurations = AAZListType(
            serialized_name="backendIPConfigurations",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )

        backend_addresses = _schema_application_gateway_backend_address_pool_read.properties.backend_addresses
        backend_addresses.Element = AAZObjectType()

        _element = _schema_application_gateway_backend_address_pool_read.properties.backend_addresses.Element
        _element.fqdn = AAZStrType()
        _element.ip_address = AAZStrType(
            serialized_name="ipAddress",
        )

        backend_ip_configurations = _schema_application_gateway_backend_address_pool_read.properties.backend_ip_configurations
        backend_ip_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_ip_configuration_read(backend_ip_configurations.Element)

        _schema.etag = cls._schema_application_gateway_backend_address_pool_read.etag
        _schema.id = cls._schema_application_gateway_backend_address_pool_read.id
        _schema.name = cls._schema_application_gateway_backend_address_pool_read.name
        _schema.properties = cls._schema_application_gateway_backend_address_pool_read.properties
        _schema.type = cls._schema_application_gateway_backend_address_pool_read.type

    _schema_application_gateway_custom_error_read = None

    @classmethod
    def _build_schema_application_gateway_custom_error_read(cls, _schema):
        if cls._schema_application_gateway_custom_error_read is not None:
            _schema.custom_error_page_url = cls._schema_application_gateway_custom_error_read.custom_error_page_url
            _schema.status_code = cls._schema_application_gateway_custom_error_read.status_code
            return

        cls._schema_application_gateway_custom_error_read = _schema_application_gateway_custom_error_read = AAZObjectType()

        application_gateway_custom_error_read = _schema_application_gateway_custom_error_read
        application_gateway_custom_error_read.custom_error_page_url = AAZStrType(
            serialized_name="customErrorPageUrl",
        )
        application_gateway_custom_error_read.status_code = AAZStrType(
            serialized_name="statusCode",
        )

        _schema.custom_error_page_url = cls._schema_application_gateway_custom_error_read.custom_error_page_url
        _schema.status_code = cls._schema_application_gateway_custom_error_read.status_code

    _schema_application_gateway_header_configuration_read = None

    @classmethod
    def _build_schema_application_gateway_header_configuration_read(cls, _schema):
        if cls._schema_application_gateway_header_configuration_read is not None:
            _schema.header_name = cls._schema_application_gateway_header_configuration_read.header_name
            _schema.header_value = cls._schema_application_gateway_header_configuration_read.header_value
            return

        cls._schema_application_gateway_header_configuration_read = _schema_application_gateway_header_configuration_read = AAZObjectType()

        application_gateway_header_configuration_read = _schema_application_gateway_header_configuration_read
        application_gateway_header_configuration_read.header_name = AAZStrType(
            serialized_name="headerName",
        )
        application_gateway_header_configuration_read.header_value = AAZStrType(
            serialized_name="headerValue",
        )

        _schema.header_name = cls._schema_application_gateway_header_configuration_read.header_name
        _schema.header_value = cls._schema_application_gateway_header_configuration_read.header_value

    _schema_application_security_group_read = None

    @classmethod
    def _build_schema_application_security_group_read(cls, _schema):
        if cls._schema_application_security_group_read is not None:
            _schema.etag = cls._schema_application_security_group_read.etag
            _schema.id = cls._schema_application_security_group_read.id
            _schema.location = cls._schema_application_security_group_read.location
            _schema.name = cls._schema_application_security_group_read.name
            _schema.properties = cls._schema_application_security_group_read.properties
            _schema.tags = cls._schema_application_security_group_read.tags
            _schema.type = cls._schema_application_security_group_read.type
            return

        cls._schema_application_security_group_read = _schema_application_security_group_read = AAZObjectType()

        application_security_group_read = _schema_application_security_group_read
        application_security_group_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        application_security_group_read.id = AAZStrType()
        application_security_group_read.location = AAZStrType()
        application_security_group_read.name = AAZStrType(
            flags={"read_only": True},
        )
        application_security_group_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        application_security_group_read.tags = AAZDictType()
        application_security_group_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_application_security_group_read.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
            flags={"read_only": True},
        )

        tags = _schema_application_security_group_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_application_security_group_read.etag
        _schema.id = cls._schema_application_security_group_read.id
        _schema.location = cls._schema_application_security_group_read.location
        _schema.name = cls._schema_application_security_group_read.name
        _schema.properties = cls._schema_application_security_group_read.properties
        _schema.tags = cls._schema_application_security_group_read.tags
        _schema.type = cls._schema_application_security_group_read.type

    _schema_ip_configuration_read = None

    @classmethod
    def _build_schema_ip_configuration_read(cls, _schema):
        if cls._schema_ip_configuration_read is not None:
            _schema.etag = cls._schema_ip_configuration_read.etag
            _schema.id = cls._schema_ip_configuration_read.id
            _schema.name = cls._schema_ip_configuration_read.name
            _schema.properties = cls._schema_ip_configuration_read.properties
            return

        cls._schema_ip_configuration_read = _schema_ip_configuration_read = AAZObjectType()

        ip_configuration_read = _schema_ip_configuration_read
        ip_configuration_read.etag = AAZStrType()
        ip_configuration_read.id = AAZStrType()
        ip_configuration_read.name = AAZStrType()
        ip_configuration_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_ip_configuration_read.properties
        properties.private_ip_address = AAZStrType(
            serialized_name="privateIPAddress",
        )
        properties.private_ip_allocation_method = AAZStrType(
            serialized_name="privateIPAllocationMethod",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.public_ip_address = AAZObjectType(
            serialized_name="publicIPAddress",
        )
        cls._build_schema_public_ip_address_read(properties.public_ip_address)
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)

        _schema.etag = cls._schema_ip_configuration_read.etag
        _schema.id = cls._schema_ip_configuration_read.id
        _schema.name = cls._schema_ip_configuration_read.name
        _schema.properties = cls._schema_ip_configuration_read.properties

    _schema_interface_endpoint_read = None

    @classmethod
    def _build_schema_interface_endpoint_read(cls, _schema):
        if cls._schema_interface_endpoint_read is not None:
            _schema.etag = cls._schema_interface_endpoint_read.etag
            _schema.id = cls._schema_interface_endpoint_read.id
            _schema.location = cls._schema_interface_endpoint_read.location
            _schema.name = cls._schema_interface_endpoint_read.name
            _schema.properties = cls._schema_interface_endpoint_read.properties
            _schema.tags = cls._schema_interface_endpoint_read.tags
            _schema.type = cls._schema_interface_endpoint_read.type
            return

        cls._schema_interface_endpoint_read = _schema_interface_endpoint_read = AAZObjectType()

        interface_endpoint_read = _schema_interface_endpoint_read
        interface_endpoint_read.etag = AAZStrType()
        interface_endpoint_read.id = AAZStrType()
        interface_endpoint_read.location = AAZStrType()
        interface_endpoint_read.name = AAZStrType(
            flags={"read_only": True},
        )
        interface_endpoint_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        interface_endpoint_read.tags = AAZDictType()
        interface_endpoint_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_interface_endpoint_read.properties
        properties.endpoint_service = AAZObjectType(
            serialized_name="endpointService",
        )
        properties.fqdn = AAZStrType()
        properties.network_interfaces = AAZListType(
            serialized_name="networkInterfaces",
            flags={"read_only": True},
        )
        properties.owner = AAZStrType(
            flags={"read_only": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)

        endpoint_service = _schema_interface_endpoint_read.properties.endpoint_service
        endpoint_service.id = AAZStrType()

        network_interfaces = _schema_interface_endpoint_read.properties.network_interfaces
        network_interfaces.Element = AAZObjectType()
        cls._build_schema_network_interface_read(network_interfaces.Element)

        tags = _schema_interface_endpoint_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_interface_endpoint_read.etag
        _schema.id = cls._schema_interface_endpoint_read.id
        _schema.location = cls._schema_interface_endpoint_read.location
        _schema.name = cls._schema_interface_endpoint_read.name
        _schema.properties = cls._schema_interface_endpoint_read.properties
        _schema.tags = cls._schema_interface_endpoint_read.tags
        _schema.type = cls._schema_interface_endpoint_read.type

    _schema_network_interface_ip_configuration_read = None

    @classmethod
    def _build_schema_network_interface_ip_configuration_read(cls, _schema):
        if cls._schema_network_interface_ip_configuration_read is not None:
            _schema.etag = cls._schema_network_interface_ip_configuration_read.etag
            _schema.id = cls._schema_network_interface_ip_configuration_read.id
            _schema.name = cls._schema_network_interface_ip_configuration_read.name
            _schema.properties = cls._schema_network_interface_ip_configuration_read.properties
            return

        cls._schema_network_interface_ip_configuration_read = _schema_network_interface_ip_configuration_read = AAZObjectType()

        network_interface_ip_configuration_read = _schema_network_interface_ip_configuration_read
        network_interface_ip_configuration_read.etag = AAZStrType()
        network_interface_ip_configuration_read.id = AAZStrType()
        network_interface_ip_configuration_read.name = AAZStrType()
        network_interface_ip_configuration_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_network_interface_ip_configuration_read.properties
        properties.application_gateway_backend_address_pools = AAZListType(
            serialized_name="applicationGatewayBackendAddressPools",
        )
        properties.application_security_groups = AAZListType(
            serialized_name="applicationSecurityGroups",
        )
        properties.load_balancer_backend_address_pools = AAZListType(
            serialized_name="loadBalancerBackendAddressPools",
        )
        properties.load_balancer_inbound_nat_rules = AAZListType(
            serialized_name="loadBalancerInboundNatRules",
        )
        properties.primary = AAZBoolType()
        properties.private_ip_address = AAZStrType(
            serialized_name="privateIPAddress",
        )
        properties.private_ip_address_version = AAZStrType(
            serialized_name="privateIPAddressVersion",
        )
        properties.private_ip_allocation_method = AAZStrType(
            serialized_name="privateIPAllocationMethod",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.public_ip_address = AAZObjectType(
            serialized_name="publicIPAddress",
        )
        cls._build_schema_public_ip_address_read(properties.public_ip_address)
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)
        properties.virtual_network_taps = AAZListType(
            serialized_name="virtualNetworkTaps",
        )

        application_gateway_backend_address_pools = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools
        application_gateway_backend_address_pools.Element = AAZObjectType()
        cls._build_schema_application_gateway_backend_address_pool_read(application_gateway_backend_address_pools.Element)

        application_security_groups = _schema_network_interface_ip_configuration_read.properties.application_security_groups
        application_security_groups.Element = AAZObjectType()
        cls._build_schema_application_security_group_read(application_security_groups.Element)

        load_balancer_backend_address_pools = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools
        load_balancer_backend_address_pools.Element = AAZObjectType()

        _element = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties
        properties.backend_ip_configurations = AAZListType(
            serialized_name="backendIPConfigurations",
            flags={"read_only": True},
        )
        properties.load_balancing_rules = AAZListType(
            serialized_name="loadBalancingRules",
            flags={"read_only": True},
        )
        properties.outbound_rule = AAZObjectType(
            serialized_name="outboundRule",
        )
        cls._build_schema_sub_resource_read(properties.outbound_rule)
        properties.outbound_rules = AAZListType(
            serialized_name="outboundRules",
            flags={"read_only": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )

        backend_ip_configurations = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.backend_ip_configurations
        backend_ip_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_ip_configuration_read(backend_ip_configurations.Element)

        load_balancing_rules = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.load_balancing_rules
        load_balancing_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(load_balancing_rules.Element)

        outbound_rules = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.outbound_rules
        outbound_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(outbound_rules.Element)

        load_balancer_inbound_nat_rules = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules
        load_balancer_inbound_nat_rules.Element = AAZObjectType()

        _element = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules.Element.properties
        properties.backend_ip_configuration = AAZObjectType(
            serialized_name="backendIPConfiguration",
        )
        cls._build_schema_network_interface_ip_configuration_read(properties.backend_ip_configuration)
        properties.backend_port = AAZIntType(
            serialized_name="backendPort",
        )
        properties.enable_floating_ip = AAZBoolType(
            serialized_name="enableFloatingIP",
        )
        properties.enable_tcp_reset = AAZBoolType(
            serialized_name="enableTcpReset",
        )
        properties.frontend_ip_configuration = AAZObjectType(
            serialized_name="frontendIPConfiguration",
        )
        cls._build_schema_sub_resource_read(properties.frontend_ip_configuration)
        properties.frontend_port = AAZIntType(
            serialized_name="frontendPort",
        )
        properties.idle_timeout_in_minutes = AAZIntType(
            serialized_name="idleTimeoutInMinutes",
        )
        properties.protocol = AAZStrType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )

        virtual_network_taps = _schema_network_interface_ip_configuration_read.properties.virtual_network_taps
        virtual_network_taps.Element = AAZObjectType()
        cls._build_schema_virtual_network_tap_read(virtual_network_taps.Element)

        _schema.etag = cls._schema_network_interface_ip_configuration_read.etag
        _schema.id = cls._schema_network_interface_ip_configuration_read.id
        _schema.name = cls._schema_network_interface_ip_configuration_read.name
        _schema.properties = cls._schema_network_interface_ip_configuration_read.properties

    _schema_network_interface_tap_configuration_read = None

    @classmethod
    def _build_schema_network_interface_tap_configuration_read(cls, _schema):
        if cls._schema_network_interface_tap_configuration_read is not None:
            _schema.etag = cls._schema_network_interface_tap_configuration_read.etag
            _schema.id = cls._schema_network_interface_tap_configuration_read.id
            _schema.name = cls._schema_network_interface_tap_configuration_read.name
            _schema.properties = cls._schema_network_interface_tap_configuration_read.properties
            _schema.type = cls._schema_network_interface_tap_configuration_read.type
            return

        cls._schema_network_interface_tap_configuration_read = _schema_network_interface_tap_configuration_read = AAZObjectType()

        network_interface_tap_configuration_read = _schema_network_interface_tap_configuration_read
        network_interface_tap_configuration_read.etag = AAZStrType()
        network_interface_tap_configuration_read.id = AAZStrType()
        network_interface_tap_configuration_read.name = AAZStrType()
        network_interface_tap_configuration_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        network_interface_tap_configuration_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_network_interface_tap_configuration_read.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.virtual_network_tap = AAZObjectType(
            serialized_name="virtualNetworkTap",
        )
        cls._build_schema_virtual_network_tap_read(properties.virtual_network_tap)

        _schema.etag = cls._schema_network_interface_tap_configuration_read.etag
        _schema.id = cls._schema_network_interface_tap_configuration_read.id
        _schema.name = cls._schema_network_interface_tap_configuration_read.name
        _schema.properties = cls._schema_network_interface_tap_configuration_read.properties
        _schema.type = cls._schema_network_interface_tap_configuration_read.type

    _schema_network_interface_read = None

    @classmethod
    def _build_schema_network_interface_read(cls, _schema):
        if cls._schema_network_interface_read is not None:
            _schema.etag = cls._schema_network_interface_read.etag
            _schema.id = cls._schema_network_interface_read.id
            _schema.location = cls._schema_network_interface_read.location
            _schema.name = cls._schema_network_interface_read.name
            _schema.properties = cls._schema_network_interface_read.properties
            _schema.tags = cls._schema_network_interface_read.tags
            _schema.type = cls._schema_network_interface_read.type
            return

        cls._schema_network_interface_read = _schema_network_interface_read = AAZObjectType()

        network_interface_read = _schema_network_interface_read
        network_interface_read.etag = AAZStrType()
        network_interface_read.id = AAZStrType()
        network_interface_read.location = AAZStrType()
        network_interface_read.name = AAZStrType(
            flags={"read_only": True},
        )
        network_interface_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        network_interface_read.tags = AAZDictType()
        network_interface_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_network_interface_read.properties
        properties.dns_settings = AAZObjectType(
            serialized_name="dnsSettings",
        )
        properties.enable_accelerated_networking = AAZBoolType(
            serialized_name="enableAcceleratedNetworking",
        )
        properties.enable_ip_forwarding = AAZBoolType(
            serialized_name="enableIPForwarding",
        )
        properties.hosted_workloads = AAZListType(
            serialized_name="hostedWorkloads",
            flags={"read_only": True},
        )
        properties.interface_endpoint = AAZObjectType(
            serialized_name="interfaceEndpoint",
        )
        cls._build_schema_interface_endpoint_read(properties.interface_endpoint)
        properties.ip_configurations = AAZListType(
            serialized_name="ipConfigurations",
        )
        properties.mac_address = AAZStrType(
            serialized_name="macAddress",
        )
        properties.network_security_group = AAZObjectType(
            serialized_name="networkSecurityGroup",
        )
        cls._build_schema_network_security_group_read(properties.network_security_group)
        properties.primary = AAZBoolType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
        )
        properties.tap_configurations = AAZListType(
            serialized_name="tapConfigurations",
        )
        properties.virtual_machine = AAZObjectType(
            serialized_name="virtualMachine",
        )
        cls._build_schema_sub_resource_read(properties.virtual_machine)

        dns_settings = _schema_network_interface_read.properties.dns_settings
        dns_settings.applied_dns_servers = AAZListType(
            serialized_name="appliedDnsServers",
        )
        dns_settings.dns_servers = AAZListType(
            serialized_name="dnsServers",
        )
        dns_settings.internal_dns_name_label = AAZStrType(
            serialized_name="internalDnsNameLabel",
        )
        dns_settings.internal_domain_name_suffix = AAZStrType(
            serialized_name="internalDomainNameSuffix",
        )
        dns_settings.internal_fqdn = AAZStrType(
            serialized_name="internalFqdn",
        )

        applied_dns_servers = _schema_network_interface_read.properties.dns_settings.applied_dns_servers
        applied_dns_servers.Element = AAZStrType()

        dns_servers = _schema_network_interface_read.properties.dns_settings.dns_servers
        dns_servers.Element = AAZStrType()

        hosted_workloads = _schema_network_interface_read.properties.hosted_workloads
        hosted_workloads.Element = AAZStrType()

        ip_configurations = _schema_network_interface_read.properties.ip_configurations
        ip_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_ip_configuration_read(ip_configurations.Element)

        tap_configurations = _schema_network_interface_read.properties.tap_configurations
        tap_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_tap_configuration_read(tap_configurations.Element)

        tags = _schema_network_interface_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_network_interface_read.etag
        _schema.id = cls._schema_network_interface_read.id
        _schema.location = cls._schema_network_interface_read.location
        _schema.name = cls._schema_network_interface_read.name
        _schema.properties = cls._schema_network_interface_read.properties
        _schema.tags = cls._schema_network_interface_read.tags
        _schema.type = cls._schema_network_interface_read.type

    _schema_network_security_group_read = None

    @classmethod
    def _build_schema_network_security_group_read(cls, _schema):
        if cls._schema_network_security_group_read is not None:
            _schema.etag = cls._schema_network_security_group_read.etag
            _schema.id = cls._schema_network_security_group_read.id
            _schema.location = cls._schema_network_security_group_read.location
            _schema.name = cls._schema_network_security_group_read.name
            _schema.properties = cls._schema_network_security_group_read.properties
            _schema.tags = cls._schema_network_security_group_read.tags
            _schema.type = cls._schema_network_security_group_read.type
            return

        cls._schema_network_security_group_read = _schema_network_security_group_read = AAZObjectType()

        network_security_group_read = _schema_network_security_group_read
        network_security_group_read.etag = AAZStrType()
        network_security_group_read.id = AAZStrType()
        network_security_group_read.location = AAZStrType()
        network_security_group_read.name = AAZStrType(
            flags={"read_only": True},
        )
        network_security_group_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        network_security_group_read.tags = AAZDictType()
        network_security_group_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_network_security_group_read.properties
        properties.default_security_rules = AAZListType(
            serialized_name="defaultSecurityRules",
        )
        properties.network_interfaces = AAZListType(
            serialized_name="networkInterfaces",
            flags={"read_only": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
        )
        properties.security_rules = AAZListType(
            serialized_name="securityRules",
        )
        properties.subnets = AAZListType(
            flags={"read_only": True},
        )

        default_security_rules = _schema_network_security_group_read.properties.default_security_rules
        default_security_rules.Element = AAZObjectType()
        cls._build_schema_security_rule_read(default_security_rules.Element)

        network_interfaces = _schema_network_security_group_read.properties.network_interfaces
        network_interfaces.Element = AAZObjectType()
        cls._build_schema_network_interface_read(network_interfaces.Element)

        security_rules = _schema_network_security_group_read.properties.security_rules
        security_rules.Element = AAZObjectType()
        cls._build_schema_security_rule_read(security_rules.Element)

        subnets = _schema_network_security_group_read.properties.subnets
        subnets.Element = AAZObjectType()
        cls._build_schema_subnet_read(subnets.Element)

        tags = _schema_network_security_group_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_network_security_group_read.etag
        _schema.id = cls._schema_network_security_group_read.id
        _schema.location = cls._schema_network_security_group_read.location
        _schema.name = cls._schema_network_security_group_read.name
        _schema.properties = cls._schema_network_security_group_read.properties
        _schema.tags = cls._schema_network_security_group_read.tags
        _schema.type = cls._schema_network_security_group_read.type

    _schema_public_ip_address_read = None

    @classmethod
    def _build_schema_public_ip_address_read(cls, _schema):
        if cls._schema_public_ip_address_read is not None:
            _schema.etag = cls._schema_public_ip_address_read.etag
            _schema.id = cls._schema_public_ip_address_read.id
            _schema.location = cls._schema_public_ip_address_read.location
            _schema.name = cls._schema_public_ip_address_read.name
            _schema.properties = cls._schema_public_ip_address_read.properties
            _schema.sku = cls._schema_public_ip_address_read.sku
            _schema.tags = cls._schema_public_ip_address_read.tags
            _schema.type = cls._schema_public_ip_address_read.type
            _schema.zones = cls._schema_public_ip_address_read.zones
            return

        cls._schema_public_ip_address_read = _schema_public_ip_address_read = AAZObjectType()

        public_ip_address_read = _schema_public_ip_address_read
        public_ip_address_read.etag = AAZStrType()
        public_ip_address_read.id = AAZStrType()
        public_ip_address_read.location = AAZStrType()
        public_ip_address_read.name = AAZStrType(
            flags={"read_only": True},
        )
        public_ip_address_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        public_ip_address_read.sku = AAZObjectType()
        public_ip_address_read.tags = AAZDictType()
        public_ip_address_read.type = AAZStrType(
            flags={"read_only": True},
        )
        public_ip_address_read.zones = AAZListType()

        properties = _schema_public_ip_address_read.properties
        properties.ddos_settings = AAZObjectType(
            serialized_name="ddosSettings",
        )
        properties.dns_settings = AAZObjectType(
            serialized_name="dnsSettings",
        )
        properties.idle_timeout_in_minutes = AAZIntType(
            serialized_name="idleTimeoutInMinutes",
        )
        properties.ip_address = AAZStrType(
            serialized_name="ipAddress",
        )
        properties.ip_configuration = AAZObjectType(
            serialized_name="ipConfiguration",
        )
        cls._build_schema_ip_configuration_read(properties.ip_configuration)
        properties.ip_tags = AAZListType(
            serialized_name="ipTags",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.public_ip_address_version = AAZStrType(
            serialized_name="publicIPAddressVersion",
        )
        properties.public_ip_allocation_method = AAZStrType(
            serialized_name="publicIPAllocationMethod",
        )
        properties.public_ip_prefix = AAZObjectType(
            serialized_name="publicIPPrefix",
        )
        cls._build_schema_sub_resource_read(properties.public_ip_prefix)
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
        )

        ddos_settings = _schema_public_ip_address_read.properties.ddos_settings
        ddos_settings.ddos_custom_policy = AAZObjectType(
            serialized_name="ddosCustomPolicy",
        )
        cls._build_schema_sub_resource_read(ddos_settings.ddos_custom_policy)
        ddos_settings.protection_coverage = AAZStrType(
            serialized_name="protectionCoverage",
        )

        dns_settings = _schema_public_ip_address_read.properties.dns_settings
        dns_settings.domain_name_label = AAZStrType(
            serialized_name="domainNameLabel",
        )
        dns_settings.fqdn = AAZStrType()
        dns_settings.reverse_fqdn = AAZStrType(
            serialized_name="reverseFqdn",
        )

        ip_tags = _schema_public_ip_address_read.properties.ip_tags
        ip_tags.Element = AAZObjectType()

        _element = _schema_public_ip_address_read.properties.ip_tags.Element
        _element.ip_tag_type = AAZStrType(
            serialized_name="ipTagType",
        )
        _element.tag = AAZStrType()

        sku = _schema_public_ip_address_read.sku
        sku.name = AAZStrType()

        tags = _schema_public_ip_address_read.tags
        tags.Element = AAZStrType()

        zones = _schema_public_ip_address_read.zones
        zones.Element = AAZStrType()

        _schema.etag = cls._schema_public_ip_address_read.etag
        _schema.id = cls._schema_public_ip_address_read.id
        _schema.location = cls._schema_public_ip_address_read.location
        _schema.name = cls._schema_public_ip_address_read.name
        _schema.properties = cls._schema_public_ip_address_read.properties
        _schema.sku = cls._schema_public_ip_address_read.sku
        _schema.tags = cls._schema_public_ip_address_read.tags
        _schema.type = cls._schema_public_ip_address_read.type
        _schema.zones = cls._schema_public_ip_address_read.zones

    _schema_security_rule_read = None

    @classmethod
    def _build_schema_security_rule_read(cls, _schema):
        if cls._schema_security_rule_read is not None:
            _schema.etag = cls._schema_security_rule_read.etag
            _schema.id = cls._schema_security_rule_read.id
            _schema.name = cls._schema_security_rule_read.name
            _schema.properties = cls._schema_security_rule_read.properties
            return

        cls._schema_security_rule_read = _schema_security_rule_read = AAZObjectType()

        security_rule_read = _schema_security_rule_read
        security_rule_read.etag = AAZStrType()
        security_rule_read.id = AAZStrType()
        security_rule_read.name = AAZStrType()
        security_rule_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_security_rule_read.properties
        properties.access = AAZStrType(
            flags={"required": True},
        )
        properties.description = AAZStrType()
        properties.destination_address_prefix = AAZStrType(
            serialized_name="destinationAddressPrefix",
        )
        properties.destination_address_prefixes = AAZListType(
            serialized_name="destinationAddressPrefixes",
        )
        properties.destination_application_security_groups = AAZListType(
            serialized_name="destinationApplicationSecurityGroups",
        )
        properties.destination_port_range = AAZStrType(
            serialized_name="destinationPortRange",
        )
        properties.destination_port_ranges = AAZListType(
            serialized_name="destinationPortRanges",
        )
        properties.direction = AAZStrType(
            flags={"required": True},
        )
        properties.priority = AAZIntType()
        properties.protocol = AAZStrType(
            flags={"required": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.source_address_prefix = AAZStrType(
            serialized_name="sourceAddressPrefix",
        )
        properties.source_address_prefixes = AAZListType(
            serialized_name="sourceAddressPrefixes",
        )
        properties.source_application_security_groups = AAZListType(
            serialized_name="sourceApplicationSecurityGroups",
        )
        properties.source_port_range = AAZStrType(
            serialized_name="sourcePortRange",
        )
        properties.source_port_ranges = AAZListType(
            serialized_name="sourcePortRanges",
        )

        destination_address_prefixes = _schema_security_rule_read.properties.destination_address_prefixes
        destination_address_prefixes.Element = AAZStrType()

        destination_application_security_groups = _schema_security_rule_read.properties.destination_application_security_groups
        destination_application_security_groups.Element = AAZObjectType()
        cls._build_schema_application_security_group_read(destination_application_security_groups.Element)

        destination_port_ranges = _schema_security_rule_read.properties.destination_port_ranges
        destination_port_ranges.Element = AAZStrType()

        source_address_prefixes = _schema_security_rule_read.properties.source_address_prefixes
        source_address_prefixes.Element = AAZStrType()

        source_application_security_groups = _schema_security_rule_read.properties.source_application_security_groups
        source_application_security_groups.Element = AAZObjectType()
        cls._build_schema_application_security_group_read(source_application_security_groups.Element)

        source_port_ranges = _schema_security_rule_read.properties.source_port_ranges
        source_port_ranges.Element = AAZStrType()

        _schema.etag = cls._schema_security_rule_read.etag
        _schema.id = cls._schema_security_rule_read.id
        _schema.name = cls._schema_security_rule_read.name
        _schema.properties = cls._schema_security_rule_read.properties

    _schema_sub_resource_read = None

    @classmethod
    def _build_schema_sub_resource_read(cls, _schema):
        if cls._schema_sub_resource_read is not None:
            _schema.id = cls._schema_sub_resource_read.id
            return

        cls._schema_sub_resource_read = _schema_sub_resource_read = AAZObjectType()

        sub_resource_read = _schema_sub_resource_read
        sub_resource_read.id = AAZStrType()

        _schema.id = cls._schema_sub_resource_read.id

    _schema_subnet_read = None

    @classmethod
    def _build_schema_subnet_read(cls, _schema):
        if cls._schema_subnet_read is not None:
            _schema.etag = cls._schema_subnet_read.etag
            _schema.id = cls._schema_subnet_read.id
            _schema.name = cls._schema_subnet_read.name
            _schema.properties = cls._schema_subnet_read.properties
            return

        cls._schema_subnet_read = _schema_subnet_read = AAZObjectType()

        subnet_read = _schema_subnet_read
        subnet_read.etag = AAZStrType()
        subnet_read.id = AAZStrType()
        subnet_read.name = AAZStrType()
        subnet_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_subnet_read.properties
        properties.address_prefix = AAZStrType(
            serialized_name="addressPrefix",
        )
        properties.address_prefixes = AAZListType(
            serialized_name="addressPrefixes",
        )
        properties.delegations = AAZListType()
        properties.interface_endpoints = AAZListType(
            serialized_name="interfaceEndpoints",
            flags={"read_only": True},
        )
        properties.ip_configuration_profiles = AAZListType(
            serialized_name="ipConfigurationProfiles",
            flags={"read_only": True},
        )
        properties.ip_configurations = AAZListType(
            serialized_name="ipConfigurations",
            flags={"read_only": True},
        )
        properties.network_security_group = AAZObjectType(
            serialized_name="networkSecurityGroup",
        )
        cls._build_schema_network_security_group_read(properties.network_security_group)
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.purpose = AAZStrType(
            flags={"read_only": True},
        )
        properties.resource_navigation_links = AAZListType(
            serialized_name="resourceNavigationLinks",
        )
        properties.route_table = AAZObjectType(
            serialized_name="routeTable",
        )
        properties.service_association_links = AAZListType(
            serialized_name="serviceAssociationLinks",
        )
        properties.service_endpoint_policies = AAZListType(
            serialized_name="serviceEndpointPolicies",
        )
        properties.service_endpoints = AAZListType(
            serialized_name="serviceEndpoints",
        )

        address_prefixes = _schema_subnet_read.properties.address_prefixes
        address_prefixes.Element = AAZStrType()

        delegations = _schema_subnet_read.properties.delegations
        delegations.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.delegations.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_subnet_read.properties.delegations.Element.properties
        properties.actions = AAZListType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.service_name = AAZStrType(
            serialized_name="serviceName",
        )

        actions = _schema_subnet_read.properties.delegations.Element.properties.actions
        actions.Element = AAZStrType()

        interface_endpoints = _schema_subnet_read.properties.interface_endpoints
        interface_endpoints.Element = AAZObjectType()
        cls._build_schema_interface_endpoint_read(interface_endpoints.Element)

        ip_configuration_profiles = _schema_subnet_read.properties.ip_configuration_profiles
        ip_configuration_profiles.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.ip_configuration_profiles.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_subnet_read.properties.ip_configuration_profiles.Element.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)

        ip_configurations = _schema_subnet_read.properties.ip_configurations
        ip_configurations.Element = AAZObjectType()
        cls._build_schema_ip_configuration_read(ip_configurations.Element)

        resource_navigation_links = _schema_subnet_read.properties.resource_navigation_links
        resource_navigation_links.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.resource_navigation_links.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_subnet_read.properties.resource_navigation_links.Element.properties
        properties.link = AAZStrType()
        properties.linked_resource_type = AAZStrType(
            serialized_name="linkedResourceType",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )

        route_table = _schema_subnet_read.properties.route_table
        route_table.etag = AAZStrType()
        route_table.id = AAZStrType()
        route_table.location = AAZStrType()
        route_table.name = AAZStrType(
            flags={"read_only": True},
        )
        route_table.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        route_table.tags = AAZDictType()
        route_table.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_subnet_read.properties.route_table.properties
        properties.disable_bgp_route_propagation = AAZBoolType(
            serialized_name="disableBgpRoutePropagation",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.routes = AAZListType()
        properties.subnets = AAZListType(
            flags={"read_only": True},
        )

        routes = _schema_subnet_read.properties.route_table.properties.routes
        routes.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.route_table.properties.routes.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_subnet_read.properties.route_table.properties.routes.Element.properties
        properties.address_prefix = AAZStrType(
            serialized_name="addressPrefix",
        )
        properties.next_hop_ip_address = AAZStrType(
            serialized_name="nextHopIpAddress",
        )
        properties.next_hop_type = AAZStrType(
            serialized_name="nextHopType",
            flags={"required": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )

        subnets = _schema_subnet_read.properties.route_table.properties.subnets
        subnets.Element = AAZObjectType()
        cls._build_schema_subnet_read(subnets.Element)

        tags = _schema_subnet_read.properties.route_table.tags
        tags.Element = AAZStrType()

        service_association_links = _schema_subnet_read.properties.service_association_links
        service_association_links.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.service_association_links.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_subnet_read.properties.service_association_links.Element.properties
        properties.link = AAZStrType()
        properties.linked_resource_type = AAZStrType(
            serialized_name="linkedResourceType",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )

        service_endpoint_policies = _schema_subnet_read.properties.service_endpoint_policies
        service_endpoint_policies.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.service_endpoint_policies.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.location = AAZStrType()
        _element.name = AAZStrType(
            flags={"read_only": True},
        )
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.tags = AAZDictType()
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_subnet_read.properties.service_endpoint_policies.Element.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
            flags={"read_only": True},
        )
        properties.service_endpoint_policy_definitions = AAZListType(
            serialized_name="serviceEndpointPolicyDefinitions",
        )
        properties.subnets = AAZListType(
            flags={"read_only": True},
        )

        service_endpoint_policy_definitions = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions
        service_endpoint_policy_definitions.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions.Element.properties
        properties.description = AAZStrType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.service = AAZStrType()
        properties.service_resources = AAZListType(
            serialized_name="serviceResources",
        )

        service_resources = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions.Element.properties.service_resources
        service_resources.Element = AAZStrType()

        subnets = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.subnets
        subnets.Element = AAZObjectType()
        cls._build_schema_subnet_read(subnets.Element)

        tags = _schema_subnet_read.properties.service_endpoint_policies.Element.tags
        tags.Element = AAZStrType()

        service_endpoints = _schema_subnet_read.properties.service_endpoints
        service_endpoints.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.service_endpoints.Element
        _element.locations = AAZListType()
        _element.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        _element.service = AAZStrType()

        locations = _schema_subnet_read.properties.service_endpoints.Element.locations
        locations.Element = AAZStrType()

        _schema.etag = cls._schema_subnet_read.etag
        _schema.id = cls._schema_subnet_read.id
        _schema.name = cls._schema_subnet_read.name
        _schema.properties = cls._schema_subnet_read.properties

    _schema_virtual_network_tap_read = None

    @classmethod
    def _build_schema_virtual_network_tap_read(cls, _schema):
        if cls._schema_virtual_network_tap_read is not None:
            _schema.etag = cls._schema_virtual_network_tap_read.etag
            _schema.id = cls._schema_virtual_network_tap_read.id
            _schema.location = cls._schema_virtual_network_tap_read.location
            _schema.name = cls._schema_virtual_network_tap_read.name
            _schema.properties = cls._schema_virtual_network_tap_read.properties
            _schema.tags = cls._schema_virtual_network_tap_read.tags
            _schema.type = cls._schema_virtual_network_tap_read.type
            return

        cls._schema_virtual_network_tap_read = _schema_virtual_network_tap_read = AAZObjectType()

        virtual_network_tap_read = _schema_virtual_network_tap_read
        virtual_network_tap_read.etag = AAZStrType()
        virtual_network_tap_read.id = AAZStrType()
        virtual_network_tap_read.location = AAZStrType()
        virtual_network_tap_read.name = AAZStrType(
            flags={"read_only": True},
        )
        virtual_network_tap_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        virtual_network_tap_read.tags = AAZDictType()
        virtual_network_tap_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_virtual_network_tap_read.properties
        properties.destination_load_balancer_front_end_ip_configuration = AAZObjectType(
            serialized_name="destinationLoadBalancerFrontEndIPConfiguration",
        )
        properties.destination_network_interface_ip_configuration = AAZObjectType(
            serialized_name="destinationNetworkInterfaceIPConfiguration",
        )
        cls._build_schema_network_interface_ip_configuration_read(properties.destination_network_interface_ip_configuration)
        properties.destination_port = AAZIntType(
            serialized_name="destinationPort",
        )
        properties.network_interface_tap_configurations = AAZListType(
            serialized_name="networkInterfaceTapConfigurations",
            flags={"read_only": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
            flags={"read_only": True},
        )

        destination_load_balancer_front_end_ip_configuration = _schema_virtual_network_tap_read.properties.destination_load_balancer_front_end_ip_configuration
        destination_load_balancer_front_end_ip_configuration.etag = AAZStrType()
        destination_load_balancer_front_end_ip_configuration.id = AAZStrType()
        destination_load_balancer_front_end_ip_configuration.name = AAZStrType()
        destination_load_balancer_front_end_ip_configuration.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        destination_load_balancer_front_end_ip_configuration.zones = AAZListType()

        properties = _schema_virtual_network_tap_read.properties.destination_load_balancer_front_end_ip_configuration.properties
        properties.inbound_nat_pools = AAZListType(
            serialized_name="inboundNatPools",
            flags={"read_only": True},
        )
        properties.inbound_nat_rules = AAZListType(
            serialized_name="inboundNatRules",
            flags={"read_only": True},
        )
        properties.load_balancing_rules = AAZListType(
            serialized_name="loadBalancingRules",
            flags={"read_only": True},
        )
        properties.outbound_rules = AAZListType(
            serialized_name="outboundRules",
            flags={"read_only": True},
        )
        properties.private_ip_address = AAZStrType(
            serialized_name="privateIPAddress",
        )
        properties.private_ip_allocation_method = AAZStrType(
            serialized_name="privateIPAllocationMethod",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.public_ip_address = AAZObjectType(
            serialized_name="publicIPAddress",
        )
        cls._build_schema_public_ip_address_read(properties.public_ip_address)
        properties.public_ip_prefix = AAZObjectType(
            serialized_name="publicIPPrefix",
        )
        cls._build_schema_sub_resource_read(properties.public_ip_prefix)
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)

        inbound_nat_pools = _schema_virtual_network_tap_read.properties.destination_load_balancer_front_end_ip_configuration.properties.inbound_nat_pools
        inbound_nat_pools.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(inbound_nat_pools.Element)

        inbound_nat_rules = _schema_virtual_network_tap_read.properties.destination_load_balancer_front_end_ip_configuration.properties.inbound_nat_rules
        inbound_nat_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(inbound_nat_rules.Element)

        load_balancing_rules = _schema_virtual_network_tap_read.properties.destination_load_balancer_front_end_ip_configuration.properties.load_balancing_rules
        load_balancing_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(load_balancing_rules.Element)

        outbound_rules = _schema_virtual_network_tap_read.properties.destination_load_balancer_front_end_ip_configuration.properties.outbound_rules
        outbound_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(outbound_rules.Element)

        zones = _schema_virtual_network_tap_read.properties.destination_load_balancer_front_end_ip_configuration.zones
        zones.Element = AAZStrType()

        network_interface_tap_configurations = _schema_virtual_network_tap_read.properties.network_interface_tap_configurations
        network_interface_tap_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_tap_configuration_read(network_interface_tap_configurations.Element)

        tags = _schema_virtual_network_tap_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_virtual_network_tap_read.etag
        _schema.id = cls._schema_virtual_network_tap_read.id
        _schema.location = cls._schema_virtual_network_tap_read.location
        _schema.name = cls._schema_virtual_network_tap_read.name
        _schema.properties = cls._schema_virtual_network_tap_read.properties
        _schema.tags = cls._schema_virtual_network_tap_read.tags
        _schema.type = cls._schema_virtual_network_tap_read.type


__all__ = ["Show"]
