/*
 * Decompiled with CFR 0.152.
 */
package org.cugos.wkg;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.cugos.wkg.CircularString;
import org.cugos.wkg.CompoundCurve;
import org.cugos.wkg.Coordinate;
import org.cugos.wkg.Curve;
import org.cugos.wkg.CurvePolygon;
import org.cugos.wkg.Dimension;
import org.cugos.wkg.Geometry;
import org.cugos.wkg.GeometryCollection;
import org.cugos.wkg.LineString;
import org.cugos.wkg.LinearRing;
import org.cugos.wkg.MultiCurve;
import org.cugos.wkg.MultiLineString;
import org.cugos.wkg.MultiPoint;
import org.cugos.wkg.MultiPolygon;
import org.cugos.wkg.MultiSurface;
import org.cugos.wkg.Point;
import org.cugos.wkg.PolyHedralSurface;
import org.cugos.wkg.Polygon;
import org.cugos.wkg.Reader;
import org.cugos.wkg.Surface;
import org.cugos.wkg.Tin;
import org.cugos.wkg.Triangle;
import org.cugos.wkg.WKB;

public class WKBReader
implements Reader<byte[]> {
    @Override
    public Geometry read(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        return this.read(buffer);
    }

    @Override
    public String getName() {
        return "WKB";
    }

    @Override
    public Geometry read(String hex) {
        return this.read(WKBReader.toBytes(hex));
    }

    @Override
    protected Geometry read(ByteBuffer buffer) {
        int geometryTypeInt;
        WKB.Endian endian = WKB.Endian.get(buffer.get());
        if (endian == WKB.Endian.Big) {
            buffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        int gt = geometryTypeInt = buffer.getInt();
        boolean hasM = false;
        boolean hasZ = false;
        boolean hasSRID = false;
        if ((geometryTypeInt & WKB.GeometryTypeFlag.M.getValue()) == WKB.GeometryTypeFlag.M.getValue()) {
            hasM = true;
            gt -= WKB.GeometryTypeFlag.M.getValue();
        }
        if ((geometryTypeInt & WKB.GeometryTypeFlag.Z.getValue()) == WKB.GeometryTypeFlag.Z.getValue()) {
            hasZ = true;
            gt -= WKB.GeometryTypeFlag.Z.getValue();
        }
        if ((geometryTypeInt & WKB.GeometryTypeFlag.SRID.getValue()) == WKB.GeometryTypeFlag.SRID.getValue()) {
            hasSRID = true;
            gt -= WKB.GeometryTypeFlag.SRID.getValue();
        }
        WKB.GeometryType geometryType = WKB.GeometryType.get(gt);
        Dimension dimension = hasZ && hasM ? Dimension.ThreeMeasured : (hasZ ? Dimension.Three : (hasM ? Dimension.TwoMeasured : Dimension.Two));
        String srid = null;
        if (hasSRID) {
            srid = String.valueOf(buffer.getInt());
        }
        if (geometryType == WKB.GeometryType.Point) {
            Coordinate coordinate = this.getCoordinate(buffer, dimension);
            return new Point(coordinate, dimension, srid);
        }
        if (geometryType == WKB.GeometryType.LineString) {
            int numberOfCoordinates = buffer.getInt();
            ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>(numberOfCoordinates);
            for (int i = 0; i < numberOfCoordinates; ++i) {
                coordinates.add(this.getCoordinate(buffer, dimension));
            }
            return new LineString(coordinates, dimension, srid);
        }
        if (geometryType == WKB.GeometryType.Polygon) {
            int numberOfRings = buffer.getInt();
            ArrayList<LinearRing> rings = new ArrayList<LinearRing>(numberOfRings);
            for (int i = 0; i < numberOfRings; ++i) {
                int numberOfCoordinates = buffer.getInt();
                ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>(numberOfCoordinates);
                for (int j = 0; j < numberOfCoordinates; ++j) {
                    coordinates.add(this.getCoordinate(buffer, dimension));
                }
                rings.add(new LinearRing(coordinates, dimension, srid));
            }
            return new Polygon((LinearRing)rings.get(0), rings.subList(1, rings.size()), dimension, srid);
        }
        if (geometryType == WKB.GeometryType.MultiPoint) {
            int numberOfPoints = buffer.getInt();
            ArrayList<Point> points = new ArrayList<Point>(numberOfPoints);
            for (int i = 0; i < numberOfPoints; ++i) {
                Point point = (Point)this.read(buffer);
                points.add(point);
            }
            return new MultiPoint((List<Point>)points, dimension, srid);
        }
        if (geometryType == WKB.GeometryType.MultiLineString) {
            int numberOfLines = buffer.getInt();
            ArrayList<LineString> lines = new ArrayList<LineString>(numberOfLines);
            for (int i = 0; i < numberOfLines; ++i) {
                LineString line = (LineString)this.read(buffer);
                lines.add(line);
            }
            return new MultiLineString((List<LineString>)lines, dimension, srid);
        }
        if (geometryType == WKB.GeometryType.MultiPolygon) {
            int numberOfPolygons = buffer.getInt();
            ArrayList<Polygon> polygons = new ArrayList<Polygon>(numberOfPolygons);
            for (int i = 0; i < numberOfPolygons; ++i) {
                Polygon polygon = (Polygon)this.read(buffer);
                polygons.add(polygon);
            }
            return new MultiPolygon((List<Polygon>)polygons, dimension, srid);
        }
        if (geometryType == WKB.GeometryType.GeometryCollection) {
            int numberOfGeometries = buffer.getInt();
            ArrayList<Geometry> geometries = new ArrayList<Geometry>(numberOfGeometries);
            for (int i = 0; i < numberOfGeometries; ++i) {
                Geometry geometry = this.read(buffer);
                geometries.add(geometry);
            }
            return new GeometryCollection((List<Geometry>)geometries, dimension, srid);
        }
        if (geometryType == WKB.GeometryType.CircularString) {
            int numberOfCoordinates = buffer.getInt();
            ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>(numberOfCoordinates);
            for (int i = 0; i < numberOfCoordinates; ++i) {
                coordinates.add(this.getCoordinate(buffer, dimension));
            }
            return new CircularString(coordinates, dimension, srid);
        }
        if (geometryType == WKB.GeometryType.Triangle) {
            int numberOfRings = buffer.getInt();
            ArrayList<LinearRing> rings = new ArrayList<LinearRing>(numberOfRings);
            for (int i = 0; i < numberOfRings; ++i) {
                int numberOfCoordinates = buffer.getInt();
                ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>(numberOfCoordinates);
                for (int j = 0; j < numberOfCoordinates; ++j) {
                    coordinates.add(this.getCoordinate(buffer, dimension));
                }
                rings.add(new LinearRing(coordinates, dimension, srid));
            }
            return new Triangle((LinearRing)rings.get(0), rings.subList(1, rings.size()), dimension, srid);
        }
        if (geometryType == WKB.GeometryType.Tin) {
            int numberOfTriangles = buffer.getInt();
            ArrayList<Triangle> triangles = new ArrayList<Triangle>(numberOfTriangles);
            for (int i = 0; i < numberOfTriangles; ++i) {
                Triangle triangle = (Triangle)this.read(buffer);
                triangles.add(triangle);
            }
            return new Tin(triangles, dimension, srid);
        }
        if (geometryType == WKB.GeometryType.CompoundCurve) {
            int numberOfCurves = buffer.getInt();
            ArrayList<Curve> curves = new ArrayList<Curve>(numberOfCurves);
            for (int i = 0; i < numberOfCurves; ++i) {
                Curve curve = (Curve)this.read(buffer);
                curves.add(curve);
            }
            return new CompoundCurve(curves, dimension, srid);
        }
        if (geometryType == WKB.GeometryType.MultiCurve) {
            int numberOfCurves = buffer.getInt();
            ArrayList<Curve> curves = new ArrayList<Curve>(numberOfCurves);
            for (int i = 0; i < numberOfCurves; ++i) {
                Curve curve = (Curve)this.read(buffer);
                curves.add(curve);
            }
            return new MultiCurve((List<Curve>)curves, dimension, srid);
        }
        if (geometryType == WKB.GeometryType.CurvePolygon) {
            int numberOfCurves = buffer.getInt();
            ArrayList<Curve> curves = new ArrayList<Curve>(numberOfCurves);
            for (int i = 0; i < numberOfCurves; ++i) {
                Curve curve = (Curve)this.read(buffer);
                curves.add(curve);
            }
            return new CurvePolygon((Curve)curves.get(0), curves.subList(1, curves.size()), dimension, srid);
        }
        if (geometryType == WKB.GeometryType.MultiSurface) {
            int numberOfSurfaces = buffer.getInt();
            ArrayList<Surface> surfaces = new ArrayList<Surface>(numberOfSurfaces);
            for (int i = 0; i < numberOfSurfaces; ++i) {
                Surface surface = (Surface)this.read(buffer);
                surfaces.add(surface);
            }
            return new MultiSurface((List<Surface>)surfaces, dimension, srid);
        }
        if (geometryType == WKB.GeometryType.PolyHedralSurface) {
            int numberOfPolygons = buffer.getInt();
            ArrayList<Polygon> polygons = new ArrayList<Polygon>(numberOfPolygons);
            for (int i = 0; i < numberOfPolygons; ++i) {
                Polygon polygon = (Polygon)this.read(buffer);
                polygons.add(polygon);
            }
            return new PolyHedralSurface(polygons, dimension, srid);
        }
        return null;
    }

    private Coordinate getCoordinate(ByteBuffer buffer, Dimension dimension) {
        double x = buffer.getDouble();
        double y = buffer.getDouble();
        double z = Double.NaN;
        double m = Double.NaN;
        if (dimension == Dimension.Three || dimension == Dimension.ThreeMeasured) {
            z = buffer.getDouble();
        }
        if (dimension == Dimension.ThreeMeasured || dimension == Dimension.TwoMeasured) {
            m = buffer.getDouble();
        }
        return new Coordinate(x, y, z, m);
    }

    private static byte[] toBytes(String hexString) {
        int len = hexString.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
    }
}

