/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObjectType;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceInfo;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.utils.CommonUtils;

class SQLServerDataSourceInfo
extends JDBCDataSourceInfo {
    private SQLServerDataSource dataSource;
    private boolean isSybase;

    public SQLServerDataSourceInfo(SQLServerDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super(metaData);
        this.dataSource = dataSource;
        this.isSybase = !SQLServerUtils.isDriverSqlServer(dataSource.getContainer().getDriver());
    }

    public boolean supportsResultSetLimit() {
        return true;
    }

    public boolean supportsMultipleResults() {
        return true;
    }

    public boolean isMultipleResultsFetchBroken() {
        return true;
    }

    public String getDatabaseProductVersion() {
        String serverVersion = this.dataSource.getServerVersion();
        return CommonUtils.isEmpty((String)serverVersion) ? super.getDatabaseProductVersion() : super.getDatabaseProductVersion() + "\n" + serverVersion;
    }

    public DBSObjectType[] getSupportedObjectTypes() {
        return SQLServerObjectType.values();
    }

    public boolean needsTableMetaForColumnResolution() {
        return false;
    }
}

