/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.erd;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.erd.ERDElement;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class ERDContext {
    private final DBRProgressMonitor monitor;
    private final DBPDataSourceContainer dataSourceContainer;
    private final DBNModel navigatorModel;
    private final List<String> icons = new ArrayList<String>();
    private final Map<ERDElement<?>, ElementSaveInfo> elementInfoMap = new IdentityHashMap();

    public ERDContext(DBRProgressMonitor monitor, DBPDataSourceContainer dataSourceContainer, DBNModel navigatorModel) {
        this.monitor = monitor;
        this.dataSourceContainer = dataSourceContainer;
        this.navigatorModel = navigatorModel;
    }

    public DBRProgressMonitor getMonitor() {
        return this.monitor;
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceContainer;
    }

    public List<String> getIcons() {
        return this.icons;
    }

    public int getIconIndex(DBPImage image) {
        String icon = image.getLocation();
        int iconIndex = this.icons.indexOf(icon);
        if (iconIndex == -1) {
            iconIndex = this.icons.size();
            this.icons.add(icon);
        }
        return iconIndex;
    }

    public int addElementInfo(ERDElement<?> element) {
        ElementSaveInfo info = new ElementSaveInfo(element, this.elementInfoMap.size());
        this.elementInfoMap.put(element, info);
        return info.objectId;
    }

    public int getElementInfo(ERDElement<?> element) {
        ElementSaveInfo info = this.elementInfoMap.get(element);
        return info == null ? -1 : info.objectId;
    }

    public DBNModel getNavigatorModel() {
        return this.navigatorModel;
    }

    private static class ElementSaveInfo {
        final ERDElement<?> element;
        final int objectId;

        private ElementSaveInfo(ERDElement<?> element, int objectId) {
            this.element = element;
            this.objectId = objectId;
        }
    }
}

