/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import MCview.AppletPDBViewer;
import jalview.analysis.AAFrequency;
import jalview.analysis.Conservation;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.AppletJmol;
import jalview.appletgui.CutAndPasteTransfer;
import jalview.appletgui.EditNameDialog;
import jalview.appletgui.SliderPanel;
import jalview.appletgui.UserDefinedColours;
import jalview.bin.JalviewLite;
import jalview.commands.ChangeCaseCommand;
import jalview.commands.EditCommand;
import jalview.datamodel.Alignment;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.io.AppletFormatAdapter;
import jalview.schemes.Blosum62ColourScheme;
import jalview.schemes.BuriedColourScheme;
import jalview.schemes.ClustalxColourScheme;
import jalview.schemes.HelixColourScheme;
import jalview.schemes.HydrophobicColourScheme;
import jalview.schemes.NucleotideColourScheme;
import jalview.schemes.PIDColourScheme;
import jalview.schemes.ResidueProperties;
import jalview.schemes.StrandColourScheme;
import jalview.schemes.TaylorColourScheme;
import jalview.schemes.TurnColourScheme;
import jalview.schemes.ZappoColourScheme;
import jalview.util.DBRefUtils;
import jalview.util.UrlLink;
import java.awt.CheckboxMenuItem;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class APopupMenu
extends PopupMenu
implements ActionListener,
ItemListener {
    Menu groupMenu = new Menu();
    MenuItem editGroupName = new MenuItem();
    protected MenuItem clustalColour = new MenuItem();
    protected MenuItem zappoColour = new MenuItem();
    protected MenuItem taylorColour = new MenuItem();
    protected MenuItem hydrophobicityColour = new MenuItem();
    protected MenuItem helixColour = new MenuItem();
    protected MenuItem strandColour = new MenuItem();
    protected MenuItem turnColour = new MenuItem();
    protected MenuItem buriedColour = new MenuItem();
    protected CheckboxMenuItem abovePIDColour = new CheckboxMenuItem();
    protected MenuItem userDefinedColour = new MenuItem();
    protected MenuItem PIDColour = new MenuItem();
    protected MenuItem BLOSUM62Colour = new MenuItem();
    MenuItem noColourmenuItem = new MenuItem();
    protected CheckboxMenuItem conservationMenuItem = new CheckboxMenuItem();
    final AlignmentPanel ap;
    MenuItem unGroupMenuItem = new MenuItem();
    MenuItem nucleotideMenuItem = new MenuItem();
    Menu colourMenu = new Menu();
    CheckboxMenuItem showBoxes = new CheckboxMenuItem();
    CheckboxMenuItem showText = new CheckboxMenuItem();
    CheckboxMenuItem showColourText = new CheckboxMenuItem();
    Menu editMenu = new Menu("Edit");
    MenuItem copy = new MenuItem("Copy (Jalview Only)");
    MenuItem cut = new MenuItem("Cut (Jalview Only)");
    MenuItem toUpper = new MenuItem("To Upper Case");
    MenuItem toLower = new MenuItem("To Lower Case");
    MenuItem toggleCase = new MenuItem("Toggle Case");
    Menu outputmenu = new Menu();
    Menu seqMenu = new Menu();
    MenuItem pdb = new MenuItem();
    MenuItem hideSeqs = new MenuItem();
    MenuItem repGroup = new MenuItem();
    MenuItem sequenceName = new MenuItem("Edit Name/Description");
    MenuItem sequenceFeature = new MenuItem("Create Sequence Feature");
    MenuItem editSequence = new MenuItem("Edit Sequence");
    Sequence seq;
    MenuItem revealAll = new MenuItem();
    Menu menu1 = new Menu();

    public APopupMenu(AlignmentPanel apanel, Sequence seq, Vector links) {
        this.ap = apanel;
        this.seq = seq;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < AppletFormatAdapter.WRITEABLE_FORMATS.length; ++i) {
            MenuItem item = new MenuItem(AppletFormatAdapter.WRITEABLE_FORMATS[i]);
            item.addActionListener(this);
            this.outputmenu.add(item);
        }
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        if (sg != null && sg.getSize() > 0) {
            this.editGroupName.setLabel(sg.getName());
            this.showText.setState(sg.getDisplayText());
            this.showColourText.setState(sg.getColourText());
            this.showBoxes.setState(sg.getDisplayBoxes());
            if (!this.ap.av.alignment.getGroups().contains(sg)) {
                this.groupMenu.remove(this.unGroupMenuItem);
            }
        } else {
            this.remove(this.hideSeqs);
            this.remove(this.groupMenu);
        }
        if (links != null && links.size() > 0) {
            Menu linkMenu = new Menu("Link");
            for (int i = 0; i < links.size(); ++i) {
                String link = links.elementAt(i).toString();
                UrlLink urlLink = new UrlLink(link);
                if (!urlLink.isValid()) {
                    System.err.println(urlLink.getInvalidMessage());
                    continue;
                }
                String target = urlLink.getTarget();
                String label = urlLink.getLabel();
                if (urlLink.isDynamic()) {
                    String[] urls;
                    DBRefEntry[] dbr = DBRefUtils.selectRefs(seq.getDBRef(), new String[]{target});
                    String id = seq.getName();
                    if (dbr != null) {
                        for (int r = 0; r < dbr.length; ++r) {
                            String[] urls2;
                            if (id != null && dbr[r].getAccessionId().equals(id)) {
                                id = null;
                            }
                            if ((urls2 = urlLink.makeUrls(dbr[r].getAccessionId(), true)) == null) continue;
                            for (int u = 0; u < urls2.length; u += 2) {
                                this.addshowLink(linkMenu, label + "|" + urls2[u], urls2[u + 1]);
                            }
                        }
                    }
                    if (id == null || (urls = urlLink.makeUrls(id, true)) == null) continue;
                    for (int u = 0; u < urls.length; u += 2) {
                        this.addshowLink(linkMenu, label, urls[u + 1]);
                    }
                    continue;
                }
                this.addshowLink(linkMenu, target, urlLink.getUrl_prefix());
            }
            if (seq != null) {
                this.seqMenu.add(linkMenu);
            } else {
                this.add(linkMenu);
            }
        }
        if (seq != null) {
            this.seqMenu.setLabel(seq.getName());
            this.repGroup.setLabel("Represent Group with " + seq.getName());
        } else {
            this.remove(this.seqMenu);
        }
        if (!this.ap.av.hasHiddenRows) {
            this.remove(this.revealAll);
        }
    }

    private void addshowLink(Menu linkMenu, String target, String url) {
        this.addshowLink(linkMenu, target, target, url);
    }

    private void addshowLink(Menu linkMenu, final String target, String label, final String url) {
        MenuItem item = new MenuItem(label);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                APopupMenu.this.ap.alignFrame.showURL(url, target);
            }
        });
        linkMenu.add(item);
    }

    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.abovePIDColour) {
            this.abovePIDColour_itemStateChanged();
        } else if (evt.getSource() == this.showColourText) {
            this.showColourText_itemStateChanged();
        } else if (evt.getSource() == this.showText) {
            this.showText_itemStateChanged();
        } else if (evt.getSource() == this.showBoxes) {
            this.showBoxes_itemStateChanged();
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.clustalColour) {
            this.clustalColour_actionPerformed();
        } else if (source == this.zappoColour) {
            this.zappoColour_actionPerformed();
        } else if (source == this.taylorColour) {
            this.taylorColour_actionPerformed();
        } else if (source == this.hydrophobicityColour) {
            this.hydrophobicityColour_actionPerformed();
        } else if (source == this.helixColour) {
            this.helixColour_actionPerformed();
        } else if (source == this.strandColour) {
            this.strandColour_actionPerformed();
        } else if (source == this.turnColour) {
            this.turnColour_actionPerformed();
        } else if (source == this.buriedColour) {
            this.buriedColour_actionPerformed();
        } else if (source == this.nucleotideMenuItem) {
            this.nucleotideMenuItem_actionPerformed();
        } else if (source == this.userDefinedColour) {
            this.userDefinedColour_actionPerformed();
        } else if (source == this.PIDColour) {
            this.PIDColour_actionPerformed();
        } else if (source == this.BLOSUM62Colour) {
            this.BLOSUM62Colour_actionPerformed();
        } else if (source == this.noColourmenuItem) {
            this.noColourmenuItem_actionPerformed();
        } else if (source == this.conservationMenuItem) {
            this.conservationMenuItem_itemStateChanged();
        } else if (source == this.unGroupMenuItem) {
            this.unGroupMenuItem_actionPerformed();
        } else if (source == this.sequenceName) {
            this.editName();
        } else if (source == this.pdb) {
            this.addPDB();
        } else if (source == this.hideSeqs) {
            this.hideSequences(false);
        } else if (source == this.repGroup) {
            this.hideSequences(true);
        } else if (source == this.revealAll) {
            this.ap.av.showAllHiddenSeqs();
        } else if (source == this.editGroupName) {
            EditNameDialog dialog = new EditNameDialog(this.getGroup().getName(), this.getGroup().getDescription(), "       Group Name", "Group Description", this.ap.alignFrame, "Edit Group Name / Description", 500, 100, true);
            if (dialog.accept) {
                this.getGroup().setName(dialog.getName().replace(' ', '_'));
                this.getGroup().setDescription(dialog.getDescription());
            }
        } else if (source == this.copy) {
            this.ap.alignFrame.copy_actionPerformed();
        } else if (source == this.cut) {
            this.ap.alignFrame.cut_actionPerformed();
        } else if (source == this.editSequence) {
            SequenceGroup sg = this.ap.av.getSelectionGroup();
            if (sg != null) {
                if (this.seq == null) {
                    this.seq = (Sequence)sg.getSequenceAt(0);
                }
                EditNameDialog dialog = new EditNameDialog(this.seq.getSequenceAsString(sg.getStartRes(), sg.getEndRes() + 1), null, "Edit Sequence ", null, this.ap.alignFrame, "Edit Sequence", 500, 100, true);
                if (dialog.accept) {
                    EditCommand editCommand = new EditCommand("Edit Sequences", 4, dialog.getName().replace(' ', this.ap.av.getGapCharacter()), sg.getSequencesAsArray(this.ap.av.hiddenRepSequences), sg.getStartRes(), sg.getEndRes() + 1, this.ap.av.alignment);
                    this.ap.alignFrame.addHistoryItem(editCommand);
                    this.ap.av.firePropertyChange("alignment", null, this.ap.av.getAlignment().getSequences());
                }
            }
        } else if (source == this.toUpper || source == this.toLower || source == this.toggleCase) {
            SequenceGroup sg = this.ap.av.getSelectionGroup();
            Vector<int[]> regions = new Vector<int[]>();
            if (sg != null) {
                int caseChange;
                String description;
                int start = sg.getStartRes();
                int end = sg.getEndRes() + 1;
                do {
                    if (this.ap.av.hasHiddenColumns) {
                        if (start == 0) {
                            start = this.ap.av.colSel.adjustForHiddenColumns(start);
                        }
                        if (start == (end = this.ap.av.colSel.getHiddenBoundaryRight(start))) {
                            end = sg.getEndRes() + 1;
                        }
                        if (end > sg.getEndRes()) {
                            end = sg.getEndRes() + 1;
                        }
                    }
                    regions.addElement(new int[]{start, end});
                    if (!this.ap.av.hasHiddenColumns) continue;
                    start = this.ap.av.colSel.adjustForHiddenColumns(end);
                    start = this.ap.av.colSel.getHiddenBoundaryLeft(start) + 1;
                } while (end < sg.getEndRes());
                int[][] startEnd = new int[regions.size()][2];
                for (int i = 0; i < regions.size(); ++i) {
                    startEnd[i] = (int[])regions.elementAt(i);
                }
                if (source == this.toggleCase) {
                    description = "Toggle Case";
                    caseChange = ChangeCaseCommand.TOGGLE_CASE;
                } else if (source == this.toUpper) {
                    description = "To Upper Case";
                    caseChange = ChangeCaseCommand.TO_UPPER;
                } else {
                    description = "To Lower Case";
                    caseChange = ChangeCaseCommand.TO_LOWER;
                }
                ChangeCaseCommand caseCommand = new ChangeCaseCommand(description, sg.getSequencesAsArray(this.ap.av.hiddenRepSequences), startEnd, caseChange);
                this.ap.alignFrame.addHistoryItem(caseCommand);
                this.ap.av.firePropertyChange("alignment", null, this.ap.av.getAlignment().getSequences());
            }
        } else if (source == this.sequenceFeature) {
            SequenceGroup sg = this.ap.av.getSelectionGroup();
            if (sg == null) {
                return;
            }
            int rsize = 0;
            int gSize = sg.getSize();
            SequenceI[] seqs = new SequenceI[gSize];
            SequenceFeature[] features = new SequenceFeature[gSize];
            for (int i = 0; i < gSize; ++i) {
                int end;
                int start = sg.getSequenceAt(i).findPosition(sg.getStartRes());
                if (start > (end = sg.findEndRes(sg.getSequenceAt(i)))) continue;
                seqs[rsize] = sg.getSequenceAt(i);
                features[rsize] = new SequenceFeature(null, null, null, start, end, "Jalview");
                ++rsize;
            }
            SequenceI[] rseqs = new SequenceI[rsize];
            SequenceFeature[] tfeatures = new SequenceFeature[rsize];
            System.arraycopy(seqs, 0, rseqs, 0, rsize);
            System.arraycopy(features, 0, tfeatures, 0, rsize);
            features = tfeatures;
            seqs = rseqs;
            if (this.ap.seqPanel.seqCanvas.getFeatureRenderer().amendFeatures(seqs, features, true, this.ap)) {
                this.ap.alignFrame.sequenceFeatures.setState(true);
                this.ap.av.showSequenceFeatures(true);
                this.ap.highlightSearchResults(null);
            }
        } else {
            this.outputText(evt);
        }
    }

    void outputText(ActionEvent e) {
        CutAndPasteTransfer cap = new CutAndPasteTransfer(true, this.ap.alignFrame);
        Frame frame = new Frame();
        frame.add(cap);
        JalviewLite.addFrame(frame, "Selection output - " + e.getActionCommand(), 600, 500);
        cap.setText(new AppletFormatAdapter().formatSequences(e.getActionCommand(), new Alignment(this.ap.av.getSelectionAsNewSequence()), this.ap.av.showJVSuffix));
    }

    void editName() {
        EditNameDialog dialog = new EditNameDialog(this.seq.getName(), this.seq.getDescription(), "       Sequence Name", "Sequence Description", this.ap.alignFrame, "Edit Sequence Name / Description", 500, 100, true);
        if (dialog.accept) {
            this.seq.setName(dialog.getName());
            this.seq.setDescription(dialog.getDescription());
            this.ap.paintAlignment(false);
        }
    }

    void addPDB() {
        if (this.seq.getPDBId() != null) {
            PDBEntry entry = (PDBEntry)this.seq.getPDBId().firstElement();
            if (this.ap.av.applet.jmolAvailable) {
                new AppletJmol(entry, new Sequence[]{this.seq}, null, this.ap, AppletFormatAdapter.URL);
            } else {
                new AppletPDBViewer(entry, new Sequence[]{this.seq}, null, this.ap, AppletFormatAdapter.URL);
            }
        } else {
            CutAndPasteTransfer cap = new CutAndPasteTransfer(true, this.ap.alignFrame);
            cap.setText("Paste your PDB file here.");
            cap.setPDBImport(this.seq);
            Frame frame = new Frame();
            frame.add(cap);
            JalviewLite.addFrame(frame, "Paste PDB file ", 400, 300);
        }
    }

    private void jbInit() throws Exception {
        this.groupMenu.setLabel("Group");
        this.groupMenu.setLabel("Selection");
        this.sequenceFeature.addActionListener(this);
        this.editGroupName.addActionListener(this);
        this.unGroupMenuItem.setLabel("Remove Group");
        this.unGroupMenuItem.addActionListener(this);
        this.nucleotideMenuItem.setLabel("Nucleotide");
        this.nucleotideMenuItem.addActionListener(this);
        this.conservationMenuItem.addItemListener(this);
        this.abovePIDColour.addItemListener(this);
        this.colourMenu.setLabel("Group Colour");
        this.showBoxes.setLabel("Boxes");
        this.showBoxes.setState(true);
        this.showBoxes.addItemListener(this);
        this.sequenceName.addActionListener(this);
        this.showText.setLabel("Text");
        this.showText.addItemListener(this);
        this.showColourText.setLabel("Colour Text");
        this.showColourText.addItemListener(this);
        this.outputmenu.setLabel("Output to Textbox...");
        this.seqMenu.setLabel("Sequence");
        this.pdb.setLabel("View PDB Structure");
        this.hideSeqs.setLabel("Hide Sequences");
        this.repGroup.setLabel("Represent Group with");
        this.revealAll.setLabel("Reveal All");
        this.menu1.setLabel("Group");
        this.add(this.groupMenu);
        this.add(this.seqMenu);
        this.add(this.hideSeqs);
        this.add(this.revealAll);
        this.groupMenu.add(this.editGroupName);
        this.groupMenu.add(this.editMenu);
        this.groupMenu.add(this.outputmenu);
        this.groupMenu.add(this.sequenceFeature);
        this.groupMenu.add(this.menu1);
        this.colourMenu.add(this.noColourmenuItem);
        this.colourMenu.add(this.clustalColour);
        this.colourMenu.add(this.BLOSUM62Colour);
        this.colourMenu.add(this.PIDColour);
        this.colourMenu.add(this.zappoColour);
        this.colourMenu.add(this.taylorColour);
        this.colourMenu.add(this.hydrophobicityColour);
        this.colourMenu.add(this.helixColour);
        this.colourMenu.add(this.strandColour);
        this.colourMenu.add(this.turnColour);
        this.colourMenu.add(this.buriedColour);
        this.colourMenu.add(this.nucleotideMenuItem);
        this.colourMenu.add(this.userDefinedColour);
        this.colourMenu.addSeparator();
        this.colourMenu.add(this.abovePIDColour);
        this.colourMenu.add(this.conservationMenuItem);
        this.noColourmenuItem.setLabel("None");
        this.noColourmenuItem.addActionListener(this);
        this.clustalColour.setLabel("Clustalx colours");
        this.clustalColour.addActionListener(this);
        this.zappoColour.setLabel("Zappo");
        this.zappoColour.addActionListener(this);
        this.taylorColour.setLabel("Taylor");
        this.taylorColour.addActionListener(this);
        this.hydrophobicityColour.setLabel("Hydrophobicity");
        this.hydrophobicityColour.addActionListener(this);
        this.helixColour.setLabel("Helix propensity");
        this.helixColour.addActionListener(this);
        this.strandColour.setLabel("Strand propensity");
        this.strandColour.addActionListener(this);
        this.turnColour.setLabel("Turn propensity");
        this.turnColour.addActionListener(this);
        this.buriedColour.setLabel("Buried Index");
        this.buriedColour.addActionListener(this);
        this.abovePIDColour.setLabel("Above % Identity");
        this.userDefinedColour.setLabel("User Defined");
        this.userDefinedColour.addActionListener(this);
        this.PIDColour.setLabel("Percentage Identity");
        this.PIDColour.addActionListener(this);
        this.BLOSUM62Colour.setLabel("BLOSUM62");
        this.BLOSUM62Colour.addActionListener(this);
        this.conservationMenuItem.setLabel("Conservation");
        this.editMenu.add(this.copy);
        this.copy.addActionListener(this);
        this.editMenu.add(this.cut);
        this.cut.addActionListener(this);
        this.editMenu.add(this.editSequence);
        this.editSequence.addActionListener(this);
        this.editMenu.add(this.toUpper);
        this.toUpper.addActionListener(this);
        this.editMenu.add(this.toLower);
        this.toLower.addActionListener(this);
        this.editMenu.add(this.toggleCase);
        this.seqMenu.add(this.sequenceName);
        this.seqMenu.add(this.pdb);
        this.seqMenu.add(this.repGroup);
        this.menu1.add(this.unGroupMenuItem);
        this.menu1.add(this.colourMenu);
        this.menu1.add(this.showBoxes);
        this.menu1.add(this.showText);
        this.menu1.add(this.showColourText);
        this.toggleCase.addActionListener(this);
        this.pdb.addActionListener(this);
        this.hideSeqs.addActionListener(this);
        this.repGroup.addActionListener(this);
        this.revealAll.addActionListener(this);
    }

    void refresh() {
        this.ap.paintAlignment(true);
    }

    protected void clustalColour_actionPerformed() {
        SequenceGroup sg = this.getGroup();
        sg.cs = new ClustalxColourScheme(sg.getSequences(this.ap.av.hiddenRepSequences), this.ap.av.alignment.getWidth());
        this.refresh();
    }

    protected void zappoColour_actionPerformed() {
        this.getGroup().cs = new ZappoColourScheme();
        this.refresh();
    }

    protected void taylorColour_actionPerformed() {
        this.getGroup().cs = new TaylorColourScheme();
        this.refresh();
    }

    protected void hydrophobicityColour_actionPerformed() {
        this.getGroup().cs = new HydrophobicColourScheme();
        this.refresh();
    }

    protected void helixColour_actionPerformed() {
        this.getGroup().cs = new HelixColourScheme();
        this.refresh();
    }

    protected void strandColour_actionPerformed() {
        this.getGroup().cs = new StrandColourScheme();
        this.refresh();
    }

    protected void turnColour_actionPerformed() {
        this.getGroup().cs = new TurnColourScheme();
        this.refresh();
    }

    protected void buriedColour_actionPerformed() {
        this.getGroup().cs = new BuriedColourScheme();
        this.refresh();
    }

    public void nucleotideMenuItem_actionPerformed() {
        this.getGroup().cs = new NucleotideColourScheme();
        this.refresh();
    }

    protected void abovePIDColour_itemStateChanged() {
        SequenceGroup sg = this.getGroup();
        if (sg.cs == null) {
            return;
        }
        if (this.abovePIDColour.getState()) {
            sg.cs.setConsensus(AAFrequency.calculate(sg.getSequences(this.ap.av.hiddenRepSequences), 0, this.ap.av.alignment.getWidth()));
            int threshold = SliderPanel.setPIDSliderSource(this.ap, sg.cs, this.getGroup().getName());
            sg.cs.setThreshold(threshold, this.ap.av.getIgnoreGapsConsensus());
            SliderPanel.showPIDSlider();
        } else {
            sg.cs.setThreshold(0, this.ap.av.getIgnoreGapsConsensus());
        }
        this.refresh();
    }

    protected void userDefinedColour_actionPerformed() {
        new UserDefinedColours(this.ap, this.getGroup());
    }

    protected void PIDColour_actionPerformed() {
        SequenceGroup sg = this.getGroup();
        sg.cs = new PIDColourScheme();
        sg.cs.setConsensus(AAFrequency.calculate(sg.getSequences(this.ap.av.hiddenRepSequences), 0, this.ap.av.alignment.getWidth()));
        this.refresh();
    }

    protected void BLOSUM62Colour_actionPerformed() {
        SequenceGroup sg = this.getGroup();
        sg.cs = new Blosum62ColourScheme();
        sg.cs.setConsensus(AAFrequency.calculate(sg.getSequences(this.ap.av.hiddenRepSequences), 0, this.ap.av.alignment.getWidth()));
        this.refresh();
    }

    protected void noColourmenuItem_actionPerformed() {
        this.getGroup().cs = null;
        this.refresh();
    }

    protected void conservationMenuItem_itemStateChanged() {
        SequenceGroup sg = this.getGroup();
        if (sg.cs == null) {
            return;
        }
        if (this.conservationMenuItem.getState()) {
            Conservation c = new Conservation("Group", ResidueProperties.propHash, 3, sg.getSequences(this.ap.av.hiddenRepSequences), 0, this.ap.av.alignment.getWidth());
            c.calculate();
            c.verdict(false, this.ap.av.ConsPercGaps);
            sg.cs.setConservation(c);
            SliderPanel.setConservationSlider(this.ap, sg.cs, sg.getName());
            SliderPanel.showConservationSlider();
        } else {
            sg.cs.setConservation(null);
        }
        this.refresh();
    }

    SequenceGroup getGroup() {
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        if (sg != null) {
            this.ap.av.alignment.addGroup(sg);
        }
        return sg;
    }

    void unGroupMenuItem_actionPerformed() {
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        this.ap.av.alignment.deleteGroup(sg);
        this.ap.av.setSelectionGroup(null);
        this.ap.paintAlignment(true);
    }

    public void showColourText_itemStateChanged() {
        this.getGroup().setColourText(this.showColourText.getState());
        this.refresh();
    }

    public void showText_itemStateChanged() {
        this.getGroup().setDisplayText(this.showText.getState());
        this.refresh();
    }

    public void showBoxes_itemStateChanged() {
        this.getGroup().setDisplayBoxes(this.showBoxes.getState());
        this.refresh();
    }

    void hideSequences(boolean representGroup) {
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        if (sg == null || sg.getSize() < 1) {
            this.ap.av.hideSequence(new SequenceI[]{this.seq});
            return;
        }
        this.ap.av.setSelectionGroup(null);
        if (representGroup) {
            this.ap.av.hideRepSequences(this.seq, sg);
            return;
        }
        int gsize = sg.getSize();
        SequenceI[] hseqs = new SequenceI[gsize];
        int index = 0;
        for (int i = 0; i < gsize; ++i) {
            hseqs[index++] = sg.getSequenceAt(i);
        }
        this.ap.av.hideSequence(hseqs);
    }
}

