// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file calculator.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__CALCULATOR_HPP
#define FAST_DDS_GENERATED__CALCULATOR_HPP

#include <cstdint>
#include <memory>
#include <string>
#include <utility>
#include <fastcdr/cdr/fixed_size_string.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/rpc/exceptions/RpcOperationError.hpp>
#include <fastdds/dds/rpc/interfaces/RpcClientReader.hpp>
#include <fastdds/dds/rpc/interfaces/RpcClientWriter.hpp>
#include <fastdds/dds/rpc/interfaces/RpcFuture.hpp>


#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(CALCULATOR_SOURCE)
#define CALCULATOR_DllAPI __declspec( dllexport )
#else
#define CALCULATOR_DllAPI __declspec( dllimport )
#endif // CALCULATOR_SOURCE
#else
#define CALCULATOR_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define CALCULATOR_DllAPI
#endif // _WIN32

namespace calculator_example {

/*!
 * @brief This class implements the user exception calculator_example::OverflowException
 * @ingroup calculator
 */
class eProsima_user_DllExport OverflowException : public eprosima::fastdds::dds::rpc::RpcOperationError
{
public:

    /**
     * Default constructor.
     */
    OverflowException()
        : OverflowException("OverflowException")
    {
    }

    /**
     * Constructor.
     */
    OverflowException(
            const std::string& message)
        : eprosima::fastdds::dds::rpc::RpcOperationError(message)
    {
    }

    /**
     * Constructor.
     */
    OverflowException(
            const char* message)
        : eprosima::fastdds::dds::rpc::RpcOperationError(message)
    {
    }

    /**
     * Copy constructor.
     */
    OverflowException(
            const OverflowException& other) noexcept = default;

    /**
     * Copy assignment.
     */
    OverflowException& operator =(
            const OverflowException& other) noexcept = default;

    /**
     * Destructor.
     */
    virtual ~OverflowException() noexcept = default;



private:


};

/*!
 * @brief This class represents the enumeration FilterKind defined by the user in the IDL file.
 * @ingroup calculator
 */
enum class FilterKind : int32_t
{
    EVEN,
    ODD,
    PRIME
};

namespace detail {

struct Calculator_representation_limits_Out;

}  // namespace detail

/*!
 * @brief This class represents the interface Calculator defined by the user in the IDL file.
 * @ingroup calculator
 */
class eProsima_user_DllExport Calculator 
{
public:
    virtual ~Calculator() = default;


    virtual eprosima::fastdds::dds::rpc::RpcFuture<calculator_example::detail::Calculator_representation_limits_Out> representation_limits(
    ) = 0;


    virtual eprosima::fastdds::dds::rpc::RpcFuture<int32_t> addition(
            /*in*/ int32_t value1,
            /*in*/ int32_t value2) = 0;


    virtual eprosima::fastdds::dds::rpc::RpcFuture<int32_t> subtraction(
            /*in*/ int32_t value1,
            /*in*/ int32_t value2) = 0;


    virtual std::shared_ptr<eprosima::fastdds::dds::rpc::RpcClientReader<int32_t> > fibonacci_seq(
            /*in*/ uint32_t n_results) = 0;


    virtual eprosima::fastdds::dds::rpc::RpcFuture<int32_t> sum_all(
            /*in*/ std::shared_ptr<eprosima::fastdds::dds::rpc::RpcClientWriter<int32_t>>& value) = 0;


    virtual std::shared_ptr<eprosima::fastdds::dds::rpc::RpcClientReader<int32_t> > accumulator(
            /*in*/ std::shared_ptr<eprosima::fastdds::dds::rpc::RpcClientWriter<int32_t>>& value) = 0;


    virtual std::shared_ptr<eprosima::fastdds::dds::rpc::RpcClientReader<int32_t> > filter(
            /*in*/ std::shared_ptr<eprosima::fastdds::dds::rpc::RpcClientWriter<int32_t>>& value,
            /*in*/ calculator_example::FilterKind filter_kind) = 0;

};

namespace detail {

struct Calculator_representation_limits_Out
{
    int32_t min_value;
    int32_t max_value;
};


}  // namespace detail


} // namespace calculator_example

#endif // _FAST_DDS_GENERATED_CALCULATOR_HPP_


