// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file struct_struct.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__STRUCT_STRUCT_HPP
#define FAST_DDS_GENERATED__STRUCT_STRUCT_HPP

#include <cstdint>
#include <string>
#include <utility>
#include <fastcdr/cdr/fixed_size_string.hpp>

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(STRUCT_STRUCT_SOURCE)
#define STRUCT_STRUCT_DllAPI __declspec( dllexport )
#else
#define STRUCT_STRUCT_DllAPI __declspec( dllimport )
#endif // STRUCT_STRUCT_SOURCE
#else
#define STRUCT_STRUCT_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define STRUCT_STRUCT_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure GrandparentStruct defined by the user in the IDL file.
 * @ingroup struct_struct
 */
class GrandparentStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport GrandparentStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~GrandparentStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object GrandparentStruct that will be copied.
     */
    eProsima_user_DllExport GrandparentStruct(
            const GrandparentStruct& x)
    {
                    m_my_long = x.m_my_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object GrandparentStruct that will be copied.
     */
    eProsima_user_DllExport GrandparentStruct(
            GrandparentStruct&& x) noexcept
    {
        m_my_long = x.m_my_long;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object GrandparentStruct that will be copied.
     */
    eProsima_user_DllExport GrandparentStruct& operator =(
            const GrandparentStruct& x)
    {

                    m_my_long = x.m_my_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object GrandparentStruct that will be copied.
     */
    eProsima_user_DllExport GrandparentStruct& operator =(
            GrandparentStruct&& x) noexcept
    {

        m_my_long = x.m_my_long;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x GrandparentStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const GrandparentStruct& x) const
    {
        return (m_my_long == x.m_my_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x GrandparentStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const GrandparentStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member my_long
     * @param _my_long New value for member my_long
     */
    eProsima_user_DllExport void my_long(
            int32_t _my_long)
    {
        m_my_long = _my_long;
    }

    /*!
     * @brief This function returns the value of member my_long
     * @return Value of member my_long
     */
    eProsima_user_DllExport int32_t my_long() const
    {
        return m_my_long;
    }

    /*!
     * @brief This function returns a reference to member my_long
     * @return Reference to member my_long
     */
    eProsima_user_DllExport int32_t& my_long()
    {
        return m_my_long;
    }



private:

    int32_t m_my_long{0};

};
/*!
 * @brief This class represents the structure ParentStruct defined by the user in the IDL file.
 * @ingroup struct_struct
 */
class ParentStruct : public GrandparentStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ParentStruct()
        : GrandparentStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ParentStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ParentStruct that will be copied.
     */
    eProsima_user_DllExport ParentStruct(
            const ParentStruct& x)
        : GrandparentStruct(x)
    {
                    m_my_short = x.m_my_short;

                    m_my_string = x.m_my_string;

                    m_my_grandparent = x.m_my_grandparent;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ParentStruct that will be copied.
     */
    eProsima_user_DllExport ParentStruct(
            ParentStruct&& x) noexcept
        : GrandparentStruct(std::move(x))

    {
        m_my_short = x.m_my_short;
        m_my_string = std::move(x.m_my_string);
        m_my_grandparent = std::move(x.m_my_grandparent);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ParentStruct that will be copied.
     */
    eProsima_user_DllExport ParentStruct& operator =(
            const ParentStruct& x)
    {
        GrandparentStruct::operator =(x);

                    m_my_short = x.m_my_short;

                    m_my_string = x.m_my_string;

                    m_my_grandparent = x.m_my_grandparent;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ParentStruct that will be copied.
     */
    eProsima_user_DllExport ParentStruct& operator =(
            ParentStruct&& x) noexcept
    {
        GrandparentStruct::operator =(std::move(x));

        m_my_short = x.m_my_short;
        m_my_string = std::move(x.m_my_string);
        m_my_grandparent = std::move(x.m_my_grandparent);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ParentStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ParentStruct& x) const
    {
        if (GrandparentStruct::operator !=(x))
                {
                    return false;
                }
        return (m_my_short == x.m_my_short &&
           m_my_string == x.m_my_string &&
           m_my_grandparent == x.m_my_grandparent);
    }

    /*!
     * @brief Comparison operator.
     * @param x ParentStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ParentStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member my_short
     * @param _my_short New value for member my_short
     */
    eProsima_user_DllExport void my_short(
            int16_t _my_short)
    {
        m_my_short = _my_short;
    }

    /*!
     * @brief This function returns the value of member my_short
     * @return Value of member my_short
     */
    eProsima_user_DllExport int16_t my_short() const
    {
        return m_my_short;
    }

    /*!
     * @brief This function returns a reference to member my_short
     * @return Reference to member my_short
     */
    eProsima_user_DllExport int16_t& my_short()
    {
        return m_my_short;
    }


    /*!
     * @brief This function copies the value in member my_string
     * @param _my_string New value to be copied in member my_string
     */
    eProsima_user_DllExport void my_string(
            const std::string& _my_string)
    {
        m_my_string = _my_string;
    }

    /*!
     * @brief This function moves the value in member my_string
     * @param _my_string New value to be moved in member my_string
     */
    eProsima_user_DllExport void my_string(
            std::string&& _my_string)
    {
        m_my_string = std::move(_my_string);
    }

    /*!
     * @brief This function returns a constant reference to member my_string
     * @return Constant reference to member my_string
     */
    eProsima_user_DllExport const std::string& my_string() const
    {
        return m_my_string;
    }

    /*!
     * @brief This function returns a reference to member my_string
     * @return Reference to member my_string
     */
    eProsima_user_DllExport std::string& my_string()
    {
        return m_my_string;
    }


    /*!
     * @brief This function copies the value in member my_grandparent
     * @param _my_grandparent New value to be copied in member my_grandparent
     */
    eProsima_user_DllExport void my_grandparent(
            const GrandparentStruct& _my_grandparent)
    {
        m_my_grandparent = _my_grandparent;
    }

    /*!
     * @brief This function moves the value in member my_grandparent
     * @param _my_grandparent New value to be moved in member my_grandparent
     */
    eProsima_user_DllExport void my_grandparent(
            GrandparentStruct&& _my_grandparent)
    {
        m_my_grandparent = std::move(_my_grandparent);
    }

    /*!
     * @brief This function returns a constant reference to member my_grandparent
     * @return Constant reference to member my_grandparent
     */
    eProsima_user_DllExport const GrandparentStruct& my_grandparent() const
    {
        return m_my_grandparent;
    }

    /*!
     * @brief This function returns a reference to member my_grandparent
     * @return Reference to member my_grandparent
     */
    eProsima_user_DllExport GrandparentStruct& my_grandparent()
    {
        return m_my_grandparent;
    }



private:

    int16_t m_my_short{0};
    std::string m_my_string;
    GrandparentStruct m_my_grandparent;

};
/*!
 * @brief This class represents the structure NestedStructElement defined by the user in the IDL file.
 * @ingroup struct_struct
 */
class NestedStructElement
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport NestedStructElement()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~NestedStructElement()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object NestedStructElement that will be copied.
     */
    eProsima_user_DllExport NestedStructElement(
            const NestedStructElement& x)
    {
                    m_my_boolean = x.m_my_boolean;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object NestedStructElement that will be copied.
     */
    eProsima_user_DllExport NestedStructElement(
            NestedStructElement&& x) noexcept
    {
        m_my_boolean = x.m_my_boolean;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object NestedStructElement that will be copied.
     */
    eProsima_user_DllExport NestedStructElement& operator =(
            const NestedStructElement& x)
    {

                    m_my_boolean = x.m_my_boolean;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object NestedStructElement that will be copied.
     */
    eProsima_user_DllExport NestedStructElement& operator =(
            NestedStructElement&& x) noexcept
    {

        m_my_boolean = x.m_my_boolean;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x NestedStructElement object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const NestedStructElement& x) const
    {
        return (m_my_boolean == x.m_my_boolean);
    }

    /*!
     * @brief Comparison operator.
     * @param x NestedStructElement object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const NestedStructElement& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member my_boolean
     * @param _my_boolean New value for member my_boolean
     */
    eProsima_user_DllExport void my_boolean(
            bool _my_boolean)
    {
        m_my_boolean = _my_boolean;
    }

    /*!
     * @brief This function returns the value of member my_boolean
     * @return Value of member my_boolean
     */
    eProsima_user_DllExport bool my_boolean() const
    {
        return m_my_boolean;
    }

    /*!
     * @brief This function returns a reference to member my_boolean
     * @return Reference to member my_boolean
     */
    eProsima_user_DllExport bool& my_boolean()
    {
        return m_my_boolean;
    }



private:

    bool m_my_boolean{false};

};
/*!
 * @brief This class represents the structure StructStruct defined by the user in the IDL file.
 * @ingroup struct_struct
 */
class StructStruct : public ParentStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructStruct()
        : ParentStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructStruct that will be copied.
     */
    eProsima_user_DllExport StructStruct(
            const StructStruct& x)
        : ParentStruct(x)
    {
                    m_my_nested_element = x.m_my_nested_element;

                    m_my_char = x.m_my_char;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructStruct that will be copied.
     */
    eProsima_user_DllExport StructStruct(
            StructStruct&& x) noexcept
        : ParentStruct(std::move(x))

    {
        m_my_nested_element = std::move(x.m_my_nested_element);
        m_my_char = x.m_my_char;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructStruct that will be copied.
     */
    eProsima_user_DllExport StructStruct& operator =(
            const StructStruct& x)
    {
        ParentStruct::operator =(x);

                    m_my_nested_element = x.m_my_nested_element;

                    m_my_char = x.m_my_char;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructStruct that will be copied.
     */
    eProsima_user_DllExport StructStruct& operator =(
            StructStruct&& x) noexcept
    {
        ParentStruct::operator =(std::move(x));

        m_my_nested_element = std::move(x.m_my_nested_element);
        m_my_char = x.m_my_char;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructStruct& x) const
    {
        if (ParentStruct::operator !=(x))
                {
                    return false;
                }
        return (m_my_nested_element == x.m_my_nested_element &&
           m_my_char == x.m_my_char);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member my_nested_element
     * @param _my_nested_element New value to be copied in member my_nested_element
     */
    eProsima_user_DllExport void my_nested_element(
            const NestedStructElement& _my_nested_element)
    {
        m_my_nested_element = _my_nested_element;
    }

    /*!
     * @brief This function moves the value in member my_nested_element
     * @param _my_nested_element New value to be moved in member my_nested_element
     */
    eProsima_user_DllExport void my_nested_element(
            NestedStructElement&& _my_nested_element)
    {
        m_my_nested_element = std::move(_my_nested_element);
    }

    /*!
     * @brief This function returns a constant reference to member my_nested_element
     * @return Constant reference to member my_nested_element
     */
    eProsima_user_DllExport const NestedStructElement& my_nested_element() const
    {
        return m_my_nested_element;
    }

    /*!
     * @brief This function returns a reference to member my_nested_element
     * @return Reference to member my_nested_element
     */
    eProsima_user_DllExport NestedStructElement& my_nested_element()
    {
        return m_my_nested_element;
    }


    /*!
     * @brief This function sets a value in member my_char
     * @param _my_char New value for member my_char
     */
    eProsima_user_DllExport void my_char(
            char _my_char)
    {
        m_my_char = _my_char;
    }

    /*!
     * @brief This function returns the value of member my_char
     * @return Value of member my_char
     */
    eProsima_user_DllExport char my_char() const
    {
        return m_my_char;
    }

    /*!
     * @brief This function returns a reference to member my_char
     * @return Reference to member my_char
     */
    eProsima_user_DllExport char& my_char()
    {
        return m_my_char;
    }



private:

    NestedStructElement m_my_nested_element;
    char m_my_char{0};

};

#endif // _FAST_DDS_GENERATED_STRUCT_STRUCT_HPP_


