// Copyright (c) 2012 Ecma International.  All rights reserved.
// Ecma International makes this code available under the terms and conditions set
// forth on http://hg.ecmascript.org/tests/test262/raw-file/tip/LICENSE (the
// "Use Terms").   Any redistribution of this code must retain the above
// copyright and this notice and otherwise comply with the Use Terms.

/*---
es5id: 15.4.4.22-2-10
description: >
    Array.prototype.reduceRight applied to Array-like object, 'length'
    is an inherited accessor property
includes: [runTestCase.js]
---*/

function testcase() {

        var accessed = false;
        var Con = function () { };


        function callbackfn(prevVal, curVal, idx, obj) {
            accessed = true;
            return obj.length === 2;
        }

        var proto = {};

        Object.defineProperty(proto, "length", {
            get: function () {
                return 2;
            },
            configurable: true
        });

        Con.prototype = proto;

        var child = new Con();
        child[0] = 12;
        child[1] = 11;
        child[2] = 9;


        return Array.prototype.reduceRight.call(child, callbackfn, 11) && accessed;
    }
runTestCase(testcase);
