/*
 * Decompiled with CFR 0.152.
 */
package com.jsql;

import com.jsql.model.InjectionModel;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.JFrameView;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.AWTError;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MainApp {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private static final InjectionModel INJECTION_MODEL;

    private MainApp() {
    }

    public static void main(String[] args) {
        MediatorHelper.register(INJECTION_MODEL);
        INJECTION_MODEL.getMediatorUtils().getExceptionUtil().setUncaughtExceptionHandler();
        INJECTION_MODEL.getMediatorUtils().getProxyUtil().initProxy();
        INJECTION_MODEL.getMediatorUtils().getAuthenticationUtil().setKerberosCifs();
        try {
            JFrameView view = new JFrameView(INJECTION_MODEL);
            MediatorHelper.register(view);
            INJECTION_MODEL.subscribe(view.getSubscriber());
        }
        catch (HeadlessException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, "HeadlessException, command line execution not supported: %s", (Throwable)e);
        }
        catch (AWTError e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, String.format("Java Access Bridge missing or corrupt, check your access bridge definition in JDK_HOME/jre/lib/accessibility.properties: %s", e.getMessage()), (Throwable)e);
        }
    }

    private static void apply4K() {
        if (INJECTION_MODEL.getMediatorUtils().getPreferencesUtil().is4K()) {
            System.setProperty("sun.java2d.uiScale", "2.5");
        }
    }

    static {
        System.setProperty("jdk.httpclient.allowRestrictedHeaders", "connection,content-length,expect,host,upgrade");
        System.setProperty("log4j2.formatMsgNoLookups", "true");
        if (GraphicsEnvironment.isHeadless()) {
            LOGGER.log(Level.ERROR, "Headless runtime not supported, use default Java runtime instead");
            System.exit(1);
        }
        INJECTION_MODEL = new InjectionModel();
        INJECTION_MODEL.getMediatorUtils().getPreferencesUtil().loadSavedPreferences();
        String nameTheme = INJECTION_MODEL.getMediatorUtils().getPreferencesUtil().getThemeFlatLafName();
        UiUtil.applyTheme(nameTheme);
        MainApp.apply4K();
    }
}

