/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.webp.lossless;

import com.twelvemonkeys.lang.Validate;

final class ColorCache {
    private final int[] colors;
    private final int hashShift;
    private static final long K_HASH_MUL = 506832829L;

    private static int hashPix(int n, int n2) {
        return (int)(((long)n * 506832829L & 0xFFFFFFFFL) >> n2);
    }

    ColorCache(int n) {
        Validate.isTrue((n > 0 ? 1 : 0) != 0, (String)"hasBits must > 0");
        int n2 = 1 << n;
        this.colors = new int[n2];
        this.hashShift = 32 - n;
    }

    int lookup(int n) {
        return this.colors[n];
    }

    void set(int n, int n2) {
        this.colors[n] = n2;
    }

    void insert(int n) {
        this.colors[this.index((int)n)] = n;
    }

    int index(int n) {
        return ColorCache.hashPix(n, this.hashShift);
    }

    int contains(int n) {
        int n2 = this.index(n);
        return this.colors[n2] == n ? n2 : -1;
    }
}

