#!/usr/bin/python2

import os, sys, commands
import json

priorities = ['yahoo', 'ixquick', 'startpage', 'duckduckgo']

archi = sys.argv[1]
curdir = sys.argv[2]
version = sys.argv[3]
abort = False

release = version
if "+" in version:
    #if "lmde" not in version:
    #    abort = True
    release = version.split("+")[0]

if "~" in version:
    release = version.split("~")[0]

if archi == "amd64":
    archi="linux-x86_64"
else:
    archi="linux-i686"

locales = {}
locales['af'] = 'af'
locales['ar'] = 'ar'
# locales['be'] = 'be'
locales['bg'] = 'bg'
locales['bn'] = 'bn-bd'
locales['ca'] = 'ca'
locales['cs'] = 'cs'
locales['da'] = 'da'
locales['de'] = 'de'
locales['el'] = 'el'
locales['en-CA'] = 'en-ca'
locales['en-GB'] = 'en-gb'
locales['eo'] = 'eo'
locales['es-ES'] = 'es'
locales['et'] = 'et'
locales['eu'] = 'eu'
locales['fa'] = 'fa'
locales['fi'] = 'fi'
locales['fr'] = 'fr'
locales['fy-NL'] = 'fy'
locales['gl'] = 'gl'
locales['gu-IN'] = 'gu'
locales['he'] = 'he'
locales['hi-IN'] = 'hi'
locales['hr'] = 'hr'
locales['hu'] = 'hu'
locales['id'] = 'id'
locales['is'] = 'is'
locales['it'] = 'it'
locales['ja'] = 'ja'
locales['kn'] = 'kn'
locales['ko'] = 'ko'
locales['lt'] = 'lt'
locales['lv'] = 'lv'
locales['ms'] = 'ms'
locales['nb-NO'] = 'nb'
locales['nl'] = 'nl'
locales['nn-NO'] = 'nn'
locales['pl'] = 'pl'
locales['pt-PT'] = 'pt'
locales['pt-BR'] = 'pt-br'
locales['ro'] = 'ro'
locales['ru'] = 'ru'
locales['sk'] = 'sk'
locales['sl'] = 'sl'
locales['sq'] = 'sq'
locales['sr'] = 'sr'
locales['sv-SE'] = 'sv'
locales['th'] = 'th'
locales['tr'] = 'tr'
locales['uk'] = 'uk'
locales['zh-CN'] = 'zh'

US_URL = "http://download-origin.cdn.mozilla.net/pub/firefox/releases/%s/%s/en-US/firefox-%s.tar.bz2" % (release, archi, release)
XPI_URL = "http://download-origin.cdn.mozilla.net/pub/firefox/releases/%s/%s/xpi" % (release, archi)

def change_value (key, value, file):
    if value is not None:
        command = "sed -i '/%(key)s=/c\%(key)s=%(value)s' %(file)s" % {'key':key, 'value':value, 'file':file}
    else:
        command = "sed -i '/%(key)s=/d' %(file)s" % {'key':key, 'file':file}
    os.system(command)

os.system("rm -rf %s/debian/firefox" % curdir)
os.system("rm -rf %s/debian/firefox-*" % curdir)
os.system("mkdir -p %s/debian/firefox/opt" % curdir)
os.chdir("%s/debian/firefox/opt" % curdir)
if not abort:

    os.system("wget %s" % US_URL)
    if (not os.path.exists("firefox-%s.tar.bz2" % release)):
        print "FAILED: Could not download %s" % (US_URL)
        sys.exit(1)

    os.system("bzip2 -d firefox-%s.tar.bz2" % release)
    os.system("tar xvf firefox-%s.tar" % release)
    os.system("rm firefox-%s.tar" % release)

    os.system("rm -rf firefox/defaults/pref/*")
    os.system("cp %s/pref/* firefox/defaults/pref/" % curdir)

    os.system("mkdir OMNI")
    os.system("cp firefox/browser/omni.ja OMNI/")
    os.chdir("OMNI/")
    os.system("unzip omni.ja")
    os.system("rm omni.ja")
    os.system("rm -rf chrome/browser/search-extensions/*")
    os.system("cp -R %s/search-extensions/* chrome/browser/search-extensions/" % curdir)
    region_properties = "chrome/en-US/locale/browser-region/region.properties"
    if os.path.exists(region_properties):
        change_value("browser.search.defaultenginename", "Yahoo!", region_properties)
        change_value("browser.search.order.1", "Yahoo!", region_properties)
        change_value("browser.search.order.2", "Startpage", region_properties)
        change_value("browser.search.order.3", "DuckDuckGo", region_properties)

    os.system("patch defaults/preferences/firefox.js %s" % os.path.join(curdir, "disable-modern-config.patch"))

    os.system("zip -qr9XD omni.ja *")
    os.chdir("..")
    os.system("cp OMNI/omni.ja firefox/browser/omni.ja")
    os.system("rm -rf OMNI")

    os.system("mkdir -p %s/debian/firefox/usr/share/icons/hicolor" % curdir)
    os.chdir("%s/debian/firefox/usr/share/icons/hicolor" % curdir)
    os.system("mkdir -p 16x16/apps 32x32/apps 48x48/apps 128x128/apps")
    os.system("ln -s /opt/firefox/browser/chrome/icons/default/default16.png 16x16/apps/firefox.png")
    os.system("ln -s /opt/firefox/browser/chrome/icons/default/default32.png 32x32/apps/firefox.png")
    os.system("ln -s /opt/firefox/browser/chrome/icons/default/default48.png 48x48/apps/firefox.png")
    os.system("ln -s /opt/firefox/browser/icons/mozicon128.png 128x128/apps/firefox.png")
    os.system("mkdir -p %s/debian/firefox/opt/firefox/browser/defaults/preferences" % curdir)
    os.chdir("%s/debian/firefox/opt/firefox/browser/defaults/preferences" % curdir)
    pref_file = open("browser.js", "wb")
    pref_file.write('pref("extensions.autoDisableScopes", 3);\n')
    pref_file.write('pref("intl.locale.matchOS", true);\n')
    pref_file.write('pref("intl.locale.requested", "");\n')
    pref_file.write('pref("extensions.langpacks.signatures.required", false);\n')
    pref_file.write('pref("browser.shell.checkDefaultBrowser", false);\n')
    pref_file.write('pref("browser.EULA.override", true);\n')
    pref_file.write('pref("general.useragent.vendor", "Linux Mint");\n')
    pref_file.write('pref("general.useragent.vendorSub", "17.3");\n')
    pref_file.write('pref("general.useragent.vendorComment", "Rosa");\n')
    pref_file.write('pref("browser.backspace_action", 0);\n')
    pref_file.write('pref("network.dns.disableIPv6", true);\n')
    pref_file.write('pref("browser.startup.homepage_override.mstone", "ignore");\n')
    pref_file.write('pref("widget.content.gtk-theme-override", "#");\n')
    pref_file.write('pref("datareporting.policy.dataSubmissionPolicyBypassNotification", true);\n')
    pref_file.write('pref("browser.slowStartup.notificationDisabled", true);\n')
    pref_file.write('pref("browser.disableResetPrompt", true);\n')
    pref_file.write('pref("browser.rights.3.shown", true);\n')
    pref_file.write('pref("toolkit.telemetry.prompted", 2);\n')
    pref_file.write('pref("toolkit.telemetry.rejected", true);\n')
    pref_file.write('pref("browser.backspace_action", 0);\n')
    pref_file.write('pref("browser.search.searchEnginesURL", "http://www.linuxmint.com/searchengines/");\n')
    pref_file.write('pref("toolkit.telemetry.unified", false);\n')
    pref_file.write('pref("toolkit.telemetry.archive.enabled", false);\n')
    pref_file.write('pref("toolkit.telemetry.enabled", false);\n')
    pref_file.write('pref("toolkit.telemetry.unifiedIsOptIn", false);\n')
    pref_file.write('pref("toolkit.telemetry.server", "data:,");\n')
    pref_file.write('pref("toolkit.telemetry.newProfilePing.enabled", false);\n')
    pref_file.write('pref("toolkit.telemetry.shutdownPingSender.enabled", false);\n')
    pref_file.write('pref("toolkit.telemetry.updatePing.enabled", false);\n')
    pref_file.write('pref("toolkit.telemetry.bhrPing.enabled", false);\n')
    pref_file.write('pref("toolkit.telemetry.firstShutdownPing.enabled", false);\n')
    pref_file.write('pref("toolkit.telemetry.coverage.opt-out", true);\n')
    pref_file.write('pref("toolkit.coverage.opt-out", true);\n')
    pref_file.write('pref("toolkit.coverage.endpoint.base", "");\n')
    pref_file.write('pref("datareporting.policy.dataSubmissionEnabled", false);\n')
    pref_file.write('pref("datareporting.healthreport.uploadEnabled", false);\n')
    pref_file.write('pref("app.shield.optoutstudies.enabled", false);\n')
    pref_file.write('pref("browser.discovery.enabled", false);\n')
    pref_file.write('pref("breakpad.reportURL", "");\n')
    pref_file.write('pref("browser.tabs.crashReporting.sendReport", false);\n')
    pref_file.write('pref("browser.crashReports.unsubmittedCheck.enabled", false);\n')
    pref_file.write('pref("browser.crashReports.unsubmittedCheck.autoSubmit2", false);\n')
    pref_file.write('pref("startup.homepage_welcome_url", "");\n')
    pref_file.write('pref("startup.homepage_welcome_url.additional", "");\n')
    pref_file.write('pref("startup.homepage_override_url", "");\n')
    pref_file.write('pref("browser.newtabpage.activity-stream.asrouter.userprefs.cfr.addons", false);\n')
    pref_file.write('pref("browser.newtabpage.activity-stream.asrouter.userprefs.cfr.features", false);\n')
    pref_file.write('pref("browser.newtabpage.activity-stream.feeds.snippets", false);\n')
    pref_file.write('pref("identity.fxaccounts.toolbar.enabled", false);\n')
    pref_file.write('pref("identity.fxaccounts.toolbar.accessed", true);\n')
    pref_file.write('pref("browser.search.modernConfig", false);\n')
    pref_file.close()

for locale in locales:
    os.system("mkdir -p %s/debian/firefox/opt/firefox/browser/extensions" % (curdir))
    os.chdir("%s/debian/firefox/opt/firefox/browser/extensions" % (curdir))
    if not abort:
        os.system("wget %s/%s.xpi" % (XPI_URL, locale))
        if (not os.path.exists("%s.xpi" % locale)):
            print "FAILED: Could not download %s/%s.xpi" % (XPI_URL, locale)
            sys.exit(1)
        os.system("mkdir EXTENSION")
        os.system("mv ./%s.xpi ./EXTENSION/langpack-%s@firefox.mozilla.org.xpi" % (locale, locale))
        os.chdir("EXTENSION")
        os.system("unzip ./langpack-%s@firefox.mozilla.org.xpi" % locale)
        os.system("rm ./langpack-%s@firefox.mozilla.org.xpi" % locale)
        os.system("zip -qr9XD langpack-%s@firefox.mozilla.org.xpi *" % locale)
        os.system("mv langpack-%s@firefox.mozilla.org.xpi ../" % locale)
        os.chdir("..")
        os.system("rm -rf EXTENSION")

os.chdir(curdir)
