/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.gedcom.GedcomDirectory;
import ancestris.view.AncestrisTopComponent;
import genj.gedcom.Context;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class ActionClose
extends AbstractAncestrisContextAction {
    private Context contextBeingClosed = null;

    public ActionClose() {
        this.setButtonName();
        this.setIconBase("ancestris/view/images/Close.png");
        this.setEnabled(this.enabled);
    }

    public ActionClose(Context context) {
        this();
        this.contextBeingClosed = context;
    }

    public void actionPerformed(ActionEvent event) {
        for (AncestrisTopComponent aTC : AncestrisPlugin.lookupAll(AncestrisTopComponent.class)) {
            if (!aTC.isOpen || !aTC.isShowing()) continue;
            aTC.requestActive();
            break;
        }
        if (this.contextBeingClosed != null) {
            GedcomDirectory.getDefault().closeGedcom(this.contextBeingClosed);
        } else {
            Context localContext = this.getContext();
            if (localContext != null) {
                GedcomDirectory.getDefault().closeGedcom(localContext);
                this.resultChanged(null);
            }
        }
    }

    protected void contextChanged() {
        this.setEnabled(!this.contextProperties.isEmpty());
        String gedcomName = this.setButtonName();
        Object title = NbBundle.getBundle((String)"org/netbeans/core/windows/view/ui/Bundle").getString("CTL_MainWindow_Title");
        if (!gedcomName.isEmpty()) {
            title = gedcomName + " - " + (String)title;
        }
        JFrame mainFrame = (JFrame)WindowManager.getDefault().getMainWindow();
        mainFrame.setTitle((String)title);
        super.contextChanged();
    }

    protected void actionPerformedImpl(ActionEvent event) {
    }

    private String getCurrentGedcom() {
        Context localContext = this.getContext();
        if (localContext != null && localContext.getGedcom() != null) {
            return localContext.getGedcom().getDisplayName();
        }
        return "";
    }

    private String setButtonName() {
        String gedcomName = this.getCurrentGedcom();
        this.setText(NbBundle.getMessage(ActionClose.class, (String)"CTL_ActionClose") + " " + gedcomName);
        this.setTip(NbBundle.getMessage(ActionClose.class, (String)"CTL_ActionClose").replaceAll("&", "") + " " + gedcomName);
        return gedcomName;
    }
}

