/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.gedart;

import ancestris.core.TextOptions;
import ancestris.gedcom.privacy.PrivacyPolicy;
import ancestris.reports.gedart.GedartTemplates;
import ancestris.reports.gedart.ReportGedart;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.PropertyAge;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyEventDetails;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyNote;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertySharedNote;
import genj.gedcom.PropertySource;
import genj.gedcom.PropertyXRef;
import genj.gedcom.SNote;
import genj.gedcom.Source;
import genj.gedcom.TagPath;
import genj.io.InputSource;
import genj.io.input.FileInput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.generic.DateTool;
import org.apache.velocity.tools.generic.ListTool;
import org.apache.velocity.tools.generic.SortTool;
import org.openide.modules.Places;

public class DocReport {
    private VelocityContext context;
    private static VelocityEngine engine = new VelocityEngine();
    private Writer out;
    public Charset CHARSET;
    private static final File TEMPLATE_DIR = Places.getUserDirectory();

    DocReport(GedartTemplates template, String encoding) {
        try {
            this.CHARSET = Charset.forName(encoding);
        }
        catch (Exception e) {
            this.CHARSET = Charset.forName("ISO-8859-1");
        }
        try {
            engine.setProperty("resource.loader", (Object)"file,class");
            engine.setProperty("file.resource.loader.path", (Object)TEMPLATE_DIR.getPath());
            engine.setProperty("file.resource.loader.cache", (Object)"true");
            engine.setProperty("directive.set.null.allowed", (Object)"true");
            engine.setProperty("runtime.interpolate.string.literals", (Object)"true");
            engine.init();
        }
        catch (Exception e) {
            System.out.println("Problem initializing Velocity : " + e);
        }
        this.restart();
    }

    DocReport(File file, GedartTemplates template, String encoding) throws IOException {
        this(template, encoding);
        this.out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.CHARSET);
    }

    final void restart() {
        this.context = new VelocityContext();
        this.context.put("gedcom", (Object)new Gedcom());
        this.context.put("list", (Object)new ListTool());
        this.context.put("sorter", (Object)new SortTool());
        this.context.put("date", (Object)new DateTool());
        this.context.put("docindex", (Object)new reportIndex());
        this.context.put("null", null);
        this.context.put("encoding", (Object)this.CHARSET);
    }

    void put(String key, Object o) {
        this.context.put(key, o);
    }

    void put(String key, Gedcom e) {
        this.context.put(key, (Object)new reportGedcom(e));
    }

    void put(String key, ReportGedart r) {
        this.put(key, new reportOptions(r));
    }

    void put(String key, Fam f) {
        reportFam rf = null;
        if (f != null) {
            rf = new reportFam(f);
        }
        this.put(key, rf);
    }

    void put(String key, Indi i) {
        this.context.put(key, (Object)new reportIndi(i));
    }

    void put(String key, Entity[] entities) {
        if (entities.length == 0) {
            this.put(key, new Object[0]);
        } else if (entities[0] instanceof Indi) {
            reportIndi[] reportIndis = new reportIndi[entities.length];
            for (int i = 0; i < entities.length; ++i) {
                reportIndis[i] = new reportIndi((Indi)entities[i]);
            }
            this.put(key, reportIndis);
        } else if (entities[0] instanceof Fam) {
            reportFam[] reportFams = new reportFam[entities.length];
            for (int i = 0; i < entities.length; ++i) {
                reportFams[i] = new reportFam((Fam)entities[i]);
            }
            this.put(key, reportFams);
        } else {
            this.put(key, (Object)null);
        }
    }

    void render(String template) {
        try {
            engine.mergeTemplate(template, "ISO-8859-1", (Context)this.context, this.out);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.restart();
    }

    void close() {
        try {
            this.out.flush();
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class reportIndex {
        private Map<String, Map<String, Map<String, List<Entity>>>> index2primary2secondary2elements = new TreeMap<String, Map<String, Map<String, List<Entity>>>>();

        private String getKey(Entity e, String tagPath) {
            Property p;
            String tp = tagPath;
            boolean isFirst = false;
            boolean isLast = false;
            isFirst = tp.endsWith("NAME:FIRST");
            isLast = tp.endsWith("NAME:LAST");
            if (isFirst || isLast) {
                tp = tp.substring(0, tp.lastIndexOf(58));
            }
            if ((p = e.getPropertyByPath(e.getTag() + ":" + tp)) == null) {
                return "?";
            }
            String result = isFirst ? ((PropertyName)p).getFirstName().split(" ", 1)[0] : (isLast ? ((PropertyName)p).getLastName() : p.toString());
            if (result.length() == 0) {
                return "?";
            }
            return result;
        }

        public Map<String, Map<String, Map<String, List<Entity>>>> buildIndexes(reportEntity[] entities, String tagpathPrimary, String tagpathSecondary) {
            this.index2primary2secondary2elements = new TreeMap<String, Map<String, Map<String, List<Entity>>>>();
            return this.addIndexes(entities, tagpathPrimary, tagpathSecondary);
        }

        public Map<String, Map<String, Map<String, List<Entity>>>> addIndexes(reportEntity[] entities, String tagpathPrimary, String tagpathSecondary) {
            for (reportEntity entitie : entities) {
                Entity e = (Entity)entitie.property;
                String prim = this.getKey(e, tagpathPrimary);
                String sec = this.getKey(e, tagpathSecondary);
                this.addIndexTerm(prim.substring(0, 1), prim, sec, e);
            }
            return this.index2primary2secondary2elements;
        }

        public void addIndexTerm(String index, String primary, Entity entity) {
            this.addIndexTerm(index, primary, "", entity);
        }

        public void addIndexTerm(String index, String primary, String secondary, Entity entity) {
            List<Entity> elements;
            Map<String, List<Entity>> secondary2elements;
            if (index == null) {
                return;
            }
            if ((index = index.trim()).length() == 0) {
                return;
            }
            if ((primary = this.trimIndexTerm(primary)).length() == 0) {
                return;
            }
            if ((secondary = this.trimIndexTerm(secondary)).length() == 0) {
                return;
            }
            Map<String, Map<String, List<Entity>>> primary2secondary2elements = this.index2primary2secondary2elements.get(index);
            if (primary2secondary2elements == null) {
                primary2secondary2elements = new TreeMap<String, Map<String, List<Entity>>>();
                this.index2primary2secondary2elements.put(index, primary2secondary2elements);
            }
            if ((secondary2elements = primary2secondary2elements.get(primary)) == null) {
                secondary2elements = new TreeMap<String, List<Entity>>();
                primary2secondary2elements.put(primary, secondary2elements);
            }
            if ((elements = secondary2elements.get(secondary)) == null) {
                elements = new ArrayList<Entity>();
                secondary2elements.put(secondary, elements);
            }
            if (!elements.contains(entity)) {
                elements.add(entity);
            }
        }

        private String trimIndexTerm(String term) {
            int comma;
            if (term == null) {
                return "";
            }
            int bracket = term.indexOf(40);
            if (bracket >= 0) {
                term = term.substring(0, bracket);
            }
            if ((comma = term.indexOf(40)) >= 0) {
                term = term.substring(0, comma);
            }
            return term.trim();
        }
    }

    public class reportGedcom {
        Gedcom theGedcom;

        reportGedcom(Gedcom g) {
            this.theGedcom = g;
        }

        public reportEntity getSubmitter() {
            return new reportEntity((Entity)this.theGedcom.getSubmitter());
        }

        public String getFileName() {
            return this.theGedcom.getOrigin().getFileName();
        }

        public String getProperty(String tagPath) {
            return this.theGedcom.getFirstEntity("HEAD").getPropertyByPath("HEAD:" + tagPath).getDisplayValue();
        }
    }

    public class reportOptions {
        private final ReportGedart report;
        private final TextOptions OPTIONS = TextOptions.getInstance();

        reportOptions(ReportGedart rep) {
            this.report = rep;
        }

        public boolean getShowBlankCells() {
            return this.report.includeBlankCells;
        }

        public boolean getShowID() {
            return this.report.showID;
        }

        public boolean getShowTOC() {
            return this.report.includeTOC;
        }

        public boolean getShowIndex() {
            return this.report.includeIndex;
        }

        public boolean getShowIndis() {
            return this.report.includeIndi;
        }

        public boolean getShowFams() {
            return this.report.includeFam;
        }

        public String getLocale() {
            return this.OPTIONS.getOutputLocale().getLanguage();
        }
    }

    public class reportFam
    extends reportEntity {
        private Indi refIndi;

        reportFam(Fam f, Indi indi) {
            this(f);
            this.refIndi = indi;
        }

        reportFam(Fam f) {
            super((Entity)f);
            this.refIndi = null;
        }

        public ReportProperty getOtherSpouse() {
            if (this.refIndi == null) {
                return null;
            }
            Indi i = ((Fam)this.property).getOtherSpouse(this.refIndi);
            return this.create((Property)i);
        }

        public String getShortValue() {
            return this.toString();
        }

        @Override
        public String toString() {
            if (this.property == null) {
                return "";
            }
            return this.property.toString() + ((Entity)this.property).format("MARR", "{ le $D}{ \ufffd $P}");
        }

        public ReportProperty[] getChildren() {
            Indi[] ch = ((Fam)this.property).getChildren();
            ReportProperty[] result = new ReportProperty[ch.length];
            for (int c = 0; c < ch.length; ++c) {
                result[c] = this.create((Property)ch[c]);
            }
            return result;
        }

        public ReportProperty getHusband() {
            Indi i = ((Fam)this.property).getHusband();
            return this.create((Property)i);
        }

        public ReportProperty getWife() {
            Indi i = ((Fam)this.property).getWife();
            return this.create((Property)i);
        }
    }

    public class reportIndi
    extends reportEntity {
        reportIndi(Indi i) {
            super((Entity)i);
        }

        public String getShortValue() {
            return this.toString();
        }

        @Override
        public String toString() {
            if (this.property == null) {
                return "";
            }
            String birth = ((Entity)this.property).format("BIRT", this.OPTIONS.getBirthSymbol() + " {$V }{$D}{ $P}");
            String death = ((Entity)this.property).format("DEAT", this.OPTIONS.getDeathSymbol() + " {$V }{$D}{ $P}");
            return this.property.toString() + " " + birth + " " + death;
        }

        public String getString(String male, String female, String unknown) {
            if (((Indi)this.property).getSex() == 1) {
                return male;
            }
            if (((Indi)this.property).getSex() == 2) {
                return female;
            }
            return unknown;
        }

        public String getString(String male, String female) {
            return this.getString(male, female, male);
        }

        public ReportProperty getFamc() {
            Fam famc = ((Indi)this.property).getFamilyWhereBiologicalChild();
            return this.create((Property)famc);
        }

        public reportFam[] getFams() {
            Fam[] fams = ((Indi)this.property).getFamiliesWhereSpouse();
            reportFam[] reportFams = new reportFam[fams.length];
            for (int f = 0; f < fams.length; ++f) {
                reportFams[f] = new reportFam(fams[f], (Indi)this.property);
            }
            return reportFams;
        }
    }

    public class ReportProperty
    implements Comparable<ReportProperty> {
        Property property;

        ReportProperty(Property prop) {
            this.property = prop;
        }

        ReportProperty create(Property p) {
            if (p == null) {
                return null;
            }
            if (p instanceof Indi) {
                Indi indi = (Indi)p;
                return new reportIndi(indi);
            }
            if (p instanceof Fam) {
                Fam fam = (Fam)p;
                return new reportFam(fam);
            }
            if (p instanceof Source) {
                Source source = (Source)p;
                return new reportEntity((Entity)source);
            }
            if (p instanceof PropertyAge) {
                PropertyAge age = (PropertyAge)p;
                return new reportPropertyAge(age);
            }
            if (p instanceof PropertyMedia || "OBJE".equals(p.getTag())) {
                return new reportPropertyMedia(p);
            }
            if (p instanceof PropertyXRef) {
                PropertyXRef xref = (PropertyXRef)p;
                return new reportPropertyXRef(xref);
            }
            if (p instanceof PropertyPlace) {
                PropertyPlace place = (PropertyPlace)p;
                return new reportPropertyPlace(place);
            }
            if (p instanceof PropertyFile) {
                PropertyFile file = (PropertyFile)p;
                return new reportPropertyFile(file);
            }
            if (p instanceof PropertyName) {
                PropertyName name = (PropertyName)p;
                return new reportPropertyName(name);
            }
            if (p instanceof PropertyEventDetails) {
                PropertyEventDetails event = (PropertyEventDetails)p;
                return new reportPropertyEvent(event);
            }
            return new ReportProperty(p);
        }

        @Override
        public int compareTo(ReportProperty that) {
            return this.property.compareTo(that.property);
        }

        public ReportProperty getProperty(String tagPath) {
            if (this.property == null) {
                return null;
            }
            Property subProp = this.property.getPropertyByPath(this.property.getTag() + ":" + tagPath);
            return this.create(subProp);
        }

        public ReportProperty getParent() {
            if (this.property == null) {
                return null;
            }
            return this.create(this.property.getParent());
        }

        public Object get(String tag) {
            return this.getProperty(tag.toUpperCase());
        }

        public ReportProperty[] getProperties(String tagPath) {
            Property[] props = this.property.getProperties(new TagPath(this.property.getTag() + ":" + tagPath));
            if (props.length == 0) {
                return null;
            }
            ReportProperty[] reportProps = new ReportProperty[props.length];
            for (int i = 0; i < props.length; ++i) {
                reportProps[i] = this.create(props[i]);
            }
            return reportProps;
        }

        public String getPath() {
            return this.property.getPath().toString();
        }

        public String getDate() {
            return this.format("{$D}");
        }

        public String getValue() {
            return this.property == null ? "" : this.property.getDisplayValue();
        }

        public String getName() {
            return this.property.format("{$T}", PrivacyPolicy.getDefault().getAllPublic(), true, true);
        }

        public String getTag() {
            return this.property.format("{$t}", PrivacyPolicy.getDefault().getAllPublic(), true, true);
        }

        public String getPlace() {
            return this.format("{$P}");
        }

        public String getAsso(String tagPath) {
            if (this.property == null) {
                return "";
            }
            Property asso = this.property.getPropertyByPath(this.property.getTag() + ":" + tagPath);
            if (asso != null && asso instanceof PropertyAssociation) {
                return ((PropertyAssociation)asso).getDisplayValue();
            }
            return "";
        }

        public ReportProperty[] getSources() {
            if (this.property == null) {
                return null;
            }
            List sources = this.property.getEntity().getProperties(PropertySource.class);
            HashSet<Source> set = new HashSet<Source>();
            for (PropertySource pSource : sources) {
                Object t;
                if (!pSource.getTargetEntity().isPresent() || !((t = pSource.getTargetEntity().get()) instanceof Source)) continue;
                Source source = (Source)t;
                set.add(source);
            }
            List sorted = set.stream().sorted((o1, o2) -> o1.getId().compareTo(o2.getId())).collect(Collectors.toList());
            ArrayList<ReportProperty> list = new ArrayList<ReportProperty>();
            for (Source source : sorted) {
                list.add(this.create((Property)source));
            }
            return (ReportProperty[])list.toArray(ReportProperty[]::new);
        }

        /*
         * WARNING - void declaration
         */
        public ReportProperty[] getAssos() {
            Entity p32;
            if (this.property == null) {
                return null;
            }
            if (this.property.isGrammar7()) {
                List propsList = this.property.getEntity().getProperties(PropertyAssociation.class);
                Fam[] famArray = this.property.getEntity();
                if (famArray instanceof Indi) {
                    Indi indi = (Indi)famArray;
                    for (Fam fam : indi.getFamiliesWhereSpouse(true)) {
                        propsList.addAll(fam.getProperties(PropertyAssociation.class));
                    }
                }
                ReportProperty[] reportProps = new ReportProperty[propsList.size()];
                int i = 0;
                for (Property p2 : propsList) {
                    reportProps[i] = this.create(p2);
                    ++i;
                }
                return reportProps.length > 0 ? reportProps : null;
            }
            ArrayList<PropertyAssociation> propsList = new ArrayList<PropertyAssociation>();
            List xrefList = this.property.getEntity().getProperties(PropertyXRef.class);
            for (Entity p32 : xrefList) {
                PropertyXRef target = p32.getTarget();
                if (!(target instanceof PropertyAssociation)) continue;
                PropertyAssociation propertyAssociation = (PropertyAssociation)target;
                propsList.add(propertyAssociation);
            }
            p32 = this.property.getEntity();
            if (p32 instanceof Indi) {
                void var6_20;
                Indi indi = (Indi)p32;
                p32 = indi.getFamiliesWhereSpouse(true);
                int n = ((Fam[])p32).length;
                boolean bl = false;
                while (var6_20 < n) {
                    Fam fam = p32[var6_20];
                    xrefList = fam.getProperties(PropertyXRef.class);
                    for (PropertyXRef p4 : xrefList) {
                        PropertyXRef target = p4.getTarget();
                        if (!(target instanceof PropertyAssociation)) continue;
                        PropertyAssociation propertyAssociation = (PropertyAssociation)target;
                        propsList.add(propertyAssociation);
                    }
                    ++var6_20;
                }
            }
            ReportProperty[] reportProps = new ReportProperty[propsList.size()];
            int i = 0;
            for (Property property : propsList) {
                reportProps[i] = this.create(property);
                ++i;
            }
            return reportProps.length > 0 ? reportProps : null;
        }

        /*
         * WARNING - void declaration
         */
        public ReportProperty[] getAssoWiths() {
            Entity p32;
            if (this.property == null) {
                return null;
            }
            if (!this.property.isGrammar7()) {
                List propsList = this.property.getEntity().getProperties(PropertyAssociation.class);
                Fam[] famArray = this.property.getEntity();
                if (famArray instanceof Indi) {
                    Indi indi = (Indi)famArray;
                    for (Fam fam : indi.getFamiliesWhereSpouse(true)) {
                        propsList.addAll(fam.getProperties(PropertyAssociation.class));
                    }
                }
                ReportProperty[] reportProps = new ReportProperty[propsList.size()];
                int i = 0;
                for (Property p2 : propsList) {
                    reportProps[i] = this.create(p2);
                    ++i;
                }
                return reportProps.length > 0 ? reportProps : null;
            }
            ArrayList<PropertyAssociation> propsList = new ArrayList<PropertyAssociation>();
            List xrefList = this.property.getEntity().getProperties(PropertyXRef.class);
            for (Entity p32 : xrefList) {
                PropertyXRef target = p32.getTarget();
                if (!(target instanceof PropertyAssociation)) continue;
                PropertyAssociation propertyAssociation = (PropertyAssociation)target;
                propsList.add(propertyAssociation);
            }
            p32 = this.property.getEntity();
            if (p32 instanceof Indi) {
                void var6_20;
                Indi indi = (Indi)p32;
                p32 = indi.getFamiliesWhereSpouse(true);
                int n = ((Fam[])p32).length;
                boolean bl = false;
                while (var6_20 < n) {
                    Fam fam = p32[var6_20];
                    xrefList = fam.getProperties(PropertyXRef.class);
                    for (PropertyXRef p4 : xrefList) {
                        PropertyXRef target = p4.getTarget();
                        if (!(target instanceof PropertyAssociation)) continue;
                        PropertyAssociation propertyAssociation = (PropertyAssociation)target;
                        propsList.add(propertyAssociation);
                    }
                    ++var6_20;
                }
            }
            ReportProperty[] reportProps = new ReportProperty[propsList.size()];
            int i = 0;
            for (Property property : propsList) {
                reportProps[i] = this.create(property);
                ++i;
            }
            return reportProps.length > 0 ? reportProps : null;
        }

        public ReportProperty[] getEvents() {
            if (this.property == null) {
                return null;
            }
            List propsList = this.property.getEntity().getEvents();
            ReportProperty[] reportProps = new ReportProperty[propsList.size()];
            int i = 0;
            for (Property p : propsList) {
                reportProps[i] = this.create(p);
                ++i;
            }
            return reportProps.length > 0 ? reportProps : null;
        }

        public String format(String fmtstr) {
            return this.property == null ? "" : this.property.format(fmtstr);
        }

        public String toString() {
            return this.getValue();
        }
    }

    public class reportPropertyEvent
    extends ReportProperty {
        reportPropertyEvent(PropertyEventDetails p) {
            super((Property)p);
        }

        public String getDescription() {
            return ((PropertyEventDetails)this.property).getDisplayValue();
        }

        public String getType() {
            Property type = this.property.getProperty("TYPE");
            return type != null ? type.getDisplayValue() : "";
        }

        public String getNote() {
            PropertyNote pnote;
            String noteTag = this.property.isGrammar7() ? "SNOTE" : "NOTE";
            Property note = this.property.getProperty(noteTag);
            if (note == null) {
                return "";
            }
            if (note instanceof PropertyNote && (pnote = (PropertyNote)note).getTargetEntity() != null && pnote.getTargetEntity().isPresent()) {
                Note noteEntity = (Note)pnote.getTargetEntity().get();
                return noteEntity.getDisplayValue();
            }
            if (note instanceof PropertySharedNote && (pnote = (PropertySharedNote)note).getTargetEntity() != null && pnote.getTargetEntity().isPresent()) {
                SNote noteEntity = (SNote)pnote.getTargetEntity().get();
                return noteEntity.getDisplayValue();
            }
            return "";
        }

        public ReportProperty getSource() {
            PropertySource psource;
            Property sour = this.property.getProperty("SOUR");
            if (sour == null) {
                return null;
            }
            if (sour instanceof PropertySource && (psource = (PropertySource)sour).getTargetEntity() != null && psource.getTargetEntity().isPresent()) {
                Source sourceEntity = (Source)psource.getTargetEntity().get();
                return this.create((Property)sourceEntity);
            }
            return null;
        }
    }

    public class reportPropertyMedia
    extends ReportProperty {
        reportPropertyMedia(Property p) {
            super(p);
            if (p instanceof PropertyMedia && p.isValid()) {
                this.property = (Property)((PropertyMedia)p).getTargetEntity().get();
            }
        }

        public String getForm() {
            return this.property.getPropertyValue("FORM");
        }

        public String getURL() {
            PropertyFile pFile = (PropertyFile)this.property.getProperty("FILE");
            if (pFile == null) {
                return "";
            }
            Optional oInput = pFile.getInput();
            if (!oInput.isPresent()) {
                return "";
            }
            InputSource input = (InputSource)oInput.get();
            if (input instanceof FileInput) {
                return "file:///" + input.getLocation();
            }
            return input.getLocation();
        }
    }

    public class reportPropertyName
    extends ReportProperty {
        reportPropertyName(PropertyName p) {
            super((Property)p);
        }

        public String getLastName() {
            return ((PropertyName)this.property).getLastName();
        }

        public String getFirstName() {
            return ((PropertyName)this.property).getFirstName();
        }
    }

    public class reportPropertyFile
    extends ReportProperty {
        reportPropertyFile(PropertyFile p) {
            super((Property)p);
        }

        public String getAbsolutePath() {
            try {
                return ((InputSource)((PropertyFile)this.property).getInput().get()).getLocation();
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public class reportPropertyPlace
    extends ReportProperty {
        reportPropertyPlace(PropertyPlace p) {
            super((Property)p);
        }

        public String[] getHierarchy() {
            String hierarchy = ((PropertyPlace)this.property).getFormatAsString();
            return hierarchy.split(",");
        }

        public String getJuridiction(int level) {
            return ((PropertyPlace)this.property).getJurisdiction(level);
        }

        public String getFirstAvailableJurisdiction() {
            return ((PropertyPlace)this.property).getFirstAvailableJurisdiction();
        }

        public String getCity() {
            return ((PropertyPlace)this.property).getCity();
        }

        public String getJuridiction(String f) {
            String[] values = ((PropertyPlace)this.property).getValue().split(",");
            String[] hierarchy = this.getHierarchy();
            for (int i = 0; i < hierarchy.length; ++i) {
                if (!hierarchy[i].trim().equalsIgnoreCase(f.trim())) continue;
                return values[i];
            }
            return null;
        }
    }

    public class reportPropertyXRef
    extends ReportProperty {
        reportPropertyXRef(PropertyXRef p) {
            super((Property)p);
        }

        public reportEntity getTarget() {
            if (this.property == null) {
                return null;
            }
            Entity e = ((PropertyXRef)this.property).getTargetEntity().orElse(null);
            return e == null ? null : (reportEntity)this.create((Property)e);
        }
    }

    public class reportPropertyAge
    extends ReportProperty {
        reportPropertyAge(PropertyAge p) {
            super((Property)p);
        }

        @Override
        public String get(String what) {
            Matcher temp = Pattern.compile("(([0-9]+)y *)?(([0-9]+)m *)?(([0-9]+)d)?").matcher(this.getValue());
            if (temp.matches()) {
                if (what.equals("Years")) {
                    return temp.group(2);
                }
                if (what.equals("Months")) {
                    return temp.group(4);
                }
                if (what.equals("Days")) {
                    return temp.group(6);
                }
                return null;
            }
            return null;
        }
    }

    public class reportEntity
    extends ReportProperty {
        TextOptions OPTIONS;

        reportEntity(Entity e) {
            super((Property)e);
            this.OPTIONS = TextOptions.getInstance();
        }

        public String getId() {
            return ((Entity)this.property).getId();
        }
    }
}

