/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.graphics.GraphicsUtilities;
import org.jdesktop.swingx.mapviewer.Tile;
import org.jdesktop.swingx.mapviewer.TileCache;
import org.jdesktop.swingx.mapviewer.TileFactory;
import org.jdesktop.swingx.mapviewer.TileFactoryInfo;
import org.jdesktop.swingx.mapviewer.util.GeoUtil;

public abstract class AbstractTileFactory
extends TileFactory {
    private static final Logger LOG = Logger.getLogger(AbstractTileFactory.class.getName());
    private int threadPoolSize = 4;
    private ExecutorService service;
    private Map<String, Tile> tileMap = new HashMap<String, Tile>();
    private TileCache cache = new TileCache();
    private static BlockingQueue<Tile> tileQueue = new PriorityBlockingQueue<Tile>(5, new Comparator<Tile>(){

        @Override
        public int compare(Tile o1, Tile o2) {
            if (o1.getPriority() == Tile.Priority.Low && o2.getPriority() == Tile.Priority.High) {
                return 1;
            }
            if (o1.getPriority() == Tile.Priority.High && o2.getPriority() == Tile.Priority.Low) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }
    });

    public AbstractTileFactory(TileFactoryInfo info) {
        super(info);
    }

    public Tile getTile(int x, int y, int zoom) {
        return this.getTile(x, y, zoom, true);
    }

    private Tile getTile(int tpx, int tpy, int zoom, boolean eagerLoad) {
        int tileX = tpx;
        int numTilesWide = (int)this.getMapSize(zoom).getWidth();
        if (tileX < 0) {
            tileX = numTilesWide - Math.abs(tileX) % numTilesWide;
        }
        int tileY = tpy;
        String url = this.getInfo().getTileUrl(tileX %= numTilesWide, tileY, zoom);
        Tile.Priority pri = Tile.Priority.High;
        if (!eagerLoad) {
            pri = Tile.Priority.Low;
        }
        Tile tile = null;
        if (!this.tileMap.containsKey(url)) {
            if (!GeoUtil.isValidTile(tileX, tileY, zoom, this.getInfo())) {
                tile = new Tile(tileX, tileY, zoom);
            } else {
                tile = new Tile(tileX, tileY, zoom, url, pri, this);
                this.startLoading(tile);
            }
            this.tileMap.put(url, tile);
        } else {
            tile = this.tileMap.get(url);
            if (tile.getPriority() == Tile.Priority.Low && eagerLoad && !tile.isLoaded()) {
                this.promote(tile);
            }
        }
        return tile;
    }

    public TileCache getTileCache() {
        return this.cache;
    }

    public void setTileCache(TileCache cache) {
        this.cache = cache;
    }

    protected synchronized ExecutorService getService() {
        if (this.service == null) {
            this.service = Executors.newFixedThreadPool(this.threadPoolSize, new ThreadFactory(){
                private int count = 0;

                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "tile-pool-" + this.count++);
                    t.setPriority(1);
                    t.setDaemon(true);
                    return t;
                }
            });
        }
        return this.service;
    }

    public void setThreadPoolSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("size invalid: " + size + ". The size of the threadpool must be greater than 0.");
        }
        this.threadPoolSize = size;
    }

    protected synchronized void startLoading(Tile tile) {
        if (tile.isLoading()) {
            System.out.println("already loading. bailing");
            return;
        }
        tile.setLoading(true);
        try {
            tileQueue.put(tile);
            this.getService().submit(this.createTileRunner(tile));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected Runnable createTileRunner(Tile tile) {
        return new TileRunner();
    }

    public synchronized void promote(Tile tile) {
        if (tileQueue.contains((Object)tile)) {
            try {
                tileQueue.remove((Object)tile);
                tile.setPriority(Tile.Priority.High);
                tileQueue.put(tile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private class TileRunner
    implements Runnable {
        private TileRunner() {
        }

        protected URI getURI(Tile tile) throws URISyntaxException {
            if (tile.getURL() == null) {
                return null;
            }
            return new URI(tile.getURL());
        }

        public void run() {
            final Tile tile = (Tile)((Object)tileQueue.remove());
            int trys = 3;
            while (!tile.isLoaded() && trys > 0) {
                try {
                    BufferedImage img = null;
                    URI uri = this.getURI(tile);
                    img = AbstractTileFactory.this.cache.get(uri);
                    if (img == null) {
                        byte[] bimg = this.cacheInputStream(uri.toURL());
                        img = GraphicsUtilities.loadCompatibleImage((InputStream)new ByteArrayInputStream(bimg));
                        AbstractTileFactory.this.cache.put(uri, bimg, img);
                        img = AbstractTileFactory.this.cache.get(uri);
                    }
                    if (img == null) {
                        System.out.println("error loading: " + uri);
                        LOG.log(Level.INFO, "Failed to load: " + uri);
                        --trys;
                        continue;
                    }
                    final BufferedImage i = img;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            tile.image = new SoftReference<BufferedImage>(i);
                            tile.setLoaded(true);
                        }
                    });
                }
                catch (OutOfMemoryError memErr) {
                    AbstractTileFactory.this.cache.needMoreMemory();
                }
                catch (Throwable e) {
                    LOG.log(Level.SEVERE, "Failed to load a tile at url: " + tile.getURL() + ", retrying", e);
                    System.err.println("Failed to load a tile at url: " + tile.getURL());
                    e.printStackTrace();
                    Throwable oldError = tile.getError();
                    tile.setError(e);
                    tile.firePropertyChangeOnEDT("loadingError", oldError, e);
                    if (trys == 0) {
                        tile.firePropertyChangeOnEDT("unrecoverableError", null, e);
                        continue;
                    }
                    --trys;
                }
            }
            tile.setLoading(false);
        }

        private byte[] cacheInputStream(URL url) throws IOException {
            int n;
            InputStream ins = url.openStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] buf = new byte[256];
            while ((n = ins.read(buf)) != -1) {
                bout.write(buf, 0, n);
            }
            return bout.toByteArray();
        }
    }
}

