/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.sax;

import com.thaiopensource.relaxng.match.Matcher;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternMatcher;
import com.thaiopensource.relaxng.pattern.ValidatorPatternBuilder;
import com.thaiopensource.relaxng.sax.Context;
import com.thaiopensource.xml.util.Name;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PatternValidator
extends Context
implements ContentHandler,
DTDHandler {
    private Matcher matcher;
    private final ErrorHandler eh;
    private boolean bufferingCharacters = false;
    private final StringBuilder charBuf = new StringBuilder();
    private Locator locator = null;

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.bufferingCharacters) {
            this.bufferingCharacters = false;
            this.check(this.matcher.matchTextBeforeStartTag(this.charBuf.toString(), this));
        }
        Name name = new Name(string, string2);
        this.check(this.matcher.matchStartTagOpen(name, string3, this));
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            Name name2 = new Name(attributes.getURI(i), attributes.getLocalName(i));
            String string4 = attributes.getQName(i);
            this.check(this.matcher.matchAttributeName(name2, string4, this));
            this.check(this.matcher.matchAttributeValue(attributes.getValue(i), name2, string4, this));
        }
        this.check(this.matcher.matchStartTagClose(name, string3, this));
        if (this.matcher.isTextTyped()) {
            this.bufferingCharacters = true;
            this.charBuf.setLength(0);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.bufferingCharacters) {
            this.bufferingCharacters = false;
            if (this.charBuf.length() > 0) {
                this.check(this.matcher.matchTextBeforeEndTag(this.charBuf.toString(), new Name(string, string2), string3, this));
            }
        }
        this.check(this.matcher.matchEndTag(new Name(string, string2), string3, this));
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.bufferingCharacters) {
            this.charBuf.append(cArray, n, n2);
            return;
        }
        block3: for (int i = 0; i < n2; ++i) {
            switch (cArray[n + i]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    this.check(this.matcher.matchUntypedText(this));
                    return;
                }
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.check(this.matcher.matchEndDocument());
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.check(this.matcher.matchStartDocument());
    }

    @Override
    public void processingInstruction(String string, String string2) {
    }

    @Override
    public void skippedEntity(String string) {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.bufferingCharacters) {
            this.bufferingCharacters = false;
            this.check(this.matcher.matchTextBeforeStartTag(this.charBuf.toString(), this));
        }
        super.startPrefixMapping(string, string2);
    }

    public PatternValidator(Pattern pattern, ValidatorPatternBuilder validatorPatternBuilder, ErrorHandler errorHandler) {
        this.matcher = new PatternMatcher(pattern, validatorPatternBuilder);
        this.eh = errorHandler;
    }

    @Override
    public void reset() {
        super.reset();
        this.bufferingCharacters = false;
        this.locator = null;
        this.matcher = this.matcher.start();
    }

    private void check(boolean bl) throws SAXException {
        if (!bl) {
            this.eh.error(new SAXParseException(this.matcher.getErrorMessage(), this.locator));
        }
    }
}

