/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.auto;

import com.thaiopensource.validate.auto.Rewindable;
import java.io.IOException;
import java.io.InputStream;

public class RewindableInputStream
extends InputStream
implements Rewindable {
    private Block head;
    private int curBlockAvail;
    private Block curBlock;
    private int curBlockPos;
    private Block lastBlock;
    private boolean saving = true;
    private final InputStream in;
    private boolean pretendClosed = false;
    private boolean eof;

    public RewindableInputStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.in = inputStream;
    }

    @Override
    public void close() throws IOException {
        if (this.saving) {
            this.curBlockAvail = 0;
            this.curBlock = null;
            this.pretendClosed = true;
        } else {
            this.head = null;
            this.curBlock = null;
            this.lastBlock = null;
            this.saving = false;
            this.curBlockAvail = 0;
            this.in.close();
        }
    }

    @Override
    public void rewind() {
        if (!this.saving) {
            throw new IllegalStateException("rewind() after willNotRewind()");
        }
        this.pretendClosed = false;
        if (this.head == null) {
            return;
        }
        this.curBlock = this.head;
        this.curBlockPos = 0;
        this.curBlockAvail = this.curBlock.used;
    }

    @Override
    public boolean canRewind() {
        return this.saving;
    }

    @Override
    public void willNotRewind() {
        this.saving = false;
        this.head = null;
        this.lastBlock = null;
        if (this.pretendClosed) {
            this.pretendClosed = false;
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public int read() throws IOException {
        if (this.curBlockAvail > 0) {
            int n = this.curBlock.buf[this.curBlockPos++] & 0xFF;
            --this.curBlockAvail;
            if (this.curBlockAvail == 0) {
                this.curBlock = this.curBlock.next;
                if (this.curBlock != null) {
                    this.curBlockPos = 0;
                    this.curBlockAvail = this.curBlock.used;
                }
            }
            return n;
        }
        int n = this.in.read();
        if (this.saving && n != -1) {
            if (this.lastBlock == null) {
                this.lastBlock = this.head = new Block();
            } else if (this.lastBlock.used == this.lastBlock.buf.length) {
                this.lastBlock = this.lastBlock.next = new Block();
            }
            this.lastBlock.append((byte)n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        block16: {
            if (this.curBlockAvail == 0 && !this.saving) {
                return this.in.read(byArray, n, n2);
            }
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            n3 = 0;
            if (this.curBlockAvail != 0) {
                while (true) {
                    if (n2 == 0) {
                        return n3;
                    }
                    byArray[n++] = this.curBlock.buf[this.curBlockPos++];
                    --n2;
                    ++n3;
                    --this.curBlockAvail;
                    if (this.curBlockAvail != 0) continue;
                    this.curBlock = this.curBlock.next;
                    if (this.curBlock == null) break;
                    this.curBlockAvail = this.curBlock.used;
                    this.curBlockPos = 0;
                }
            }
            if (n2 == 0) {
                return n3;
            }
            if (this.eof) {
                return n3 > 0 ? n3 : -1;
            }
            try {
                int n4 = this.in.read(byArray, n, n2);
                if (n4 < 0) {
                    this.eof = true;
                    return n3 > 0 ? n3 : -1;
                }
                n3 += n4;
                if (this.saving) {
                    if (this.lastBlock == null) {
                        this.lastBlock = this.head = new Block(n4);
                    } else if (this.lastBlock.buf.length - this.lastBlock.used < n4) {
                        if (this.lastBlock.used != this.lastBlock.buf.length) {
                            int n5 = this.lastBlock.buf.length - this.lastBlock.used;
                            this.lastBlock.append(byArray, n, n5);
                            n += n5;
                            n4 -= n5;
                        }
                        this.lastBlock = this.lastBlock.next = new Block(n4);
                    }
                    this.lastBlock.append(byArray, n, n4);
                }
            }
            catch (IOException iOException) {
                this.eof = true;
                if (n3 != 0) break block16;
                throw iOException;
            }
        }
        return n3;
    }

    @Override
    public int available() throws IOException {
        if (this.curBlockAvail == 0) {
            return this.in.available();
        }
        int n = this.curBlockAvail;
        Block block = this.curBlock.next;
        while (block != null) {
            n += block.used;
            block = block.next;
        }
        return n + this.in.available();
    }

    static class Block {
        Block next;
        final byte[] buf;
        int used = 0;
        static final int MIN_SIZE = 1024;

        Block(int n) {
            this.buf = new byte[Math.max(1024, n)];
        }

        Block() {
            this(0);
        }

        void append(byte by) {
            this.buf[this.used++] = by;
        }

        void append(byte[] byArray, int n, int n2) {
            System.arraycopy(byArray, n, this.buf, this.used, n2);
            this.used += n2;
        }
    }
}

