/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.options;

import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.feature.FeatureWithLines;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class OptionsFileParser {
    private static final Pattern RERUN_PATH_SPECIFICATION = Pattern.compile("(?m:^| |)(.*?\\.feature(?:(?::\\d+)*))");

    private OptionsFileParser() {
    }

    static Collection<FeatureWithLines> parseFeatureWithLinesFile(Path path) {
        try {
            ArrayList<FeatureWithLines> featurePaths = new ArrayList<FeatureWithLines>();
            Files.readAllLines(path).forEach(line -> {
                Matcher matcher = RERUN_PATH_SPECIFICATION.matcher((CharSequence)line);
                while (matcher.find()) {
                    featurePaths.add(FeatureWithLines.parse(matcher.group(1)));
                }
            });
            return featurePaths;
        }
        catch (Exception e) {
            throw new CucumberException(String.format("Failed to parse '%s'", path), e);
        }
    }
}

