/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.z;

import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntRangeSet;
import net.sf.saxon.z.IntToIntMap;

public class IntRangeToIntMap
implements IntToIntMap {
    private int[] startPoints;
    private int[] endPoints;
    private int[] values;
    private int used;
    private int count = 0;
    private int defaultValue = Integer.MIN_VALUE;

    public IntRangeToIntMap(int capacity) {
        this.startPoints = new int[capacity];
        this.endPoints = new int[capacity];
        this.values = new int[capacity];
        this.used = 0;
        this.count = 0;
    }

    @Override
    public void setDefaultValue(int defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public int getDefaultValue() {
        return this.defaultValue;
    }

    public IntRangeToIntMap(int[] startPoints, int[] endPoints) {
        if (startPoints.length != endPoints.length) {
            throw new IllegalArgumentException("Array lengths differ");
        }
        this.startPoints = startPoints;
        this.endPoints = endPoints;
        this.used = startPoints.length;
        for (int i = 0; i < this.used; ++i) {
            this.count += endPoints[i] - startPoints[i] + 1;
        }
    }

    @Override
    public void clear() {
        this.startPoints = new int[4];
        this.endPoints = new int[4];
        this.values = new int[4];
        this.used = 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean contains(int value) {
        if (this.used == 0) {
            return false;
        }
        if (value > this.endPoints[this.used - 1]) {
            return false;
        }
        if (value < this.startPoints[0]) {
            return false;
        }
        int i = 0;
        int j = this.used;
        do {
            int mid;
            if (this.endPoints[mid = i + (j - i) / 2] < value) {
                i = Math.max(mid, i + 1);
                continue;
            }
            if (this.startPoints[mid] > value) {
                j = Math.min(mid, j - 1);
                continue;
            }
            return true;
        } while (i != j);
        return false;
    }

    @Override
    public int get(int value) {
        if (this.used == 0) {
            return this.getDefaultValue();
        }
        if (value > this.endPoints[this.used - 1]) {
            return this.getDefaultValue();
        }
        if (value < this.startPoints[0]) {
            return this.getDefaultValue();
        }
        int i = 0;
        int j = this.used;
        do {
            int mid;
            if (this.endPoints[mid = i + (j - i) / 2] < value) {
                i = Math.max(mid, i + 1);
                continue;
            }
            if (this.startPoints[mid] > value) {
                j = Math.min(mid, j - 1);
                continue;
            }
            return this.values[mid];
        } while (i != j);
        return this.getDefaultValue();
    }

    @Override
    public boolean remove(int value) {
        throw new UnsupportedOperationException("remove");
    }

    public void addEntry(int start, int end, int value) {
        this.ensureCapacity(this.used + 1);
        this.startPoints[this.used] = start;
        this.endPoints[this.used] = end;
        this.values[this.used] = value;
        ++this.used;
        this.count += end - start + 1;
    }

    private void ensureCapacity(int n) {
        if (this.startPoints.length < n) {
            int[] s = new int[this.startPoints.length * 2];
            int[] e = new int[this.startPoints.length * 2];
            int[] v = new int[this.startPoints.length * 2];
            System.arraycopy(this.startPoints, 0, s, 0, this.used);
            System.arraycopy(this.endPoints, 0, e, 0, this.used);
            System.arraycopy(this.values, 0, v, 0, this.used);
            this.startPoints = s;
            this.endPoints = e;
            this.values = v;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.used * 8);
        for (int i = 0; i < this.used; ++i) {
            sb.append(this.startPoints[i]).append("-").append(this.endPoints[i]).append(":").append(this.values[i]).append(",");
        }
        return sb.toString();
    }

    public int[] getStartPoints() {
        return this.startPoints;
    }

    public int[] getEndPoints() {
        return this.endPoints;
    }

    public int getNumberOfRanges() {
        return this.used;
    }

    @Override
    public void put(int key, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntIterator keyIterator() {
        IntRangeSet irs = new IntRangeSet(this.startPoints, this.endPoints);
        return irs.iterator();
    }
}

