/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Group {
    private final List<Group> children;
    private final Long start;
    private final String value;

    public Group(List<Group> children, Long start, String value) {
        this.children = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(children, "Group.children cannot be null")));
        this.start = start;
        this.value = value;
    }

    public List<Group> getChildren() {
        return this.children;
    }

    public Optional<Long> getStart() {
        return Optional.ofNullable(this.start);
    }

    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Group that = (Group)o;
        return this.children.equals(that.children) && Objects.equals(this.start, that.start) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.children, this.start, this.value);
    }

    public String toString() {
        return "Group{children=" + this.children + ", start=" + this.start + ", value=" + this.value + '}';
    }
}

