# coding=UTF-8

"""Define an exhaustive list of countries and administrative regions.

This data was provided by geonames.org and is licensed
under the Creative Commons Attribution 3.0 License,
see http://creativecommons.org/licenses/by/3.0/

The data is provided "as is" without warranty or any
representation of accuracy, timeliness or completeness.

The data was then converted from tab-delimited UTF8 into
python source code by Robert Park <robru@gottengeography.ca>

>>> one = set(key.split('.')[0] for key in territories)
>>> two = set(countries)
>>> len(one - two) is 0      # No provinces that don't belong to a country.
True
>>> len(two - one) > 1       # Some countries don't have provinces/states.
True
"""

from os import listdir
from os.path import sep, join, isdir

countries = {
"AD": "Andorra",
"AE": "United Arab Emirates",
"AF": "Afghanistan",
"AG": "Antigua and Barbuda",
"AI": "Anguilla",
"AL": "Albania",
"AM": "Armenia",
"AO": "Angola",
"AQ": "Antarctica",
"AR": "Argentina",
"AS": "American Samoa",
"AT": "Austria",
"AU": "Australia",
"AW": "Aruba",
"AX": "Aland Islands",
"AZ": "Azerbaijan",
"BA": "Bosnia and Herzegovina",
"BB": "Barbados",
"BD": "Bangladesh",
"BE": "Belgium",
"BF": "Burkina Faso",
"BG": "Bulgaria",
"BH": "Bahrain",
"BI": "Burundi",
"BJ": "Benin",
"BL": "Saint Barthelemy",
"BM": "Bermuda",
"BN": "Brunei",
"BO": "Bolivia",
"BQ": "Bonaire, Saint Eustatius and Saba ",
"BR": "Brazil",
"BS": "Bahamas",
"BT": "Bhutan",
"BV": "Bouvet Island",
"BW": "Botswana",
"BY": "Belarus",
"BZ": "Belize",
"CA": "Canada",
"CC": "Cocos Islands",
"CD": "Democratic Republic of the Congo",
"CF": "Central African Republic",
"CG": "Republic of the Congo",
"CH": "Switzerland",
"CI": "Ivory Coast",
"CK": "Cook Islands",
"CL": "Chile",
"CM": "Cameroon",
"CN": "China",
"CO": "Colombia",
"CR": "Costa Rica",
"CU": "Cuba",
"CV": "Cape Verde",
"CW": "Curacao",
"CX": "Christmas Island",
"CY": "Cyprus",
"CZ": "Czechia",
"DE": "Germany",
"DJ": "Djibouti",
"DK": "Denmark",
"DM": "Dominica",
"DO": "Dominican Republic",
"DZ": "Algeria",
"EC": "Ecuador",
"EE": "Estonia",
"EG": "Egypt",
"EH": "Western Sahara",
"ER": "Eritrea",
"ES": "Spain",
"ET": "Ethiopia",
"FI": "Finland",
"FJ": "Fiji",
"FK": "Falkland Islands",
"FM": "Micronesia",
"FO": "Faroe Islands",
"FR": "France",
"GA": "Gabon",
"GB": "United Kingdom",
"GD": "Grenada",
"GE": "Georgia",
"GF": "French Guiana",
"GG": "Guernsey",
"GH": "Ghana",
"GI": "Gibraltar",
"GL": "Greenland",
"GM": "Gambia",
"GN": "Guinea",
"GP": "Guadeloupe",
"GQ": "Equatorial Guinea",
"GR": "Greece",
"GS": "South Georgia and the South Sandwich Islands",
"GT": "Guatemala",
"GU": "Guam",
"GW": "Guinea-Bissau",
"GY": "Guyana",
"HK": "Hong Kong",
"HM": "Heard Island and McDonald Islands",
"HN": "Honduras",
"HR": "Croatia",
"HT": "Haiti",
"HU": "Hungary",
"ID": "Indonesia",
"IE": "Ireland",
"IL": "Israel",
"IM": "Isle of Man",
"IN": "India",
"IO": "British Indian Ocean Territory",
"IQ": "Iraq",
"IR": "Iran",
"IS": "Iceland",
"IT": "Italy",
"JE": "Jersey",
"JM": "Jamaica",
"JO": "Jordan",
"JP": "Japan",
"KE": "Kenya",
"KG": "Kyrgyzstan",
"KH": "Cambodia",
"KI": "Kiribati",
"KM": "Comoros",
"KN": "Saint Kitts and Nevis",
"KP": "North Korea",
"KR": "South Korea",
"XK": "Kosovo",
"KW": "Kuwait",
"KY": "Cayman Islands",
"KZ": "Kazakhstan",
"LA": "Laos",
"LB": "Lebanon",
"LC": "Saint Lucia",
"LI": "Liechtenstein",
"LK": "Sri Lanka",
"LR": "Liberia",
"LS": "Lesotho",
"LT": "Lithuania",
"LU": "Luxembourg",
"LV": "Latvia",
"LY": "Libya",
"MA": "Morocco",
"MC": "Monaco",
"MD": "Moldova",
"ME": "Montenegro",
"MF": "Saint Martin",
"MG": "Madagascar",
"MH": "Marshall Islands",
"MK": "Macedonia",
"ML": "Mali",
"MM": "Myanmar",
"MN": "Mongolia",
"MO": "Macao",
"MP": "Northern Mariana Islands",
"MQ": "Martinique",
"MR": "Mauritania",
"MS": "Montserrat",
"MT": "Malta",
"MU": "Mauritius",
"MV": "Maldives",
"MW": "Malawi",
"MX": "Mexico",
"MY": "Malaysia",
"MZ": "Mozambique",
"NA": "Namibia",
"NC": "New Caledonia",
"NE": "Niger",
"NF": "Norfolk Island",
"NG": "Nigeria",
"NI": "Nicaragua",
"NL": "Netherlands",
"NO": "Norway",
"NP": "Nepal",
"NR": "Nauru",
"NU": "Niue",
"NZ": "New Zealand",
"OM": "Oman",
"PA": "Panama",
"PE": "Peru",
"PF": "French Polynesia",
"PG": "Papua New Guinea",
"PH": "Philippines",
"PK": "Pakistan",
"PL": "Poland",
"PM": "Saint Pierre and Miquelon",
"PN": "Pitcairn",
"PR": "Puerto Rico",
"PS": "Palestinian Territory",
"PT": "Portugal",
"PW": "Palau",
"PY": "Paraguay",
"QA": "Qatar",
"RE": "Reunion",
"RO": "Romania",
"RS": "Serbia",
"RU": "Russia",
"RW": "Rwanda",
"SA": "Saudi Arabia",
"SB": "Solomon Islands",
"SC": "Seychelles",
"SD": "Sudan",
"SS": "South Sudan",
"SE": "Sweden",
"SG": "Singapore",
"SH": "Saint Helena",
"SI": "Slovenia",
"SJ": "Svalbard and Jan Mayen",
"SK": "Slovakia",
"SL": "Sierra Leone",
"SM": "San Marino",
"SN": "Senegal",
"SO": "Somalia",
"SR": "Suriname",
"ST": "Sao Tome and Principe",
"SV": "El Salvador",
"SX": "Sint Maarten",
"SY": "Syria",
"SZ": "Swaziland",
"TC": "Turks and Caicos Islands",
"TD": "Chad",
"TF": "French Southern Territories",
"TG": "Togo",
"TH": "Thailand",
"TJ": "Tajikistan",
"TK": "Tokelau",
"TL": "East Timor",
"TM": "Turkmenistan",
"TN": "Tunisia",
"TO": "Tonga",
"TR": "Turkey",
"TT": "Trinidad and Tobago",
"TV": "Tuvalu",
"TW": "Taiwan",
"TZ": "Tanzania",
"UA": "Ukraine",
"UG": "Uganda",
"UM": "United States Minor Outlying Islands",
"US": "United States",
"UY": "Uruguay",
"UZ": "Uzbekistan",
"VA": "Vatican",
"VC": "Saint Vincent and the Grenadines",
"VE": "Venezuela",
"VG": "British Virgin Islands",
"VI": "U.S. Virgin Islands",
"VN": "Vietnam",
"VU": "Vanuatu",
"WF": "Wallis and Futuna",
"WS": "Samoa",
"YE": "Yemen",
"YT": "Mayotte",
"ZA": "South Africa",
"ZM": "Zambia",
"ZW": "Zimbabwe",
"CS": "Serbia and Montenegro",
"AN": "Netherlands Antilles",
}

territories = {
"AD.06": "Sant Julià de Loria",
"AD.05": "Ordino",
"AD.04": "La Massana",
"AD.03": "Encamp",
"AD.02": "Canillo",
"AD.07": "Andorra la Vella",
"AD.08": "Escaldes-Engordany",
"AE.07": "Umm al Qaywayn",
"AE.05": "Raʼs al Khaymah",
"AE.03": "Dubai",
"AE.06": "Ash Shāriqah",
"AE.04": "Al Fujayrah",
"AE.02": "Ajman",
"AE.01": "Abu Dhabi",
"AF.28": "Zabul",
"AF.27": "Vardak",
"AF.26": "Takhar",
"AF.33": "Sar-e Pol",
"AF.32": "Samangan",
"AF.40": "Parwan",
"AF.29": "Paktika",
"AF.36": "Paktia",
"AF.39": "Oruzgan",
"AF.19": "Nimroz",
"AF.18": "Nangarhar",
"AF.17": "Logar",
"AF.35": "Laghman",
"AF.24": "Kunduz",
"AF.34": "Kunar",
"AF.14": "Kapisa",
"AF.23": "Kandahar",
"AF.13": "Kabul",
"AF.31": "Jowzjan",
"AF.11": "Herat",
"AF.10": "Helmand",
"AF.09": "Ghowr",
"AF.08": "Ghazni",
"AF.07": "Faryab",
"AF.06": "Farah",
"AF.05": "Bamyan",
"AF.30": "Balkh",
"AF.03": "Baghlan",
"AF.02": "Badghis",
"AF.01": "Badakhshan",
"AF.37": "Khowst",
"AF.38": "Nuristan",
"AF.41": "Daykundi",
"AF.42": "Panjshir",
"AG.08": "Saint Philip",
"AG.07": "Saint Peter",
"AG.06": "Saint Paul",
"AG.05": "Saint Mary",
"AG.04": "Saint John",
"AG.03": "Saint George",
"AG.09": "Redonda",
"AG.01": "Barbuda",
"AI.11205389": "Blowing Point",
"AI.11205392": "Sandy Ground",
"AI.11205393": "Sandy Hill",
"AI.11205396": "The Valley",
"AI.11205433": "East End",
"AI.11205436": "North Hill",
"AI.11205437": "West End",
"AI.11205438": "South Hill",
"AI.11205439": "The Quarter",
"AI.11205440": "North Side",
"AI.11205441": "Island Harbour",
"AI.11205442": "George Hill",
"AI.11205443": "Stoney Ground",
"AI.11205444": "The Farrington",
"AL.40": "Berat",
"AL.41": "Dibër",
"AL.43": "Elbasan",
"AL.45": "Gjirokastër",
"AL.46": "Korçë",
"AL.47": "Kukës",
"AL.42": "Durrës",
"AL.44": "Fier",
"AL.48": "Lezhë",
"AL.49": "Shkodër",
"AL.50": "Tiranë",
"AL.51": "Vlorë",
"AM.02": "Ararat",
"AM.08": "Syunik",
"AM.10": "Vayots Dzor",
"AM.11": "Yerevan",
"AM.01": "Aragatsotn",
"AM.03": "Armavir",
"AM.04": "Gegharkunik",
"AM.05": "Kotayk",
"AM.06": "Lori",
"AM.07": "Shirak",
"AM.09": "Tavush",
"AO.18": "Lunda Sul",
"AO.17": "Luanda Norte",
"AO.14": "Moxico",
"AO.04": "Cuando Cobango",
"AO.16": "Zaire",
"AO.15": "Uíge",
"AO.12": "Malanje",
"AO.20": "Luanda",
"AO.05": "Cuanza Norte",
"AO.03": "Cabinda",
"AO.19": "Bengo",
"AO.13": "Namibe",
"AO.09": "Huíla",
"AO.08": "Huambo",
"AO.07": "Cunene",
"AO.06": "Kwanza Sul",
"AO.02": "Bíe",
"AO.01": "Benguela",
"AR.14": "Misiones",
"AR.09": "Formosa",
"AR.07": "Buenos Aires F.D.",
"AR.08": "Entre Rios",
"AR.06": "Corrientes",
"AR.01": "Buenos Aires",
"AR.24": "Tucuman",
"AR.23": "Tierra del Fuego",
"AR.22": "Santiago del Estero",
"AR.21": "Santa Fe",
"AR.20": "Santa Cruz",
"AR.19": "San Luis",
"AR.18": "San Juan",
"AR.17": "Salta",
"AR.16": "Rio Negro",
"AR.15": "Neuquen",
"AR.13": "Mendoza",
"AR.12": "La Rioja",
"AR.11": "La Pampa",
"AR.10": "Jujuy",
"AR.05": "Cordoba",
"AR.04": "Chubut",
"AR.03": "Chaco",
"AR.02": "Catamarca",
"AS.050": "Western District",
"AS.040": "Swains Island",
"AS.010": "Eastern District",
"AS.020": "Manu'a",
"AS.030": "Rose Island",
"AT.09": "Vienna",
"AT.08": "Vorarlberg",
"AT.07": "Tyrol",
"AT.06": "Styria",
"AT.05": "Salzburg",
"AT.04": "Upper Austria",
"AT.03": "Lower Austria",
"AT.02": "Carinthia",
"AT.01": "Burgenland",
"AU.08": "Western Australia",
"AU.05": "South Australia",
"AU.03": "Northern Territory",
"AU.07": "Victoria",
"AU.06": "Tasmania",
"AU.04": "Queensland",
"AU.02": "New South Wales",
"AU.01": "ACT",
"AX.211": "Mariehamns stad",
"AX.212": "Ålands landsbygd",
"AX.213": "Ålands skärgård",
"AZ.12": "Beyləqan",
"AZ.69": "Zǝngilan",
"AZ.66": "Yardımlı",
"AZ.55": "Şuşa",
"AZ.49": "Salyan",
"AZ.46": "Sabirabad",
"AZ.45": "Saatlı",
"AZ.13": "Bilǝsuvar",
"AZ.36": "Neftçala",
"AZ.35": "Nakhichevan",
"AZ.32": "Masally",
"AZ.31": "Lerik",
"AZ.29": "Lənkəran",
"AZ.28": "Laçın",
"AZ.43": "Qubadlı",
"AZ.24": "İmişli",
"AZ.18": "Füzuli",
"AZ.14": "Jabrayil",
"AZ.15": "Jalilabad",
"AZ.08": "Astara",
"AZ.64": "Xocalı",
"AZ.02": "Ağcabǝdi",
"AZ.03": "Ağdam",
"AZ.07": "Shirvan",
"AZ.30": "Lankaran Sahari",
"AZ.56": "Şuşa Şəhəri",
"AZ.57": "Tǝrtǝr",
"AZ.61": "Xankǝndi",
"AZ.65": "Khojavend",
"AZ.71": "Zərdab",
"AZ.70": "Zaqatala",
"AZ.67": "Yevlax",
"AZ.37": "Oğuz",
"AZ.59": "Ucar",
"AZ.58": "Tovuz",
"AZ.50": "Şamaxı",
"AZ.47": "Şǝki",
"AZ.51": "Şǝmkir",
"AZ.27": "Kürdǝmir",
"AZ.38": "Qǝbǝlǝ",
"AZ.44": "Qusar",
"AZ.42": "Quba",
"AZ.62": "Goygol Rayon",
"AZ.60": "Xaçmaz",
"AZ.26": "Kalbajar",
"AZ.40": "Qazax",
"AZ.21": "Goranboy",
"AZ.39": "Qǝx",
"AZ.25": "İsmayıllı",
"AZ.22": "Göyçay",
"AZ.17": "Shabran",
"AZ.16": "Daşkǝsǝn",
"AZ.10": "Balakǝn",
"AZ.11": "Bǝrdǝ",
"AZ.09": "Baki",
"AZ.01": "Abşeron",
"AZ.06": "Ağsu",
"AZ.04": "Ağdaş",
"AZ.19": "Gǝdǝbǝy",
"AZ.05": "Ağstafa",
"AZ.20": "Gǝncǝ",
"AZ.33": "Mingǝcevir",
"AZ.34": "Naftalan",
"AZ.41": "Qobustan",
"AZ.52": "Samux",
"AZ.48": "Shaki City",
"AZ.53": "Siyǝzǝn",
"AZ.54": "Sumqayit",
"AZ.63": "Xızı",
"AZ.68": "Yevlax City",
"AZ.23": "Hacıqabul",
"AZ.75": "Nakhchivan",
"BA.01": "Federation of B&H",
"BA.02": "Srspka",
"BA.BRC": "Brčko",
"BB.11": "Saint Thomas",
"BB.10": "Saint Philip",
"BB.09": "Saint Peter",
"BB.08": "Saint Michael",
"BB.07": "Saint Lucy",
"BB.06": "Saint Joseph",
"BB.05": "Saint John",
"BB.04": "Saint James",
"BB.03": "Saint George",
"BB.02": "Saint Andrew",
"BB.01": "Christ Church",
"BD.83": "Rājshāhi",
"BD.81": "Dhaka",
"BD.84": "Chittagong",
"BD.82": "Khulna",
"BD.85": "Barisāl",
"BD.86": "Sylhet",
"BD.87": "Rangpur Division",
"BD.H": "Mymensingh Division",
"BE.BRU": "Brussels Capital",
"BE.WAL": "Wallonia",
"BE.VLG": "Flanders",
"BF.01": "Boucle du Mouhoun",
"BF.02": "Cascades",
"BF.03": "Centre",
"BF.04": "Centre-Est",
"BF.05": "Centre-Nord",
"BF.06": "Centre-Ouest",
"BF.07": "Centre-Sud",
"BF.08": "Est",
"BF.09": "Hauts-Bassins",
"BF.10": "Nord",
"BF.11": "Plateau-Central",
"BF.12": "Sahel",
"BF.13": "Sud-Ouest",
"BG.52": "Razgrad",
"BG.47": "Montana",
"BG.64": "Vratsa",
"BG.61": "Varna",
"BG.40": "Dobrich",
"BG.58": "Sofia",
"BG.53": "Ruse",
"BG.51": "Plovdiv",
"BG.50": "Pleven",
"BG.49": "Pernik",
"BG.48": "Pazardzhik",
"BG.46": "Lovech",
"BG.43": "Khaskovo",
"BG.42": "Sofia-Capital",
"BG.39": "Burgas",
"BG.38": "Blagoevgrad",
"BG.41": "Gabrovo",
"BG.44": "Kŭrdzhali",
"BG.45": "Kyustendil",
"BG.54": "Shumen",
"BG.55": "Silistra",
"BG.56": "Sliven",
"BG.57": "Smolyan",
"BG.59": "Stara Zagora",
"BG.60": "Tŭrgovishte",
"BG.62": "Veliko Tŭrnovo",
"BG.63": "Vidin",
"BG.65": "Yambol",
"BH.15": "Muharraq",
"BH.16": "Manama",
"BH.17": "Southern Governorate",
"BH.19": "Northern",
"BI.17": "Makamba",
"BI.10": "Bururi",
"BI.22": "Muramvya",
"BI.13": "Gitega",
"BI.21": "Ruyigi",
"BI.11": "Cankuzo",
"BI.14": "Karuzi",
"BI.09": "Bubanza",
"BI.12": "Cibitoke",
"BI.19": "Ngozi",
"BI.15": "Kayanza",
"BI.18": "Muyinga",
"BI.16": "Kirundo",
"BI.20": "Rutana",
"BI.23": "Mwaro",
"BI.24": "Bujumbura Mairie",
"BI.25": "Bujumbura Rural",
"BI.26": "Rumonge",
"BJ.18": "Zou",
"BJ.16": "Ouémé",
"BJ.15": "Mono",
"BJ.10": "Borgou",
"BJ.09": "Atlantique",
"BJ.08": "Atakora",
"BJ.07": "Alibori",
"BJ.11": "Collines",
"BJ.12": "Kouffo",
"BJ.13": "Donga",
"BJ.14": "Littoral",
"BJ.17": "Plateau",
"BM.11": "Warwick",
"BM.10": "Southampton",
"BM.09": "Smithʼs",
"BM.08": "Sandys",
"BM.07": "Saint Georgeʼs",
"BM.06": "Saint George",
"BM.05": "Pembroke",
"BM.04": "Paget",
"BM.02": "Hamilton",
"BM.03": "Hamilton city",
"BM.01": "Devonshire",
"BN.04": "Tutong",
"BN.03": "Temburong",
"BN.02": "Brunei and Muara",
"BN.01": "Belait",
"BO.09": "Tarija",
"BO.08": "Santa Cruz",
"BO.07": "Potosí",
"BO.06": "Pando",
"BO.05": "Oruro",
"BO.04": "La Paz",
"BO.02": "Cochabamba",
"BO.01": "Chuquisaca",
"BO.03": "El Beni",
"BQ.BO": "Bonaire",
"BQ.SB": "Saba",
"BQ.SE": "Sint Eustatius",
"BR.22": "Rio Grande do Norte",
"BR.20": "Piauí",
"BR.30": "Pernambuco",
"BR.17": "Paraíba",
"BR.16": "Pará",
"BR.13": "Maranhão",
"BR.06": "Ceará",
"BR.03": "Amapá",
"BR.02": "Alagoas",
"BR.28": "Sergipe",
"BR.27": "São Paulo",
"BR.26": "Santa Catarina",
"BR.23": "Rio Grande do Sul",
"BR.21": "Rio de Janeiro",
"BR.18": "Paraná",
"BR.15": "Minas Gerais",
"BR.11": "Mato Grosso do Sul",
"BR.14": "Mato Grosso",
"BR.29": "Goiás",
"BR.07": "Federal District",
"BR.08": "Espírito Santo",
"BR.05": "Bahia",
"BR.31": "Tocantins",
"BR.25": "Roraima",
"BR.04": "Amazonas",
"BR.01": "Acre",
"BR.24": "Rondônia",
"BS.35": "San Salvador",
"BS.18": "Ragged Island",
"BS.32": "Berry Islands",
"BS.23": "New Providence",
"BS.16": "Mayaguana",
"BS.15": "Long Island",
"BS.13": "Inagua",
"BS.22": "Harbour Island",
"BS.25": "Freeport",
"BS.10": "Exuma",
"BS.06": "Cat Island",
"BS.05": "Bimini",
"BS.24": "Acklins",
"BS.36": "Black Point",
"BS.37": "Central Abaco",
"BS.38": "Central Andros",
"BS.39": "Central Eleuthera",
"BS.40": "Crooked Island and Long Cay",
"BS.41": "East Grand Bahama",
"BS.42": "Grand Cay",
"BS.43": "Hope Town",
"BS.44": "Mangrove Cay",
"BS.45": "Moore’s Island",
"BS.46": "North Abaco",
"BS.47": "North Andros",
"BS.48": "North Eleuthera",
"BS.49": "Rum Cay",
"BS.50": "South Abaco",
"BS.51": "South Andros",
"BS.52": "South Eleuthera",
"BS.53": "Spanish Wells",
"BS.54": "West Grand Bahama",
"BT.05": "Bumthang",
"BT.06": "Chukha",
"BT.08": "Dagana",
"BT.07": "Chirang",
"BT.09": "Geylegphug",
"BT.10": "Haa",
"BT.11": "Lhuntse",
"BT.12": "Mongar",
"BT.13": "Paro",
"BT.14": "Pemagatshel",
"BT.15": "Punakha",
"BT.16": "Samchi",
"BT.17": "Samdrup Jongkhar",
"BT.18": "Shemgang",
"BT.19": "Tashigang",
"BT.20": "Thimphu",
"BT.21": "Tongsa",
"BT.22": "Wangdi Phodrang",
"BT.23": "Gasa",
"BT.24": "Trashi Yangste",
"BW.10": "Ngwaketsi",
"BW.09": "South-East",
"BW.08": "North-East",
"BW.11": "North-West",
"BW.06": "Kweneng",
"BW.05": "Kgatleng",
"BW.04": "Kgalagadi",
"BW.03": "Ghanzi",
"BW.01": "Central",
"BY.07": "Vitebsk",
"BY.06": "Mogilev",
"BY.05": "Minsk",
"BY.04": "Minsk City",
"BY.03": "Grodnenskaya",
"BY.02": "Gomel",
"BY.01": "Brest",
"BZ.06": "Toledo",
"BZ.05": "Stann Creek",
"BZ.04": "Orange Walk",
"BZ.03": "Corozal",
"BZ.02": "Cayo",
"BZ.01": "Belize",
"CA.01": "Alberta",
"CA.02": "British Columbia",
"CA.03": "Manitoba",
"CA.04": "New Brunswick",
"CA.13": "Northwest Territories",
"CA.07": "Nova Scotia",
"CA.14": "Nunavut",
"CA.08": "Ontario",
"CA.09": "Prince Edward Island",
"CA.10": "Quebec",
"CA.11": "Saskatchewan",
"CA.12": "Yukon",
"CA.05": "Newfoundland and Labrador",
"CD.31": "Tshuapa",
"CD.30": "Tshopo",
"CD.29": "Tanganika",
"CD.12": "South Kivu",
"CD.27": "Sankuru",
"CD.11": "Nord Kivu",
"CD.25": "Mongala",
"CD.10": "Maniema",
"CD.23": "Kasaï-Central",
"CD.04": "Kasaï-Oriental",
"CD.18": "Kasai",
"CD.17": "Ituri",
"CD.16": "Haut Uele",
"CD.15": "Haut-Lomani",
"CD.02": "Équateur",
"CD.13": "Bas Uele",
"CD.22": "Lualaba",
"CD.24": "Mai Ndombe",
"CD.20": "Kwilu",
"CD.19": "Kwango",
"CD.06": "Kinshasa",
"CD.08": "Bas-Congo",
"CD.14": "Haut-Katanga",
"CD.21": "Lomami",
"CD.26": "Nord-Ubangi",
"CD.28": "Sud-Ubangi",
"CF.14": "Vakaga",
"CF.11": "Ouaka",
"CF.08": "Mbomou",
"CF.05": "Haut-Mbomou",
"CF.03": "Haute-Kotto",
"CF.02": "Basse-Kotto",
"CF.01": "Bamingui-Bangoran",
"CF.16": "Sangha-Mbaéré",
"CF.13": "Ouham-Pendé",
"CF.12": "Ouham",
"CF.17": "Ombella-M'Poko",
"CF.09": "Nana-Mambéré",
"CF.07": "Lobaye",
"CF.06": "Kémo",
"CF.04": "Mambéré-Kadéï",
"CF.15": "Nana-Grébizi",
"CF.18": "Bangui",
"CG.10": "Sangha",
"CG.11": "Pool",
"CG.08": "Plateaux",
"CG.07": "Niari",
"CG.06": "Likouala",
"CG.05": "Lékoumou",
"CG.04": "Kouilou",
"CG.13": "Cuvette",
"CG.01": "Bouenza",
"CG.12": "Brazzaville",
"CG.14": "Cuvette-Ouest",
"CG.7280295": "Pointe-Noire",
"CH.ZH": "Zurich",
"CH.ZG": "Zug",
"CH.VD": "Vaud",
"CH.VS": "Valais",
"CH.UR": "Uri",
"CH.TI": "Ticino",
"CH.TG": "Thurgau",
"CH.SO": "Solothurn",
"CH.SZ": "Schwyz",
"CH.SH": "Schaffhausen",
"CH.SG": "Saint Gallen",
"CH.OW": "Obwalden",
"CH.NW": "Nidwalden",
"CH.NE": "Neuchâtel",
"CH.LU": "Lucerne",
"CH.JU": "Jura",
"CH.GR": "Grisons",
"CH.GL": "Glarus",
"CH.GE": "Geneva",
"CH.FR": "Fribourg",
"CH.BE": "Bern",
"CH.BS": "Basel-City",
"CH.BL": "Basel-Landschaft",
"CH.AR": "Appenzell Ausserrhoden",
"CH.AI": "Appenzell Innerrhoden",
"CH.AG": "Aargau",
"CI.98": "Yamoussoukro Autonomous District",
"CI.76": "Bas-Sassandra",
"CI.94": "Comoé",
"CI.77": "Denguélé",
"CI.95": "Gôh-Djiboua",
"CI.81": "Lacs",
"CI.82": "Lagunes",
"CI.78": "Montagnes",
"CI.96": "Sassandra-Marahoué",
"CI.87": "Savanes",
"CI.90": "Vallée du Bandama",
"CI.97": "Woroba",
"CI.92": "Zanzan",
"CI.93": "Abidjan",
"CL.01": "Valparaíso",
"CL.15": "Tarapacá",
"CL.12": "Santiago Metropolitan",
"CL.11": "Maule",
"CL.14": "Los Lagos",
"CL.08": "O'Higgins",
"CL.07": "Coquimbo",
"CL.06": "Biobío",
"CL.05": "Atacama",
"CL.04": "Araucanía",
"CL.03": "Antofagasta",
"CL.02": "Aisén",
"CL.10": "Magallanes",
"CL.16": "Arica y Parinacota",
"CL.17": "Los Ríos",
"CM.09": "South-West",
"CM.14": "South",
"CM.08": "West",
"CM.07": "North-West",
"CM.13": "North",
"CM.05": "Littoral",
"CM.12": "Far North",
"CM.04": "East",
"CM.11": "Centre",
"CM.10": "Adamaoua",
"CN.14": "Tibet",
"CN.06": "Qinghai",
"CN.13": "Xinjiang",
"CN.02": "Zhejiang",
"CN.29": "Yunnan",
"CN.28": "Tianjin",
"CN.32": "Sichuan",
"CN.24": "Shanxi",
"CN.23": "Shanghai",
"CN.25": "Shandong",
"CN.26": "Shaanxi",
"CN.21": "Ningsia Hui Autonomous Region",
"CN.03": "Jiangxi",
"CN.04": "Jiangsu",
"CN.11": "Hunan",
"CN.12": "Hubei",
"CN.09": "Henan",
"CN.10": "Hebei",
"CN.31": "Hainan",
"CN.18": "Guizhou",
"CN.16": "Guangxi",
"CN.30": "Guangdong",
"CN.15": "Gansu",
"CN.07": "Fujian",
"CN.33": "Chongqing",
"CN.01": "Anhui",
"CN.20": "Inner Mongolia",
"CN.19": "Liaoning",
"CN.05": "Jilin",
"CN.08": "Heilongjiang",
"CN.22": "Beijing",
"CO.31": "Vichada",
"CO.30": "Vaupés",
"CO.29": "Valle del Cauca",
"CO.28": "Tolima",
"CO.27": "Sucre",
"CO.26": "Santander",
"CO.25": "San Andres y Providencia",
"CO.24": "Risaralda",
"CO.23": "Quindío",
"CO.22": "Putumayo",
"CO.21": "Norte de Santander",
"CO.20": "Nariño",
"CO.19": "Meta",
"CO.38": "Magdalena",
"CO.17": "La Guajira",
"CO.16": "Huila",
"CO.14": "Guaviare",
"CO.15": "Guainía",
"CO.33": "Cundinamarca",
"CO.12": "Córdoba",
"CO.11": "Chocó",
"CO.10": "Cesar",
"CO.09": "Cauca",
"CO.32": "Casanare",
"CO.08": "Caquetá",
"CO.37": "Caldas",
"CO.36": "Boyacá",
"CO.35": "Bolívar",
"CO.34": "Bogota D.C.",
"CO.04": "Atlántico",
"CO.03": "Arauca",
"CO.02": "Antioquia",
"CO.01": "Amazonas",
"CR.08": "San José",
"CR.07": "Puntarenas",
"CR.06": "Limón",
"CR.04": "Heredia",
"CR.03": "Guanacaste",
"CR.02": "Cartago",
"CR.01": "Alajuela",
"CU.16": "Villa Clara",
"CU.15": "Santiago de Cuba",
"CU.14": "Sancti Spíritus",
"CU.01": "Pinar del Río",
"CU.03": "Matanzas",
"CU.13": "Las Tunas",
"CU.04": "Isla de la Juventud",
"CU.12": "Holguín",
"CU.10": "Guantánamo",
"CU.09": "Granma",
"CU.02": "La Habana",
"CU.08": "Cienfuegos",
"CU.07": "Ciego de Ávila",
"CU.05": "Camagüey",
"CU.AR": "Artemisa",
"CU.MA": "Mayabeque",
"CV.20": "Tarrafal",
"CV.11": "São Vicente",
"CV.15": "Santa Catarina",
"CV.08": "Sal",
"CV.07": "Ribeira Grande",
"CV.14": "Praia",
"CV.05": "Paul",
"CV.04": "Maio",
"CV.02": "Brava",
"CV.01": "Boa Vista",
"CV.13": "Mosteiros",
"CV.16": "Santa Cruz",
"CV.17": "São Domingos",
"CV.18": "São Filipe",
"CV.19": "São Miguel",
"CV.21": "Porto Novo",
"CV.22": "Ribeira Brava",
"CV.24": "Santa Catarina do Fogo",
"CV.26": "São Salvador do Mundo",
"CV.27": "Tarrafal de São Nicolau",
"CV.25": "São Lourenço dos Órgãos",
"CV.23": "Ribeira Grande de Santiago",
"CY.06": "Pafos",
"CY.04": "Nicosia",
"CY.05": "Limassol",
"CY.03": "Larnaka",
"CY.02": "Keryneia",
"CY.01": "Ammochostos",
"CZ.52": "Praha",
"CZ.78": "South Moravian",
"CZ.79": "Jihočeský",
"CZ.80": "Vysočina",
"CZ.81": "Karlovarský",
"CZ.82": "Královéhradecký",
"CZ.83": "Liberecký",
"CZ.84": "Olomoucký",
"CZ.85": "Moravskoslezský",
"CZ.86": "Pardubický",
"CZ.87": "Plzeňský",
"CZ.88": "Central Bohemia",
"CZ.89": "Ústecký",
"CZ.90": "Zlín",
"DE.15": "Thuringia",
"DE.10": "Schleswig-Holstein",
"DE.14": "Saxony-Anhalt",
"DE.13": "Saxony",
"DE.09": "Saarland",
"DE.08": "Rheinland-Pfalz",
"DE.07": "North Rhine-Westphalia",
"DE.06": "Lower Saxony",
"DE.12": "Mecklenburg-Vorpommern",
"DE.05": "Hesse",
"DE.04": "Hamburg",
"DE.03": "Bremen",
"DE.11": "Brandenburg",
"DE.16": "Berlin",
"DE.02": "Bavaria",
"DE.01": "Baden-Württemberg",
"DJ.05": "Tadjourah",
"DJ.04": "Obock",
"DJ.07": "Djibouti",
"DJ.06": "Dikhil",
"DJ.01": "Ali Sabieh",
"DJ.08": "Arta",
"DK.17": "Capital Region",
"DK.18": "Central Jutland",
"DK.19": "North Denmark",
"DK.20": "Zealand",
"DK.21": "South Denmark",
"DM.11": "Saint Peter",
"DM.10": "Saint Paul",
"DM.09": "Saint Patrick",
"DM.08": "Saint Mark",
"DM.07": "Saint Luke",
"DM.06": "Saint Joseph",
"DM.05": "Saint John",
"DM.04": "Saint George",
"DM.03": "Saint David",
"DM.02": "Saint Andrew",
"DO.27": "Valverde",
"DO.26": "Santiago Rodríguez",
"DO.25": "Santiago",
"DO.24": "San Pedro de Macorís",
"DO.23": "San Juan",
"DO.33": "San Cristóbal",
"DO.21": "Sánchez Ramírez",
"DO.20": "Samaná",
"DO.19": "Hermanas Mirabal",
"DO.18": "Puerto Plata",
"DO.35": "Peravia",
"DO.16": "Pedernales",
"DO.34": "Nacional",
"DO.32": "Monte Plata",
"DO.15": "Monte Cristi",
"DO.31": "Monseñor Nouel",
"DO.14": "María Trinidad Sánchez",
"DO.30": "La Vega",
"DO.12": "La Romana",
"DO.10": "La Altagracia",
"DO.09": "Independencia",
"DO.29": "Hato Mayor",
"DO.08": "Espaillat",
"DO.28": "El Seíbo",
"DO.11": "Elías Piña",
"DO.06": "Duarte",
"DO.04": "Dajabón",
"DO.03": "Barahona",
"DO.02": "Baoruco",
"DO.01": "Azua",
"DO.36": "San José de Ocoa",
"DO.37": "Santo Domingo",
"DZ.15": "Tlemcen",
"DZ.14": "Tizi Ouzou",
"DZ.56": "Tissemsilt",
"DZ.55": "Tipaza",
"DZ.54": "Tindouf",
"DZ.13": "Tiaret",
"DZ.33": "Tébessa",
"DZ.53": "Tamanrasset",
"DZ.52": "Souk Ahras",
"DZ.31": "Skikda",
"DZ.30": "Sidi Bel Abbès",
"DZ.12": "Sétif",
"DZ.10": "Saida",
"DZ.51": "Relizane",
"DZ.29": "Oum el Bouaghi",
"DZ.50": "Ouargla",
"DZ.09": "Oran",
"DZ.49": "Naama",
"DZ.27": "M'Sila",
"DZ.07": "Mostaganem",
"DZ.48": "Mila",
"DZ.06": "Medea",
"DZ.26": "Mascara",
"DZ.25": "Laghouat",
"DZ.47": "Khenchela",
"DZ.24": "Jijel",
"DZ.46": "Illizi",
"DZ.23": "Guelma",
"DZ.45": "Ghardaia",
"DZ.44": "El Tarf",
"DZ.43": "El Oued",
"DZ.42": "El Bayadh",
"DZ.22": "Djelfa",
"DZ.04": "Constantine",
"DZ.41": "Chlef",
"DZ.40": "Boumerdes",
"DZ.21": "Bouira",
"DZ.39": "Bordj Bou Arréridj",
"DZ.20": "Blida",
"DZ.19": "Biskra",
"DZ.18": "Béjaïa",
"DZ.38": "Béchar",
"DZ.03": "Batna",
"DZ.37": "Annaba",
"DZ.01": "Algiers",
"DZ.36": "Aïn Témouchent",
"DZ.35": "Aïn Defla",
"DZ.34": "Adrar",
"EC.20": "Zamora-Chinchipe",
"EC.19": "Tungurahua",
"EC.18": "Pichincha",
"EC.17": "Pastaza",
"EC.23": "Napo",
"EC.15": "Morona-Santiago",
"EC.14": "Manabí",
"EC.13": "Los Ríos",
"EC.12": "Loja",
"EC.11": "Imbabura",
"EC.10": "Guayas",
"EC.01": "Galápagos",
"EC.09": "Esmeraldas",
"EC.08": "El Oro",
"EC.07": "Cotopaxi",
"EC.06": "Chimborazo",
"EC.05": "Carchi",
"EC.04": "Cañar",
"EC.03": "Bolívar",
"EC.02": "Azuay",
"EC.22": "Sucumbios",
"EC.24": "Orellana",
"EC.26": "Santo Domingo de los Tsáchilas",
"EC.25": "Santa Elena",
"EE.21": "Võrumaa",
"EE.20": "Viljandimaa",
"EE.19": "Valgamaa",
"EE.18": "Tartu",
"EE.14": "Saare",
"EE.13": "Raplamaa",
"EE.12": "Põlvamaa",
"EE.11": "Pärnumaa",
"EE.08": "Lääne-Virumaa",
"EE.07": "Lääne",
"EE.05": "Jõgevamaa",
"EE.04": "Järvamaa",
"EE.03": "Ida-Virumaa",
"EE.02": "Hiiumaa",
"EE.01": "Harjumaa",
"EG.24": "Sohag",
"EG.27": "North Sinai",
"EG.23": "Qena",
"EG.22": "Matruh",
"EG.21": "Kafr el-Sheikh",
"EG.26": "South Sinai",
"EG.20": "Damietta",
"EG.19": "Port Said",
"EG.18": "Beni Suweif",
"EG.17": "Asyut",
"EG.16": "Aswan",
"EG.15": "Suez",
"EG.14": "Sharqia",
"EG.13": "New Valley",
"EG.12": "Qalyubia",
"EG.11": "Cairo",
"EG.10": "Minya",
"EG.09": "Monufia",
"EG.08": "Giza",
"EG.07": "Ismailia",
"EG.06": "Alexandria",
"EG.05": "Gharbia",
"EG.04": "Faiyum",
"EG.03": "Beheira",
"EG.02": "Red Sea",
"EG.01": "Dakahlia",
"EG.28": "Luxor",
"ER.01": "Anseba",
"ER.02": "Debub",
"ER.03": "Southern Red Sea",
"ER.04": "Gash-Barka",
"ER.05": "Maekel",
"ER.06": "Northern Red Sea",
"ES.31": "Murcia",
"ES.CE": "Ceuta",
"ES.07": "Balearic Islands",
"ES.51": "Andalusia",
"ES.53": "Canary Islands",
"ES.54": "Castille-La Mancha",
"ES.57": "Extremadura",
"ES.60": "Valencia",
"ES.34": "Asturias",
"ES.32": "Navarre",
"ES.29": "Madrid",
"ES.27": "La Rioja",
"ES.39": "Cantabria",
"ES.52": "Aragon",
"ES.55": "Castille and León",
"ES.56": "Catalonia",
"ES.58": "Galicia",
"ES.59": "Basque Country",
"ES.ML": "Melilla",
"ET.44": "Addis Ababa",
"ET.45": "Āfar",
"ET.46": "Amhara",
"ET.47": "Bīnshangul Gumuz",
"ET.48": "Dire Dawa",
"ET.49": "Gambela",
"ET.50": "Harari",
"ET.51": "Oromiya",
"ET.52": "Somali",
"ET.53": "Tigray",
"ET.54": "SNNPR",
"FI.19": "Lapland",
"FI.18": "Kainuu",
"FI.17": "Northern Ostrobothnia",
"FI.16": "Central Ostrobothnia",
"FI.15": "Ostrobothnia",
"FI.14": "Southern Ostrobothnia",
"FI.13": "Central Finland",
"FI.12": "North Karelia",
"FI.11": "Northern Savo",
"FI.10": "Southern Savonia",
"FI.09": "South Karelia",
"FI.08": "Kymenlaakso",
"FI.06": "Pirkanmaa",
"FI.05": "Häme",
"FI.02": "Southwest Finland",
"FI.01": "Uusimaa",
"FI.07": "Päijänne Tavastia",
"FI.04": "Satakunta",
"FJ.05": "Western",
"FJ.03": "Northern",
"FJ.01": "Central",
"FJ.02": "Eastern",
"FJ.04": "Rotuma",
"FM.04": "Yap",
"FM.02": "Pohnpei",
"FM.01": "Kosrae",
"FM.03": "Chuuk",
"FO.VG": "Vágar",
"FO.SU": "Suðuroy",
"FO.ST": "Streymoy",
"FO.SA": "Sandoy",
"FO.NO": "Norðoyar",
"FO.OS": "Eysturoy",
"FR.93": "Provence-Alpes-Côte d'Azur",
"FR.52": "Pays de la Loire",
"FR.11": "Île-de-France",
"FR.94": "Corsica",
"FR.24": "Centre",
"FR.53": "Brittany",
"FR.27": "Bourgogne-Franche-Comté",
"FR.75": "Nouvelle-Aquitaine",
"FR.28": "Normandy",
"FR.44": "Grand Est",
"FR.76": "Occitanie",
"FR.32": "Hauts-de-France",
"FR.84": "Auvergne-Rhône-Alpes",
"GA.09": "Woleu-Ntem",
"GA.08": "Ogooué-Maritime",
"GA.07": "Ogooué-Lolo",
"GA.06": "Ogooué-Ivindo",
"GA.05": "Nyanga",
"GA.04": "Ngouni",
"GA.03": "Moyen-Ogooué",
"GA.02": "Haut-Ogooué",
"GA.01": "Estuaire",
"GB.WLS": "Wales",
"GB.SCT": "Scotland",
"GB.NIR": "Northern Ireland",
"GB.ENG": "England",
"GD.06": "Saint Patrick",
"GD.05": "Saint Mark",
"GD.04": "Saint John",
"GD.03": "Saint George",
"GD.02": "Saint David",
"GD.01": "Saint Andrew",
"GD.10": "Carriacou and Petite Martinique",
"GE.51": "T'bilisi",
"GE.04": "Ajaria",
"GE.68": "Kvemo Kartli",
"GE.67": "Kakheti",
"GE.65": "Guria",
"GE.66": "Imereti",
"GE.73": "Shida Kartli",
"GE.69": "Mtskheta-Mtianeti",
"GE.70": "Racha-Lechkhumi and Kvemo Svaneti",
"GE.71": "Samegrelo and Zemo Svaneti",
"GE.72": "Samtskhe-Javakheti",
"GE.02": "Abkhazia",
"GF.GF": "Guyane",
"GG.6417213": "St Pierre du Bois",
"GG.6417214": "Torteval",
"GG.6417215": "Saint Saviour",
"GG.6417223": "Forest",
"GG.6417224": "St Martin",
"GG.6417226": "Saint Andrew",
"GG.6417228": "St Peter Port",
"GG.6417229": "Castel",
"GG.6417230": "Vale",
"GG.6417233": "St Sampson",
"GG.8989934": "Alderney",
"GH.09": "Western",
"GH.08": "Volta",
"GH.11": "Upper West",
"GH.10": "Upper East",
"GH.06": "Northern",
"GH.01": "Greater Accra",
"GH.05": "Eastern",
"GH.04": "Central",
"GH.03": "Brong-Ahafo",
"GH.02": "Ashanti",
"GL.05": "Qaasuitsup",
"GL.04": "Kujalleq",
"GL.06": "Qeqqata",
"GL.07": "Sermersooq",
"GM.05": "Western",
"GM.04": "Upper River",
"GM.07": "North Bank",
"GM.03": "Central River",
"GM.02": "Lower River",
"GM.01": "Banjul",
"GN.04": "Conakry",
"GN.B": "Boke",
"GN.F": "Faranah",
"GN.K": "Kankan",
"GN.D": "Kindia",
"GN.L": "Labe",
"GN.M": "Mamou",
"GN.N": "Nzerekore",
"GP.GP": "Guadeloupe",
"GQ.03": "Annobon",
"GQ.04": "Bioko Norte",
"GQ.05": "Bioko Sur",
"GQ.06": "Centro Sur",
"GQ.07": "Kié-Ntem",
"GQ.08": "Litoral",
"GQ.09": "Wele-Nzas",
"GR.736572": "Mount Athos",
"GR.ESYE31": "Attica",
"GR.ESYE24": "Central Greece",
"GR.ESYE12": "Central Macedonia",
"GR.ESYE43": "Crete",
"GR.ESYE11": "East Macedonia and Thrace",
"GR.ESYE21": "Epirus",
"GR.ESYE22": "Ionian Islands",
"GR.ESYE41": "North Aegean",
"GR.ESYE25": "Peloponnese",
"GR.ESYE42": "South Aegean",
"GR.ESYE14": "Thessaly",
"GR.ESYE23": "West Greece",
"GR.ESYE13": "West Macedonia",
"GT.22": "Zacapa",
"GT.21": "Totonicapán",
"GT.20": "Suchitepeque",
"GT.19": "Sololá",
"GT.18": "Santa Rosa",
"GT.17": "San Marcos",
"GT.16": "Sacatepéquez",
"GT.15": "Retalhuleu",
"GT.14": "Quiché",
"GT.13": "Quetzaltenango",
"GT.12": "Petén",
"GT.11": "Jutiapa",
"GT.10": "Jalapa",
"GT.09": "Izabal",
"GT.08": "Huehuetenango",
"GT.07": "Guatemala",
"GT.06": "Escuintla",
"GT.05": "El Progreso",
"GT.04": "Chiquimula",
"GT.03": "Chimaltenango",
"GT.02": "Baja Verapaz",
"GT.01": "Alta Verapaz",
"GU.PI": "Piti",
"GU.SR": "Santa Rita",
"GU.SJ": "Sinajana",
"GU.TF": "Talofofo",
"GU.TM": "Tamuning",
"GU.UM": "Umatac",
"GU.YG": "Yigo",
"GU.YN": "Yona",
"GU.ME": "Merizo",
"GU.MA": "Mangilao",
"GU.AH": "Agana Heights",
"GU.CP": "Chalan Pago-Ordot",
"GU.AS": "Asan",
"GU.AT": "Agat",
"GU.DD": "Dededo",
"GU.BA": "Barrigada",
"GU.AN": "Hagatna",
"GU.IN": "Inarajan",
"GU.MT": "Mongmong-Toto-Maite",
"GW.07": "Tombali",
"GW.02": "Quinara",
"GW.04": "Oio",
"GW.10": "Gabú",
"GW.06": "Cacheu",
"GW.05": "Bolama and Bijagos",
"GW.11": "Bissau",
"GW.12": "Biombo",
"GW.01": "Bafatá",
"GY.19": "Upper Takutu-Upper Essequibo",
"GY.18": "Upper Demerara-Berbice",
"GY.17": "Potaro-Siparuni",
"GY.16": "Pomeroon-Supenaam",
"GY.15": "Mahaica-Berbice",
"GY.14": "Essequibo Islands-West Demerara",
"GY.13": "East Berbice-Corentyne",
"GY.12": "Demerara-Mahaica",
"GY.11": "Cuyuni-Mazaruni",
"GY.10": "Barima-Waini",
"HK.NYL": "Yuen Long",
"HK.NTW": "Tsuen Wan",
"HK.NTP": "Tai Po",
"HK.NSK": "Sai Kung",
"HK.NIS": "Islands",
"HK.HCW": "Central and Western",
"HK.HWC": "Wanchai",
"HK.HEA": "Eastern",
"HK.HSO": "Southern",
"HK.KYT": "Yau Tsim Mong",
"HK.KSS": "Sham Shui Po",
"HK.KKC": "Kowloon City",
"HK.KWT": "Wong Tai Sin",
"HK.KKT": "Kwun Tong",
"HK.NKT": "Kwai Tsing",
"HK.NTM": "Tuen Mun",
"HK.NNO": "North",
"HK.NST": "Sha Tin",
"HN.18": "Yoro",
"HN.17": "Valle",
"HN.16": "Santa Bárbara",
"HN.15": "Olancho",
"HN.14": "Ocotepeque",
"HN.13": "Lempira",
"HN.12": "La Paz",
"HN.11": "Bay Islands",
"HN.10": "Intibucá",
"HN.09": "Gracias a Dios",
"HN.08": "Francisco Morazán",
"HN.07": "El Paraíso",
"HN.06": "Cortés",
"HN.05": "Copán",
"HN.04": "Comayagua",
"HN.03": "Colón",
"HN.02": "Choluteca",
"HN.01": "Atlántida",
"HR.01": "Bjelovarsko-Bilogorska",
"HR.02": "Slavonski Brod-Posavina",
"HR.03": "Dubrovačko-Neretvanska",
"HR.04": "Istarska",
"HR.05": "Karlovačka",
"HR.06": "Koprivničko-Križevačka",
"HR.07": "Krapinsko-Zagorska",
"HR.08": "Ličko-Senjska",
"HR.09": "Međimurska",
"HR.10": "Osječko-Baranjska",
"HR.11": "Požeško-Slavonska",
"HR.12": "Primorsko-Goranska",
"HR.13": "Šibensko-Kniniska",
"HR.14": "Sisačko-Moslavačka",
"HR.15": "Splitsko-Dalmatinska",
"HR.16": "Varaždinska",
"HR.18": "Vukovar-Sirmium",
"HR.19": "Zadarska",
"HR.20": "Zagrebačka",
"HR.21": "City of Zagreb",
"HR.17": "Virovitičk-Podravska",
"HT.13": "Sud-Est",
"HT.12": "Sud",
"HT.11": "Ouest",
"HT.03": "Nord-Ouest",
"HT.10": "Nord-Est",
"HT.09": "Nord",
"HT.14": "GrandʼAnse",
"HT.07": "Centre",
"HT.06": "Artibonite",
"HT.15": "Nippes",
"HU.18": "Szabolcs-Szatmár-Bereg",
"HU.20": "Jász-Nagykun-Szolnok",
"HU.11": "Heves",
"HU.10": "Hajdú-Bihar",
"HU.06": "Csongrád",
"HU.04": "Borsod-Abaúj-Zemplén",
"HU.03": "Bekes",
"HU.24": "Zala",
"HU.23": "Veszprém",
"HU.22": "Vas",
"HU.21": "Tolna",
"HU.17": "Somogy",
"HU.16": "Pest",
"HU.14": "Nógrád",
"HU.12": "Komárom-Esztergom",
"HU.09": "Győr-Moson-Sopron",
"HU.08": "Fejér",
"HU.05": "Budapest",
"HU.02": "Baranya",
"HU.01": "Bács-Kiskun",
"ID.26": "North Sumatra",
"ID.01": "Aceh",
"ID.10": "Yogyakarta",
"ID.32": "South Sumatra",
"ID.24": "West Sumatra",
"ID.31": "North Sulawesi",
"ID.22": "Southeast Sulawesi",
"ID.21": "Central Sulawesi",
"ID.38": "South Sulawesi",
"ID.37": "Riau",
"ID.18": "East Nusa Tenggara",
"ID.17": "West Nusa Tenggara",
"ID.28": "Maluku",
"ID.15": "Lampung",
"ID.14": "East Kalimantan",
"ID.13": "Central Kalimantan",
"ID.12": "South Kalimantan",
"ID.11": "West Kalimantan",
"ID.08": "East Java",
"ID.07": "Central Java",
"ID.30": "West Java",
"ID.05": "Jambi",
"ID.04": "Jakarta",
"ID.36": "Papua",
"ID.03": "Bengkulu",
"ID.02": "Bali",
"ID.33": "Banten",
"ID.34": "Gorontalo",
"ID.35": "Bangka–Belitung Islands",
"ID.29": "North Maluku",
"ID.39": "West Papua",
"ID.41": "West Sulawesi",
"ID.40": "Riau Islands",
"ID.42": "North Kalimantan",
"IE.C": "Connaught",
"IE.L": "Leinster",
"IE.M": "Munster",
"IE.U": "Ulster",
"IL.06": "Jerusalem",
"IL.05": "Tel Aviv",
"IL.04": "Haifa",
"IL.03": "Northern District",
"IL.02": "Central District",
"IL.01": "Southern District",
"IM.9782164": "Andreas",
"IM.9782165": "Arbory",
"IM.9782166": "Ballaugh",
"IM.9782167": "Braddan",
"IM.9782168": "Bride",
"IM.9782169": "Castletown",
"IM.9782170": "Douglas",
"IM.9782171": "German",
"IM.9782172": "Jurby",
"IM.9782173": "Laxey",
"IM.9782176": "Lezayre",
"IM.9782180": "Lonan",
"IM.9782182": "Malew",
"IM.9782183": "Marown",
"IM.9782184": "Maughold",
"IM.9782185": "Michael",
"IM.9782186": "Onchan",
"IM.9782187": "Patrick",
"IM.9782188": "Peel",
"IM.9782189": "Port Erin",
"IM.9782190": "Port St Mary",
"IM.9782191": "Ramsey",
"IM.9782192": "Rushen",
"IM.9782193": "Santon",
"IN.28": "West Bengal",
"IN.36": "Uttar Pradesh",
"IN.26": "Tripura",
"IN.40": "Telangana",
"IN.25": "Tamil Nadu",
"IN.29": "Sikkim",
"IN.24": "Rajasthan",
"IN.23": "Punjab",
"IN.22": "Pondicherry",
"IN.21": "Odisha",
"IN.20": "Nagaland",
"IN.31": "Mizoram",
"IN.18": "Meghalaya",
"IN.17": "Manipur",
"IN.16": "Maharashtra",
"IN.35": "Madhya Pradesh",
"IN.14": "Laccadives",
"IN.13": "Kerala",
"IN.19": "Karnataka",
"IN.12": "Kashmir",
"IN.11": "Himachal Pradesh",
"IN.10": "Haryana",
"IN.09": "Gujarat",
"IN.32": "Daman and Diu",
"IN.33": "Goa",
"IN.07": "NCT",
"IN.06": "Dadra and Nagar Haveli",
"IN.05": "Chandigarh",
"IN.34": "Bihar",
"IN.03": "Assam",
"IN.30": "Arunachal Pradesh",
"IN.02": "Andhra Pradesh",
"IN.01": "Andaman and Nicobar",
"IN.37": "Chhattisgarh",
"IN.38": "Jharkhand",
"IN.39": "Uttarakhand",
"IQ.02": "Basra",
"IQ.16": "Wāsiţ",
"IQ.18": "Salah ad Din",
"IQ.15": "Nīnawá",
"IQ.14": "Maysan",
"IQ.12": "Karbalāʼ",
"IQ.11": "Arbīl",
"IQ.10": "Diyālá",
"IQ.09": "Dhi Qar",
"IQ.08": "Dahūk",
"IQ.07": "Baghdad",
"IQ.06": "Bābil",
"IQ.13": "Kirkuk",
"IQ.05": "As Sulaymānīyah",
"IQ.17": "An Najaf",
"IQ.04": "Al Qādisīyah",
"IQ.03": "Al Muthanná",
"IQ.01": "Anbar",
"IR.26": "Tehrān",
"IR.36": "Zanjan",
"IR.40": "Yazd",
"IR.25": "Semnān",
"IR.35": "Māzandarān",
"IR.34": "Markazi",
"IR.23": "Lorestān",
"IR.16": "Kordestān",
"IR.05": "Kohgīlūyeh va Būyer Aḩmad",
"IR.15": "Khuzestan",
"IR.13": "Kermānshāh",
"IR.29": "Kerman",
"IR.10": "Īlām",
"IR.11": "Hormozgan",
"IR.09": "Hamadān",
"IR.08": "Gīlān",
"IR.07": "Fars",
"IR.03": "Chaharmahal and Bakhtiari",
"IR.22": "Bushehr",
"IR.33": "East Azerbaijan",
"IR.01": "Āz̄ārbāyjān-e Gharbī",
"IR.32": "Ardabīl",
"IR.28": "Isfahan",
"IR.37": "Golestān",
"IR.38": "Qazvīn",
"IR.39": "Qom",
"IR.04": "Sistan and Baluchestan",
"IR.41": "Khorāsān-e Jonūbī",
"IR.42": "Razavi Khorasan",
"IR.43": "Khorāsān-e Shomālī",
"IR.44": "Alborz",
"IS.41": "Northwest",
"IS.40": "Northeast",
"IS.38": "East",
"IS.42": "South",
"IS.39": "Capital Region",
"IS.43": "Southern Peninsula",
"IS.45": "West",
"IS.44": "Westfjords",
"IT.15": "Sicily",
"IT.14": "Sardinia",
"IT.03": "Calabria",
"IT.20": "Veneto",
"IT.19": "Aosta Valley",
"IT.18": "Umbria",
"IT.17": "Trentino-Alto Adige",
"IT.16": "Tuscany",
"IT.13": "Apulia",
"IT.12": "Piedmont",
"IT.11": "Molise",
"IT.10": "The Marches",
"IT.09": "Lombardy",
"IT.08": "Liguria",
"IT.07": "Latium",
"IT.06": "Friuli Venezia Giulia",
"IT.05": "Emilia-Romagna",
"IT.04": "Campania",
"IT.02": "Basilicate",
"IT.01": "Abruzzo",
"JE.3237072": "St Clement",
"JE.3237073": "St Saviour",
"JE.3237200": "St. Brelade",
"JE.3237203": "Grouville",
"JE.3237212": "St Mary",
"JE.3237214": "St Lawrence",
"JE.3237221": "St Peter",
"JE.3237229": "St Ouen",
"JE.3237497": "St John",
"JE.3237530": "Trinity",
"JE.3237716": "St Martîn",
"JE.3237864": "St Helier",
"JM.16": "Westmoreland",
"JM.15": "Trelawny",
"JM.14": "St. Thomas",
"JM.13": "St. Mary",
"JM.12": "St. James",
"JM.11": "St. Elizabeth",
"JM.10": "Saint Catherine",
"JM.09": "St Ann",
"JM.08": "St. Andrew",
"JM.07": "Portland",
"JM.04": "Manchester",
"JM.17": "Kingston",
"JM.02": "Hanover",
"JM.01": "Clarendon",
"JO.19": "Ma’an",
"JO.18": "Irbid",
"JO.17": "Zarqa",
"JO.12": "Tafielah",
"JO.16": "Amman",
"JO.15": "Mafraq",
"JO.09": "Karak",
"JO.02": "Balqa",
"JO.20": "Ajlun",
"JO.22": "Jerash",
"JO.21": "Aqaba",
"JO.23": "Madaba",
"JP.46": "Yamanashi",
"JP.45": "Yamaguchi",
"JP.43": "Wakayama",
"JP.42": "Toyama",
"JP.41": "Tottori",
"JP.40": "Tokyo",
"JP.39": "Tokushima",
"JP.38": "Tochigi",
"JP.37": "Shizuoka",
"JP.36": "Shimane",
"JP.35": "Shiga",
"JP.34": "Saitama",
"JP.33": "Saga",
"JP.32": "Ōsaka",
"JP.47": "Okinawa",
"JP.31": "Okayama",
"JP.30": "Oita",
"JP.29": "Niigata",
"JP.28": "Nara",
"JP.27": "Nagasaki",
"JP.26": "Nagano",
"JP.25": "Miyazaki",
"JP.23": "Mie",
"JP.22": "Kyoto",
"JP.21": "Kumamoto",
"JP.20": "Kochi",
"JP.19": "Kanagawa",
"JP.18": "Kagoshima",
"JP.17": "Kagawa",
"JP.15": "Ishikawa",
"JP.13": "Hyōgo",
"JP.11": "Hiroshima",
"JP.10": "Gunma",
"JP.09": "Gifu",
"JP.07": "Fukuoka",
"JP.06": "Fukui",
"JP.05": "Ehime",
"JP.01": "Aichi",
"JP.44": "Yamagata",
"JP.24": "Miyagi",
"JP.16": "Iwate",
"JP.14": "Ibaraki",
"JP.08": "Fukushima",
"JP.04": "Chiba",
"JP.02": "Akita",
"JP.12": "Hokkaido",
"JP.03": "Aomori",
"KE.55": "West Pokot",
"KE.54": "Wajir",
"KE.52": "Uasin Gishu",
"KE.51": "Turkana",
"KE.50": "Trans Nzoia",
"KE.49": "Tharaka - Nithi",
"KE.48": "Tana River",
"KE.46": "Siaya",
"KE.45": "Samburu",
"KE.05": "Nairobi Area",
"KE.38": "Murang'A",
"KE.37": "Mombasa",
"KE.35": "Meru",
"KE.34": "Marsabit",
"KE.33": "Mandera",
"KE.29": "Laikipia",
"KE.28": "Kwale",
"KE.27": "Kitui",
"KE.26": "Kisumu",
"KE.25": "Kisii",
"KE.24": "Kirinyaga",
"KE.23": "Kilifi",
"KE.22": "Kiambu",
"KE.21": "Kericho",
"KE.20": "Kakamega",
"KE.18": "Isiolo",
"KE.16": "Garissa",
"KE.15": "Embu",
"KE.13": "Busia",
"KE.12": "Bungoma",
"KE.10": "Baringo",
"KE.43": "Nyandarua",
"KE.53": "Vihiga",
"KE.30": "Lamu",
"KE.31": "Machakos",
"KE.32": "Makueni",
"KE.14": "Elegeyo-Marakwet",
"KE.47": "Taita Taveta",
"KE.19": "Kajiado",
"KE.44": "Nyeri",
"KE.17": "Homa Bay",
"KE.11": "Bomet",
"KE.36": "Migori",
"KE.39": "Nakuru",
"KE.41": "Narok",
"KE.42": "Nyamira",
"KE.40": "Nandi",
"KG.08": "Osh",
"KG.09": "Batken",
"KG.06": "Talas",
"KG.04": "Naryn",
"KG.07": "Issyk-Kul",
"KG.01": "Bishkek",
"KG.03": "Jalal-Abad",
"KG.02": "Chüy",
"KG.10": "Osh City",
"KH.12": "Pursat",
"KH.29": "Battambang",
"KH.19": "Takeo",
"KH.18": "Svay Rieng",
"KH.17": "Stung Treng",
"KH.27": "Ŏtâr Méanchey",
"KH.24": "Siem Reap",
"KH.23": "Ratanakiri",
"KH.14": "Prey Veng",
"KH.13": "Preah Vihear",
"KH.22": "Phnom Penh",
"KH.30": "Pailin",
"KH.10": "Mondolkiri",
"KH.09": "Kratie",
"KH.26": "Kep",
"KH.08": "Koh Kong",
"KH.07": "Kandal",
"KH.21": "Kampot",
"KH.05": "Kampong Thom",
"KH.04": "Kampong Speu",
"KH.03": "Kampong Chhnang",
"KH.02": "Kampong Cham",
"KH.28": "Preah Sihanouk",
"KH.25": "Banteay Meanchey",
"KH.31": "Tboung Khmum",
"KI.01": "Gilbert Islands",
"KI.02": "Line Islands",
"KI.03": "Phoenix Islands",
"KM.03": "Mohéli",
"KM.02": "Grande Comore",
"KM.01": "Anjouan",
"KN.15": "Trinity Palmetto Point",
"KN.13": "Middle Island",
"KN.12": "Saint Thomas Lowland",
"KN.11": "Saint Peter Basseterre",
"KN.10": "Saint Paul Charlestown",
"KN.09": "Saint Paul Capesterre",
"KN.08": "Saint Mary Cayon",
"KN.07": "Saint John Figtree",
"KN.06": "Saint John Capesterre",
"KN.05": "Saint James Windwa",
"KN.04": "Saint George Gingerland",
"KN.03": "Saint George Basseterre",
"KN.02": "Saint Anne Sandy Point",
"KN.01": "Christ Church Nichola Town",
"KP.12": "Pyongyang",
"KP.15": "P'yŏngan-namdo",
"KP.11": "P'yŏngan-bukto",
"KP.09": "Kangwŏn-do",
"KP.06": "Hwanghae-namdo",
"KP.07": "Hwanghae-bukto",
"KP.03": "Hamgyŏng-namdo",
"KP.13": "Yanggang-do",
"KP.17": "Hamgyŏng-bukto",
"KP.01": "Chagang-do",
"KP.18": "Rason",
"KR.21": "Ulsan",
"KR.19": "Daejeon",
"KR.15": "Daegu",
"KR.11": "Seoul",
"KR.10": "Busan",
"KR.14": "Gyeongsangbuk-do",
"KR.13": "Gyeonggi-do",
"KR.18": "Gwangju",
"KR.06": "Gangwon-do",
"KR.12": "Incheon",
"KR.17": "Chungcheongnam-do",
"KR.05": "North Chungcheong",
"KR.16": "Jeollanam-do",
"KR.03": "Jeollabuk-do",
"KR.01": "Jeju-do",
"KR.20": "Gyeongsangnam-do",
"KR.22": "Sejong-si",
"KW.08": "Hawalli",
"KW.02": "Al Asimah",
"KW.05": "Al Jahrāʼ",
"KW.07": "Al Farwaniyah",
"KW.04": "Al Aḩmadī",
"KW.09": "Mubārak al Kabīr",
"KY.10346796": "George Town",
"KY.10375968": "West Bay",
"KY.10375969": "Bodden Town",
"KY.10375970": "North Side",
"KY.10375971": "East End",
"KY.10375972": "Sister Island",
"KZ.07": "Batys Qazaqstan",
"KZ.09": "Mangghystaū",
"KZ.06": "Atyraū",
"KZ.04": "Aqtöbe",
"KZ.15": "East Kazakhstan",
"KZ.03": "Aqmola",
"KZ.16": "Soltüstik Qazaqstan",
"KZ.11": "Pavlodar",
"KZ.14": "Qyzylorda",
"KZ.13": "Qostanay",
"KZ.12": "Qaraghandy",
"KZ.17": "Zhambyl",
"KZ.10": "Ongtüstik Qazaqstan",
"KZ.02": "Almaty Qalasy",
"KZ.01": "Almaty Oblysy",
"KZ.08": "Baikonur",
"KZ.05": "Astana Qalasy",
"LA.14": "Xiangkhoang",
"LA.13": "Xiagnabouli",
"LA.27": "Vientiane",
"LA.20": "Savannahkhét",
"LA.19": "Salavan",
"LA.18": "Phôngsali",
"LA.07": "Oudômxai",
"LA.17": "Louangphabang",
"LA.16": "Loungnamtha",
"LA.15": "Khammouan",
"LA.03": "Houaphan",
"LA.02": "Champasak",
"LA.01": "Attapu",
"LA.26": "Xékong",
"LA.22": "Bokeo",
"LA.23": "Bolikhamsai",
"LA.24": "Vientiane Prefecture",
"LA.28": "Xaisomboun",
"LB.05": "Mont-Liban",
"LB.04": "Beyrouth",
"LB.09": "Liban-Nord",
"LB.06": "South Governorate",
"LB.08": "Béqaa",
"LB.07": "Nabatîyé",
"LB.10": "Aakkâr",
"LB.11": "Baalbek-Hermel",
"LC.10": "Vieux-Fort",
"LC.09": "Soufrière",
"LC.08": "Micoud",
"LC.07": "Laborie",
"LC.06": "Gros-Islet",
"LC.05": "Dennery",
"LC.04": "Choiseul",
"LC.03": "Castries",
"LC.01": "Anse-la-Raye",
"LC.12": "Canaries",
"LI.11": "Vaduz",
"LI.10": "Triesenberg",
"LI.09": "Triesen",
"LI.08": "Schellenberg",
"LI.07": "Schaan",
"LI.06": "Ruggell",
"LI.05": "Planken",
"LI.04": "Mauren",
"LI.03": "Gamprin",
"LI.02": "Eschen",
"LI.01": "Balzers",
"LK.36": "Western",
"LK.35": "Uva",
"LK.34": "Southern",
"LK.33": "Sabaragamuwa",
"LK.32": "North Western",
"LK.30": "North Central",
"LK.29": "Central",
"LK.38": "Northern Province",
"LK.37": "Eastern Province",
"LR.10": "Sinoe",
"LR.09": "Nimba",
"LR.14": "Montserrado",
"LR.13": "Maryland",
"LR.20": "Lofa",
"LR.19": "Grand Gedeh",
"LR.12": "Grand Cape Mount",
"LR.11": "Grand Bassa",
"LR.01": "Bong",
"LR.15": "Bomi",
"LR.16": "Grand Kru",
"LR.17": "Margibi",
"LR.18": "River Cess",
"LR.21": "Gbarpolu",
"LR.22": "River Gee",
"LS.19": "Thaba-Tseka",
"LS.18": "Quthing",
"LS.17": "Qachaʼs Nek",
"LS.16": "Mokhotlong",
"LS.15": "Mohaleʼs Hoek",
"LS.14": "Maseru",
"LS.13": "Mafeteng",
"LS.12": "Leribe",
"LS.11": "Butha-Buthe",
"LS.10": "Berea",
"LT.56": "Alytus",
"LT.57": "Kaunas",
"LT.58": "Klaipėda County",
"LT.59": "Marijampolė County",
"LT.60": "Panevėžys",
"LT.61": "Siauliai",
"LT.62": "Tauragė County",
"LT.63": "Telsiai",
"LT.64": "Utena",
"LT.65": "Vilnius",
"LU.WI": "Wiltz",
"LU.VD": "Vianden",
"LU.RM": "Remich",
"LU.RD": "Redange",
"LU.ME": "Mersch",
"LU.LU": "Luxembourg",
"LU.GR": "Grevenmacher",
"LU.ES": "Esch-sur-Alzette",
"LU.EC": "Echternach",
"LU.DI": "Diekirch",
"LU.CL": "Clervaux",
"LU.CA": "Capellen",
"LV.33": "Ventspils Rajons",
"LV.32": "Ventspils",
"LV.31": "Valmieras Rajons",
"LV.30": "Valkas Rajons",
"LV.29": "Tukuma Rajons",
"LV.28": "Talsu Rajons",
"LV.27": "Saldus Rajons",
"LV.25": "Riga",
"LV.24": "Rēzeknes Rajons",
"LV.23": "Rēzekne",
"LV.22": "Preiļu Rajons",
"LV.21": "Ogre",
"LV.20": "Madonas Rajons",
"LV.19": "Ludzas Rajons",
"LV.18": "Limbažu Rajons",
"LV.16": "Liepāja",
"LV.15": "Kuldīgas Rajons",
"LV.14": "Krāslavas Rajons",
"LV.13": "Jūrmala",
"LV.12": "Jelgavas Rajons",
"LV.11": "Jelgava",
"LV.10": "Jēkabpils Municipality",
"LV.09": "Gulbenes Rajons",
"LV.08": "Dobeles Rajons",
"LV.07": "Daugavpils municipality",
"LV.06": "Daugavpils",
"LV.05": "Cēsu Rajons",
"LV.04": "Bauskas Rajons",
"LV.03": "Balvu Rajons",
"LV.02": "Alūksnes Novads",
"LV.01": "Aizkraukles Rajons",
"LV.60": "Dundaga",
"LV.40": "Alsunga",
"LV.A5": "Pāvilostas",
"LV.99": "Nīca",
"LV.B6": "Rucavas",
"LV.65": "Grobiņa",
"LV.61": "Durbe",
"LV.37": "Aizpute",
"LV.A8": "Priekule",
"LV.D7": "Vaiņode",
"LV.C9": "Skrunda",
"LV.51": "Brocēni",
"LV.B4": "Rojas",
"LV.77": "Kandava",
"LV.44": "Auces",
"LV.73": "Jaunpils",
"LV.62": "Engure",
"LV.D5": "Tērvete",
"LV.A3": "Ozolnieku",
"LV.B9": "Rundāles",
"LV.45": "Babīte",
"LV.95": "Mārupe",
"LV.A2": "Olaine",
"LV.67": "Lecava",
"LV.80": "Ķekava",
"LV.C3": "Salaspils",
"LV.46": "Baldone",
"LV.D2": "Stopiņi",
"LV.53": "Carnikava",
"LV.34": "Ādaži",
"LV.64": "Garkalne",
"LV.E4": "Vecumnieki",
"LV.79": "Ķegums",
"LV.87": "Lielvārde",
"LV.C8": "Skrīveri",
"LV.71": "Jaunjelgava",
"LV.98": "Nereta",
"LV.E6": "Viesīte",
"LV.C2": "Salas",
"LV.74": "Jēkabpils",
"LV.38": "Aknīste",
"LV.69": "Ilūkste",
"LV.E2": "Vārkava",
"LV.90": "Līvāni",
"LV.E1": "Varakļāni",
"LV.E8": "Vilanu",
"LV.B3": "Riebiņu",
"LV.35": "Aglona",
"LV.56": "Cibla",
"LV.E9": "Zilupes",
"LV.E7": "Viļaka",
"LV.47": "Baltinava",
"LV.57": "Dagda",
"LV.78": "Karsava",
"LV.B7": "Rugāju",
"LV.55": "Cesvaine",
"LV.91": "Lubāna",
"LV.85": "Krustpils",
"LV.A6": "Pļaviņu",
"LV.82": "Koknese",
"LV.68": "Ikšķile",
"LV.B5": "Ropažu",
"LV.70": "Inčukalns",
"LV.84": "Krimulda",
"LV.C7": "Sigulda",
"LV.88": "Līgatne",
"LV.94": "Mālpils",
"LV.C6": "Sēja",
"LV.C5": "Saulkrastu",
"LV.C1": "Salacgrīvas",
"LV.39": "Aloja",
"LV.97": "Naukšēni",
"LV.B8": "Rūjienas",
"LV.96": "Mazsalaca",
"LV.52": "Burtnieki",
"LV.A4": "Pārgaujas",
"LV.81": "Kocēni",
"LV.42": "Amatas",
"LV.A9": "Priekuļi",
"LV.B1": "Raunas",
"LV.D3": "Strenči",
"LV.50": "Beverīna",
"LV.D1": "Smiltene",
"LV.72": "Jaunpiebalga",
"LV.63": "Ērgļi",
"LV.E3": "Vecpiebalga",
"LV.43": "Apes",
"LV.F1": "Mesraga",
"LY.70": "Darnah",
"LY.69": "Banghāzī",
"LY.66": "Al Marj",
"LY.65": "Al Kufrah",
"LY.63": "Al Jabal al Akhḑar",
"LY.77": "Tripoli",
"LY.76": "Surt",
"LY.75": "Sabhā",
"LY.74": "Sha‘bīyat Nālūt",
"LY.73": "Murzuq",
"LY.72": "Mişrātah",
"LY.71": "Sha‘bīyat Ghāt",
"LY.68": "Az Zāwiyah",
"LY.78": "Ash Shāţiʼ",
"LY.64": "Al Jufrah",
"LY.67": "An Nuqāţ al Khams",
"LY.79": "Sha‘bīyat al Buţnān",
"LY.80": "Jabal al Gharbi",
"LY.81": "Sha‘bīyat al Jafārah",
"LY.82": "Al Marqab",
"LY.83": "Sha‘bīyat al Wāḩāt",
"LY.84": "Sha‘bīyat Wādī al Ḩayāt",
"MA.01": "Tanger-Tetouan-Al Hoceima",
"MA.02": "Oriental",
"MA.03": "Fès-Meknès",
"MA.04": "Rabat-Salé-Kénitra",
"MA.05": "Béni Mellal-Khénifra",
"MA.06": "Casablanca-Settat",
"MA.07": "Marrakesh-Safi",
"MA.08": "Drâa-Tafilalet",
"MA.09": "Souss-Massa",
"MA.10": "Guelmim-Oued Noun",
"MA.11": "Laâyoune-Sakia El Hamra",
"MA.12": "Dakhla-Oued Ed-Dahab",
"MC.00": "",
"MD.73": "Raionul Edineţ",
"MD.92": "Ungheni",
"MD.91": "Teleneşti",
"MD.90": "Taraclia",
"MD.88": "Ştefan-Vodă",
"MD.89": "Strășeni",
"MD.87": "Raionul Soroca",
"MD.84": "Rîşcani",
"MD.83": "Rezina",
"MD.82": "Orhei",
"MD.81": "Raionul Ocniţa",
"MD.59": "Anenii Noi",
"MD.80": "Nisporeni",
"MD.79": "Leova",
"MD.85": "Sîngerei",
"MD.69": "Criuleni",
"MD.78": "Ialoveni",
"MD.57": "Chișinău Municipality",
"MD.67": "Căuşeni",
"MD.65": "Cantemir",
"MD.66": "Călăraşi",
"MD.64": "Cahul",
"MD.76": "Glodeni",
"MD.75": "Floreşti",
"MD.74": "Făleşti",
"MD.72": "Dubăsari",
"MD.71": "Drochia",
"MD.70": "Donduşeni",
"MD.68": "Cimişlia",
"MD.63": "Briceni",
"MD.61": "Basarabeasca",
"MD.77": "Hînceşti",
"MD.86": "Şoldăneşti",
"MD.58": "Stînga Nistrului",
"MD.51": "Găgăuzia",
"MD.62": "Bender Municipality",
"MD.60": "Bălţi",
"ME.17": "Opština Rožaje",
"ME.21": "Opština Žabljak",
"ME.20": "Ulcinj",
"ME.19": "Tivat",
"ME.16": "Podgorica",
"ME.18": "Opština Šavnik",
"ME.15": "Opština Plužine",
"ME.14": "Pljevlja",
"ME.13": "Opština Plav",
"ME.12": "Opština Nikšić",
"ME.11": "Mojkovac",
"ME.10": "Kotor",
"ME.09": "Opština Kolašin",
"ME.03": "Berane",
"ME.08": "Herceg Novi",
"ME.07": "Danilovgrad",
"ME.06": "Cetinje",
"ME.05": "Budva",
"ME.04": "Bijelo Polje",
"ME.02": "Bar",
"ME.01": "Andrijevica",
"ME.22": "Gusinje",
"ME.23": "Petnjica",
"MG.7670842": "Diana",
"MG.7670846": "Sava",
"MG.7670847": "Sofia",
"MG.7670848": "Analanjirofo",
"MG.7670849": "Boeny",
"MG.7670850": "Betsiboka",
"MG.7670851": "Alaotra Mangoro",
"MG.7670852": "Melaky",
"MG.7670853": "Bongolava",
"MG.7670854": "Vakinankaratra",
"MG.7670855": "Itasy",
"MG.7670856": "Analamanga",
"MG.7670857": "Atsinanana",
"MG.7670902": "Menabe",
"MG.7670904": "Amoron'i Mania",
"MG.7670905": "Upper Matsiatra",
"MG.7670906": "Vatovavy Fitovinany",
"MG.7670907": "Ihorombe",
"MG.7670908": "Atsimo-Atsinanana",
"MG.7670910": "Anosy",
"MG.7670911": "Androy",
"MG.7670913": "Atsimo-Andrefana",
"MH.007": "Ailinginae Atoll",
"MH.010": "Ailinglaplap Atoll",
"MH.030": "Ailuk Atoll",
"MH.040": "Arno Atoll",
"MH.050": "Aur Atoll",
"MH.060": "Bikar Atoll",
"MH.070": "Bikini Atoll",
"MH.080": "Ebon Atoll",
"MH.090": "Enewetak Atoll",
"MH.100": "Erikub Atoll",
"MH.120": "Jaluit Atoll",
"MH.150": "Kwajalein Atoll",
"MH.160": "Lae Atoll",
"MH.180": "Likiep Atoll",
"MH.190": "Majuro Atoll",
"MH.300": "Maloelap Atoll",
"MH.320": "Mili Atoll",
"MH.330": "Namdrik Atoll",
"MH.340": "Namu Atoll",
"MH.350": "Rongelap Atoll",
"MH.360": "Rongrik Atoll",
"MH.385": "Taka Atoll",
"MH.073": "Bokak Atoll",
"MH.390": "Ujae Atoll",
"MH.400": "Ujelang",
"MH.410": "Utrik Atoll",
"MH.420": "Wotho Atoll",
"MH.430": "Wotje Atoll",
"MH.110": "Jabat Island",
"MH.130": "Jemo Island",
"MH.140": "Kili Island",
"MH.170": "Lib Island",
"MH.310": "Mejit Island",
"MK.E9": "Valandovo",
"MK.86": "Resen",
"MK.51": "Kratovo",
"MK.78": "Pehčevo",
"MK.72": "Novo Selo",
"MK.11": "Bosilovo",
"MK.A9": "Vasilevo",
"MK.E5": "Dojran",
"MK.08": "Bogdanci",
"MK.47": "Konče",
"MK.62": "Makedonska Kamenica",
"MK.C6": "Zrnovci",
"MK.40": "Karbinci",
"MK.25": "Demir Kapija",
"MK.87": "Rosoman",
"MK.35": "Gradsko",
"MK.60": "Lozovo",
"MK.19": "Češinovo-Obleševo",
"MK.E1": "Novaci",
"MK.04": "Berovo",
"MK.06": "Bitola",
"MK.D9": "Mogila",
"MK.01": "Aračinovo",
"MK.C7": "Bogovinje",
"MK.12": "Brvenica",
"MK.C8": "Čair",
"MK.C9": "Čaška Municipality",
"MK.D1": "Centar",
"MK.18": "Centar Župa",
"MK.20": "Čučer-Sandevo",
"MK.D2": "Debar",
"MK.22": "Delčevo",
"MK.D3": "Demir Hisar",
"MK.28": "Dolneni",
"MK.29": "Opstina Gjorce Petrov",
"MK.30": "Drugovo",
"MK.32": "Gazi Baba",
"MK.33": "Gevgelija",
"MK.D4": "Gostivar",
"MK.36": "Ilinden",
"MK.D5": "Jegunovce",
"MK.41": "Karpoš",
"MK.D6": "Kavadarci",
"MK.43": "Kičevo",
"MK.44": "Kisela Voda",
"MK.46": "Kočani",
"MK.52": "Kriva Palanka",
"MK.53": "Krivogaštani",
"MK.54": "Kruševo",
"MK.D7": "Kumanovo",
"MK.59": "Opstina Lipkovo",
"MK.D8": "Makedonski Brod",
"MK.69": "Negotino",
"MK.E2": "Ohrid",
"MK.77": "Oslomej",
"MK.79": "Petrovec",
"MK.80": "Plasnica",
"MK.E3": "Prilep",
"MK.83": "Probištip",
"MK.84": "Radoviš",
"MK.85": "Opstina Rankovce",
"MK.E4": "Mavrovo and Rostuša",
"MK.90": "Saraj",
"MK.92": "Sopište",
"MK.97": "Staro Nagoričane",
"MK.98": "Štip",
"MK.E6": "Struga",
"MK.E7": "Strumica",
"MK.A2": "Studeničani",
"MK.A3": "Šuto Orizari",
"MK.A4": "Sveti Nikole",
"MK.A5": "Tearce",
"MK.E8": "Tetovo",
"MK.F1": "Veles",
"MK.B3": "Vevčani",
"MK.B4": "Vinica",
"MK.B6": "Vraneštica",
"MK.B7": "Vrapčište",
"MK.C1": "Zajas",
"MK.C2": "Zelenikovo",
"MK.C3": "Želino",
"MK.F3": "Aerodrom",
"MK.F4": "Butel",
"MK.F5": "Debarca",
"MK.F6": "Grad Skopje",
"ML.08": "Tombouctou",
"ML.06": "Sikasso",
"ML.05": "Ségou",
"ML.04": "Mopti",
"ML.07": "Koulikoro",
"ML.03": "Kayes",
"ML.09": "Gao",
"ML.01": "Bamako",
"ML.10": "Kidal",
"MM.12": "Tanintharyi",
"MM.11": "Shan",
"MM.10": "Sagain",
"MM.17": "Yangon",
"MM.01": "Rakhine",
"MM.16": "Bago",
"MM.13": "Mon",
"MM.08": "Mandalay",
"MM.15": "Magway",
"MM.06": "Kayah",
"MM.05": "Kayin",
"MM.04": "Kachin",
"MM.03": "Ayeyarwady",
"MM.02": "Chin",
"MM.18": "Nay Pyi Taw",
"MN.19": "Uvs",
"MN.12": "Hovd",
"MN.10": "Govĭ-Altay",
"MN.09": "Dzabkhan",
"MN.03": "Bayan-Ölgiy",
"MN.02": "Bayanhongor",
"MN.20": "Ulaanbaatar",
"MN.18": "Central Aimak",
"MN.17": "Sühbaatar",
"MN.16": "Selenge",
"MN.15": "Övörhangay",
"MN.14": "Ömnögovĭ",
"MN.13": "Hövsgöl",
"MN.11": "Hentiy",
"MN.08": "Middle Govĭ",
"MN.07": "East Gobi Aymag",
"MN.06": "East Aimak",
"MN.21": "Bulgan",
"MN.01": "Arhangay",
"MN.23": "Darhan Uul",
"MN.24": "Govĭ-Sumber",
"MN.25": "Orhon",
"MP.100": "Rota",
"MP.110": "Saipan",
"MP.120": "Tinian",
"MP.085": "Northern Islands",
"MQ.MQ": "Martinique",
"MR.06": "Trarza",
"MR.11": "Tiris Zemmour",
"MR.09": "Tagant",
"MR.12": "Inchiri",
"MR.02": "Hodh El Gharbi",
"MR.01": "Hodh ech Chargui",
"MR.10": "Guidimaka",
"MR.04": "Gorgol",
"MR.08": "Dakhlet Nouadhibou",
"MR.05": "Brakna",
"MR.03": "Assaba",
"MR.07": "Adrar",
"MR.13": "Nouakchott Ouest",
"MR.14": "Nouakchott Nord",
"MR.15": "Nouakchott Sud",
"MS.03": "Saint Peter",
"MS.02": "Saint Georges",
"MS.01": "Saint Anthony",
"MT.01": "Attard",
"MT.02": "Balzan",
"MT.03": "Il-Birgu",
"MT.04": "Birkirkara",
"MT.05": "Birżebbuġa",
"MT.06": "Bormla",
"MT.07": "Dingli",
"MT.08": "Il-Fgura",
"MT.09": "Il-Furjana",
"MT.10": "Il-Fontana",
"MT.11": "Għajnsielem",
"MT.12": "L-Għarb",
"MT.13": "Ħal Għargħur",
"MT.14": "L-Għasri",
"MT.15": "Ħal Għaxaq",
"MT.16": "Il-Gudja",
"MT.17": "Il-Gżira",
"MT.18": "Il-Ħamrun",
"MT.19": "L-Iklin",
"MT.20": "L-Imdina",
"MT.21": "L-Imġarr",
"MT.22": "L-Imqabba",
"MT.23": "L-Imsida",
"MT.24": "L-Imtarfa",
"MT.25": "L-Isla",
"MT.26": "Il-Kalkara",
"MT.27": "Ta’ Kerċem",
"MT.28": "Kirkop",
"MT.29": "Lija",
"MT.30": "Luqa",
"MT.31": "Il-Marsa",
"MT.32": "Marsaskala",
"MT.33": "Marsaxlokk",
"MT.34": "Il-Mellieħa",
"MT.35": "Il-Mosta",
"MT.36": "Il-Munxar",
"MT.37": "In-Nadur",
"MT.38": "In-Naxxar",
"MT.39": "Paola",
"MT.40": "Pembroke",
"MT.41": "Tal-Pietà",
"MT.42": "Il-Qala",
"MT.43": "Qormi",
"MT.44": "Il-Qrendi",
"MT.45": "Ir-Rabat",
"MT.46": "Victoria",
"MT.47": "Safi",
"MT.48": "Saint John",
"MT.49": "Saint Julian",
"MT.50": "Saint Lawrence",
"MT.51": "Saint Lucia",
"MT.52": "Saint Paul’s Bay",
"MT.53": "Saint Venera",
"MT.54": "Sannat",
"MT.55": "Is-Siġġiewi",
"MT.56": "Tas-Sliema",
"MT.57": "Is-Swieqi",
"MT.58": "Tarxien",
"MT.59": "Ta’ Xbiex",
"MT.61": "Ix-Xagħra",
"MT.62": "Ix-Xewkija",
"MT.63": "Ix-Xgħajra",
"MT.64": "Ħaż-Żabbar",
"MT.65": "Ħaż-Żebbuġ",
"MT.66": "Iż-Żebbuġ",
"MT.67": "Iż-Żejtun",
"MT.68": "Iż-Żurrieq",
"MT.60": "Il-Belt Valletta",
"MU.21": "Agalega Islands",
"MU.20": "Savanne",
"MU.19": "Rivière du Rempart",
"MU.18": "Port Louis",
"MU.17": "Plaines Wilhems",
"MU.16": "Pamplemousses",
"MU.15": "Moka",
"MU.14": "Grand Port",
"MU.13": "Flacq",
"MU.12": "Black River",
"MU.22": "Cargados Carajos",
"MU.23": "Rodrigues",
"MV.47": "Vaavu Atholhu",
"MV.46": "Thaa Atholhu",
"MV.45": "Shaviyani Atholhu",
"MV.01": "Seenu",
"MV.44": "Raa Atoll",
"MV.43": "Noonu Atoll",
"MV.42": "Gnyaviyani Atoll",
"MV.41": "Meemu Atholhu",
"MV.39": "Lhaviyani Atholhu",
"MV.05": "Laamu",
"MV.38": "Kaafu Atoll",
"MV.37": "Haa Dhaalu Atholhu",
"MV.36": "Haa Alifu Atholhu",
"MV.35": "Gaafu Dhaalu Atholhu",
"MV.34": "Gaafu Alifu Atholhu",
"MV.33": "Faafu Atholhu",
"MV.32": "Dhaalu Atholhu",
"MV.31": "Baa Atholhu",
"MV.30": "Northern Ari Atoll",
"MV.10346475": "Southern Ari Atoll",
"MW.S": "Southern Region",
"MW.N": "Northern Region",
"MW.C": "Central Region",
"MX.31": "Yucatán",
"MX.30": "Veracruz",
"MX.29": "Tlaxcala",
"MX.28": "Tamaulipas",
"MX.27": "Tabasco",
"MX.23": "Quintana Roo",
"MX.22": "Querétaro",
"MX.21": "Puebla",
"MX.20": "Oaxaca",
"MX.19": "Nuevo León",
"MX.17": "Morelos",
"MX.15": "México",
"MX.13": "Hidalgo",
"MX.12": "Guerrero",
"MX.09": "Mexico City",
"MX.05": "Chiapas",
"MX.04": "Campeche",
"MX.32": "Zacatecas",
"MX.26": "Sonora",
"MX.25": "Sinaloa",
"MX.24": "San Luis Potosí",
"MX.18": "Nayarit",
"MX.16": "Michoacán",
"MX.14": "Jalisco",
"MX.11": "Guanajuato",
"MX.10": "Durango",
"MX.08": "Colima",
"MX.07": "Coahuila",
"MX.06": "Chihuahua",
"MX.03": "Baja California Sur",
"MX.02": "Baja California",
"MX.01": "Aguascalientes",
"MY.04": "Melaka",
"MY.13": "Terengganu",
"MY.12": "Selangor",
"MY.11": "Sarawak",
"MY.16": "Sabah",
"MY.08": "Perlis",
"MY.07": "Perak",
"MY.06": "Pahang",
"MY.05": "Negeri Sembilan",
"MY.03": "Kelantan",
"MY.14": "Kuala Lumpur",
"MY.09": "Penang",
"MY.02": "Kedah",
"MY.01": "Johor",
"MY.15": "Labuan",
"MY.17": "Putrajaya",
"MZ.09": "Zambézia",
"MZ.08": "Tete",
"MZ.05": "Sofala",
"MZ.07": "Niassa",
"MZ.06": "Nampula",
"MZ.04": "Maputo",
"MZ.10": "Manica",
"MZ.03": "Inhambane",
"MZ.02": "Gaza",
"MZ.01": "Cabo Delgado",
"MZ.11": "Maputo City",
"NA.28": "Zambezi",
"NA.21": "Khomas",
"NA.29": "Erongo",
"NA.30": "Hardap",
"NA.31": "Karas",
"NA.32": "Kunene",
"NA.33": "Ohangwena",
"NA.35": "Omaheke",
"NA.36": "Omusati",
"NA.37": "Oshana",
"NA.38": "Oshikoto",
"NA.39": "Otjozondjupa",
"NA.40": "Kavango East",
"NA.41": "Kavango West",
"NC.02": "South Province",
"NC.01": "North Province",
"NC.03": "Loyalty Islands",
"NE.07": "Zinder",
"NE.06": "Tahoua",
"NE.04": "Maradi",
"NE.03": "Dosso",
"NE.02": "Diffa",
"NE.01": "Agadez",
"NE.09": "Tillabéri",
"NE.08": "Niamey",
"NG.51": "Sokoto",
"NG.50": "Rivers",
"NG.49": "Plateau",
"NG.32": "Oyo",
"NG.48": "Ondo",
"NG.16": "Ogun",
"NG.31": "Niger",
"NG.05": "Lagos",
"NG.30": "Kwara",
"NG.24": "Katsina",
"NG.29": "Kano",
"NG.23": "Kaduna",
"NG.28": "Imo",
"NG.22": "Cross River",
"NG.27": "Borno",
"NG.26": "Benue",
"NG.46": "Bauchi",
"NG.25": "Anambra",
"NG.21": "Akwa Ibom",
"NG.11": "FCT",
"NG.45": "Abia",
"NG.36": "Delta",
"NG.35": "Adamawa",
"NG.37": "Edo",
"NG.47": "Enugu",
"NG.39": "Jigawa",
"NG.52": "Bayelsa",
"NG.53": "Ebonyi",
"NG.54": "Ekiti",
"NG.55": "Gombe",
"NG.56": "Nassarawa",
"NG.57": "Zamfara",
"NG.40": "Kebbi",
"NG.41": "Kogi",
"NG.42": "Osun",
"NG.43": "Taraba",
"NG.44": "Yobe",
"NI.15": "Rivas",
"NI.14": "Río San Juan",
"NI.13": "Nueva Segovia",
"NI.12": "Matagalpa",
"NI.11": "Masaya",
"NI.10": "Managua",
"NI.09": "Madriz",
"NI.08": "León",
"NI.07": "Jinotega",
"NI.06": "Granada",
"NI.05": "Estelí",
"NI.04": "Chontales",
"NI.03": "Chinandega",
"NI.02": "Carazo",
"NI.01": "Boaco",
"NI.17": "Atlántico Norte (RAAN)",
"NI.18": "Atlántico Sur",
"NL.11": "South Holland",
"NL.10": "Zeeland",
"NL.09": "Utrecht",
"NL.15": "Overijssel",
"NL.07": "North Holland",
"NL.06": "North Brabant",
"NL.05": "Limburg",
"NL.04": "Groningen",
"NL.03": "Gelderland",
"NL.02": "Friesland",
"NL.01": "Drenthe",
"NL.16": "Flevoland",
"NO.05": "Finnmark",
"NO.20": "Vestfold",
"NO.19": "Vest-Agder",
"NO.18": "Troms",
"NO.17": "Telemark",
"NO.16": "Sør-Trøndelag",
"NO.15": "Sogn og Fjordane",
"NO.14": "Rogaland",
"NO.13": "Østfold",
"NO.12": "Oslo",
"NO.11": "Oppland",
"NO.10": "Nord-Trøndelag",
"NO.09": "Nordland",
"NO.08": "Møre og Romsdal",
"NO.07": "Hordaland",
"NO.06": "Hedmark",
"NO.04": "Buskerud",
"NO.02": "Aust-Agder",
"NO.01": "Akershus",
"NP.FR": "Far Western",
"NP.MR": "Mid Western",
"NP.CR": "Central Region",
"NP.ER": "Eastern Region",
"NP.WR": "Western Region",
"NP.00": "",
"NR.14": "Yaren",
"NR.13": "Uaboe",
"NR.12": "Nibok",
"NR.11": "Meneng",
"NR.10": "Ijuw",
"NR.09": "Ewa",
"NR.08": "Denigomodu",
"NR.07": "Buada",
"NR.06": "Boe",
"NR.05": "Baiti",
"NR.04": "Anibare",
"NR.03": "Anetan",
"NR.02": "Anabar",
"NR.01": "Aiwo",
"NZ.G2": "Wellington",
"NZ.F3": "Manawatu-Wanganui",
"NZ.G1": "Waikato",
"NZ.TAS": "Tasman",
"NZ.F9": "Taranaki",
"NZ.F8": "Southland",
"NZ.E8": "Bay of Plenty",
"NZ.F6": "Northland",
"NZ.F4": "Marlborough",
"NZ.F2": "Hawke's Bay",
"NZ.F1": "Gisborne",
"NZ.E9": "Canterbury",
"NZ.E7": "Auckland",
"NZ.10": "Chatham Islands",
"NZ.F5": "Nelson",
"NZ.F7": "Otago",
"NZ.G3": "West Coast",
"OM.01": "Ad Dakhiliyah",
"OM.02": "Al Batinah South",
"OM.03": "Al Wusţá",
"OM.04": "Southeastern Governorate",
"OM.09": "Az̧ Z̧āhirah",
"OM.06": "Muscat",
"OM.07": "Musandam",
"OM.08": "Dhofar",
"OM.10": "Al Buraimi",
"OM.12": "Northeastern Governorate",
"OM.11": "Al Batinah North",
"PA.10": "Veraguas",
"PA.09": "Guna Yala",
"PA.08": "Panamá",
"PA.07": "Los Santos",
"PA.06": "Herrera",
"PA.05": "Darién",
"PA.04": "Colón",
"PA.03": "Coclé",
"PA.02": "Chiriquí",
"PA.01": "Bocas del Toro",
"PA.11": "Emberá",
"PA.12": "Ngöbe-Buglé",
"PA.13": "Panamá Oeste",
"PE.25": "Ucayali",
"PE.24": "Tumbes",
"PE.22": "San Martín",
"PE.20": "Piura",
"PE.16": "Loreto",
"PE.14": "Lambayeque",
"PE.13": "La Libertad",
"PE.10": "Huanuco",
"PE.06": "Cajamarca",
"PE.02": "Ancash",
"PE.01": "Amazonas",
"PE.23": "Tacna",
"PE.21": "Puno",
"PE.19": "Pasco",
"PE.18": "Moquegua",
"PE.17": "Madre de Dios",
"PE.LMA": "Lima",
"PE.15": "Lima region",
"PE.12": "Junin",
"PE.11": "Ica",
"PE.09": "Huancavelica",
"PE.08": "Cusco",
"PE.07": "Callao",
"PE.05": "Ayacucho",
"PE.04": "Arequipa",
"PE.03": "Apurímac",
"PF.04": "Îles Marquises",
"PF.03": "Îles Tuamotu-Gambier",
"PF.02": "Leeward Islands",
"PF.01": "Îles du Vent",
"PF.05": "Îles Australes",
"PG.17": "West New Britain",
"PG.06": "Western Province",
"PG.16": "Western Highlands",
"PG.05": "Southern Highlands",
"PG.18": "Sandaun",
"PG.07": "Bougainville",
"PG.04": "Northern Province",
"PG.15": "New Ireland",
"PG.20": "National Capital",
"PG.14": "Morobe",
"PG.13": "Manus",
"PG.12": "Madang",
"PG.02": "Gulf",
"PG.19": "Enga",
"PG.11": "East Sepik",
"PG.10": "East New Britain",
"PG.09": "Eastern Highlands",
"PG.08": "Chimbu",
"PG.03": "Milne Bay",
"PG.01": "Central Province",
"PG.21": "Hela",
"PG.22": "Jiwaka",
"PH.14": "ARMM",
"PH.10": "Northern Mindanao",
"PH.41": "Mimaropa",
"PH.02": "Cagayan Valley",
"PH.12": "Soccsksargen",
"PH.13": "Caraga",
"PH.15": "Cordillera",
"PH.01": "Ilocos",
"PH.40": "Calabarzon",
"PH.06": "Western Visayas",
"PH.03": "Central Luzon",
"PH.07": "Central Visayas",
"PH.08": "Eastern Visayas",
"PH.09": "Zamboanga Peninsula",
"PH.11": "Davao",
"PH.05": "Bicol",
"PH.NCR": "Metro Manila",
"PH.NIR": "Negros Island Region",
"PK.08": "Islāmābād",
"PK.05": "Sindh",
"PK.04": "Punjab",
"PK.03": "Khyber Pakhtunkhwa",
"PK.07": "Gilgit-Baltistan",
"PK.01": "FATA",
"PK.02": "Balochistān",
"PK.06": "Azad Kashmir",
"PL.75": "Lublin",
"PL.77": "Lesser Poland Voivodeship",
"PL.78": "Mazovia",
"PL.80": "Subcarpathian Voivodeship",
"PL.81": "Podlasie",
"PL.84": "Świętokrzyskie",
"PL.85": "Warmia-Masuria",
"PL.72": "Lower Silesia",
"PL.74": "Łódź Voivodeship",
"PL.76": "Lubusz",
"PL.79": "Opole Voivodeship",
"PL.82": "Pomerania",
"PL.83": "Silesia",
"PL.86": "Greater Poland",
"PL.87": "West Pomerania",
"PL.73": "Kujawsko-Pomorskie",
"PM.97502": "Saint-Pierre",
"PM.97501": "Miquelon-Langlade",
"PR.001": "Adjuntas",
"PR.003": "Aguada",
"PR.005": "Aguadilla",
"PR.007": "Aguas Buenas",
"PR.009": "Aibonito",
"PR.011": "Añasco",
"PR.013": "Arecibo",
"PR.015": "Arroyo",
"PR.017": "Barceloneta",
"PR.019": "Barranquitas",
"PR.021": "Bayamón",
"PR.023": "Cabo Rojo",
"PR.025": "Caguas",
"PR.027": "Camuy",
"PR.029": "Canovanas",
"PR.031": "Carolina",
"PR.033": "Catano",
"PR.035": "Cayey",
"PR.037": "Ceiba",
"PR.039": "Ciales",
"PR.041": "Cidra",
"PR.043": "Coamo",
"PR.045": "Comerio",
"PR.047": "Corozal",
"PR.049": "Culebra",
"PR.051": "Dorado",
"PR.053": "Fajardo",
"PR.054": "Florida",
"PR.055": "Guanica",
"PR.057": "Guayama",
"PR.059": "Guayanilla",
"PR.061": "Guaynabo",
"PR.063": "Gurabo",
"PR.065": "Hatillo",
"PR.067": "Hormigueros",
"PR.069": "Humacao",
"PR.071": "Isabela",
"PR.073": "Municipio de Jayuya",
"PR.075": "Juana Diaz",
"PR.077": "Municipio de Juncos",
"PR.079": "Lajas",
"PR.081": "Lares",
"PR.083": "Las Marias",
"PR.085": "Las Piedras",
"PR.087": "Loiza",
"PR.089": "Luquillo",
"PR.091": "Manati",
"PR.093": "Maricao",
"PR.095": "Maunabo",
"PR.097": "Mayaguez",
"PR.099": "Moca",
"PR.101": "Morovis",
"PR.103": "Naguabo",
"PR.105": "Naranjito",
"PR.107": "Orocovis",
"PR.109": "Patillas",
"PR.111": "Penuelas",
"PR.113": "Ponce",
"PR.117": "Rincon",
"PR.115": "Quebradillas",
"PR.119": "Rio Grande",
"PR.121": "Sabana Grande",
"PR.123": "Salinas",
"PR.125": "San German",
"PR.127": "San Juan",
"PR.129": "San Lorenzo",
"PR.131": "San Sebastian",
"PR.133": "Santa Isabel Municipio",
"PR.135": "Toa Alta",
"PR.137": "Toa Baja",
"PR.139": "Trujillo Alto",
"PR.141": "Utuado",
"PR.143": "Vega Alta",
"PR.145": "Vega Baja",
"PR.149": "Villalba",
"PR.151": "Yabucoa",
"PR.153": "Yauco",
"PR.147": "Vieques",
"PS.GZ": "Gaza Strip",
"PS.WE": "West Bank",
"PT.19": "Setúbal",
"PT.18": "Santarém",
"PT.16": "Portalegre",
"PT.14": "Lisbon",
"PT.13": "Leiria",
"PT.09": "Faro",
"PT.08": "Évora",
"PT.06": "Castelo Branco",
"PT.03": "Beja",
"PT.10": "Madeira",
"PT.22": "Viseu",
"PT.21": "Vila Real",
"PT.20": "Viana do Castelo",
"PT.17": "Porto",
"PT.11": "Guarda",
"PT.07": "Coimbra",
"PT.05": "Bragança",
"PT.04": "Braga",
"PT.02": "Aveiro",
"PT.23": "Azores",
"PW.11": "Ngatpang",
"PW.16": "Sonsorol",
"PW.05": "Kayangel",
"PW.04": "Hatohobei",
"PW.01": "Aimeliik",
"PW.02": "Airai",
"PW.03": "Angaur",
"PW.06": "Koror",
"PW.07": "Melekeok",
"PW.08": "Ngaraard",
"PW.12": "Ngchesar",
"PW.09": "Ngarchelong",
"PW.10": "Ngardmau",
"PW.13": "Ngaremlengui",
"PW.14": "Ngiwal",
"PW.15": "Peleliu",
"PY.17": "San Pedro",
"PY.16": "Presidente Hayes",
"PY.15": "Paraguarí",
"PY.13": "Ñeembucú",
"PY.12": "Misiones",
"PY.11": "Itapúa",
"PY.10": "Guairá",
"PY.08": "Cordillera",
"PY.07": "Concepción",
"PY.06": "Central",
"PY.19": "Canindeyú",
"PY.05": "Caazapá",
"PY.04": "Caaguazú",
"PY.02": "Amambay",
"PY.01": "Alto Paraná",
"PY.23": "Alto Paraguay",
"PY.22": "Asunción",
"PY.24": "Boquerón",
"QA.08": "Madīnat ash Shamāl",
"QA.04": "Al Khawr",
"QA.09": "Baladīyat Umm Şalāl",
"QA.06": "Baladīyat ar Rayyān",
"QA.01": "Baladīyat ad Dawḩah",
"QA.10": "Al Wakrah",
"QA.13": "Baladīyat az̧ Z̧a‘āyin",
"RE.RE": "Réunion",
"RO.40": "Vrancea",
"RO.39": "Vâlcea",
"RO.38": "Vaslui",
"RO.37": "Tulcea",
"RO.36": "Timiş",
"RO.35": "Teleorman",
"RO.34": "Suceava",
"RO.33": "Sibiu",
"RO.32": "Satu Mare",
"RO.31": "Sălaj",
"RO.30": "Prahova",
"RO.29": "Olt",
"RO.28": "Neamţ",
"RO.27": "Mureş",
"RO.26": "Mehedinţi",
"RO.25": "Maramureş",
"RO.23": "Iaşi",
"RO.22": "Ialomiţa",
"RO.21": "Hunedoara",
"RO.20": "Harghita",
"RO.19": "Gorj",
"RO.42": "Giurgiu",
"RO.18": "Galaţi",
"RO.17": "Dolj",
"RO.16": "Dâmboviţa",
"RO.15": "Covasna",
"RO.14": "Constanța",
"RO.13": "Cluj",
"RO.12": "Caraş-Severin",
"RO.41": "Călăraşi",
"RO.11": "Buzău",
"RO.10": "Bucureşti",
"RO.09": "Braşov",
"RO.08": "Brăila",
"RO.07": "Botoşani",
"RO.06": "Bistriţa-Năsăud",
"RO.05": "Bihor",
"RO.04": "Bacău",
"RO.03": "Argeş",
"RO.02": "Arad",
"RO.01": "Alba",
"RO.43": "Ilfov",
"RS.VO": "Vojvodina",
"RS.SE": "Central Serbia",
"RU.88": "Jaroslavl",
"RU.86": "Voronezj",
"RU.85": "Vologda",
"RU.84": "Volgograd",
"RU.81": "Ulyanovsk",
"RU.80": "Udmurtiya",
"RU.77": "Tverskaya",
"RU.76": "Tula",
"RU.73": "Tatarstan",
"RU.72": "Tambov",
"RU.70": "Stavropol'skiy",
"RU.69": "Smolensk",
"RU.67": "Saratov",
"RU.65": "Samara",
"RU.62": "Rjazan",
"RU.61": "Rostov",
"RU.60": "Pskov",
"RU.90": "Perm",
"RU.57": "Penza",
"RU.56": "Orjol",
"RU.55": "Orenburg",
"RU.52": "Novgorod",
"RU.68": "North Ossetia",
"RU.50": "Nenets",
"RU.49": "Murmansk",
"RU.48": "Moscow",
"RU.47": "Moscow Oblast",
"RU.46": "Mordoviya",
"RU.45": "Mariy-El",
"RU.43": "Lipetsk",
"RU.42": "Leningradskaya Oblast'",
"RU.66": "St.-Petersburg",
"RU.41": "Kursk",
"RU.38": "Krasnodarskiy",
"RU.37": "Kostroma",
"RU.34": "Komi",
"RU.33": "Kirov",
"RU.28": "Karelia",
"RU.27": "Karachayevo-Cherkesiya",
"RU.25": "Kaluga",
"RU.24": "Kalmykiya",
"RU.23": "Kaliningrad",
"RU.22": "Kabardino-Balkariya",
"RU.21": "Ivanovo",
"RU.19": "Ingushetiya",
"RU.51": "Nizjnij Novgorod",
"RU.17": "Dagestan",
"RU.16": "Chuvashia",
"RU.12": "Chechnya",
"RU.10": "Brjansk",
"RU.09": "Belgorod",
"RU.08": "Bashkortostan",
"RU.07": "Astrakhan",
"RU.06": "Arkhangelskaya",
"RU.01": "Adygeya",
"RU.83": "Vladimir",
"RU.87": "Yamalo-Nenets",
"RU.78": "Tyumenskaya",
"RU.79": "Republic of Tyva",
"RU.75": "Tomsk",
"RU.71": "Sverdlovsk",
"RU.54": "Omsk",
"RU.53": "Novosibirsk",
"RU.40": "Kurgan",
"RU.91": "Krasnoyarskiy",
"RU.32": "Khanty-Mansia",
"RU.31": "Khakasiya",
"RU.29": "Kemerovo",
"RU.03": "Altai",
"RU.13": "Chelyabinsk",
"RU.04": "Altai Krai",
"RU.63": "Chukot",
"RU.59": "Primorskiy",
"RU.30": "Khabarovsk",
"RU.20": "Irkutsk",
"RU.89": "Jewish Autonomous Oblast",
"RU.05": "Amur",
"RU.11": "Respublika Buryatiya",
"RU.64": "Sakhalin",
"RU.44": "Magadan",
"RU.92": "Kamtsjatka",
"RU.15": "Chukotka",
"RU.93": "Transbaikal Territory",
"RW.11": "Eastern Province",
"RW.12": "Kigali",
"RW.13": "Northern Province",
"RW.14": "Western Province",
"RW.15": "Southern Province",
"SA.19": "Tabuk",
"SA.16": "Najran",
"SA.14": "Makkah",
"SA.17": "Jizan",
"SA.13": "Ḩāʼil",
"SA.11": "'Asir",
"SA.06": "Eastern Province",
"SA.10": "Ar Riyāḑ",
"SA.08": "Al-Qassim",
"SA.05": "Al Madīnah al Munawwarah",
"SA.20": "Al Jawf",
"SA.15": "Northern Borders",
"SA.02": "Al Bahah",
"SB.11": "Western Province",
"SB.03": "Malaita",
"SB.07": "Isabel",
"SB.06": "Guadalcanal",
"SB.10": "Central Province",
"SB.09": "Temotu",
"SB.08": "Makira",
"SB.12": "Choiseul",
"SB.13": "Rennell and Bellona",
"SB.14": "Honiara",
"SC.23": "Takamaka",
"SC.22": "Saint Louis",
"SC.27": "Port Glaud",
"SC.20": "Pointe Larue",
"SC.19": "Plaisance",
"SC.18": "Mont Fleuri",
"SC.17": "Mont Buxton",
"SC.26": "English River",
"SC.25": "Inner Islands",
"SC.24": "Grand Anse Mahe",
"SC.14": "Grand Anse Praslin",
"SC.12": "Glacis",
"SC.11": "Cascade",
"SC.10": "Bel Ombre",
"SC.09": "Bel Air",
"SC.08": "Beau Vallon",
"SC.07": "Baie Sainte Anne",
"SC.06": "Baie Lazare",
"SC.05": "Anse Royale",
"SC.03": "Anse Etoile",
"SC.02": "Anse Boileau",
"SC.01": "Anse-aux-Pins",
"SC.29": "Les Mamelles",
"SC.30": "Roche Caiman",
"SC.28": "Au Cap",
"SD.43": "Northern State",
"SD.29": "Khartoum",
"SD.36": "Red Sea",
"SD.38": "Al Jazīrah",
"SD.39": "Al Qaḑārif",
"SD.41": "White Nile",
"SD.42": "Blue Nile",
"SD.47": "Western Darfur",
"SD.62": "West Kordofan State",
"SD.49": "Southern Darfur",
"SD.50": "Southern Kordofan",
"SD.52": "Kassala",
"SD.53": "River Nile",
"SD.55": "Northern Darfur",
"SD.56": "North Kordofan",
"SD.58": "Sinnār",
"SD.60": "Eastern Darfur",
"SD.61": "Central Darfur",
"SE.14": "Norrbotten",
"SE.25": "Västmanland",
"SE.24": "Västernorrland",
"SE.23": "Västerbotten",
"SE.22": "Värmland",
"SE.21": "Uppsala",
"SE.26": "Stockholm",
"SE.18": "Södermanland",
"SE.16": "Östergötland",
"SE.15": "Örebro",
"SE.12": "Kronoberg",
"SE.10": "Dalarna",
"SE.09": "Kalmar",
"SE.08": "Jönköping",
"SE.07": "Jämtland",
"SE.06": "Halland",
"SE.05": "Gotland",
"SE.03": "Gävleborg",
"SE.02": "Blekinge",
"SE.27": "Skåne",
"SE.28": "Västra Götaland",
"SG.01": "Central Singapore",
"SG.02": "North East",
"SG.04": "South East",
"SG.05": "South West",
"SG.03": "North West",
"SH.01": "Ascension",
"SH.03": "Tristan da Cunha",
"SH.02": "Saint Helena",
"SI.N5": "Žalec",
"SI.E7": "Zagorje ob Savi",
"SI.E5": "Vrhnika",
"SI.D5": "Tržič",
"SI.D4": "Trebnje",
"SI.D3": "Trbovlje",
"SI.D2": "Tolmin",
"SI.D7": "Velenje",
"SI.C5": "Šmarje pri Jelšah",
"SI.C4": "Slovenska Konjice",
"SI.L8": "Slovenska Bistrica",
"SI.C2": "Slovenj Gradec",
"SI.B9": "Škofja Loka",
"SI.B7": "Sežana",
"SI.B6": "Sevnica",
"SI.L7": "Sentjur",
"SI.L1": "Ribnica",
"SI.A3": "Radovljica",
"SI.A2": "Radlje ob Dravi",
"SI.K7": "Ptuj",
"SI.94": "Postojna",
"SI.J9": "Piran-Pirano",
"SI.87": "Ormož",
"SI.J7": "Novo Mesto",
"SI.84": "Nova Gorica",
"SI.80": "Murska Sobota",
"SI.79": "Mozirje",
"SI.73": "Metlika",
"SI.J2": "Maribor",
"SI.64": "Logatec",
"SI.I6": "Ljutomer",
"SI.I5": "Litija",
"SI.I3": "Lenart",
"SI.57": "Laško",
"SI.54": "Krško",
"SI.52": "Kranj",
"SI.50": "Koper-Capodistria",
"SI.H7": "Kočevje",
"SI.H6": "Kamnik",
"SI.H4": "Jesenice",
"SI.40": "Izola-Isola",
"SI.38": "Ilirska Bistrica",
"SI.36": "Idrija",
"SI.34": "Hrastnik",
"SI.32": "Grosuplje",
"SI.29": "Gornja Radgona",
"SI.25": "Dravograd",
"SI.G7": "Domžale",
"SI.17": "Črnomelj",
"SI.13": "Cerknica",
"SI.11": "Celje",
"SI.08": "Brežice",
"SI.01": "Ajdovščina",
"SI.35": "Hrpelje-Kozina",
"SI.19": "Divača",
"SI.91": "Pivka",
"SI.I7": "Loška Dolina",
"SI.66": "Loški Potok",
"SI.88": "Osilnica",
"SI.D8": "Velike Lašče",
"SI.C1": "Škofljica",
"SI.37": "Ig",
"SI.09": "Brezovica",
"SI.05": "Borovnica",
"SI.E1": "Vipava",
"SI.49": "Komen",
"SI.J5": "Miren-Kostanjevica",
"SI.07": "Brda",
"SI.44": "Kanal",
"SI.F2": "Žiri",
"SI.14": "Cerkno",
"SI.F1": "Železniki",
"SI.27": "Gorenja Vas-Poljane",
"SI.G4": "Dobrova-Horjul-Polhov Gradec",
"SI.46": "Kobarid",
"SI.06": "Bovec",
"SI.04": "Bohinj",
"SI.03": "Bled",
"SI.82": "Naklo",
"SI.53": "Kranjska Gora",
"SI.K5": "Preddvor",
"SI.12": "Cerklje na Gorenjskem",
"SI.B2": "Šenčur",
"SI.E3": "Vodice",
"SI.71": "Medvode",
"SI.72": "Mengeš",
"SI.22": "Dol pri Ljubljani",
"SI.77": "Moravče",
"SI.30": "Gornji Grad",
"SI.I9": "Luče",
"SI.K8": "Ravne na Koroškem",
"SI.74": "Mežica",
"SI.81": "Muta",
"SI.E6": "Vuzenica",
"SI.16": "Črna na Koroškem",
"SI.62": "Ljubno",
"SI.C7": "Šoštanj",
"SI.C6": "Šmartno ob Paki",
"SI.68": "Lukovica",
"SI.99": "Radeče",
"SI.39": "Ivančna Gorica",
"SI.20": "Dobrepolje",
"SI.B1": "Semič",
"SI.B4": "Šentjernej",
"SI.B8": "Škocjan",
"SI.C9": "Štore",
"SI.N3": "Vojnik",
"SI.E2": "Vitanje",
"SI.F3": "Zreče",
"SI.76": "Mislinja",
"SI.L3": "Ruše",
"SI.55": "Kungota",
"SI.B3": "Šentilj",
"SI.89": "Pesnica",
"SI.26": "Duplek",
"SI.98": "Rače-Fram",
"SI.C8": "Starše",
"SI.45": "Kidričevo",
"SI.J1": "Majšperk",
"SI.N2": "Videm",
"SI.A7": "Rogaška Slatina",
"SI.A8": "Rogatec",
"SI.92": "Podčetrtek",
"SI.51": "Kozje",
"SI.28": "Gorišnica",
"SI.E9": "Zavrč",
"SI.24": "Dornava",
"SI.42": "Juršinci",
"SI.D1": "Sveti Jurij",
"SI.A1": "Radenci",
"SI.97": "Puconci",
"SI.A6": "Rogašovci",
"SI.I2": "Kuzma",
"SI.31": "Gornji Petrovci",
"SI.78": "Moravske Toplice",
"SI.47": "Kobilje",
"SI.02": "Beltinci",
"SI.D6": "Turnišče",
"SI.86": "Odranci",
"SI.15": "Črenšovci",
"SI.83": "Nazarje",
"SI.61": "Ljubljana",
"SI.N7": "Žirovnica",
"SI.H5": "Jezersko",
"SI.M2": "Solčava",
"SI.H8": "Komenda",
"SI.H3": "Horjul",
"SI.L6": "Šempeter-Vrtojba",
"SI.F6": "Bloke",
"SI.M1": "Sodražica",
"SI.M8": "Trzin",
"SI.K6": "Prevalje",
"SI.N4": "Vransko",
"SI.M5": "Tabor",
"SI.F7": "Braslovče",
"SI.K3": "Polzela",
"SI.K4": "Prebold",
"SI.H9": "Kostel",
"SI.N8": "Žužemberk",
"SI.G6": "Dolenjske Toplice",
"SI.J6": "Mirna Peč",
"SI.F5": "Bistrica ob Sotli",
"SI.G2": "Dobje",
"SI.G3": "Dobrna",
"SI.J8": "Oplotnica",
"SI.K2": "Podvelka",
"SI.L2": "Ribnica na Pohorju",
"SI.I8": "Lovrenc na Pohorju",
"SI.L5": "Selnica ob Dravi",
"SI.H1": "Hoče-Slivnica",
"SI.J4": "Miklavž na Dravskem Polju",
"SI.G9": "Hajdina",
"SI.N6": "Žetale",
"SI.K1": "Podlehnik",
"SI.J3": "Markovci",
"SI.G1": "Destrnik",
"SI.M7": "Trnovska Vas",
"SI.M4": "Sveti Andraž v Slovenskih Goricah",
"SI.F9": "Cerkvenjak",
"SI.F4": "Benedikt",
"SI.M3": "Sveta Ana",
"SI.I1": "Križevci",
"SI.N1": "Veržej",
"SI.M9": "Velika Polana",
"SI.I4": "Lendava-Lendva",
"SI.G5": "Dobrovnik-Dobronak",
"SI.M6": "Tišina",
"SI.F8": "Cankova",
"SI.G8": "Grad",
"SI.H2": "Hodoš-Hodos",
"SI.K9": "Razkrižje",
"SI.L9": "Šmartno pri Litiji",
"SI.L4": "Šalovci",
"SI.N9": "Apače",
"SI.O1": "Cirkulane",
"SI.O3": "Kostanjevica na Krki",
"SI.O4": "Log–Dragomer",
"SI.O5": "Makole",
"SI.O7": "Mokronog-Trebelno",
"SI.O8": "Poljčane",
"SI.O9": "Rečica ob Savinji",
"SI.P1": "Renče-Vogrsko",
"SI.P4": "Središče ob Dravi",
"SI.P5": "Straža",
"SI.P6": "Sv. Trojica v Slov. Goricah",
"SI.P8": "Sveti Tomaž",
"SI.P2": "Šentrupert",
"SI.P3": "Šmarješke Toplice",
"SI.P7": "Sveti Jurij v Slovenskih Goricah",
"SI.O2": "Gorje",
"SI.P9": "Comune di Ancarano",
"SI.O6": "Mirna",
"SJ.22": "Jan Mayen",
"SJ.21": "Svalbard",
"SK.03": "Košický",
"SK.05": "Prešovský",
"SK.08": "Žilinský",
"SK.01": "Banskobystrický",
"SK.02": "Bratislavský",
"SK.04": "Nitriansky",
"SK.06": "Trenčiansky",
"SK.07": "Trnavský",
"SL.04": "Western Area",
"SL.03": "Southern Province",
"SL.02": "Northern Province",
"SL.01": "Eastern Province",
"SM.09": "Serravalle",
"SM.02": "Chiesanuova",
"SM.07": "San Marino",
"SM.01": "Acquaviva",
"SM.06": "Borgo Maggiore",
"SM.03": "Domagnano",
"SM.04": "Faetano",
"SM.05": "Fiorentino",
"SM.08": "Montegiardino",
"SN.12": "Ziguinchor",
"SN.07": "Thiès",
"SN.05": "Tambacounda",
"SN.14": "Saint-Louis",
"SN.15": "Matam",
"SN.13": "Louga",
"SN.11": "Kolda",
"SN.10": "Kaolack",
"SN.09": "Fatick",
"SN.03": "Diourbel",
"SN.01": "Dakar",
"SN.16": "Kaffrine",
"SN.17": "Kédougou",
"SN.18": "Sédhiou",
"SO.20": "Woqooyi Galbeed",
"SO.19": "Togdheer",
"SO.14": "Lower Shabeelle",
"SO.13": "Middle Shabele",
"SO.12": "Sanaag",
"SO.18": "Nugaal",
"SO.10": "Mudug",
"SO.09": "Lower Juba",
"SO.08": "Middle Juba",
"SO.07": "Hiiraan",
"SO.06": "Gedo",
"SO.05": "Galguduud",
"SO.04": "Bay",
"SO.03": "Bari",
"SO.02": "Banaadir",
"SO.01": "Bakool",
"SO.21": "Awdal",
"SO.22": "Sool",
"SR.19": "Wanica",
"SR.18": "Sipaliwini",
"SR.17": "Saramacca",
"SR.16": "Paramaribo",
"SR.15": "Para",
"SR.14": "Nickerie",
"SR.13": "Marowijne",
"SR.12": "Coronie",
"SR.11": "Commewijne",
"SR.10": "Brokopondo",
"SS.07": "Upper Nile",
"SS.04": "Lakes",
"SS.06": "Unity",
"SS.01": "Central Equatoria",
"SS.10": "Western Equatoria",
"SS.09": "Western Bahr al Ghazal",
"SS.03": "Jonglei",
"SS.05": "Northern Bahr al Ghazal",
"SS.02": "Eastern Equatoria",
"SS.08": "Warrap",
"ST.02": "São Tomé Island",
"ST.01": "Príncipe",
"SV.14": "Usulután",
"SV.13": "Sonsonate",
"SV.12": "San Vicente",
"SV.11": "Santa Ana",
"SV.10": "San Salvador",
"SV.09": "San Miguel",
"SV.08": "Morazán",
"SV.07": "La Unión",
"SV.06": "La Paz",
"SV.05": "La Libertad",
"SV.04": "Cuscatlán",
"SV.03": "Chalatenango",
"SV.02": "Cabañas",
"SV.01": "Ahuachapán",
"SY.14": "Tartus",
"SY.13": "Dimashq",
"SY.12": "Idlib",
"SY.11": "Homs",
"SY.10": "Hama",
"SY.09": "Aleppo",
"SY.08": "Rif-dimashq",
"SY.07": "Deir ez-Zor",
"SY.06": "Daraa",
"SY.05": "As-Suwayda",
"SY.04": "Ar-Raqqah",
"SY.03": "Quneitra",
"SY.02": "Latakia",
"SY.01": "Al-Hasakah",
"SZ.04": "Shiselweni",
"SZ.03": "Manzini",
"SZ.02": "Lubombo",
"SZ.01": "Hhohho",
"TD.13": "Salamat",
"TD.12": "Ouadaï",
"TD.02": "Wadi Fira",
"TD.14": "Tandjilé",
"TD.17": "Moyen-Chari",
"TD.16": "Mayo-Kebbi Est",
"TD.09": "Logone Oriental",
"TD.08": "Logone Occidental",
"TD.07": "Lac",
"TD.06": "Kanem",
"TD.05": "Guéra",
"TD.15": "Chari-Baguirmi",
"TD.01": "Batha",
"TD.23": "Borkou",
"TD.18": "Hadjer-Lamis",
"TD.19": "Mandoul",
"TD.20": "Mayo-Kebbi Ouest",
"TD.21": "N’Djaména",
"TD.22": "Barh el Gazel",
"TD.25": "Sila",
"TD.26": "Tibesti",
"TD.28": "Ennedi-Ouest",
"TD.27": "Ennedi-Est",
"TF.02": "Crozet",
"TF.03": "Kerguelen",
"TF.01": "Saint-Paul-et-Amsterdam",
"TF.05": "Îles Éparses",
"TF.04": "Terre-Adélie",
"TG.26": "Savanes",
"TG.25": "Plateaux",
"TG.24": "Maritime",
"TG.22": "Centrale",
"TG.23": "Kara",
"TH.15": "Uthai Thani",
"TH.65": "Trang",
"TH.08": "Tak",
"TH.60": "Surat Thani",
"TH.09": "Sukhothai",
"TH.52": "Ratchaburi",
"TH.59": "Ranong",
"TH.57": "Prachuap Khiri Khan",
"TH.62": "Phuket",
"TH.56": "Phetchaburi",
"TH.61": "Phangnga",
"TH.01": "Mae Hong Son",
"TH.05": "Lamphun",
"TH.06": "Lampang",
"TH.63": "Krabi",
"TH.50": "Kanchanaburi",
"TH.11": "Kamphaeng Phet",
"TH.58": "Chumphon",
"TH.03": "Chiang Rai",
"TH.02": "Chiang Mai",
"TH.72": "Yasothon",
"TH.70": "Yala",
"TH.10": "Uttaradit",
"TH.49": "Trat",
"TH.29": "Surin",
"TH.51": "Suphan Buri",
"TH.68": "Songkhla",
"TH.30": "Sisaket",
"TH.33": "Sing Buri",
"TH.67": "Satun",
"TH.37": "Sara Buri",
"TH.54": "Samut Songkhram",
"TH.55": "Samut Sakhon",
"TH.42": "Samut Prakan",
"TH.20": "Sakon Nakhon",
"TH.25": "Roi Et",
"TH.47": "Rayong",
"TH.36": "Phra Nakhon Si Ayutthaya",
"TH.07": "Phrae",
"TH.12": "Phitsanulok",
"TH.13": "Phichit",
"TH.14": "Phetchabun",
"TH.41": "Phayao",
"TH.66": "Phatthalung",
"TH.69": "Pattani",
"TH.39": "Pathum Thani",
"TH.38": "Nonthaburi",
"TH.17": "Nong Khai",
"TH.31": "Narathiwat",
"TH.04": "Nan",
"TH.64": "Nakhon Si Thammarat",
"TH.16": "Nakhon Sawan",
"TH.27": "Nakhon Ratchasima",
"TH.73": "Nakhon Phanom",
"TH.53": "Nakhon Pathom",
"TH.43": "Nakhon Nayok",
"TH.78": "Mukdahan",
"TH.24": "Maha Sarakham",
"TH.34": "Lop Buri",
"TH.18": "Loei",
"TH.40": "Bangkok",
"TH.22": "Khon Kaen",
"TH.23": "Kalasin",
"TH.46": "Chon Buri",
"TH.48": "Chanthaburi",
"TH.26": "Chaiyaphum",
"TH.32": "Chai Nat",
"TH.44": "Chachoengsao",
"TH.28": "Buriram",
"TH.35": "Ang Thong",
"TH.76": "Changwat Udon Thani",
"TH.74": "Prachin Buri",
"TH.75": "Changwat Ubon Ratchathani",
"TH.77": "Amnat Charoen",
"TH.79": "Changwat Nong Bua Lamphu",
"TH.80": "Sa Kaeo",
"TH.81": "Changwat Bueng Kan",
"TJ.03": "Viloyati Sughd",
"TJ.01": "Gorno-Badakhshan",
"TJ.02": "Khatlon",
"TJ.RR": "Republican Subordination",
"TJ.04": "Dushanbe",
"TK.N": "Nukunonu",
"TK.F": "Fakaofo",
"TK.A": "Atafu",
"TL.VI": "Viqueque",
"TL.MF": "Manufahi",
"TL.MT": "Manatuto",
"TL.LI": "Liquiçá",
"TL.LA": "Lautém",
"TL.CO": "Cova Lima",
"TL.ER": "Ermera",
"TL.DI": "Díli",
"TL.BO": "Bobonaro",
"TL.BA": "Baucau",
"TL.OE": "Oecusse",
"TL.AN": "Ainaro",
"TL.AL": "Aileu",
"TM.02": "Balkan",
"TM.01": "Ahal",
"TM.S": "Ashgabat",
"TM.03": "Daşoguz",
"TM.05": "Mary",
"TM.04": "Lebap",
"TN.37": "Zaghwān",
"TN.36": "Tūnis",
"TN.35": "Tawzar",
"TN.34": "Tataouine",
"TN.23": "Sūsah",
"TN.22": "Silyānah",
"TN.33": "Sīdī Bū Zayd",
"TN.32": "Şafāqis",
"TN.31": "Qibilī",
"TN.30": "Gafsa",
"TN.29": "Qābis",
"TN.19": "Nābul",
"TN.28": "Madanīn",
"TN.06": "Jundūbah",
"TN.27": "Bin ‘Arūs",
"TN.18": "Banzart",
"TN.17": "Bājah",
"TN.38": "Ariana",
"TN.03": "Al Qayrawān",
"TN.02": "Al Qaşrayn",
"TN.16": "Al Munastīr",
"TN.15": "Al Mahdīyah",
"TN.14": "Kef",
"TN.39": "Manouba",
"TO.03": "Vava‘u",
"TO.02": "Tongatapu",
"TO.01": "Ha‘apai",
"TO.EU": "ʻEua",
"TO.NI": "Niuas",
"TR.66": "Yozgat",
"TR.65": "Van",
"TR.64": "Uşak",
"TR.63": "Şanlıurfa",
"TR.62": "Tunceli",
"TR.58": "Sivas",
"TR.74": "Siirt",
"TR.73": "Niğde",
"TR.50": "Nevşehir",
"TR.49": "Muş",
"TR.48": "Muğla",
"TR.72": "Mardin",
"TR.45": "Manisa",
"TR.44": "Malatya",
"TR.43": "Kütahya",
"TR.71": "Konya",
"TR.40": "Kırşehir",
"TR.38": "Kayseri",
"TR.46": "Kahramanmaraş",
"TR.35": "İzmir",
"TR.33": "Isparta",
"TR.32": "Mersin",
"TR.31": "Hatay",
"TR.70": "Hakkâri",
"TR.83": "Gaziantep",
"TR.26": "Eskişehir",
"TR.25": "Erzurum",
"TR.24": "Erzincan",
"TR.23": "Elazığ",
"TR.21": "Diyarbakır",
"TR.20": "Denizli",
"TR.15": "Burdur",
"TR.13": "Bitlis",
"TR.12": "Bingöl",
"TR.11": "Bilecik",
"TR.10": "Balıkesir",
"TR.09": "Aydın",
"TR.07": "Antalya",
"TR.68": "Ankara",
"TR.04": "Ağrı",
"TR.03": "Afyonkarahisar",
"TR.02": "Adıyaman",
"TR.81": "Adana",
"TR.91": "Osmaniye",
"TR.88": "Iğdır",
"TR.75": "Aksaray",
"TR.76": "Batman",
"TR.78": "Karaman",
"TR.79": "Kırıkkale",
"TR.80": "Şırnak",
"TR.90": "Kilis",
"TR.85": "Zonguldak",
"TR.61": "Trabzon",
"TR.60": "Tokat",
"TR.59": "Tekirdağ",
"TR.57": "Sinop",
"TR.55": "Samsun",
"TR.54": "Sakarya",
"TR.53": "Rize",
"TR.52": "Ordu",
"TR.41": "Kocaeli",
"TR.39": "Kırklareli",
"TR.37": "Kastamonu",
"TR.84": "Kars",
"TR.34": "Istanbul",
"TR.69": "Gümüşhane",
"TR.28": "Giresun",
"TR.22": "Edirne",
"TR.19": "Çorum",
"TR.82": "Çankırı",
"TR.17": "Canakkale",
"TR.16": "Bursa",
"TR.14": "Bolu",
"TR.08": "Artvin",
"TR.05": "Amasya",
"TR.87": "Bartın",
"TR.89": "Karabük",
"TR.92": "Yalova",
"TR.86": "Ardahan",
"TR.77": "Bayburt",
"TR.93": "Düzce",
"TT.11": "Tobago",
"TT.10": "City of San Fernando",
"TT.05": "City of Port of Spain",
"TT.03": "Mayaro",
"TT.01": "Borough of Arima",
"TT.CHA": "Chaguanas",
"TT.CTT": "Couva-Tabaquite-Talparo",
"TT.DMN": "Diego Martin",
"TT.PED": "Penal/Debe",
"TT.PRT": "Princes Town",
"TT.PTF": "Point Fortin",
"TT.SGE": "Sangre Grande",
"TT.SIP": "Siparia",
"TT.SJL": "San Juan/Laventille",
"TT.TUP": "Tunapuna/Piarco",
"TV.NUI": "Nui",
"TV.NMA": "Nanumea",
"TV.FUN": "Funafuti",
"TV.NIT": "Niutao",
"TV.NMG": "Nanumanga",
"TV.VAI": "Vaitupu",
"TV.NKF": "Nukufetau",
"TV.NKL": "Nukulaelae",
"TW.01": "Fukien",
"TW.02": "Takao",
"TW.03": "Taipei",
"TW.04": "Taiwan",
"TZ.19": "Kagera",
"TZ.25": "Zanzibar Urban/West",
"TZ.22": "Zanzibar North",
"TZ.21": "Zanzibar Central/South",
"TZ.18": "Tanga",
"TZ.17": "Tabora",
"TZ.16": "Singida",
"TZ.15": "Shinyanga",
"TZ.24": "Rukwa",
"TZ.02": "Pwani",
"TZ.20": "Pemba South",
"TZ.13": "Pemba North",
"TZ.12": "Mwanza",
"TZ.10": "Morogoro",
"TZ.09": "Mbeya",
"TZ.08": "Mara",
"TZ.07": "Lindi",
"TZ.06": "Kilimanjaro",
"TZ.05": "Kigoma",
"TZ.04": "Iringa",
"TZ.03": "Dodoma",
"TZ.23": "Dar es Salaam",
"TZ.26": "Arusha",
"TZ.27": "Manyara",
"TZ.14": "Ruvuma",
"TZ.11": "Mtwara",
"TZ.31": "Simiyu",
"TZ.28": "Geita",
"TZ.29": "Katavi",
"TZ.30": "Njombe",
"UA.27": "Zhytomyr",
"UA.26": "Zaporizhia",
"UA.25": "Transcarpathia",
"UA.24": "Volyn",
"UA.23": "Vinnyts'ka",
"UA.22": "Ternopil",
"UA.21": "Sumy",
"UA.20": "Gorod Sevastopol",
"UA.19": "Rivne",
"UA.18": "Poltava",
"UA.17": "Odessa",
"UA.16": "Mykolaiv",
"UA.15": "Lviv",
"UA.14": "Luhansk",
"UA.13": "Kiev",
"UA.12": "Kyiv City",
"UA.11": "Republic of Crimea",
"UA.10": "Kirovohrad",
"UA.09": "Khmelnytskyi",
"UA.08": "Kherson",
"UA.07": "Kharkiv",
"UA.06": "Ivano-Frankivsk",
"UA.05": "Donetsk",
"UA.04": "Dnipropetrovsk",
"UA.03": "Chernivtsi",
"UA.02": "Chernihiv",
"UA.01": "Cherkasy",
"UG.C": "Central Region",
"UG.E": "Eastern Region",
"UG.N": "Northern Region",
"UG.W": "Western Region",
"UM.450": "Wake Island",
"UM.350": "Navassa Island",
"UM.050": "Baker Island",
"UM.100": "Howland Island",
"UM.150": "Jarvis Island",
"UM.200": "Johnston Atoll",
"UM.250": "Kingman Reef",
"UM.300": "Midway Islands",
"UM.400": "Palmyra Atoll",
"US.AR": "Arkansas",
"US.DC": "Washington, D.C.",
"US.DE": "Delaware",
"US.FL": "Florida",
"US.GA": "Georgia",
"US.KS": "Kansas",
"US.LA": "Louisiana",
"US.MD": "Maryland",
"US.MO": "Missouri",
"US.MS": "Mississippi",
"US.NC": "North Carolina",
"US.OK": "Oklahoma",
"US.SC": "South Carolina",
"US.TN": "Tennessee",
"US.TX": "Texas",
"US.WV": "West Virginia",
"US.AL": "Alabama",
"US.CT": "Connecticut",
"US.IA": "Iowa",
"US.IL": "Illinois",
"US.IN": "Indiana",
"US.ME": "Maine",
"US.MI": "Michigan",
"US.MN": "Minnesota",
"US.NE": "Nebraska",
"US.NH": "New Hampshire",
"US.NJ": "New Jersey",
"US.NY": "New York",
"US.OH": "Ohio",
"US.RI": "Rhode Island",
"US.VT": "Vermont",
"US.WI": "Wisconsin",
"US.CA": "California",
"US.CO": "Colorado",
"US.NM": "New Mexico",
"US.NV": "Nevada",
"US.UT": "Utah",
"US.AZ": "Arizona",
"US.ID": "Idaho",
"US.MT": "Montana",
"US.ND": "North Dakota",
"US.OR": "Oregon",
"US.SD": "South Dakota",
"US.WA": "Washington",
"US.WY": "Wyoming",
"US.HI": "Hawaii",
"US.AK": "Alaska",
"US.KY": "Kentucky",
"US.MA": "Massachusetts",
"US.PA": "Pennsylvania",
"US.VA": "Virginia",
"UY.19": "Treinta y Tres",
"UY.18": "Tacuarembó",
"UY.17": "Soriano",
"UY.16": "San José",
"UY.15": "Salto",
"UY.14": "Rocha",
"UY.13": "Rivera",
"UY.12": "Río Negro",
"UY.11": "Paysandú",
"UY.10": "Montevideo",
"UY.09": "Maldonado",
"UY.08": "Lavalleja",
"UY.07": "Florida",
"UY.06": "Flores",
"UY.05": "Durazno",
"UY.04": "Colonia",
"UY.03": "Cerro Largo",
"UY.02": "Canelones",
"UY.01": "Artigas",
"UZ.09": "Karakalpakstan",
"UZ.12": "Surxondaryo",
"UZ.10": "Samarqand",
"UZ.08": "Qashqadaryo",
"UZ.02": "Bukhara",
"UZ.14": "Toshkent",
"UZ.13": "Toshkent Shahri",
"UZ.16": "Sirdaryo",
"UZ.07": "Navoiy",
"UZ.06": "Namangan",
"UZ.05": "Xorazm",
"UZ.15": "Jizzax",
"UZ.03": "Fergana",
"UZ.01": "Andijon",
"VC.05": "Saint Patrick",
"VC.04": "Saint George",
"VC.03": "Saint David",
"VC.02": "Saint Andrew",
"VC.06": "Grenadines",
"VC.01": "Charlotte",
"VE.23": "Zulia",
"VE.22": "Yaracuy",
"VE.21": "Trujillo",
"VE.20": "Táchira",
"VE.19": "Sucre",
"VE.18": "Portuguesa",
"VE.17": "Nueva Esparta",
"VE.16": "Monagas",
"VE.15": "Miranda",
"VE.14": "Mérida",
"VE.13": "Lara",
"VE.12": "Guárico",
"VE.24": "Dependencias Federales",
"VE.25": "Capital",
"VE.11": "Falcón",
"VE.09": "Delta Amacuro",
"VE.08": "Cojedes",
"VE.07": "Carabobo",
"VE.06": "Bolívar",
"VE.05": "Barinas",
"VE.04": "Aragua",
"VE.03": "Apure",
"VE.02": "Anzoátegui",
"VE.01": "Amazonas",
"VE.26": "Vargas",
"VI.010": "Saint Croix Island",
"VI.020": "Saint John Island",
"VI.030": "Saint Thomas Island",
"VN.58": "Nghệ An",
"VN.59": "Ninh Bình",
"VN.60": "Ninh Thuận",
"VN.65": "Sóc Trăng",
"VN.67": "Trà Vinh",
"VN.68": "Tuyên Quang",
"VN.69": "Vĩnh Long",
"VN.70": "Yên Bái",
"VN.90": "Lào Cai",
"VN.37": "Tiền Giang",
"VN.66": "Thừa Thiên-Huế",
"VN.55": "Kon Tum",
"VN.34": "Thanh Hóa",
"VN.35": "Thái Bình",
"VN.33": "Tây Ninh",
"VN.32": "Sơn La",
"VN.64": "Quảng Trị",
"VN.30": "Quảng Ninh",
"VN.63": "Quảng Ngãi",
"VN.62": "Quảng Bình",
"VN.61": "Phú Yên",
"VN.53": "Hòa Bình",
"VN.24": "Long An",
"VN.39": "Lạng Sơn",
"VN.23": "Lâm Đồng",
"VN.89": "Lai Châu",
"VN.21": "Kiến Giang",
"VN.54": "Khánh Hòa",
"VN.20": "Ho Chi Minh City",
"VN.52": "Hà Tĩnh",
"VN.50": "Hà Giang",
"VN.49": "Gia Lai",
"VN.44": "Ha Nội",
"VN.87": "Cần Thơ",
"VN.13": "Hải Phòng",
"VN.47": "Bình Thuận",
"VN.09": "Đồng Tháp",
"VN.43": "Đồng Nai",
"VN.88": "Ðắc Lắk",
"VN.45": "Bà Rịa-Vũng Tàu",
"VN.05": "Cao Bằng",
"VN.46": "Bình Định",
"VN.03": "Bến Tre",
"VN.01": "An Giang",
"VN.91": "Ðắk Nông",
"VN.92": "Tỉnh Ðiện Biên",
"VN.74": "Bắc Ninh",
"VN.71": "Bắc Giang",
"VN.78": "Đà Nẵng",
"VN.75": "Bình Dương",
"VN.76": "Bình Phước",
"VN.85": "Thái Nguyên",
"VN.84": "Quảng Nam",
"VN.83": "Phú Thọ",
"VN.82": "Nam Định",
"VN.80": "Hà Nam",
"VN.72": "Bắc Kạn",
"VN.73": "Bạc Liêu",
"VN.77": "Cà Mau",
"VN.79": "Hải Dương",
"VN.81": "Hưng Yên",
"VN.86": "Vĩnh Phúc",
"VN.93": "Hau Giang",
"VU.15": "Tafea",
"VU.13": "Sanma",
"VU.07": "Torba",
"VU.16": "Malampa",
"VU.17": "Penama",
"VU.18": "Shefa",
"WF.98613": "Uvea",
"WF.98612": "Sigave",
"WF.98611": "Alo",
"WS.11": "Vaisigano",
"WS.06": "Va‘a-o-Fonoti",
"WS.10": "Tuamasaga",
"WS.09": "Satupa‘itea",
"WS.08": "Palauli",
"WS.07": "Gagaifomauga",
"WS.05": "Gaga‘emauga",
"WS.04": "Fa‘asaleleaga",
"WS.03": "Atua",
"WS.02": "Aiga-i-le-Tai",
"WS.01": "A'ana",
"XK.10096138": "Ferizaj",
"XK.10096859": "Gjakova",
"XK.10097357": "Gjilan",
"XK.10097358": "Mitrovica",
"XK.10097359": "Pec",
"XK.10097360": "Pristina",
"XK.10097361": "Prizren",
"YE.25": "Ta‘izz",
"YE.05": "Shabwah",
"YE.16": "Sanaa",
"YE.15": "Şa‘dah",
"YE.27": "Raymah",
"YE.14": "Ma’rib",
"YE.10": "Al Maḩwīt",
"YE.21": "Al Jawf",
"YE.04": "Muḩāfaz̧at Ḩaḑramawt",
"YE.11": "Dhamār",
"YE.03": "Al Mahrah",
"YE.08": "Al Hudaydah",
"YE.20": "Al Bayda Governorate",
"YE.02": "Aden",
"YE.01": "Abyan",
"YE.18": "Aḑ Ḑāli‘",
"YE.19": "Omran",
"YE.22": "Ḩajjah",
"YE.23": "Ibb",
"YE.24": "Laḩij",
"YE.26": "Amanat Al Asimah",
"YE.28": "Soqatra",
"YT.97601": "Acoua",
"YT.97602": "Bandraboua",
"YT.97603": "Bandrele",
"YT.97604": "Bouéni",
"YT.97605": "Chiconi",
"YT.97606": "Chirongui",
"YT.97607": "Dembeni",
"YT.97608": "Dzaoudzi",
"YT.97609": "Kani-Kéli",
"YT.97610": "Koungou",
"YT.97611": "Mamoudzou",
"YT.97612": "Mtsamboro",
"YT.97613": "M'Tsangamouji",
"YT.97614": "Ouangani",
"YT.97615": "Pamandzi",
"YT.97616": "Sada",
"YT.97617": "Tsingoni",
"ZA.03": "Orange Free State",
"ZA.02": "KwaZulu-Natal",
"ZA.05": "Eastern Cape",
"ZA.06": "Gauteng",
"ZA.07": "Mpumalanga",
"ZA.08": "Northern Cape",
"ZA.09": "Limpopo",
"ZA.10": "North-West",
"ZA.11": "Western Cape",
"ZM.01": "Western",
"ZM.07": "Southern",
"ZM.06": "North-Western",
"ZM.05": "Northern",
"ZM.09": "Lusaka",
"ZM.04": "Luapula",
"ZM.03": "Eastern",
"ZM.08": "Copperbelt",
"ZM.02": "Central",
"ZM.10": "Muchinga",
"ZW.02": "Midlands",
"ZW.07": "Matabeleland South",
"ZW.06": "Matabeleland North",
"ZW.08": "Masvingo",
"ZW.05": "Mashonaland West",
"ZW.04": "Mashonaland East",
"ZW.03": "Mashonaland Central",
"ZW.01": "Manicaland",
"ZW.09": "Bulawayo",
"ZW.10": "Harare",
}

zoneinfo = join(sep, 'usr', 'share', 'zoneinfo')
zones = {}
for region in listdir(zoneinfo):
    region_path = join(zoneinfo, region)
    if not isdir(region_path) or region in ('posix', 'Etc', 'right'):
        continue
    zones[region] = sorted(listdir(region_path))

tz_regions   = sorted(zones.keys())
get_timezone = zones.get
get_country  = countries.get

def get_state(country, state):
    """Returns the name of a province/state given a Geonames.org admin1code.

    >>> get_country('CA')
    'Canada'
    >>> get_country('MT')
    'Malta'
    >>> get_state('CA', '01')
    'Alberta'
    >>> get_state('US', 'WI')
    'Wisconsin'
    """
    return territories.get("{}.{}".format(country, state))

