// Generated by gmmproc 2.84.0 -- DO NOT MODIFY!
#ifndef _GTKMM_FILEDIALOG_H
#define _GTKMM_FILEDIALOG_H

#include <gtkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2022 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glibmm/object.h>
#include <giomm/asyncresult.h>
#include <giomm/cancellable.h>
#include <giomm/listmodel.h>
#include <giomm/file.h>
#include <gtkmm/filefilter.h>
#include <gtk/gtk.h>
#include <tuple>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class GTKMM_API FileDialog_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{
class Window;

/** A %Gtk::FileDialog object collects the arguments that
 * are needed to present a file chooser dialog to the
 * user, such as a title for the dialog and whether it
 * should be modal.
 *
 * The dialog is shown with open(), save(), etc. These APIs follow the
 * GIO async pattern, and the result can be obtained by calling
 * the corresponding finish function, for example open_finish().
 *
 * @ingroup Dialogs
 * @newin{4,10}
 */

class GTKMM_API FileDialog : public Glib::Object
{
   
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = FileDialog;
  using CppClassType = FileDialog_Class;
  using BaseObjectType = GtkFileDialog;
  using BaseClassType = GtkFileDialogClass;

  // noncopyable
  FileDialog(const FileDialog&) = delete;
  FileDialog& operator=(const FileDialog&) = delete;

private:  friend class FileDialog_Class;
  static CppClassType filedialog_class_;

protected:
  explicit FileDialog(const Glib::ConstructParams& construct_params);
  explicit FileDialog(GtkFileDialog* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  FileDialog(FileDialog&& src) noexcept;
  FileDialog& operator=(FileDialog&& src) noexcept;

  ~FileDialog() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkFileDialog*       gobj()       { return reinterpret_cast<GtkFileDialog*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkFileDialog* gobj() const { return reinterpret_cast<GtkFileDialog*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkFileDialog* gobj_copy();

private:

     
protected:
  FileDialog();

public:
  
  static Glib::RefPtr<FileDialog> create();


  /** Returns the title that will be shown on the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The title.
   */
  Glib::ustring get_title() const;
  
  /** Sets the title that will be shown on the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @param title The new title.
   */
  void set_title(const Glib::ustring& title);
  
  /** Returns whether the file chooser dialog blocks interaction
   * with the parent window while it is presented.
   * 
   * @newin{4,10}
   * 
   * @return True if the file chooser dialog is modal.
   */
  bool get_modal() const;
  
  /** Sets whether the file chooser dialog blocks interaction
   * with the parent window while it is presented.
   * 
   * @newin{4,10}
   * 
   * @param modal The new value.
   */
  void set_modal(bool modal =  true);

  
  /** Gets the filters that will be offered to the user
   * in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The filters,
   * as a list model of Gtk::FileFilter.
   */
  Glib::RefPtr<Gio::ListModel> get_filters();
  
  /** Gets the filters that will be offered to the user
   * in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The filters,
   * as a list model of Gtk::FileFilter.
   */
  Glib::RefPtr<const Gio::ListModel> get_filters() const;
  
  /** Sets the filters that will be offered to the user
   * in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @param filters A list model of Gtk::FileFilter.
   */
  void set_filters(const Glib::RefPtr<Gio::ListModel>& filters);

  
  /** Gets the filter that will be selected by default
   * in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The default filter.
   */
  Glib::RefPtr<FileFilter> get_default_filter();
  
  /** Gets the filter that will be selected by default
   * in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The default filter.
   */
  Glib::RefPtr<const FileFilter> get_default_filter() const;
  
  /** Sets the filter that will be selected by default
   * in the file chooser dialog.
   * 
   * If set to <tt>nullptr</tt>, the first item in property_filters()
   * will be used as the default filter. If that list is empty, the dialog
   * will be unfiltered.
   * 
   * @newin{4,10}
   * 
   * @param filter The file filter.
   */
  void set_default_filter(const Glib::RefPtr<FileFilter>& filter);

  
  /** Gets the folder that will be set as the
   * initial folder in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The folder.
   */
  Glib::RefPtr<Gio::File> get_initial_folder();
  
  /** Gets the folder that will be set as the
   * initial folder in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The folder.
   */
  Glib::RefPtr<const Gio::File> get_initial_folder() const;
  
  /** Sets the folder that will be set as the
   * initial folder in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @param folder A file.
   */
  void set_initial_folder(const Glib::RefPtr<Gio::File>& folder);

  
  /** Gets the filename that will be initially selected.
   * 
   * @newin{4,10}
   * 
   * @return The name.
   */
  std::string get_initial_name() const;
  
  /** Sets the filename that will be initially selected.
   * 
   * For save dialogs, @a name will usually be pre-entered into the
   * name field.
   * 
   * If a file with this name already exists in the directory set
   * via property_initial_folder(), the dialog will
   * preselect it.
   * 
   * @newin{4,10}
   * 
   * @param name A string.
   */
  void set_initial_name(const std::string& name);

  
  /** Gets the file that will be initially selected in
   * the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The file.
   */
  Glib::RefPtr<Gio::File> get_initial_file();
  
  /** Gets the file that will be initially selected in
   * the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The file.
   */
  Glib::RefPtr<const Gio::File> get_initial_file() const;
  
  /** Sets the file that will be initially selected in
   * the file chooser dialog.
   * 
   * This function is a shortcut for calling both
   * set_initial_folder() and
   * set_initial_name() with the
   * directory and name of @a file, respectively.
   * 
   * @newin{4,10}
   * 
   * @param file A file.
   */
  void set_initial_file(const Glib::RefPtr<Gio::File>& file);

  
  /** Retrieves the text used by the dialog on its accept button.
   * 
   * @newin{4,10}
   * 
   * @return The label shown on the file chooser's accept button.
   */
  Glib::ustring get_accept_label() const;
  
  /** Sets the label shown on the file chooser's accept button.
   * 
   * Leaving the accept label unset or setting it as <tt>nullptr</tt> will
   * fall back to a default label, depending on what API is used
   * to launch the file dialog.
   * 
   * @newin{4,10}
   * 
   * @param accept_label The new accept label.
   */
  void set_accept_label(const Glib::ustring& accept_label);

  
  /** Presents a file chooser dialog to the user.
   * 
   * The file chooser dialog will be set up to select a single file.
   * 
   * The @a slot will be called when the dialog is dismissed.
   * 
   * @newin{4,10}
   * 
   * @param parent The parent window.
   * @param cancellable A cancellable to cancel the operation.
   * @param slot A callback to call when the
   * operation is complete.
   */
  void open(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});

  /// A open() convenience overload.
  void open(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});
  
  /** Finishes the open() call.
   * 
   * @newin{4,10}
   * 
   * @param result The result.
   * @return The file that was selected.
   * 
   * @throws Gtk::DialogError
   */
  Glib::RefPtr<Gio::File> open_finish(const Glib::RefPtr<Gio::AsyncResult>& result);

  
  /** Presents a file chooser dialog to the user.
   * 
   * The file chooser dialog will be set up to select a single folder.
   * 
   * If you pass @a initial_folder, the file chooser dialog will initially
   * be opened in the parent directory of that folder, otherwise, it
   * will be in the directory property_initial_folder().
   * 
   * The @a slot will be called when the dialog is dismissed.
   * 
   * @newin{4,10}
   * 
   * @param parent The parent window.
   * @param cancellable A cancellable to cancel the operation.
   * @param slot A callback to call when the
   * operation is complete.
   */
  void select_folder(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});

  /// A select_folder() convenience overload.
  void select_folder(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});
  
  /** Finishes the select_folder() call.
   * 
   * @newin{4,10}
   * 
   * @param result The result.
   * @return The folder that was selected.
   * 
   * @throws Gtk::DialogError
   */
  Glib::RefPtr<Gio::File> select_folder_finish(const Glib::RefPtr<Gio::AsyncResult>& result);

  
  /** Presents a file chooser dialog to the user.
   * 
   * The file chooser dialog will be save mode.
   * 
   * The @a slot will be called when the dialog is dismissed.
   * 
   * @newin{4,10}
   * 
   * @param parent The parent window.
   * @param cancellable A cancellable to cancel the operation.
   * @param slot A callback to call when the
   * operation is complete.
   */
  void save(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});

  /// A save() convenience overload.
  void save(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});
  
  /** Finishes the save() call.
   * 
   * @newin{4,10}
   * 
   * @param result The result.
   * @return The file that was selected.
   * 
   * @throws Gtk::DialogError
   */
  Glib::RefPtr<Gio::File> save_finish(const Glib::RefPtr<Gio::AsyncResult>& result);

 
  /** Presents a file chooser dialog to the user.
   * 
   * The file chooser dialog will be set up to select multiple files.
   * 
   * The file chooser dialog will initially be opened in the directory
   * property_initial_folder().
   * 
   * The @a slot will be called when the dialog is dismissed.
   * 
   * @newin{4,10}
   * 
   * @param parent The parent window.
   * @param cancellable A cancellable to cancel the operation.
   * @param slot A callback to call when the
   * operation is complete.
   */
  void open_multiple(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});

  /// A open_multiple() convenience overload.
  void open_multiple(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});

  
  /** Finishes the open_multiple() call and
   * returns the resulting files in a std::vector.
   *
   * @newin{4,10}
   *
   * @param result A `Gio::AsyncResult`.
   * @return The files that were selected, as a vector of `Gio::File`s.
   *         Otherwise, an exception is thrown.
   *
   * @throws Gtk::DialogError
   */
  std::vector<Glib::RefPtr<Gio::File>> open_multiple_finish(const Glib::RefPtr<Gio::AsyncResult>& result);

  
  /** Presents a file chooser dialog to the user.
   * 
   * The file chooser dialog will be set up to allow selecting
   * multiple folders.
   * 
   * The file chooser dialog will initially be opened in the
   * directory property_initial_folder().
   * 
   * The @a slot will be called when the dialog is dismissed.
   * 
   * @newin{4,10}
   * 
   * @param parent The parent window.
   * @param cancellable A cancellable to cancel the operation.
   * @param slot A callback to call when the
   * operation is complete.
   */
  void select_multiple_folders(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});

  /// A select_multiple_folders() convenience overload.
  void select_multiple_folders(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});

  
  /** Finishes the select_multiple_folders()
   * call and returns the resulting files in a std::vector.
   *
   * @newin{4,10}
   *
   * @param result A Gio::AsyncResult.
   * @return The files that were selected, as a vector of `Gio::File`s.
   *         Otherwise, an exception is thrown.
   *
   * @throws Gtk::DialogError
   */
  std::vector<Glib::RefPtr<Gio::File>> select_multiple_folders_finish(const Glib::RefPtr<Gio::AsyncResult>& result);

  
  /** Initiates a file selection operation by presenting a file chooser
   * dialog to the user.
   * 
   * In contrast to open(), this function
   * lets the user select the text encoding for the file, if possible.
   * 
   * The @a slot will be called when the dialog is dismissed.
   * 
   * @newin{4,18}
   * 
   * @param parent The parent `Gtk::Window`.
   * @param cancellable A `Cancellable` to cancel the operation.
   * @param slot A callback to call when the
   * operation is complete.
   */
  void open_text_file(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});

  /// A open_text_file() convenience overload.
  void open_text_file(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});

  /** Finishes the open_text_file() call and returns the resulting file and text encoding.
   *
   * If the user has explicitly selected a text encoding to use
   * for the file, then @a encoding will be set to a codeset name that
   * is suitable for passing to iconv_open(). Otherwise, it will be an empty string.
   *
   * @newin{4,18}
   *
   * @param result A `Gio::AsyncResult`.
   * @return {file, encoding} The file that was selected and the text encoding to use.
   * @throws Gtk::DialogError
   */
  std::tuple<Glib::RefPtr<Gio::File>, Glib::ustring>
  open_text_file_finish(const Glib::RefPtr<Gio::AsyncResult>& result);
  

  /** Presents a file chooser dialog to the user.
   * 
   * The file chooser dialog will be set up to select multiple files.
   * 
   * The file chooser dialog will initially be opened in the directory
   * property_initial_folder().
   * 
   * In contrast to open(), this function
   * lets the user select the text encoding for the files, if possible.
   * 
   * The @a slot will be called when the dialog is dismissed.
   * 
   * @newin{4,18}
   * 
   * @param parent The parent window.
   * @param cancellable A cancellable to cancel the operation.
   * @param slot A callback to call when the
   * operation is complete.
   */
  void open_multiple_text_files(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});

  /// A open_multiple_text_files() convenience overload.
  void open_multiple_text_files(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});

  /** Finishes the open_multiple_text_files() call.
   *
   * If the user has explicitly selected a text encoding to use
   * for the file, then @a encoding will be set to a codeset name that
   * is suitable for passing to iconv_open(). Otherwise, it will be an empty string.
   *
   * @newin{4,18}
   *
   * @param result A `Gio::AsyncResult`.
   * @return {files, encoding} The files that were selected, as a vector of `Gio::File`s,
   *         and the text encoding to use.
   * @throws Gtk::DialogError
   */
  std::tuple<std::vector<Glib::RefPtr<Gio::File>>, Glib::ustring>
  open_multiple_text_files_finish(const Glib::RefPtr<Gio::AsyncResult>& result);
  

  /** Initiates a file save operation by presenting a file chooser
   * dialog to the user.
   * 
   * In contrast to save(), this function
   * lets the user select the text encoding and line endings for
   * the text file, if possible.
   * 
   * The @a slot will be called when the dialog is dismissed.
   * 
   * @newin{4,18}
   * 
   * @param parent The parent `Gtk::Window`.
   * @param cancellable A `Cancellable` to cancel the operation.
   * @param slot A callback to call when the
   * operation is complete.
   */
  void save_text_file(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});

  /// A save_text_file() convenience overload.
  void save_text_file(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});

  /** Finishes the save_text_file() call
   * and returns the resulting file, text encoding and line endings.
   *
   * If the user has explicitly selected a text encoding to use
   * for the file, then @a encoding will be set to a codeset name that
   * is suitable for passing to iconv_open(). Otherwise, it will be an empty string.
   *
   * The @a line_ending will be set to one of "\\n", "\\r\\n", "\\r" or "",
   * where the latter means to preserve existing line endings.
   *
   * @newin{4,18}
   *
   * @param result A `Gio::AsyncResult`.
   * @return {file, encoding, line_ending} The file that was selected,
   *         the text encoding to use, and the line endings to use.
   * @throws Gtk::DialogError
   */
  std::tuple<Glib::RefPtr<Gio::File>, Glib::ustring, Glib::ustring>
  save_text_file_finish(const Glib::RefPtr<Gio::AsyncResult>& result);
  

  /** A title that may be shown on the file chooser dialog.
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_title() ;

/** A title that may be shown on the file chooser dialog.
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_title() const;

  /** Whether the file chooser dialog is modal.
   * 
   * @newin{4,10}
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_modal() ;

/** Whether the file chooser dialog is modal.
   * 
   * @newin{4,10}
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_modal() const;

  /** The list of filters.
   * 
   * See property_default_filter() about how these
   * two properties interact.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::ListModel> > property_filters() ;

/** The list of filters.
   * 
   * See property_default_filter() about how these
   * two properties interact.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::ListModel> > property_filters() const;

  /** The default filter.
   * 
   * This filter is initially active in the file chooser dialog.
   * 
   * If the default filter is <tt>nullptr</tt>, the first filter of property_filters()
   * is used as the default filter. If that property contains no filter, the dialog will
   * be unfiltered.
   * 
   * If property_filters() is not <tt>nullptr</tt>, the default filter should be
   * part of the list. If it is not, the dialog may choose to not make it available.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<FileFilter> > property_default_filter() ;

/** The default filter.
   * 
   * This filter is initially active in the file chooser dialog.
   * 
   * If the default filter is <tt>nullptr</tt>, the first filter of property_filters()
   * is used as the default filter. If that property contains no filter, the dialog will
   * be unfiltered.
   * 
   * If property_filters() is not <tt>nullptr</tt>, the default filter should be
   * part of the list. If it is not, the dialog may choose to not make it available.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<FileFilter> > property_default_filter() const;

  /** The initial file.
   * 
   * This file is initially selected in the file chooser dialog
   * 
   * This is a utility property that sets both property_initial_folder()
   * and property_initial_name().
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::File> > property_initial_file() ;

/** The initial file.
   * 
   * This file is initially selected in the file chooser dialog
   * 
   * This is a utility property that sets both property_initial_folder()
   * and property_initial_name().
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::File> > property_initial_file() const;

  /** The initial folder.
   * 
   * This is the directory that is initially opened in the file chooser dialog.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::File> > property_initial_folder() ;

/** The initial folder.
   * 
   * This is the directory that is initially opened in the file chooser dialog.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::File> > property_initial_folder() const;

  /** The initial name.
   * 
   * This is the name of the file that is initially selected in the file chooser dialog.
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< std::string > property_initial_name() ;

/** The initial name.
   * 
   * This is the name of the file that is initially selected in the file chooser dialog.
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< std::string > property_initial_name() const;

  /** Label for the file chooser's accept button.
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_accept_label() ;

/** Label for the file chooser's accept button.
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_accept_label() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::FileDialog
   */
  GTKMM_API
  Glib::RefPtr<Gtk::FileDialog> wrap(GtkFileDialog* object, bool take_copy = false);
}


#endif /* _GTKMM_FILEDIALOG_H */

