/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.mapmode.ImproveWayAccuracyHelper;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.mapmode.SelectAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.preferences.CachingProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.data.preferences.StrokeProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.draw.MapViewPath;
import org.openstreetmap.josm.gui.draw.SymbolShape;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.util.ModifierExListener;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

public class ImproveWayAccuracyAction
extends MapMode
implements DataSelectionListener,
DataSetListener,
ModifierExListener {
    private static final String CROSSHAIR = "crosshair";
    private State state;
    private MapView mv;
    private static final long serialVersionUID = 42L;
    private transient Way targetWay;
    private transient Node candidateNode;
    private transient WaySegment candidateSegment;
    private Point mousePos;
    private boolean dragging;
    private final Cursor cursorSelect = ImageProvider.getCursor("normal", "mode");
    private final Cursor cursorSelectHover = ImageProvider.getCursor("hand", "mode");
    private final Cursor cursorImprove = ImageProvider.getCursor("crosshair", null);
    private final Cursor cursorImproveAdd = ImageProvider.getCursor("crosshair", "addnode");
    private final Cursor cursorImproveDelete = ImageProvider.getCursor("crosshair", "delete_node");
    private final Cursor cursorImproveAddLock = ImageProvider.getCursor("crosshair", "add_node_lock");
    private final Cursor cursorImproveLock = ImageProvider.getCursor("crosshair", "lock");
    private Color guideColor;
    private static final CachingProperty<BasicStroke> SELECT_TARGET_WAY_STROKE = new StrokeProperty("improvewayaccuracy.stroke.select-target", "2").cached();
    private static final CachingProperty<BasicStroke> MOVE_NODE_STROKE = new StrokeProperty("improvewayaccuracy.stroke.move-node", "1 6").cached();
    private static final CachingProperty<BasicStroke> MOVE_NODE_INTERSECTING_STROKE = new StrokeProperty("improvewayaccuracy.stroke.move-node-intersecting", "1 2 6").cached();
    private static final CachingProperty<BasicStroke> ADD_NODE_STROKE = new StrokeProperty("improvewayaccuracy.stroke.add-node", "1").cached();
    private static final CachingProperty<BasicStroke> DELETE_NODE_STROKE = new StrokeProperty("improvewayaccuracy.stroke.delete-node", "1").cached();
    private static final CachingProperty<Integer> DOT_SIZE = new IntegerProperty("improvewayaccuracy.dot-size", 6).cached();
    private boolean selectionChangedBlocked;
    protected String oldModeHelpText;
    private final transient AbstractMapViewPaintable temporaryLayer = new AbstractMapViewPaintable(){

        @Override
        public void paint(Graphics2D g, MapView mv, Bounds bbox) {
            ImproveWayAccuracyAction.this.paint(g, mv, bbox);
        }
    };

    public ImproveWayAccuracyAction() {
        super(I18n.tr("Improve Way Accuracy", new Object[0]), "improvewayaccuracy", I18n.tr("Improve Way Accuracy mode", new Object[0]), Shortcut.registerShortcut("mapmode:ImproveWayAccuracy", I18n.tr("Mode: {0}", I18n.tr("Improve Way Accuracy", new Object[0])), 87, 5003), Cursor.getPredefinedCursor(0));
        this.readPreferences();
    }

    @Override
    public void enterMode() {
        if (!this.isEnabled()) {
            return;
        }
        super.enterMode();
        this.readPreferences();
        MapFrame map = MainApplication.getMap();
        this.mv = map.mapView;
        this.mousePos = null;
        this.oldModeHelpText = "";
        if (this.getLayerManager().getEditDataSet() == null) {
            return;
        }
        this.updateStateByCurrentSelection();
        map.mapView.addMouseListener(this);
        map.mapView.addMouseMotionListener(this);
        map.mapView.addTemporaryLayer(this.temporaryLayer);
        SelectionEventManager.getInstance().addSelectionListener(this);
        DatasetEventManager.getInstance().addDatasetListener(this, DatasetEventManager.FireMode.IMMEDIATELY);
        map.keyDetector.addModifierExListener(this);
    }

    @Override
    protected void readPreferences() {
        this.guideColor = new NamedColorProperty(I18n.marktr("improve way accuracy helper line"), Color.RED).get();
    }

    @Override
    public void exitMode() {
        super.exitMode();
        MapFrame map = MainApplication.getMap();
        map.mapView.removeMouseListener(this);
        map.mapView.removeMouseMotionListener(this);
        map.mapView.removeTemporaryLayer(this.temporaryLayer);
        SelectionEventManager.getInstance().removeSelectionListener(this);
        DatasetEventManager.getInstance().removeDatasetListener(this);
        map.keyDetector.removeModifierExListener(this);
        this.temporaryLayer.invalidate();
        this.targetWay = null;
        this.candidateNode = null;
        this.candidateSegment = null;
    }

    @Override
    protected void updateStatusLine() {
        String newModeHelpText = this.getModeHelpText();
        if (!newModeHelpText.equals(this.oldModeHelpText)) {
            this.oldModeHelpText = newModeHelpText;
            MapFrame map = MainApplication.getMap();
            map.statusLine.setHelpText(newModeHelpText);
            map.statusLine.repaint();
        }
    }

    @Override
    public String getModeHelpText() {
        if (this.state == State.SELECTING) {
            if (this.targetWay != null) {
                return I18n.tr("Click on the way to start improving its shape.", new Object[0]);
            }
            return I18n.tr("Select a way that you want to make more accurate.", new Object[0]);
        }
        if (this.ctrl) {
            return I18n.tr("Click to add a new node. Release Ctrl to move existing nodes or hold Alt to delete.", new Object[0]);
        }
        if (this.alt) {
            return I18n.tr("Click to delete the highlighted node. Release Alt to move existing nodes or hold Ctrl to add new nodes.", new Object[0]);
        }
        return I18n.tr("Click to move the highlighted node. Hold Ctrl to add new nodes, or Alt to delete.", new Object[0]);
    }

    @Override
    public boolean layerIsSupported(Layer l) {
        return this.isEditableDataLayer(l);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getEditLayer() != null);
    }

    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        if (this.mousePos == null || this.candidateNode != null && this.candidateNode.getDataSet() == null) {
            return;
        }
        g.setColor(this.guideColor);
        if (this.state == State.SELECTING && this.targetWay != null) {
            BasicStroke stroke = SELECT_TARGET_WAY_STROKE.get();
            g.setStroke(stroke);
            List<Node> nodes = this.targetWay.getNodes();
            g.draw(new MapViewPath(mv).append(nodes, false).computeClippedLine(stroke));
        } else if (this.state == State.IMPROVING) {
            if (this.ctrl && this.candidateSegment != null) {
                this.paintAddNodeStroke(g);
            } else if (!this.alt && !this.ctrl && this.candidateNode != null) {
                this.paintMoveNodeStroke(g);
            } else if (this.alt && !this.ctrl && this.candidateNode != null) {
                this.paintDeleteStroke(g);
            }
        }
    }

    private void paintAddNodeStroke(Graphics2D g) {
        g.setStroke(ADD_NODE_STROKE.get());
        ILatLon p1 = null;
        ILatLon p2 = null;
        try {
            p1 = (ILatLon)this.candidateSegment.getFirstNode();
            p2 = (ILatLon)this.candidateSegment.getSecondNode();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Logging.error(e);
        }
        this.paintImprovingPreviewLines(g, p1, p2);
    }

    private void paintMoveNodeStroke(Graphics2D g) {
        g.setStroke(MOVE_NODE_STROKE.get());
        List<Pair<Node, Node>> wpps = this.targetWay.getNodePairs(false);
        ILatLon p1 = null;
        ILatLon p2 = null;
        for (Pair<Node, Node> wpp : wpps) {
            if (wpp.a == this.candidateNode) {
                p1 = (ILatLon)wpp.b;
            }
            if (wpp.b == this.candidateNode) {
                p2 = (ILatLon)wpp.a;
            }
            if (p1 == null || p2 == null) continue;
            break;
        }
        this.paintImprovingPreviewLines(g, p1, p2);
    }

    private void paintDeleteStroke(Graphics2D g) {
        g.setStroke(DELETE_NODE_STROKE.get());
        List<Node> nodes = this.targetWay.getNodes();
        int index = nodes.indexOf(this.candidateNode);
        ILatLon p1 = null;
        ILatLon p2 = null;
        if (index > 0 && index < nodes.size() - 1) {
            p1 = nodes.get(index - 1);
            p2 = nodes.get(index + 1);
        } else if (this.targetWay.isClosed()) {
            p1 = this.targetWay.getNode(1);
            p2 = this.targetWay.getNode(nodes.size() - 2);
        }
        this.paintImprovingPreviewLines(g, p1, p2);
    }

    private void paintImprovingPreviewLines(Graphics2D g, ILatLon p1, ILatLon p2) {
        MapViewPath b = new MapViewPath(this.mv);
        if (this.alt && !this.ctrl) {
            if (p1 != null && p2 != null) {
                b.moveTo(p1);
                b.lineTo(p2);
            }
        } else {
            if (p1 != null) {
                b.moveTo(this.mousePos.x, this.mousePos.y);
                b.lineTo(p1);
            }
            if (p2 != null) {
                b.moveTo(this.mousePos.x, this.mousePos.y);
                b.lineTo(p2);
            }
        }
        g.draw(b.computeClippedLine(g.getStroke()));
        if (this.candidateNode != null) {
            p1 = this.candidateNode;
            g.fill(new MapViewPath(this.mv).shapeAround(p1, SymbolShape.SQUARE, (double)DOT_SIZE.get().intValue()));
        }
        if (!this.alt && !this.ctrl && this.candidateNode != null) {
            b.reset();
            this.drawIntersectingWayHelperLines(this.mv, b);
            g.setStroke(MOVE_NODE_INTERSECTING_STROKE.get());
            g.draw(b.computeClippedLine(g.getStroke()));
        }
    }

    protected void drawIntersectingWayHelperLines(MapView mv, MapViewPath b) {
        for (OsmPrimitive referrer : this.candidateNode.getReferrers()) {
            if (!(referrer instanceof Way) || this.targetWay.equals(referrer)) continue;
            List<Node> nodes = ((Way)referrer).getNodes();
            for (int i = 0; i < nodes.size(); ++i) {
                if (!this.candidateNode.equals(nodes.get(i))) continue;
                if (i > 0) {
                    b.moveTo(this.mousePos.x, this.mousePos.y);
                    b.lineTo(nodes.get(i - 1));
                }
                if (i >= nodes.size() - 1) continue;
                b.moveTo(this.mousePos.x, this.mousePos.y);
                b.lineTo(nodes.get(i + 1));
            }
        }
    }

    @Override
    public void modifiersExChanged(int modifiers) {
        if (!MainApplication.isDisplayingMapView() || !MainApplication.getMap().mapView.isActiveLayerDrawable()) {
            return;
        }
        this.updateKeyModifiersEx(modifiers);
        this.updateCursorDependentObjectsIfNeeded();
        this.updateCursor();
        this.updateStatusLine();
        this.temporaryLayer.invalidate();
    }

    @Override
    public void selectionChanged(DataSelectionListener.SelectionChangeEvent event) {
        if (this.selectionChangedBlocked) {
            return;
        }
        this.updateStateByCurrentSelection();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.dragging = true;
        this.mouseMoved(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.mousePos = e.getPoint();
        this.updateKeyModifiers(e);
        this.updateCursorDependentObjectsIfNeeded();
        this.updateCursor();
        this.updateStatusLine();
        this.temporaryLayer.invalidate();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dragging = false;
        if (!this.isEnabled() || e.getButton() != 1) {
            return;
        }
        DataSet ds = this.getLayerManager().getEditDataSet();
        this.updateKeyModifiers(e);
        this.mousePos = e.getPoint();
        if (this.state == State.SELECTING) {
            if (this.targetWay != null) {
                ds.setSelected(this.targetWay.getPrimitiveId());
                this.updateStateByCurrentSelection();
            }
        } else if (this.state == State.IMPROVING) {
            if (new Node(this.mv.getEastNorth(this.mousePos.x, this.mousePos.y)).isOutSideWorld()) {
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Cannot add a node outside of the world.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                return;
            }
            if (this.ctrl && !this.alt && this.candidateSegment != null) {
                this.addNode(ds);
            } else if (this.alt && !this.ctrl && this.candidateNode != null) {
                this.deleteHighlightedNode();
            } else if (this.candidateNode != null) {
                this.moveHighlightedNode();
            }
        }
        this.mousePos = null;
        this.updateCursor();
        this.updateStatusLine();
        this.temporaryLayer.invalidate();
    }

    private void addNode(DataSet ds) {
        LinkedList<WaySegment> virtualSegments = new LinkedList<WaySegment>();
        HashSet<Way> commonParentWays = new HashSet<Way>(((Node)this.candidateSegment.getFirstNode()).getParentWays());
        commonParentWays.retainAll(((Node)this.candidateSegment.getSecondNode()).getParentWays());
        for (Way w : commonParentWays) {
            for (int i = 0; i < w.getNodesCount() - 1; ++i) {
                WaySegment testWS = new WaySegment(w, i);
                if (!testWS.isSimilar(this.candidateSegment)) continue;
                virtualSegments.add(testWS);
            }
        }
        LinkedList<Command> virtualCmds = new LinkedList<Command>();
        Node virtualNode = new Node(this.mv.getEastNorth(this.mousePos.x, this.mousePos.y));
        virtualCmds.add(new AddCommand(ds, virtualNode));
        for (WaySegment virtualSegment : virtualSegments) {
            Way w = (Way)virtualSegment.getWay();
            List<Node> modNodes = w.getNodes();
            modNodes.add(virtualSegment.getUpperIndex(), virtualNode);
            virtualCmds.add(new ChangeNodesCommand(w, modNodes));
        }
        String text = I18n.trn("Add a new node to way", "Add a new node to {0} ways", virtualSegments.size(), virtualSegments.size());
        UndoRedoHandler.getInstance().add(new SequenceCommand(text, virtualCmds));
    }

    private void deleteHighlightedNode() {
        long referrersCount = this.candidateNode.referrers(OsmPrimitive.class).count();
        long referrerWayCount = this.candidateNode.referrers(Way.class).count();
        if (referrersCount != 1L || referrerWayCount != 1L) {
            List<Node> nodes = this.targetWay.getNodes();
            nodes.remove(this.candidateNode);
            if (nodes.size() < 2) {
                Command deleteCmd = DeleteCommand.delete(Collections.singleton(this.targetWay), true);
                if (deleteCmd != null) {
                    UndoRedoHandler.getInstance().add(deleteCmd);
                }
            } else {
                UndoRedoHandler.getInstance().add(new ChangeNodesCommand(this.targetWay, nodes));
            }
        } else if (this.candidateNode.isTagged()) {
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Cannot delete node that has tags", new Object[0]), I18n.tr("Error", new Object[0]), 0);
        } else {
            Command deleteCmd = DeleteCommand.delete(Collections.singleton(this.candidateNode), true);
            if (deleteCmd != null) {
                UndoRedoHandler.getInstance().add(deleteCmd);
            }
        }
    }

    private void moveHighlightedNode() {
        EastNorth nodeEN = this.candidateNode.getEastNorth();
        EastNorth cursorEN = this.mv.getEastNorth(this.mousePos.x, this.mousePos.y);
        UndoRedoHandler.getInstance().add(new MoveCommand((OsmPrimitive)this.candidateNode, cursorEN.east() - nodeEN.east(), cursorEN.north() - nodeEN.north()));
        SelectAction.checkCommandForLargeDistance(UndoRedoHandler.getInstance().getLastCommand());
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.dragging) {
            this.mousePos = null;
        }
        this.temporaryLayer.invalidate();
    }

    private void updateCursor() {
        if (!this.isEnabled()) {
            this.mv.setNewCursor(null, (Object)this);
            return;
        }
        if (this.state == State.SELECTING) {
            this.mv.setNewCursor(this.targetWay == null ? this.cursorSelect : this.cursorSelectHover, (Object)this);
        } else if (this.state == State.IMPROVING) {
            this.updateCursorImproving();
        }
    }

    private void updateCursorImproving() {
        if (this.alt && !this.ctrl) {
            this.mv.setNewCursor(this.cursorImproveDelete, (Object)this);
        } else if (this.shift || this.dragging) {
            if (this.ctrl) {
                this.mv.setNewCursor(this.cursorImproveAddLock, (Object)this);
            } else {
                this.mv.setNewCursor(this.cursorImproveLock, (Object)this);
            }
        } else if (this.ctrl && !this.alt) {
            this.mv.setNewCursor(this.cursorImproveAdd, (Object)this);
        } else {
            this.mv.setNewCursor(this.cursorImprove, (Object)this);
        }
    }

    public void updateCursorDependentObjectsIfNeeded() {
        if (this.state == State.IMPROVING && (this.shift || this.dragging) && (this.candidateNode != null || this.candidateSegment != null)) {
            return;
        }
        if (this.mousePos == null) {
            this.candidateNode = null;
            this.candidateSegment = null;
            return;
        }
        if (this.state == State.SELECTING) {
            this.targetWay = ImproveWayAccuracyHelper.findWay(this.mv, this.mousePos);
        } else if (this.state == State.IMPROVING) {
            if (this.ctrl && !this.alt) {
                this.candidateSegment = ImproveWayAccuracyHelper.findCandidateSegment(this.mv, this.targetWay, this.mousePos);
                this.candidateNode = null;
            } else {
                this.candidateNode = ImproveWayAccuracyHelper.findCandidateNode(this.mv, this.targetWay, this.mousePos);
                this.candidateSegment = null;
            }
        }
    }

    public void startSelecting() {
        this.state = State.SELECTING;
        this.targetWay = null;
        this.temporaryLayer.invalidate();
        this.updateStatusLine();
    }

    public void startImproving(Way targetWay) {
        this.state = State.IMPROVING;
        DataSet ds = this.getLayerManager().getEditDataSet();
        Collection currentSelection = ds.getSelected();
        if (currentSelection.size() != 1 || !((OsmPrimitive)currentSelection.iterator().next()).equals(targetWay)) {
            this.selectionChangedBlocked = true;
            ds.clearSelection();
            ds.setSelected(targetWay.getPrimitiveId());
            this.selectionChangedBlocked = false;
        }
        this.targetWay = targetWay;
        this.candidateNode = null;
        this.candidateSegment = null;
        this.temporaryLayer.invalidate();
        this.updateStatusLine();
    }

    private void updateStateByCurrentSelection() {
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (ds != null && this.selectWay(ds)) {
            return;
        }
        this.startSelecting();
    }

    private boolean selectWay(DataSet ds) {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        ArrayList<Way> wayList = new ArrayList<Way>();
        Collection sel = ds.getSelected();
        for (OsmPrimitive p : sel) {
            if (p instanceof Way) {
                wayList.add((Way)p);
            }
            if (!(p instanceof Node)) continue;
            nodeList.add((Node)p);
        }
        if (wayList.size() == 1) {
            this.startImproving((Way)wayList.get(0));
            return true;
        }
        if (nodeList.size() == 1) {
            List<OsmPrimitive> r = ((Node)nodeList.get(0)).getReferrers();
            r.removeIf(osm -> !osm.isUsable());
            if (r.size() == 1 && r.get(0) instanceof Way) {
                this.startImproving((Way)r.get(0));
                return true;
            }
        }
        return false;
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        if (event.getPrimitives().contains(this.candidateNode) || event.getPrimitives().contains(this.targetWay)) {
            this.updateCursorDependentObjectsIfNeeded();
        }
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent event) {
    }

    @Override
    public void tagsChanged(TagsChangedEvent event) {
    }

    @Override
    public void nodeMoved(NodeMovedEvent event) {
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent event) {
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    @Override
    public void dataChanged(DataChangedEvent event) {
    }

    static enum State {
        SELECTING,
        IMPROVING;

    }
}

