/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.ext;

import java.util.function.Consumer;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.javasupport.Java;
import org.jruby.util.cli.Options;

public class JavaExtensions {
    private static final boolean LAZY = Options.JI_LOAD_LAZY.load();
    private static final Consumer<RubyModule> NOOP = noop -> {};

    private JavaExtensions() {
    }

    static void put(Ruby runtime2, Class javaClass, Consumer<RubyModule> proxyClass) {
        if (!LAZY) {
            proxyClass.accept(Java.getProxyClass(runtime2.getCurrentContext(), javaClass));
            return;
        }
        Consumer<RubyModule> previous = runtime2.getJavaExtensionDefinitions().put(javaClass, proxyClass);
        assert (previous == null);
    }

    public static void define(Ruby runtime2, Class javaClass, RubyModule proxyClass) {
        runtime2.getJavaExtensionDefinitions().getOrDefault(javaClass, NOOP).accept(proxyClass);
    }
}

