/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.RubyStringBuilder;

public class RubyTimeParser {
    public static final int TIME_SCALE_NUMDIGITS = 10;
    public static final long SIZE_MAX = Long.MAX_VALUE;
    private int beg;
    private int ptr;
    private int end;
    private byte[] bytes;
    private int ndigits;

    public IRubyObject parse(ThreadContext context, RubyTime self2, RubyString str, IRubyObject zone2, IRubyObject precision2) {
        long prec;
        ByteList bytelist = str.getByteList();
        this.ptr = this.beg = bytelist.begin();
        this.end = this.beg + bytelist.length();
        this.bytes = bytelist.unsafeBytes();
        this.ndigits = 0;
        IRubyObject subsec2 = context.nil;
        int mon2 = -1;
        int mday2 = -1;
        int hour2 = -1;
        int min2 = -1;
        int sec2 = -1;
        long l = prec = precision2.isNil() ? Long.MAX_VALUE : Convert.toLong(context, precision2);
        if (!this.isEOS() && (this.isSpace() || Character.isSpaceChar(this.bytes[this.end - 1]))) {
            throw Error.argumentError(context, RubyStringBuilder.str(context.runtime, "can't parse: ", str));
        }
        IRubyObject year2 = this.parseInt(context, true);
        if (year2.isNil()) {
            throw Error.argumentError(context, RubyStringBuilder.str(context.runtime, "can't parse: ", str));
        }
        if (this.ndigits < 4) {
            RubyString invalidYear = context.runtime.newString(new ByteList(this.bytes, this.ptr - this.ndigits - this.beg, this.ndigits, true));
            throw Error.argumentError(context, RubyStringBuilder.str(context.runtime, "year must be 4 or more digits: ", invalidYear));
        }
        if (this.ptr == this.end) {
            return self2.initialize(context, year2, context.nil, context.nil, context.nil, context.nil, context.nil, precision2, zone2);
        }
        if (this.peek() == 45) {
            this.advance();
            mon2 = this.expectTwoDigits(context, "mon", 12);
            if (this.peek() == 45) {
                this.advance();
                mday2 = this.expectTwoDigits(context, "mday", 31);
                byte next2 = this.peek();
                if (next2 == 32 || next2 == 84) {
                    this.advance();
                    int timePart = this.ptr;
                    if (1 < this.end - this.ptr && this.isDigit(0)) {
                        hour2 = this.expectTwoDigits(context, "hour", 24);
                        this.noFraction(context, "hour", timePart);
                        this.needColon(context, "min", timePart);
                        min2 = this.expectTwoDigits(context, "min", 60);
                        this.noFraction(context, "min", timePart);
                        this.needColon(context, "sec", timePart);
                        sec2 = this.expectTwoDigits(context, "sec", 60);
                        if (this.peek() == 46) {
                            this.advance();
                            int digits2 = 0;
                            while ((long)digits2 < prec && this.isDigit(digits2)) {
                                ++digits2;
                            }
                            if (digits2 == 0) {
                                RubyString invalidSecs = context.runtime.newString(new ByteList(this.bytes, timePart, this.ptr - timePart + 1, true));
                                throw Error.argumentError(context, RubyStringBuilder.str(context.runtime, "subsecond expected after dot: ", invalidSecs));
                            }
                            this.ndigits = digits2;
                            subsec2 = this.parseInt(context, false);
                            if (!subsec2.isNil()) {
                                while (!this.isEOS() && this.isDigit(0)) {
                                    ++this.ptr;
                                }
                            }
                        }
                    }
                }
            }
        }
        this.eatSpace();
        int zstr = this.ptr;
        while (!this.isEOS() && !this.isSpace()) {
            this.advance();
        }
        int zend = this.ptr;
        this.eatSpace();
        if (!this.isEOS()) {
            RubyString invalid = Create.newString(context, new ByteList(this.bytes, this.ptr, this.end - this.ptr, true));
            throw Error.argumentError(context, RubyStringBuilder.str(context.runtime, "can't parse at: ", invalid));
        }
        if (zend > zstr) {
            zone2 = Create.newString(context, new ByteList(this.bytes, zstr, zend - zstr, true));
        } else if (hour2 == -1) {
            throw Error.argumentError(context, "no time information");
        }
        if (!subsec2.isNil()) {
            if (this.ndigits < 10) {
                mul = (int)Math.pow(10.0, 10 - this.ndigits);
                subsec2 = Convert.asFixnum(context, ((RubyInteger)subsec2).asLong(context) * (long)mul);
            } else if (this.ndigits > 10) {
                mul = (int)Math.pow(10.0, this.ndigits - 10);
                subsec2 = RubyRational.newRational(context.runtime, ((RubyInteger)subsec2).asLong(context), mul);
            }
        }
        return self2.initialize(context, year2, Convert.asFixnum(context, mon2), Convert.asFixnum(context, mday2), Convert.asFixnum(context, hour2), Convert.asFixnum(context, min2), Convert.asFixnum(context, sec2), subsec2, zone2);
    }

    private void advance() {
        ++this.ptr;
    }

    private void eatSpace() {
        while (!this.isEOS() && this.isSpace()) {
            this.advance();
        }
    }

    private byte peek() {
        return this.ptr < this.end ? this.bytes[this.ptr] : (byte)0;
    }

    private byte peek(int offset2) {
        int p2 = this.ptr + offset2;
        return p2 < this.end ? this.bytes[p2] : (byte)0;
    }

    private boolean isEOS() {
        return this.ptr >= this.end;
    }

    private boolean isDigit(int offset2) {
        return Character.isDigit(this.peek(offset2));
    }

    private boolean isSpace() {
        return Character.isSpaceChar(this.peek());
    }

    private void needColon(ThreadContext context, String label2, int start2) {
        if (this.peek() != 58) {
            throw Error.argumentError(context, RubyStringBuilder.str(context.runtime, "missing " + label2 + " part: ", this.substr(context, start2)));
        }
        this.advance();
    }

    private void noFraction(ThreadContext context, String label2, int start2) {
        if (this.peek() == 46) {
            throw Error.argumentError(context, RubyStringBuilder.str(context.runtime, "fraction " + label2 + " is not supported: ", this.substr(context, start2)));
        }
    }

    private IRubyObject substr(ThreadContext context, int from) {
        return context.runtime.newString(new ByteList(this.bytes, from, this.ptr - from + 1, true));
    }

    private int twoDigits(ThreadContext context, String label2) {
        int len = this.end - this.ptr;
        if (len < 2 || !this.isDigit(0) || !this.isDigit(1) || len > 2 && this.isDigit(2)) {
            StringBuilder builder = new StringBuilder("two digits ");
            builder.append(label2).append(" is expected");
            byte pre = this.peek(-1);
            if (pre == 45 || pre == 58) {
                builder.append(" after '").append((char)pre).append("'");
            }
            builder.append(": ").append(new ByteList(this.bytes, this.ptr - 1, len > 10 ? 11 : len + 1, true));
            throw Error.argumentError(context, builder.toString());
        }
        return (this.peek(0) - 48) * 10 + (this.peek(1) - 48);
    }

    private int expectTwoDigits(ThreadContext context, String label2, int max2) {
        int value2 = this.twoDigits(context, label2);
        if (value2 > max2) {
            throw Error.argumentError(context, label2 + " out of range");
        }
        this.advance();
        this.advance();
        return value2;
    }

    private IRubyObject parseInt(ThreadContext context, boolean parseSign) {
        int sign2 = 1;
        if (parseSign) {
            this.eatSpace();
            byte signByte = this.peek();
            if (signByte == 43) {
                ++this.ndigits;
                this.advance();
            } else if (signByte == 45) {
                ++this.ndigits;
                this.advance();
                sign2 = -1;
            }
        }
        long total2 = 0L;
        while (!this.isEOS() && this.isDigit(0)) {
            total2 = total2 * 10L + (long)(this.peek() - 48);
            this.advance();
            ++this.ndigits;
        }
        return new RubyFixnum(context.runtime, (long)sign2 * total2);
    }
}

