/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyIndexError;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.KeyError;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"KeyError"}, parent="IndexError")
public class RubyKeyError
extends RubyIndexError {
    private static final String[] VALID_KEYS = new String[]{"receiver", "key"};
    private IRubyObject receiver;
    private IRubyObject key;

    protected RubyKeyError(Ruby runtime2, RubyClass exceptionClass) {
        super(runtime2, exceptionClass);
    }

    public RubyKeyError(Ruby runtime2, RubyClass exceptionClass, String message2, IRubyObject recv2, IRubyObject key2) {
        super(runtime2, exceptionClass, message2);
        this.receiver = recv2;
        this.key = key2;
    }

    static RubyClass define(ThreadContext context, RubyClass IndexError2) {
        return (RubyClass)((RubyModule)Define.defineClass(context, "KeyError", IndexError2, RubyKeyError::new).reifiedClass(RubyKeyError.class)).defineMethods(context, RubyKeyError.class);
    }

    @Override
    protected RaiseException constructThrowable(String message2) {
        return new KeyError(message2, this);
    }

    @Override
    @JRubyMethod
    public IRubyObject initialize(ThreadContext context) {
        return context.nil;
    }

    @Override
    @JRubyMethod
    public IRubyObject initialize(ThreadContext context, IRubyObject messageOrKwargs) {
        IRubyObject[] receiverKey = ArgsUtil.extractKeywordArgs(context, messageOrKwargs, VALID_KEYS);
        if (receiverKey == null) {
            return this.initialize(context, messageOrKwargs, null);
        }
        return this.initializeCommon(context, context.nil, receiverKey);
    }

    @Override
    @JRubyMethod
    public IRubyObject initialize(ThreadContext context, IRubyObject message2, IRubyObject kwargs) {
        IRubyObject[] receiverKey = ArgsUtil.extractKeywordArgs(context, kwargs, VALID_KEYS);
        return this.initializeCommon(context, message2, receiverKey);
    }

    private IRubyObject initializeCommon(ThreadContext context, IRubyObject message2, IRubyObject[] receiverKey) {
        IRubyObject key2;
        IRubyObject receiver2;
        if (receiverKey == null) {
            receiver2 = null;
            key2 = null;
        } else {
            receiver2 = receiverKey[0];
            key2 = receiverKey[1];
        }
        this.setMessage(message2);
        this.receiver = receiver2;
        this.key = key2;
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext context, IRubyObject message2, IRubyObject receiver2, IRubyObject key2) {
        this.setMessage(message2);
        this.receiver = receiver2;
        this.key = key2;
        return context.nil;
    }

    @Deprecated(since="10.0")
    public IRubyObject receiver() {
        return this.receiver(this.getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject receiver(ThreadContext context) {
        if (this.receiver == null) {
            throw Error.argumentError(context, "no receiver is available");
        }
        return this.receiver;
    }

    @Deprecated(since="10.0")
    public IRubyObject key() {
        return this.key(this.getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject key(ThreadContext context) {
        if (this.key == null) {
            throw Error.argumentError(context, "no key is available");
        }
        return this.key;
    }
}

