/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.proxy;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.internal.runtime.AbstractIRMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.java.util.ClassUtils;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.JavaProxyConstructor;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.javasupport.proxy.JavaProxyReflectionObject;
import org.jruby.javasupport.proxy.ReifiedJavaProxy;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.JavaNameMangler;

@JRubyClass(name={"Java::JavaProxyClass"})
public class JavaProxyClass
extends JavaProxyReflectionObject {
    private final Class proxyClass;
    private final ArrayList<JavaProxyMethod> methods = new ArrayList();
    private final HashMap<String, ArrayList<JavaProxyMethod>> methodMap = new HashMap();
    private transient JavaProxyConstructor[] constructors;
    private static final HashSet<String> EXCLUDE_MODULES = new HashSet(8, 1.0f);
    private static final ThreadLocal<Object[]> lookup;

    private JavaProxyClass(ThreadContext context, Class<?> proxyClass) {
        super(context.runtime, Access.getClass(context, "Java", "JavaProxyClass"));
        this.proxyClass = proxyClass;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JavaProxyClass && this.proxyClass == ((JavaProxyClass)other).proxyClass;
    }

    @Override
    public int hashCode() {
        return this.proxyClass.hashCode();
    }

    public Object getValue() {
        return this;
    }

    public Class getSuperclass() {
        return this.proxyClass.getSuperclass();
    }

    public Class[] getInterfaces() {
        Class<?>[] ifaces = this.proxyClass.getInterfaces();
        Class[] result2 = new Class[ifaces.length - 1];
        int j = 0;
        for (int i2 = 0; i2 < ifaces.length; ++i2) {
            if (ifaces[i2] == ReifiedJavaProxy.class) continue;
            result2[j++] = ifaces[i2];
        }
        return result2;
    }

    @Deprecated(since="10.0")
    public JavaProxyConstructor[] getConstructors() {
        return this.getConstructors(this.getCurrentContext());
    }

    public JavaProxyConstructor[] getConstructors(ThreadContext context) {
        JavaProxyConstructor[] constructorsCached = this.constructors;
        if (constructorsCached != null) {
            return constructorsCached;
        }
        Constructor<?>[] ctors = this.proxyClass.getConstructors();
        ArrayList<JavaProxyConstructor> constructors2 = new ArrayList<JavaProxyConstructor>(ctors.length);
        for (int i2 = 0; i2 < ctors.length; ++i2) {
            JavaProxyConstructor jpc = new JavaProxyConstructor(context.runtime, this, ctors[i2]);
            if (jpc.isExportable()) continue;
            constructors2.add(jpc);
        }
        this.constructors = constructors2.toArray(new JavaProxyConstructor[constructors2.size()]);
        return this.constructors;
    }

    @Deprecated(since="10.0")
    public JavaProxyConstructor getConstructor(Class[] args2) throws SecurityException, NoSuchMethodException {
        Class[] realArgs = new Class[args2.length + 2];
        System.arraycopy(args2, 0, realArgs, 0, args2.length);
        realArgs[args2.length] = Ruby.class;
        realArgs[args2.length + 1] = RubyClass.class;
        Constructor constructor2 = this.proxyClass.getConstructor(realArgs);
        return new JavaProxyConstructor(this.getCurrentContext().runtime, this, constructor2);
    }

    public JavaProxyMethod[] getMethods() {
        return this.methods.toArray(new JavaProxyMethod[this.methods.size()]);
    }

    public JavaProxyMethod getMethod(String name2, Class[] parameterTypes) {
        List methods2 = this.methodMap.get(name2);
        if (methods2 != null && methods2.size() > 0) {
            int i2 = methods2.size();
            while (--i2 >= 0) {
                ProxyMethodImpl impl2 = (ProxyMethodImpl)methods2.get(i2);
                if (!impl2.matches(name2, parameterTypes)) continue;
                return impl2;
            }
        }
        return null;
    }

    @Override
    public final Class getJavaClass() {
        return this.proxyClass;
    }

    public void initMethod(ThreadContext context, String name2, String desc, boolean hasSuper) {
        Class proxy2 = this.proxyClass;
        try {
            Class[] paramTypes = JavaProxyClass.parse(proxy2.getClassLoader(), desc);
            Method method2 = proxy2.getDeclaredMethod(name2, paramTypes);
            Method superMethod = null;
            if (hasSuper) {
                superMethod = proxy2.getDeclaredMethod(JavaProxyClass.generateSuperName(proxy2.getName(), name2), paramTypes);
            }
            ProxyMethodImpl proxyMethod = new ProxyMethodImpl(context.runtime, this, method2, superMethod);
            this.methods.add(proxyMethod);
            ArrayList<JavaProxyMethod> methodsWithName = this.methodMap.get(name2);
            if (methodsWithName == null) {
                methodsWithName = new ArrayList(2);
                this.methodMap.put(name2, methodsWithName);
            }
            methodsWithName.add(proxyMethod);
        }
        catch (ClassNotFoundException e) {
            throw new InternalError(e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new InternalError(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.getMessage(), e);
        }
    }

    public static String generateSuperName(String className, String superName) {
        return "__super$" + JavaNameMangler.mangleMethodName(className) + "$" + superName;
    }

    private static Class[] parse(final ClassLoader loader, String desc) throws ClassNotFoundException {
        ArrayList<Class<Byte>> types = new ArrayList<Class<Byte>>(8);
        int idx = 1;
        while (desc.charAt(idx) != ')') {
            Class type2;
            int arr = 0;
            while (desc.charAt(idx) == '[') {
                ++idx;
                ++arr;
            }
            switch (desc.charAt(idx)) {
                case 'L': {
                    int semi = desc.indexOf(59, idx);
                    final String name2 = desc.substring(idx + 1, semi);
                    idx = semi;
                    try {
                        type2 = AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                            @Override
                            public Class run() throws ClassNotFoundException {
                                return Class.forName(name2.replace('/', '.'), false, loader);
                            }
                        });
                        break;
                    }
                    catch (PrivilegedActionException e) {
                        throw (ClassNotFoundException)e.getException();
                    }
                }
                case 'B': {
                    type2 = Byte.TYPE;
                    break;
                }
                case 'C': {
                    type2 = Character.TYPE;
                    break;
                }
                case 'Z': {
                    type2 = Boolean.TYPE;
                    break;
                }
                case 'S': {
                    type2 = Short.TYPE;
                    break;
                }
                case 'I': {
                    type2 = Integer.TYPE;
                    break;
                }
                case 'J': {
                    type2 = Long.TYPE;
                    break;
                }
                case 'F': {
                    type2 = Float.TYPE;
                    break;
                }
                case 'D': {
                    type2 = Double.TYPE;
                    break;
                }
                default: {
                    throw new InternalError("cannot parse " + desc + "[" + idx + "]");
                }
            }
            ++idx;
            if (arr != 0) {
                type2 = Array.newInstance(type2, new int[arr]).getClass();
            }
            types.add(type2);
        }
        return types.isEmpty() ? ClassUtils.EMPTY_CLASS_ARRAY : types.toArray(new Class[types.size()]);
    }

    public static void createJavaProxyClasses(ThreadContext context, RubyModule Java2, RubyClass Object2) {
        JavaProxyClass.createJavaProxyClassClass(context, Object2, Java2);
        ProxyMethodImpl.createJavaProxyMethodClass(context, Object2, Java2);
        JavaProxyConstructor.createJavaProxyConstructorClass(context, Object2, Java2);
    }

    public static RubyClass createJavaProxyClassClass(ThreadContext context, RubyClass Object2, RubyModule Java2) {
        RubyClass JavaProxyClass2 = (RubyClass)((RubyModule)Java2.defineClassUnder(context, "JavaProxyClass", Object2, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR)).defineMethods(context, JavaProxyClass.class);
        JavaProxyReflectionObject.registerRubyMethods(context, JavaProxyClass2);
        return JavaProxyClass2;
    }

    @Deprecated(since="10.0")
    public static RubyObject get_with_class(IRubyObject self2, IRubyObject obj) {
        return JavaProxyClass.get_with_class(((RubyBasicObject)self2).getCurrentContext(), self2, obj);
    }

    @JRubyMethod(meta=true)
    public static RubyObject get_with_class(ThreadContext context, IRubyObject self2, IRubyObject obj) {
        return JavaProxyClass.getProxyClass(context, Convert.castAsClass(context, obj));
    }

    public static JavaProxyClass setProxyClassReified(ThreadContext context, RubyClass clazz, Class<? extends ReifiedJavaProxy> reified, boolean allocator) {
        JavaProxyClass proxyClass = new JavaProxyClass(context, reified);
        clazz.setInstanceVariable("@java_proxy_class", proxyClass);
        RubyClass singleton = clazz.singletonClass(context);
        singleton.setInstanceVariable("@java_proxy_class", proxyClass);
        singleton.setInstanceVariable("@java_class", Java.wrapJavaObject(context, reified));
        if (allocator) {
            boolean defaultNew;
            DynamicMethod oldNewMethod = singleton.searchMethod("new");
            boolean bl = defaultNew = !(oldNewMethod instanceof AbstractIRMethod);
            if (defaultNew) {
                singleton.addMethod(context, "new", new ConcreteJavaProxy.NewMethodReified(clazz, reified));
            }
            ConcreteJavaProxy.StaticJCreateMethod.tryInstall(context.runtime, clazz, proxyClass, reified, defaultNew);
        }
        return proxyClass;
    }

    public static int addStaticInitLookup(Object ... objects) {
        if (objects != null) {
            JavaProxyClass.ensureStaticIntConsumed();
        }
        lookup.set(objects);
        return System.identityHashCode(objects);
    }

    public static void ensureStaticIntConsumed() {
        if (lookup.get() != null) {
            throw new IllegalStateException("Thread local class wasn't consumed for: " + String.valueOf(lookup.get()[1]));
        }
    }

    public static Object[] getStaticInitLookup(int id2) {
        Object[] objects = lookup.get();
        if (objects == null) {
            throw new IllegalStateException("Thread local class wasn't set up for reification");
        }
        if (System.identityHashCode(objects) != id2) {
            throw new IllegalStateException("Thread local class wasn't what reification was expecting: " + String.valueOf(lookup.get()[1]));
        }
        lookup.set(null);
        return objects;
    }

    @Deprecated(since="10.0")
    public static JavaProxyClass getProxyClass(Ruby runtime2, RubyClass clazz) {
        return JavaProxyClass.getProxyClass(runtime2.getCurrentContext(), clazz);
    }

    public static JavaProxyClass getProxyClass(ThreadContext context, RubyClass clazz) {
        clazz.reifyWithAncestors();
        return (JavaProxyClass)clazz.getInstanceVariable("@java_proxy_class");
    }

    @Deprecated(since="10.0")
    public IRubyObject superclass() {
        return this.superclass(this.getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject superclass(ThreadContext context) {
        return Java.getInstance(context.runtime, this.getSuperclass());
    }

    @Deprecated(since="10.0")
    public RubyArray methods() {
        return this.methods(this.getCurrentContext());
    }

    @JRubyMethod
    public RubyArray methods(ThreadContext context) {
        return this.toRubyArray(context, this.getMethods());
    }

    @Deprecated(since="10.0")
    public RubyArray interfaces() {
        return this.interfaces(this.getCurrentContext());
    }

    @JRubyMethod
    public RubyArray interfaces(ThreadContext context) {
        return JavaProxyClass.toClassArray(context, this.getInterfaces());
    }

    @Deprecated(since="10.0")
    public final RubyArray constructors() {
        return this.constructors(this.getCurrentContext());
    }

    @JRubyMethod
    public final RubyArray constructors(ThreadContext context) {
        return this.toRubyArray(context, this.getConstructors(context));
    }

    public final String nameOnInspection() {
        return "[Proxy:" + this.getSuperclass().getName() + "]";
    }

    static {
        EXCLUDE_MODULES.add("Kernel");
        EXCLUDE_MODULES.add("Java");
        EXCLUDE_MODULES.add("JavaProxyMethods");
        EXCLUDE_MODULES.add("Enumerable");
        lookup = new ThreadLocal();
    }

    @JRubyClass(name={"Java::JavaProxyMethod"})
    public static class ProxyMethodImpl
    extends JavaProxyReflectionObject
    implements JavaProxyMethod {
        private final Method method;
        private final Method superMethod;
        private final Class[] parameterTypes;
        private final JavaProxyClass proxyClass;
        private Object state;

        public static RubyClass createJavaProxyMethodClass(ThreadContext context, RubyClass Object2, RubyModule Java2) {
            RubyClass JavaProxyMethod2 = (RubyClass)((RubyModule)Java2.defineClassUnder(context, "JavaProxyMethod", Object2, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR)).defineMethods(context, ProxyMethodImpl.class);
            JavaProxyReflectionObject.registerRubyMethods(context, JavaProxyMethod2);
            return JavaProxyMethod2;
        }

        public ProxyMethodImpl(Ruby runtime2, JavaProxyClass clazz, Method method2, Method superMethod) {
            super(runtime2, ProxyMethodImpl.getJavaProxyMethod(runtime2.getCurrentContext()));
            this.method = method2;
            this.parameterTypes = method2.getParameterTypes();
            this.superMethod = superMethod;
            this.proxyClass = clazz;
        }

        private static RubyClass getJavaProxyMethod(ThreadContext context) {
            return context.runtime.getJavaSupport().getJavaModule(context).getClass(context, "JavaProxyMethod");
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof ProxyMethodImpl)) {
                return false;
            }
            ProxyMethodImpl that = (ProxyMethodImpl)other;
            return this.method == that.method || this.method.equals(that.method);
        }

        @Override
        public int hashCode() {
            return this.method.hashCode();
        }

        public Method getMethod() {
            return this.method;
        }

        @Override
        public Method getSuperMethod() {
            return this.superMethod;
        }

        @Override
        public int getModifiers() {
            return this.method.getModifiers();
        }

        @Override
        public String getName() {
            return this.method.getName();
        }

        @Override
        public final Class<?>[] getExceptionTypes() {
            return this.method.getExceptionTypes();
        }

        @Override
        public final Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        @Override
        public final boolean isVarArgs() {
            return this.method.isVarArgs();
        }

        @Override
        public boolean hasSuperImplementation() {
            return this.superMethod != null;
        }

        @Override
        public Object invoke(Object proxy2, Object[] args2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            if (!this.hasSuperImplementation()) {
                throw new NoSuchMethodException();
            }
            return this.superMethod.invoke(proxy2, args2);
        }

        @Override
        public Object getState() {
            return this.state;
        }

        @Override
        public void setState(Object state2) {
            this.state = state2;
        }

        @Override
        public String toString() {
            return this.method.toString();
        }

        @Override
        @Deprecated
        public Object defaultResult() {
            Class<?> returnType = this.method.getReturnType();
            if (returnType == Void.TYPE) {
                return null;
            }
            if (returnType == Boolean.TYPE) {
                return Boolean.FALSE;
            }
            if (returnType == Byte.TYPE) {
                return (byte)0;
            }
            if (returnType == Short.TYPE) {
                return (short)0;
            }
            if (returnType == Integer.TYPE) {
                return 0;
            }
            if (returnType == Long.TYPE) {
                return 0L;
            }
            if (returnType == Float.TYPE) {
                return Float.valueOf(0.0f);
            }
            if (returnType == Double.TYPE) {
                return 0.0;
            }
            return null;
        }

        public final boolean matches(String name2, Class<?>[] parameterTypes) {
            return this.method.getName().equals(name2) && Arrays.equals(this.parameterTypes, parameterTypes);
        }

        @Override
        public final Class<?> getReturnType() {
            return this.method.getReturnType();
        }

        @Deprecated(since="10.0")
        public RubyObject name() {
            return Create.newString(this.getCurrentContext(), this.getName());
        }

        @Override
        @JRubyMethod(name={"declaring_class"})
        public final JavaProxyClass getDeclaringClass() {
            return this.proxyClass;
        }

        @Deprecated(since="10.0")
        public RubyArray argument_types() {
            return this.argument_types(this.getCurrentContext());
        }

        @JRubyMethod
        public RubyArray argument_types(ThreadContext context) {
            return ProxyMethodImpl.toClassArray(context, this.getParameterTypes());
        }

        @Deprecated(since="10.0")
        public IRubyObject super_p() {
            return this.super_p(this.getCurrentContext());
        }

        @JRubyMethod(name={"super?"})
        public IRubyObject super_p(ThreadContext context) {
            return this.hasSuperImplementation() ? context.tru : context.fals;
        }

        @Deprecated(since="10.0")
        public RubyFixnum arity() {
            return this.arity(this.getCurrentContext());
        }

        @JRubyMethod
        public RubyFixnum arity(ThreadContext context) {
            return Convert.asFixnum(context, this.getArity());
        }

        @Override
        @Deprecated(since="10.0")
        public RubyString inspect() {
            return this.inspect(this.getCurrentContext());
        }

        @Override
        @JRubyMethod
        public RubyString inspect(ThreadContext context) {
            StringBuilder buf = new StringBuilder();
            buf.append("#<");
            buf.append(this.getDeclaringClass().nameOnInspection()).append('/').append(this.getName());
            JavaCallable.inspectParameterTypes(buf, this);
            buf.append('>');
            return Create.newString(context, buf.toString());
        }

        @Deprecated(since="10.0")
        public IRubyObject do_invoke(IRubyObject[] args2) {
            return this.do_invoke(this.getCurrentContext(), args2);
        }

        @JRubyMethod(name={"invoke"}, rest=true)
        public IRubyObject do_invoke(ThreadContext context, IRubyObject[] args2) {
            if (args2.length != 1 + this.getArity()) {
                throw Error.argumentError(context, args2.length, 1 + this.getArity());
            }
            IRubyObject iRubyObject = args2[0];
            if (!(iRubyObject instanceof JavaProxy)) {
                throw Error.typeError(context, "not a java proxy: " + String.valueOf(args2[0] == null ? null : args2[0].getClass()));
            }
            JavaProxy invokee = (JavaProxy)iRubyObject;
            Object receiver_value = invokee.getObject();
            Object[] arguments = new Object[args2.length - 1];
            Class<?>[] parameterTypes = this.getParameterTypes();
            for (int i2 = 0; i2 < arguments.length; ++i2) {
                arguments[i2] = args2[i2 + 1].toJava(parameterTypes[i2]);
            }
            try {
                Object javaResult = this.superMethod.invoke(receiver_value, arguments);
                return JavaUtil.convertJavaToRuby(context.runtime, javaResult, this.getReturnType());
            }
            catch (IllegalArgumentException ex) {
                throw Error.typeError(context, "expected " + String.valueOf(this.argument_types(context).inspect(context)));
            }
            catch (IllegalAccessException ex) {
                throw Error.typeError(context, "illegal access on '" + this.superMethod.getName() + "': " + ex.getMessage());
            }
            catch (InvocationTargetException ex) {
                if (context.runtime.getDebug().isTrue()) {
                    ex.getTargetException().printStackTrace();
                }
                context.runtime.getJavaSupport().handleNativeException(ex.getTargetException(), this.superMethod);
                return context.nil;
            }
        }

        @Override
        public final int getArity() {
            return this.getParameterTypes().length;
        }
    }
}

