/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import org.jruby.ext.openssl.impl.Base64BIOFilter;
import org.jruby.ext.openssl.impl.CipherBIOFilter;
import org.jruby.ext.openssl.impl.MemBIO;
import org.jruby.ext.openssl.impl.MessageDigestBIOFilter;
import org.jruby.ext.openssl.impl.NullSinkBIO;
import org.jruby.ext.openssl.impl.PKCS7Exception;
import org.jruby.ext.openssl.impl.SMIME;

public class BIO {
    public static final int TYPE_DESCRIPTOR = 256;
    public static final int TYPE_FILTER = 512;
    public static final int TYPE_SOURCE_SINK = 1024;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_MEM = 1025;
    public static final int TYPE_FILE = 1026;
    public static final int TYPE_FD = 1284;
    public static final int TYPE_SOCKET = 1285;
    public static final int TYPE_NULL = 1030;
    public static final int TYPE_SSL = 519;
    public static final int TYPE_MD = 520;
    public static final int TYPE_BUFFER = 521;
    public static final int TYPE_CIPHER = 522;
    public static final int TYPE_BASE64 = 523;
    public static final int TYPE_CONNECT = 1292;
    public static final int TYPE_ACCEPT = 1293;
    public static final int TYPE_PROXY_CLIENT = 526;
    public static final int TYPE_PROXY_SERVER = 527;
    public static final int TYPE_NBIO_TEST = 528;
    public static final int TYPE_NULL_FILTER = 529;
    public static final int TYPE_BER = 530;
    public static final int TYPE_BIO = 1043;
    protected BIO nextBio;
    protected BIO prevBio;
    private static final byte[] CONTENT_TEXT;

    public static InputStream asInputStream(BIO input) {
        return new BIOInputStream(input);
    }

    public static OutputStream asOutputStream(BIO output) {
        return new BIOOutputStream(output);
    }

    public static BIO base64Filter(BIO real) {
        Base64BIOFilter b64 = new Base64BIOFilter();
        ((BIO)b64).push(real);
        return b64;
    }

    public static BIO mdFilter(MessageDigest md) {
        return new MessageDigestBIOFilter(md);
    }

    public static BIO cipherFilter(Cipher cipher2) {
        return new CipherBIOFilter(cipher2);
    }

    public static BIO fromString(String input) {
        MemBIO bio = new MemBIO();
        byte[] buf = null;
        try {
            buf = input.getBytes("ISO8859-1");
            bio.write(buf, 0, buf.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bio;
    }

    public static BIO buffered() {
        return null;
    }

    public static BIO mem() {
        return new MemBIO();
    }

    public static BIO nullSink() {
        return new NullSinkBIO();
    }

    public static BIO memBuf(byte[] arr) {
        return BIO.memBuf(arr, 0, arr.length);
    }

    public static BIO memBuf(byte[] arr, int offset, int length) {
        try {
            MemBIO bio = new MemBIO();
            ((BIO)bio).write(arr, offset, length);
            return bio;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void flush() throws IOException, PKCS7Exception {
    }

    public void crlfCopy(BIO out, int flags) throws IOException {
        BIO in = this;
        byte[] linebuf = new byte[1024];
        int[] len = new int[]{0};
        if ((flags & 0x80) > 0) {
            while ((len[0] = in.read(linebuf, 0, 1024)) > 0) {
                out.write(linebuf, 0, len[0]);
            }
            return;
        }
        if ((flags & 1) > 0) {
            out.write(CONTENT_TEXT, 0, CONTENT_TEXT.length);
        }
        while ((len[0] = in.gets(linebuf, 1024)) > 0) {
            boolean eol = SMIME.stripEol(linebuf, len);
            if (len[0] != 0) {
                out.write(linebuf, 0, len[0]);
            }
            if (!eol) continue;
            out.write(SMIME.NEWLINE, 0, 2);
        }
    }

    public int gets(byte[] in, int len) throws IOException {
        throw new UnsupportedOperationException("for " + this.getClass().getName());
    }

    public int write(byte[] out, int offset, int len) throws IOException {
        throw new UnsupportedOperationException("for " + this.getClass().getName());
    }

    public int read(byte[] into, int offset, int len) throws IOException {
        throw new UnsupportedOperationException("for " + this.getClass().getName());
    }

    public void setMemEofReturn(int value2) {
        throw new UnsupportedOperationException("for " + this.getClass().getName());
    }

    public BIO push(BIO bio) {
        BIO lb = this;
        while (lb.nextBio != null) {
            lb = lb.nextBio;
        }
        if (bio != null) {
            bio.prevBio = lb;
        }
        lb.nextBio = bio;
        return this;
    }

    public BIO pop() {
        BIO ret = this.nextBio;
        if (this.prevBio != null) {
            this.prevBio.nextBio = this.nextBio;
        }
        if (this.nextBio != null) {
            this.nextBio.prevBio = this.prevBio;
        }
        this.nextBio = null;
        this.prevBio = null;
        return ret;
    }

    public BIO findType(int type) {
        int mask = type & 0xFF;
        BIO bio = this;
        do {
            int mt = bio.getType();
            if (!(mask == 0 ? (mt & type) != 0 : mt == type)) continue;
            return bio;
        } while ((bio = bio.nextBio) != null);
        return null;
    }

    public BIO next() {
        return this.nextBio;
    }

    public int getType() {
        return 1043;
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        String[] names = this.getClass().getName().split("\\.");
        return "#<BIO:" + names[names.length - 1] + " next=" + this.next() + ">";
    }

    public byte[] toBytes() {
        throw new UnsupportedOperationException("toBytes() for " + this.getClass().getName());
    }

    static {
        try {
            CONTENT_TEXT = "Content-Type: text/plain\r\n\r\n".getBytes("ISO8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private static final class BIOOutputStream
    extends OutputStream {
        private BIO bio;

        public BIOOutputStream(BIO bio) {
            this.bio = bio;
        }

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] out) throws IOException {
            this.write(out, 0, out.length);
        }

        @Override
        public void write(byte[] out, int off, int len) throws IOException {
            this.bio.write(out, off, len);
        }
    }

    private static final class BIOInputStream
    extends InputStream {
        private BIO bio;

        public BIOInputStream(BIO bio) {
            this.bio = bio;
        }

        @Override
        public int read() throws IOException {
            byte[] buffer = new byte[1];
            int read2 = this.bio.read(buffer, 0, 1);
            if (read2 == 0) {
                return -1;
            }
            return buffer[0] & 0xFF;
        }

        @Override
        public int read(byte[] into) throws IOException {
            return this.read(into, 0, into.length);
        }

        @Override
        public int read(byte[] into, int off, int len) throws IOException {
            int read2 = this.bio.read(into, off, len);
            if (read2 == 0) {
                return -1;
            }
            return read2;
        }
    }
}

