/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.filter.stream;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.java.sen.dictionary.Morpheme;
import net.java.sen.dictionary.Sentence;
import net.java.sen.dictionary.Token;
import net.java.sen.filter.StreamFilter;

public class CommentFilter
implements StreamFilter {
    protected List<Rule> ruleList = new ArrayList<Rule>();
    private List<Token> commentTokens = new ArrayList<Token>();

    public void readRules(BufferedReader reader) throws IOException {
        String line = null;
        while ((line = reader.readLine()) != null) {
            StringTokenizer tokenizer = new StringTokenizer(line);
            if (!tokenizer.hasMoreTokens()) continue;
            Rule rule = new Rule();
            if (tokenizer.countTokens() == 2) {
                rule.start = tokenizer.nextToken();
                rule.end = "";
                rule.partOfSpeech = tokenizer.nextToken();
            } else {
                rule.start = tokenizer.nextToken();
                rule.end = tokenizer.nextToken();
                rule.partOfSpeech = tokenizer.nextToken();
            }
            this.ruleList.add(rule);
        }
    }

    @Override
    public void preProcess(Sentence sentence) {
        Iterator<Rule> itr = this.ruleList.iterator();
        this.commentTokens.clear();
        String surface = new String(sentence.getCharacters());
        while (itr.hasNext()) {
            int count = 0;
            Rule rule = itr.next();
            while (count < surface.length()) {
                int start = -1;
                int end = -1;
                start = surface.indexOf(rule.start, count);
                if (start >= 0) {
                    count = start + rule.start.length();
                    end = rule.end.equals("") ? start : surface.indexOf(rule.end, count);
                    if (end >= 0) {
                        end = rule.end.equals("") ? (end += rule.start.length()) : (end += rule.end.length());
                        count = end;
                        String tokenStr = surface.substring(start, end);
                        Morpheme morpheme = new Morpheme(rule.partOfSpeech, "*", "*", "*", new String[]{tokenStr}, new String[]{tokenStr}, null);
                        Token token = new Token(tokenStr, 0, start, end - start, morpheme);
                        this.commentTokens.add(token);
                        sentence.setBreakingIgnoreSpan(start, (short)(end - start));
                        continue;
                    }
                    count = surface.length();
                    continue;
                }
                count = surface.length();
            }
        }
    }

    @Override
    public List<Token> postProcess(List<Token> tokens) {
        if (this.commentTokens.size() == 0 || tokens.size() == 0) {
            return tokens;
        }
        if (tokens.size() == 0) {
            return new ArrayList<Token>(this.commentTokens);
        }
        ArrayList<Token> newTokens = new ArrayList<Token>(tokens.size() + this.commentTokens.size());
        Iterator<Token> iterator = this.commentTokens.iterator();
        Token commentToken = iterator.next();
        for (int i = 0; i < tokens.size(); ++i) {
            while (commentToken != null && tokens.get(i).getStart() >= commentToken.getStart()) {
                newTokens.add(commentToken);
                if (!iterator.hasNext()) {
                    commentToken = null;
                    break;
                }
                commentToken = iterator.next();
            }
            newTokens.add(tokens.get(i));
        }
        if (commentToken != null) {
            newTokens.add(commentToken);
            while (iterator.hasNext()) {
                newTokens.add(iterator.next());
            }
        }
        return newTokens;
    }

    static class Rule {
        public String start;
        public String end;
        public String partOfSpeech;

        Rule() {
        }
    }
}

