/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core.metrics;

import io.github.resilience4j.core.registry.EntryAddedEvent;
import io.github.resilience4j.core.registry.EntryRemovedEvent;
import io.github.resilience4j.core.registry.EntryReplacedEvent;
import io.github.resilience4j.core.registry.RegistryEventConsumer;

public interface MetricsPublisher<E>
extends RegistryEventConsumer<E> {
    public void publishMetrics(E var1);

    public void removeMetrics(E var1);

    @Override
    default public void onEntryAddedEvent(EntryAddedEvent<E> entryAddedEvent) {
        this.publishMetrics(entryAddedEvent.getAddedEntry());
    }

    @Override
    default public void onEntryRemovedEvent(EntryRemovedEvent<E> entryRemoveEvent) {
        this.removeMetrics(entryRemoveEvent.getRemovedEntry());
    }

    @Override
    default public void onEntryReplacedEvent(EntryReplacedEvent<E> entryReplacedEvent) {
        this.removeMetrics(entryReplacedEvent.getOldEntry());
        this.publishMetrics(entryReplacedEvent.getNewEntry());
    }
}

