/*
 * Decompiled with CFR 0.152.
 */
package waffle.util.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import org.checkerframework.checker.index.qual.NonNegative;
import waffle.util.cache.Cache;

public class CaffeineCache<K, V>
implements Cache<K, V> {
    private final com.github.benmanes.caffeine.cache.Cache<K, V> cache;

    public CaffeineCache(@NonNegative long timeout) {
        this.cache = Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(timeout)).build();
    }

    @Override
    public V get(K key) {
        return this.cache.asMap().get(key);
    }

    @Override
    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    @Override
    public void remove(K key) {
        this.cache.asMap().remove(key);
    }

    @Override
    public int size() {
        return this.cache.asMap().size();
    }
}

