/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.classification.features;

import com.hankcs.hanlp.classification.corpus.Catalog;
import com.hankcs.hanlp.classification.corpus.Document;
import com.hankcs.hanlp.classification.corpus.IDataSet;
import com.hankcs.hanlp.classification.corpus.Lexicon;
import com.hankcs.hanlp.collection.trie.bintrie.BinTrie;
import java.util.Map;

public class BaseFeatureData {
    public int n;
    public int[][] featureCategoryJointCount;
    public int[] categoryCounts;
    public BinTrie<Integer> wordIdTrie;

    public BaseFeatureData(IDataSet dataSet) {
        Catalog catalog = dataSet.getCatalog();
        Lexicon lexicon = dataSet.getLexicon();
        this.n = dataSet.size();
        this.featureCategoryJointCount = new int[lexicon.size()][catalog.size()];
        this.categoryCounts = new int[catalog.size()];
        for (Document document : dataSet) {
            int n = document.category;
            this.categoryCounts[n] = this.categoryCounts[n] + 1;
            for (Map.Entry entry : document.tfMap.entrySet()) {
                int[] nArray = this.featureCategoryJointCount[(Integer)entry.getKey()];
                int n2 = document.category;
                nArray[n2] = nArray[n2] + 1;
            }
        }
    }
}

