/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.occurrence;

import com.hankcs.hanlp.collection.trie.bintrie.BinTrie;
import com.hankcs.hanlp.corpus.occurrence.PairFrequency;
import com.hankcs.hanlp.corpus.occurrence.TermFrequency;
import com.hankcs.hanlp.corpus.occurrence.TriaFrequency;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.tokenizer.NotionalTokenizer;
import com.hankcs.hanlp.utility.Predefine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Occurrence {
    public static final char RIGHT = '\u0000';
    static final char LEFT = '\u0001';
    double totalTerm = 0.0;
    double totalPair = 0.0;
    BinTrie<PairFrequency> triePair = new BinTrie();
    BinTrie<TermFrequency> trieSingle = new BinTrie();
    BinTrie<TriaFrequency> trieTria = new BinTrie();
    private Set<Map.Entry<String, PairFrequency>> entrySetPair;

    public void addPair(String first, String second) {
        this.addPair(first, '\u0000', second);
    }

    public void addTerm(String key) {
        TermFrequency value = this.trieSingle.get(key);
        if (value == null) {
            value = new TermFrequency(key);
            this.trieSingle.put(key, value);
        } else {
            value.increase();
        }
        this.totalTerm += 1.0;
    }

    private void addPair(String first, char delimiter, String second) {
        String key = first + delimiter + second;
        PairFrequency value = this.triePair.get(key);
        if (value == null) {
            value = PairFrequency.create(first, delimiter, second);
            this.triePair.put(key, value);
        } else {
            value.increase();
        }
        this.totalPair += 1.0;
    }

    public void addTria(String first, String second, String third) {
        String key = first + '\u0000' + second + '\u0000' + third;
        TriaFrequency value = this.trieTria.get(key);
        if (value == null) {
            value = TriaFrequency.create(first, '\u0000', second, third);
            this.trieTria.put(key, value);
        } else {
            value.increase();
        }
        key = second + '\u0000' + third + '\u0001' + first;
        value = this.trieTria.get(key);
        if (value == null) {
            value = TriaFrequency.create(second, third, '\u0001', first);
            this.trieTria.put(key, value);
        } else {
            value.increase();
        }
    }

    public int getTermFrequency(String term) {
        TermFrequency termFrequency = this.trieSingle.get(term);
        if (termFrequency == null) {
            return 0;
        }
        return (Integer)termFrequency.getValue();
    }

    public int getPairFrequency(String first, String second) {
        TermFrequency termFrequency = this.triePair.get(first + '\u0000' + second);
        if (termFrequency == null) {
            return 0;
        }
        return (Integer)termFrequency.getValue();
    }

    public void addAll(String[] termList) {
        for (String term : termList) {
            this.addTerm(term);
        }
        String first = null;
        for (String current : termList) {
            if (first != null) {
                this.addPair(first, current);
            }
            first = current;
        }
        for (int i = 2; i < termList.length; ++i) {
            this.addTria(termList[i - 2], termList[i - 1], termList[i]);
        }
    }

    public List<PairFrequency> getPhraseByMi() {
        ArrayList<PairFrequency> pairFrequencyList = new ArrayList<PairFrequency>(this.entrySetPair.size());
        for (Map.Entry<String, PairFrequency> entry : this.entrySetPair) {
            pairFrequencyList.add(entry.getValue());
        }
        Collections.sort(pairFrequencyList, new Comparator<PairFrequency>(){

            @Override
            public int compare(PairFrequency o1, PairFrequency o2) {
                return -Double.compare(o1.mi, o2.mi);
            }
        });
        return pairFrequencyList;
    }

    public List<PairFrequency> getPhraseByLe() {
        ArrayList<PairFrequency> pairFrequencyList = new ArrayList<PairFrequency>(this.entrySetPair.size());
        for (Map.Entry<String, PairFrequency> entry : this.entrySetPair) {
            pairFrequencyList.add(entry.getValue());
        }
        Collections.sort(pairFrequencyList, new Comparator<PairFrequency>(){

            @Override
            public int compare(PairFrequency o1, PairFrequency o2) {
                return -Double.compare(o1.le, o2.le);
            }
        });
        return pairFrequencyList;
    }

    public List<PairFrequency> getPhraseByRe() {
        ArrayList<PairFrequency> pairFrequencyList = new ArrayList<PairFrequency>(this.entrySetPair.size());
        for (Map.Entry<String, PairFrequency> entry : this.entrySetPair) {
            pairFrequencyList.add(entry.getValue());
        }
        Collections.sort(pairFrequencyList, new Comparator<PairFrequency>(){

            @Override
            public int compare(PairFrequency o1, PairFrequency o2) {
                return -Double.compare(o1.re, o2.re);
            }
        });
        return pairFrequencyList;
    }

    public List<PairFrequency> getPhraseByScore() {
        ArrayList<PairFrequency> pairFrequencyList = new ArrayList<PairFrequency>(this.entrySetPair.size());
        for (Map.Entry<String, PairFrequency> entry : this.entrySetPair) {
            pairFrequencyList.add(entry.getValue());
        }
        Collections.sort(pairFrequencyList, new Comparator<PairFrequency>(){

            @Override
            public int compare(PairFrequency o1, PairFrequency o2) {
                return -Double.compare(o1.score, o2.score);
            }
        });
        return pairFrequencyList;
    }

    public void addAll(List<Term> resultList) {
        String[] termList = new String[resultList.size()];
        int i = 0;
        for (Term word : resultList) {
            termList[i] = word.word;
            ++i;
        }
        this.addAll(termList);
    }

    public void addAll(String text) {
        this.addAll(NotionalTokenizer.segment(text));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\u4e8c\u9636\u5171\u73b0\uff1a\n");
        for (Map.Entry<String, PairFrequency> entry : this.triePair.entrySet()) {
            sb.append(entry.getValue()).append('\n');
        }
        sb.append("\u4e09\u9636\u5171\u73b0\uff1a\n");
        for (Map.Entry<String, PairFrequency> entry : this.trieTria.entrySet()) {
            sb.append(entry.getValue()).append('\n');
        }
        return sb.toString();
    }

    public double computeMutualInformation(String first, String second) {
        return Math.log(Math.max(1.0E-10, (double)this.getPairFrequency(first, second) / (this.totalPair / 2.0)) / Math.max(1.0E-10, (double)this.getTermFrequency(first) / this.totalTerm * (double)this.getTermFrequency(second) / this.totalTerm));
    }

    public double computeMutualInformation(PairFrequency pair) {
        return Math.log(Math.max(1.0E-10, (double)((Integer)pair.getValue()).intValue() / this.totalPair) / Math.max(1.0E-10, (double)CoreDictionary.getTermFrequency(pair.first) / (double)Predefine.TOTAL_FREQUENCY * (double)CoreDictionary.getTermFrequency(pair.second) / (double)Predefine.TOTAL_FREQUENCY));
    }

    public double computeLeftEntropy(PairFrequency pair) {
        Set<Map.Entry<String, TriaFrequency>> entrySet = this.trieTria.prefixSearch((String)pair.getKey() + '\u0001');
        return this.computeEntropy(entrySet);
    }

    public double computeRightEntropy(PairFrequency pair) {
        Set<Map.Entry<String, TriaFrequency>> entrySet = this.trieTria.prefixSearch((String)pair.getKey() + '\u0000');
        return this.computeEntropy(entrySet);
    }

    private double computeEntropy(Set<Map.Entry<String, TriaFrequency>> entrySet) {
        double totalFrequency = 0.0;
        for (Map.Entry<String, TriaFrequency> entry : entrySet) {
            totalFrequency += (double)((Integer)entry.getValue().getValue()).intValue();
        }
        double le = 0.0;
        for (Map.Entry<String, TriaFrequency> entry : entrySet) {
            double p = (double)((Integer)entry.getValue().getValue()).intValue() / totalFrequency;
            le += -p * Math.log(p);
        }
        return le;
    }

    public void compute() {
        PairFrequency value;
        this.entrySetPair = this.triePair.entrySet();
        double total_mi = 0.0;
        double total_le = 0.0;
        double total_re = 0.0;
        for (Map.Entry<String, PairFrequency> entry : this.entrySetPair) {
            value = entry.getValue();
            value.mi = this.computeMutualInformation(value);
            value.le = this.computeLeftEntropy(value);
            value.re = this.computeRightEntropy(value);
            total_mi += value.mi;
            total_le += value.le;
            total_re += value.re;
        }
        for (Map.Entry<String, PairFrequency> entry : this.entrySetPair) {
            value = entry.getValue();
            value.score = Occurrence.safeDivide(value.mi, total_mi) + Occurrence.safeDivide(value.le, total_le) + Occurrence.safeDivide(value.re, total_re);
            value.score *= (double)this.entrySetPair.size();
        }
    }

    private static double safeDivide(double x, double y) {
        if (y == 0.0) {
            return 0.0;
        }
        return x / y;
    }

    public Set<Map.Entry<String, TermFrequency>> getUniGram() {
        return this.trieSingle.entrySet();
    }

    public Set<Map.Entry<String, PairFrequency>> getBiGram() {
        return this.triePair.entrySet();
    }

    public Set<Map.Entry<String, TriaFrequency>> getTriGram() {
        return this.trieTria.entrySet();
    }
}

