/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.summary;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class BM25 {
    int D;
    double avgdl;
    List<List<String>> docs;
    Map<String, Integer>[] f;
    Map<String, Integer> df;
    Map<String, Double> idf;
    static final float k1 = 1.5f;
    static final float b = 0.75f;

    public BM25(List<List<String>> docs) {
        this.docs = docs;
        this.D = docs.size();
        for (List<String> sentence : docs) {
            this.avgdl += (double)sentence.size();
        }
        this.avgdl /= (double)this.D;
        this.f = new Map[this.D];
        this.df = new TreeMap<String, Integer>();
        this.idf = new TreeMap<String, Double>();
        this.init();
    }

    private void init() {
        int index = 0;
        for (List<String> list : this.docs) {
            TreeMap<String, Integer> tf = new TreeMap<String, Integer>();
            for (String string : list) {
                Integer freq = (Integer)tf.get(string);
                freq = (freq == null ? 0 : freq) + 1;
                tf.put(string, freq);
            }
            this.f[index] = tf;
            for (Map.Entry entry : tf.entrySet()) {
                String word = (String)entry.getKey();
                Integer freq = this.df.get(word);
                freq = (freq == null ? 0 : freq) + 1;
                this.df.put(word, freq);
            }
            ++index;
        }
        for (Map.Entry entry : this.df.entrySet()) {
            String word = (String)entry.getKey();
            Integer freq = (Integer)entry.getValue();
            this.idf.put(word, Math.log((double)(this.D - freq) + 0.5) - Math.log((double)freq.intValue() + 0.5));
        }
    }

    public double sim(List<String> sentence, int index) {
        double score = 0.0;
        for (String word : sentence) {
            if (!this.f[index].containsKey(word)) continue;
            int d = this.docs.get(index).size();
            Integer tf = this.f[index].get(word);
            score += this.idf.get(word) * (double)tf.intValue() * 2.5 / ((double)tf.intValue() + 1.5 * (0.25 + (double)(0.75f * (float)d) / this.avgdl));
        }
        return score;
    }

    public double[] simAll(List<String> sentence) {
        double[] scores = new double[this.D];
        for (int i = 0; i < this.D; ++i) {
            scores[i] = this.sim(sentence, i);
        }
        return scores;
    }
}

