/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.client.result;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.mariadb.jdbc.Statement;
import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.result.Result;
import org.mariadb.jdbc.client.socket.Reader;
import org.mariadb.jdbc.client.util.ClosableLock;

public class CompleteResult
extends Result {
    protected static final int BEFORE_FIRST_POS = -1;
    private boolean bulkResult;
    private boolean mightBeBulkResult;

    public CompleteResult(Statement stmt, boolean binaryProtocol, long maxRows, ColumnDecoder[] metadataList, Reader reader, Context context, int resultSetType, boolean closeOnCompletion, boolean traceEnable, boolean mightBeBulkResult) throws IOException, SQLException {
        super(stmt, binaryProtocol, maxRows, metadataList, reader, context, resultSetType, closeOnCompletion, traceEnable, false, 0);
        this.mightBeBulkResult = mightBeBulkResult;
        this.data = new byte[10][];
        if (maxRows > 0L) {
            this.data = new byte[10][];
            do {
                this.readNext(reader.readPacket(traceEnable));
            } while (!this.loaded && (long)this.dataSize < maxRows);
            if (!this.loaded) {
                this.skipRemaining();
            }
        } else {
            byte[] buf = reader.readPacket(traceEnable);
            if (buf[0] == -1 || buf[0] == -2 && buf.length < 0xFFFFFF) {
                this.data = new byte[0][];
                this.readNext(buf);
            } else {
                byte[] buf2 = reader.readPacket(traceEnable);
                if (buf2[0] == -1 || buf2[0] == -2 && buf2.length < 0xFFFFFF) {
                    this.data = new byte[1][];
                    this.data[0] = buf;
                    this.dataSize = 1;
                    this.readNext(buf2);
                } else {
                    this.data = new byte[10][];
                    this.data[0] = buf;
                    this.data[1] = buf2;
                    this.dataSize = 2;
                    do {
                        this.readNext(reader.readPacket(traceEnable));
                    } while (!this.loaded);
                }
            }
        }
    }

    @Override
    public void setBulkResult() {
        if (this.mightBeBulkResult) {
            this.bulkResult = true;
        }
    }

    private CompleteResult(ColumnDecoder[] metadataList, CompleteResult prev) {
        super(metadataList, prev);
    }

    public CompleteResult(ColumnDecoder[] metadataList, byte[][] data, Context context, int resultSetType) {
        super(metadataList, data, context, resultSetType);
    }

    public static ResultSet createResultSet(String columnName, DataType columnType, String[][] data, Context context, int flags, int resultSetType) {
        return CompleteResult.createResultSet(new String[]{columnName}, new DataType[]{columnType}, data, context, flags, resultSetType);
    }

    public static ResultSet createResultSet(String[] columnNames, DataType[] columnTypes, String[][] data, Context context, int flags, int resultSetType) {
        int columnNameLength = columnNames.length;
        ColumnDecoder[] columns = new ColumnDecoder[columnNameLength];
        for (int i = 0; i < columnNameLength; ++i) {
            columns[i] = ColumnDecoder.create(columnNames[i], columnTypes[i], flags);
        }
        ArrayList<byte[]> rows = new ArrayList<byte[]>();
        for (String[] rowData : data) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (String rowDatum : rowData) {
                if (rowDatum != null) {
                    byte[] bb = rowDatum.getBytes();
                    int len = bb.length;
                    if (len < 251) {
                        baos.write((byte)len);
                    } else {
                        baos.write(-4);
                        baos.write((byte)len);
                        baos.write((byte)(len >>> 8));
                    }
                    baos.write(bb, 0, bb.length);
                    continue;
                }
                baos.write(-5);
            }
            byte[] bb = baos.toByteArray();
            rows.add(bb);
        }
        return new CompleteResult(columns, (byte[][])rows.toArray((T[])new byte[0][0]), context, resultSetType);
    }

    public CompleteResult newResultsetWithUseAliasAsName() {
        ColumnDecoder[] newMeta = new ColumnDecoder[this.metadataList.length];
        for (int i = 0; i < this.metadataList.length; ++i) {
            newMeta[i] = this.metadataList[i].useAliasAsName();
        }
        return new CompleteResult(newMeta, this);
    }

    @Override
    public boolean next() throws SQLException {
        if (this.rowPointer < this.dataSize - 1) {
            this.setRow(this.data[++this.rowPointer]);
            return true;
        }
        this.setNullRowBuf();
        this.rowPointer = this.dataSize;
        return false;
    }

    @Override
    public boolean streaming() {
        return false;
    }

    @Override
    public boolean isBulkResult() {
        return this.bulkResult;
    }

    @Override
    public void fetchRemaining() {
    }

    @Override
    public void closeFromStmtClose(ClosableLock lock) {
        this.closed = true;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClose();
        if (this.rowPointer < this.dataSize) {
            return false;
        }
        return this.dataSize > 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClose();
        return this.rowPointer == 0 && this.dataSize > 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClose();
        return this.rowPointer == this.dataSize - 1 && this.dataSize > 0;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClose();
        this.rowPointer = -1;
        this.setNullRowBuf();
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClose();
        this.setNullRowBuf();
        this.rowPointer = this.dataSize;
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClose();
        this.rowPointer = 0;
        if (this.dataSize == 0) {
            this.setNullRowBuf();
            return false;
        }
        this.setRow(this.data[this.rowPointer]);
        return true;
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClose();
        this.rowPointer = this.dataSize - 1;
        if (this.rowPointer == -1) {
            this.setNullRowBuf();
            return false;
        }
        this.setRow(this.data[this.rowPointer]);
        return true;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClose();
        return this.rowPointer == this.dataSize ? 0 : this.rowPointer + 1;
    }

    @Override
    public boolean absolute(int idx) throws SQLException {
        this.checkClose();
        if (idx == 0 || idx > this.dataSize) {
            this.rowPointer = idx == 0 ? -1 : this.dataSize;
            this.setNullRowBuf();
            return false;
        }
        if (idx > 0) {
            this.rowPointer = idx - 1;
            this.setRow(this.data[this.rowPointer]);
            return true;
        }
        if (this.dataSize + idx >= 0) {
            this.rowPointer = this.dataSize + idx;
            this.setRow(this.data[this.rowPointer]);
            return true;
        }
        this.rowPointer = -1;
        this.setNullRowBuf();
        return false;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkClose();
        int newPos = this.rowPointer + rows;
        if (newPos <= -1) {
            this.rowPointer = -1;
            this.setNullRowBuf();
            return false;
        }
        if (newPos >= this.dataSize) {
            this.rowPointer = this.dataSize;
            this.setNullRowBuf();
            return false;
        }
        this.rowPointer = newPos;
        this.setRow(this.data[this.rowPointer]);
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClose();
        if (this.rowPointer > -1) {
            --this.rowPointer;
            if (this.rowPointer != -1) {
                this.setRow(this.data[this.rowPointer]);
                return true;
            }
        }
        this.setNullRowBuf();
        return false;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClose();
        return super.getFetchSize();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClose();
        super.setFetchSize(rows);
    }
}

