/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

class BDOffScreenImageSource
implements ImageProducer {
    private ImageConsumer consumer;
    private int width;
    private int height;
    private int[] buffer;

    public BDOffScreenImageSource(int[] buffer, int w, int h) {
        this.width = w;
        this.height = h;
        this.buffer = buffer;
    }

    @Override
    public void addConsumer(ImageConsumer ic) {
        this.consumer = ic;
        this.produce();
    }

    @Override
    public boolean isConsumer(ImageConsumer ic) {
        return ic == this.consumer;
    }

    @Override
    public void removeConsumer(ImageConsumer ic) {
        if (this.consumer == ic) {
            this.consumer = null;
        }
    }

    @Override
    public void startProduction(ImageConsumer ic) {
        this.addConsumer(ic);
    }

    private ColorModel getColorModel() {
        return new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
    }

    private void sendPixels() {
        if (this.consumer != null) {
            this.consumer.setPixels(0, 0, this.width, this.height, this.getColorModel(), this.buffer, 0, this.width);
        }
    }

    private void produce() {
        if (this.consumer != null) {
            this.consumer.setDimensions(this.width, this.height);
        }
        if (this.consumer != null) {
            this.consumer.setProperties(new Hashtable());
        }
        this.sendPixels();
        if (this.consumer != null) {
            this.consumer.imageComplete(2);
        }
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }
}

