/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ja.dict.ToStringUtil;
import org.apache.lucene.analysis.ja.tokenattributes.ReadingAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public final class JapaneseReadingFormFilter
extends TokenFilter {
    private final CharTermAttribute termAttr = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final ReadingAttribute readingAttr = (ReadingAttribute)this.addAttribute(ReadingAttribute.class);
    private StringBuilder buffer = new StringBuilder();
    private boolean useRomaji;
    private static final char HIRAGANA_START = '\u3041';
    private static final char HIRAGANA_END = '\u3096';

    public JapaneseReadingFormFilter(TokenStream input, boolean useRomaji) {
        super(input);
        this.useRomaji = useRomaji;
    }

    public JapaneseReadingFormFilter(TokenStream input) {
        this(input, false);
    }

    private boolean isHiragana(char ch) {
        return ch >= '\u3041' && ch <= '\u3096';
    }

    private boolean containsHiragana(CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!this.isHiragana(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            String reading = this.readingAttr.getReading();
            if (reading == null && this.containsHiragana((CharSequence)this.termAttr)) {
                int len = this.termAttr.length();
                char[] readingBuffer = new char[len];
                for (int i = 0; i < len; ++i) {
                    readingBuffer[i] = this.termAttr.charAt(i);
                    if (!this.isHiragana(readingBuffer[i])) continue;
                    int n = i;
                    readingBuffer[n] = (char)(readingBuffer[n] + 96);
                }
                reading = new String(readingBuffer);
            }
            if (this.useRomaji) {
                if (reading == null) {
                    this.buffer.setLength(0);
                    ToStringUtil.getRomanization(this.buffer, (CharSequence)this.termAttr);
                    this.termAttr.setEmpty().append(this.buffer);
                } else {
                    ToStringUtil.getRomanization((Appendable)this.termAttr.setEmpty(), reading);
                }
            } else if (reading != null) {
                this.termAttr.setEmpty().append(reading);
            }
            return true;
        }
        return false;
    }
}

