/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.morfologik;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.IStemmer;
import morfologik.stemming.WordData;
import morfologik.stemming.polish.PolishStemmer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.morfologik.MorphosyntacticTagsAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.IgnoreRandomChains;

public class MorfologikFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final MorphosyntacticTagsAttribute tagsAtt = (MorphosyntacticTagsAttribute)this.addAttribute(MorphosyntacticTagsAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final KeywordAttribute keywordAttr = (KeywordAttribute)this.addAttribute(KeywordAttribute.class);
    private final CharsRefBuilder scratch = new CharsRefBuilder();
    private AttributeSource.State current;
    private final TokenStream input;
    private final IStemmer stemmer;
    private List<WordData> lemmaList;
    private final ArrayList<StringBuilder> tagsList = new ArrayList();
    private int lemmaListIndex;
    private static final Pattern lemmaSplitter = Pattern.compile("\\+|\\|");

    public MorfologikFilter(TokenStream in) {
        this(in, new PolishStemmer().getDictionary());
    }

    @IgnoreRandomChains(reason="No dictionary support yet")
    public MorfologikFilter(TokenStream in, Dictionary dict) {
        super(in);
        this.input = in;
        this.stemmer = new DictionaryLookup(dict);
        this.lemmaList = Collections.emptyList();
    }

    private void popNextLemma() {
        WordData lemma = this.lemmaList.get(this.lemmaListIndex++);
        this.termAtt.setEmpty().append(lemma.getStem());
        CharSequence tag = lemma.getTag();
        if (tag != null) {
            String[] tags = lemmaSplitter.split(tag.toString());
            for (int i = 0; i < tags.length; ++i) {
                if (this.tagsList.size() <= i) {
                    this.tagsList.add(new StringBuilder());
                }
                StringBuilder buffer = this.tagsList.get(i);
                buffer.setLength(0);
                buffer.append(tags[i]);
            }
            this.tagsAtt.setTags(this.tagsList.subList(0, tags.length));
        } else {
            this.tagsAtt.setTags(Collections.emptyList());
        }
    }

    private boolean lookupSurfaceForm(CharSequence token) {
        this.lemmaList = this.stemmer.lookup(token);
        this.lemmaListIndex = 0;
        return this.lemmaList.size() > 0;
    }

    public final boolean incrementToken() throws IOException {
        if (this.lemmaListIndex < this.lemmaList.size()) {
            this.restoreState(this.current);
            this.posIncrAtt.setPositionIncrement(0);
            this.popNextLemma();
            return true;
        }
        if (this.input.incrementToken()) {
            if (!this.keywordAttr.isKeyword() && (this.lookupSurfaceForm((CharSequence)this.termAtt) || this.lookupSurfaceForm(this.toLowercase((CharSequence)this.termAtt)))) {
                this.current = this.captureState();
                this.popNextLemma();
            } else {
                this.tagsAtt.clear();
            }
            return true;
        }
        return false;
    }

    private CharSequence toLowercase(CharSequence chs) {
        int length = chs.length();
        this.scratch.setLength(length);
        this.scratch.grow(length);
        char[] buffer = this.scratch.chars();
        for (int i = 0; i < length; i += Character.toChars(Character.toLowerCase(Character.codePointAt(chs, i)), buffer, i)) {
        }
        return this.scratch.get();
    }

    public void reset() throws IOException {
        this.lemmaListIndex = 0;
        this.lemmaList = Collections.emptyList();
        this.tagsList.clear();
        super.reset();
    }
}

