/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.uk;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Set;
import morfologik.stemming.Dictionary;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.charfilter.MappingCharFilter;
import org.apache.lucene.analysis.charfilter.NormalizeCharMap;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.morfologik.MorfologikFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.IOUtils;

public final class UkrainianMorfologikAnalyzer
extends StopwordAnalyzerBase {
    private final Dictionary dictionary;
    private final CharArraySet stemExclusionSet;
    private static final NormalizeCharMap NORMALIZER_MAP;
    private static volatile DefaultResources defaultResources;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DefaultResources getDefaultResources() {
        if (defaultResources != null) return defaultResources;
        Class<DefaultResources> clazz = DefaultResources.class;
        synchronized (DefaultResources.class) {
            try {
                Dictionary dictionary;
                CharArraySet wordList;
                block26: {
                    try (InputStream is = UkrainianMorfologikAnalyzer.class.getResourceAsStream("stopwords.txt");){
                        if (is == null) {
                            throw new IOException("Could not locate the required stopwords resource.");
                        }
                        wordList = WordlistLoader.getSnowballWordSet((InputStream)is);
                    }
                    Module ourModule = DefaultResources.class.getModule();
                    if (ourModule.isNamed() && ourModule.getLayer() != null) {
                        Module module = ourModule.getLayer().findModule("morfologik.ukrainian.search").orElseThrow(() -> new IOException("Can't find the resource module: morfologik.ukrainian.search"));
                        try (InputStream fsaStream = module.getResourceAsStream("ua/net/nlp/ukrainian.dict");
                             InputStream metaStream = module.getResourceAsStream("ua/net/nlp/ukrainian.info");){
                            dictionary = Dictionary.read((InputStream)fsaStream, (InputStream)metaStream);
                            break block26;
                        }
                    }
                    String name = "ua/net/nlp/ukrainian.dict";
                    dictionary = Dictionary.read((URL)((URL)IOUtils.requireResourceNonNull((Object)UkrainianMorfologikAnalyzer.class.getClassLoader().getResource(name), (String)name)));
                }
                defaultResources = new DefaultResources(wordList, dictionary);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not load the required resources for the Ukrainian analyzer.", e);
            }
            return defaultResources;
        }
    }

    public static CharArraySet getDefaultStopwords() {
        return CharArraySet.unmodifiableSet((CharArraySet)UkrainianMorfologikAnalyzer.getDefaultResources().stopSet);
    }

    public UkrainianMorfologikAnalyzer() {
        this(UkrainianMorfologikAnalyzer.getDefaultResources().stopSet);
    }

    public UkrainianMorfologikAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public UkrainianMorfologikAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy((Set)stemExclusionSet));
        this.dictionary = UkrainianMorfologikAnalyzer.getDefaultResources().dictionary;
    }

    protected Reader initReader(String fieldName, Reader reader) {
        return new MappingCharFilter(NORMALIZER_MAP, reader);
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        Object result = new LowerCaseFilter((TokenStream)source);
        result = new StopFilter((TokenStream)result, this.stopwords);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter((TokenStream)result, this.stemExclusionSet);
        }
        result = new MorfologikFilter((TokenStream)result, this.dictionary);
        return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
    }

    static {
        NormalizeCharMap.Builder builder = new NormalizeCharMap.Builder();
        builder.add("\u2019", "'");
        builder.add("\u2018", "'");
        builder.add("\u02bc", "'");
        builder.add("`", "'");
        builder.add("\u00b4", "'");
        builder.add("\u0301", "");
        builder.add("\u00ad", "");
        builder.add("\u0491", "\u0433");
        builder.add("\u0490", "\u0413");
        NORMALIZER_MAP = builder.build();
    }

    private record DefaultResources(CharArraySet stopSet, Dictionary dictionary) {
    }
}

