/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.theta.CompactSketch;
import com.yahoo.sketches.theta.DirectCompactSketch;
import com.yahoo.sketches.theta.UpdateSketch;

final class DirectCompactOrderedSketch
extends DirectCompactSketch {
    private DirectCompactOrderedSketch(Memory mem) {
        super(mem);
    }

    static DirectCompactOrderedSketch wrapInstance(Memory srcMem, long seed) {
        short memSeedHash = srcMem.getShort(6L);
        short computedSeedHash = Util.computeSeedHash(seed);
        Util.checkSeedHashes(memSeedHash, computedSeedHash);
        return new DirectCompactOrderedSketch(srcMem);
    }

    static DirectCompactOrderedSketch compact(UpdateSketch sketch, WritableMemory dstMem) {
        int curCount = sketch.getRetainedEntries(true);
        long thetaLong = sketch.getThetaLong();
        boolean empty = sketch.isEmpty();
        thetaLong = DirectCompactOrderedSketch.thetaOnCompact(empty, curCount, thetaLong);
        empty = DirectCompactOrderedSketch.emptyOnCompact(curCount, thetaLong);
        int preLongs = DirectCompactOrderedSketch.computeCompactPreLongs(thetaLong, empty, curCount);
        short seedHash = sketch.getSeedHash();
        long[] cache = sketch.getCache();
        int requiredFlags = 26;
        byte flags = (byte)(0x1A | (empty ? 4 : 0));
        boolean ordered = true;
        long[] compactCache = CompactSketch.compactCache(cache, curCount, thetaLong, true);
        DirectCompactOrderedSketch.loadCompactMemory(compactCache, seedHash, curCount, thetaLong, dstMem, flags, preLongs);
        return new DirectCompactOrderedSketch((Memory)dstMem);
    }

    static DirectCompactOrderedSketch compact(long[] cache, boolean empty, short seedHash, int curCount, long thetaLong, WritableMemory dstMem) {
        int preLongs = DirectCompactOrderedSketch.computeCompactPreLongs(thetaLong, empty, curCount);
        int requiredFlags = 26;
        byte flags = (byte)(0x1A | (empty ? 4 : 0));
        DirectCompactOrderedSketch.loadCompactMemory(cache, seedHash, curCount, thetaLong, dstMem, flags, preLongs);
        return new DirectCompactOrderedSketch((Memory)dstMem);
    }

    @Override
    public boolean isOrdered() {
        return true;
    }
}

