/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.tuple;

import com.yahoo.sketches.ResizeFactor;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.hash.MurmurHash3;
import java.nio.charset.StandardCharsets;

final class Util {
    Util() {
    }

    static final long[] doubleToLongArray(double value) {
        double d = value == 0.0 ? 0.0 : value;
        long[] array = new long[]{Double.doubleToLongBits(d)};
        return array;
    }

    static final byte[] stringToByteArray(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return value.getBytes(StandardCharsets.UTF_8);
    }

    static short computeSeedHash(long seed) {
        long[] seedArr = new long[]{seed};
        short seedHash = (short)(MurmurHash3.hash(seedArr, 0L)[0] & 0xFFFFL);
        if (seedHash == 0) {
            throw new SketchesArgumentException("The given seed: " + seed + " produced a seedHash of zero. You must choose a different seed.");
        }
        return seedHash;
    }

    static final void checkSeedHashes(short seedHashA, short seedHashB) {
        if (seedHashA != seedHashB) {
            throw new SketchesArgumentException("Incompatible Seed Hashes. " + seedHashA + ", " + seedHashB);
        }
    }

    static int getStartingCapacity(int nomEntries, int lgResizeFactor) {
        return 1 << com.yahoo.sketches.Util.startingSubMultiple(Integer.numberOfTrailingZeros(com.yahoo.sketches.Util.ceilingPowerOf2(nomEntries) * 2), ResizeFactor.getRF(lgResizeFactor), 5);
    }
}

