/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import org.opensearch.ad.transport.ADCancelTaskRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.transport.TransportRequest;

public class ADCancelTaskNodeRequest
extends TransportRequest {
    private String detectorId;
    private String detectorTaskId;
    private String userName;
    private String reason;

    public ADCancelTaskNodeRequest(StreamInput in) throws IOException {
        super(in);
        this.detectorId = in.readOptionalString();
        this.userName = in.readOptionalString();
        if (in.available() > 0) {
            this.detectorTaskId = in.readOptionalString();
            this.reason = in.readOptionalString();
        }
    }

    public ADCancelTaskNodeRequest(ADCancelTaskRequest request) {
        this.detectorId = request.getId();
        this.detectorTaskId = request.getDetectorTaskId();
        this.userName = request.getUserName();
        this.reason = request.getReason();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.detectorId);
        out.writeOptionalString(this.userName);
        out.writeOptionalString(this.detectorTaskId);
        out.writeOptionalString(this.reason);
    }

    public String getId() {
        return this.detectorId;
    }

    public String getDetectorTaskId() {
        return this.detectorTaskId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getReason() {
        return this.reason;
    }
}

